/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.authorize.AtlasTypesDefFilterRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.ChangedTypeDefs;
import org.apache.atlas.listener.TypeDefChangeListener;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.AtlasDefStore;
import org.apache.atlas.repository.util.FilterUtil;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlasTypeDefGraphStore
implements AtlasTypeDefStore {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasTypeDefGraphStore.class);
    private final AtlasTypeRegistry typeRegistry;
    private final Set<TypeDefChangeListener> typeDefChangeListeners;
    private final int typeUpdateLockMaxWaitTimeSeconds;

    protected AtlasTypeDefGraphStore(AtlasTypeRegistry typeRegistry, Set<TypeDefChangeListener> typeDefChangeListeners) {
        this.typeRegistry = typeRegistry;
        this.typeDefChangeListeners = typeDefChangeListeners;
        this.typeUpdateLockMaxWaitTimeSeconds = AtlasRepositoryConfiguration.getTypeUpdateLockMaxWaitTimeInSeconds();
    }

    protected abstract AtlasDefStore<AtlasEnumDef> getEnumDefStore(AtlasTypeRegistry var1);

    protected abstract AtlasDefStore<AtlasStructDef> getStructDefStore(AtlasTypeRegistry var1);

    protected abstract AtlasDefStore<AtlasClassificationDef> getClassificationDefStore(AtlasTypeRegistry var1);

    protected abstract AtlasDefStore<AtlasEntityDef> getEntityDefStore(AtlasTypeRegistry var1);

    protected abstract AtlasDefStore<AtlasRelationshipDef> getRelationshipDefStore(AtlasTypeRegistry var1);

    protected abstract AtlasDefStore<AtlasBusinessMetadataDef> getBusinessMetadataDefStore(AtlasTypeRegistry var1);

    public AtlasTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws AtlasBaseException {
        LOG.info("==> AtlasTypeDefGraphStore.init()");
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commitUpdates = false;
        try {
            ttr = this.typeRegistry.lockTypeRegistryForUpdate(this.typeUpdateLockMaxWaitTimeSeconds);
            ttr.clear();
            AtlasTypesDef typesDef = new AtlasTypesDef(this.getEnumDefStore((AtlasTypeRegistry)ttr).getAll(), this.getStructDefStore((AtlasTypeRegistry)ttr).getAll(), this.getClassificationDefStore((AtlasTypeRegistry)ttr).getAll(), this.getEntityDefStore((AtlasTypeRegistry)ttr).getAll(), this.getRelationshipDefStore((AtlasTypeRegistry)ttr).getAll(), this.getBusinessMetadataDefStore((AtlasTypeRegistry)ttr).getAll());
            this.rectifyTypeErrorsIfAny(typesDef);
            ttr.addTypes(typesDef);
            commitUpdates = true;
        }
        finally {
            this.typeRegistry.releaseTypeRegistryForUpdate(ttr, commitUpdates);
            LOG.info("<== AtlasTypeDefGraphStore.init()");
        }
    }

    @Override
    public AtlasEnumDef getEnumDefByName(String name) throws AtlasBaseException {
        AtlasEnumDef ret = this.typeRegistry.getEnumDefByName(name);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", name});
        return ret;
    }

    @Override
    public AtlasEnumDef getEnumDefByGuid(String guid) throws AtlasBaseException {
        AtlasEnumDef ret = this.typeRegistry.getEnumDefByGuid(guid);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", guid});
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEnumDef updateEnumDefByName(String name, AtlasEnumDef enumDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByName(name, (AtlasBaseTypeDef)enumDef, ttr);
        return this.getEnumDefStore((AtlasTypeRegistry)ttr).updateByName(name, enumDef);
    }

    @Override
    @GraphTransaction
    public AtlasEnumDef updateEnumDefByGuid(String guid, AtlasEnumDef enumDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByGUID(guid, (AtlasBaseTypeDef)enumDef, ttr);
        return this.getEnumDefStore((AtlasTypeRegistry)ttr).updateByGuid(guid, enumDef);
    }

    @Override
    public AtlasStructDef getStructDefByName(String name) throws AtlasBaseException {
        AtlasStructDef ret = this.typeRegistry.getStructDefByName(name);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", name});
        return ret;
    }

    @Override
    public AtlasStructDef getStructDefByGuid(String guid) throws AtlasBaseException {
        AtlasStructDef ret = this.typeRegistry.getStructDefByGuid(guid);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", guid});
        return ret;
    }

    @Override
    public AtlasRelationshipDef getRelationshipDefByName(String name) throws AtlasBaseException {
        AtlasRelationshipDef ret = this.typeRegistry.getRelationshipDefByName(name);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", name});
        return ret;
    }

    @Override
    public AtlasRelationshipDef getRelationshipDefByGuid(String guid) throws AtlasBaseException {
        AtlasRelationshipDef ret = this.typeRegistry.getRelationshipDefByGuid(guid);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", guid});
        return ret;
    }

    @Override
    public AtlasBusinessMetadataDef getBusinessMetadataDefByName(String name) throws AtlasBaseException {
        AtlasBusinessMetadataDef ret = this.typeRegistry.getBusinessMetadataDefByName(name);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", name});
        return ret;
    }

    @Override
    public AtlasBusinessMetadataDef getBusinessMetadataDefByGuid(String guid) throws AtlasBaseException {
        AtlasBusinessMetadataDef ret = this.typeRegistry.getBusinessMetadataDefByGuid(guid);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", guid});
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasStructDef updateStructDefByName(String name, AtlasStructDef structDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByName(name, (AtlasBaseTypeDef)structDef, ttr);
        return this.getStructDefStore((AtlasTypeRegistry)ttr).updateByName(name, structDef);
    }

    @Override
    @GraphTransaction
    public AtlasStructDef updateStructDefByGuid(String guid, AtlasStructDef structDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByGUID(guid, (AtlasBaseTypeDef)structDef, ttr);
        return this.getStructDefStore((AtlasTypeRegistry)ttr).updateByGuid(guid, structDef);
    }

    @Override
    public AtlasClassificationDef getClassificationDefByName(String name) throws AtlasBaseException {
        AtlasClassificationDef ret = this.typeRegistry.getClassificationDefByName(name);
        if (ret == null) {
            AtlasClassificationDef atlasClassificationDef = ret = StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"_ALL_CLASSIFICATION_TYPES") ? AtlasClassificationType.getClassificationRoot().getClassificationDef() : null;
            if (ret == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
            }
            return ret;
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", name});
        return ret;
    }

    @Override
    public AtlasClassificationDef getClassificationDefByGuid(String guid) throws AtlasBaseException {
        AtlasClassificationDef ret = this.typeRegistry.getClassificationDefByGuid(guid);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", guid});
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasClassificationDef updateClassificationDefByName(String name, AtlasClassificationDef classificationDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByName(name, (AtlasBaseTypeDef)classificationDef, ttr);
        return this.getClassificationDefStore((AtlasTypeRegistry)ttr).updateByName(name, classificationDef);
    }

    @Override
    @GraphTransaction
    public AtlasClassificationDef updateClassificationDefByGuid(String guid, AtlasClassificationDef classificationDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByGUID(guid, (AtlasBaseTypeDef)classificationDef, ttr);
        return this.getClassificationDefStore((AtlasTypeRegistry)ttr).updateByGuid(guid, classificationDef);
    }

    @Override
    public AtlasEntityDef getEntityDefByName(String name) throws AtlasBaseException {
        AtlasEntityDef ret = this.typeRegistry.getEntityDefByName(name);
        if (ret == null) {
            AtlasEntityDef atlasEntityDef = ret = StringUtils.equals((CharSequence)name, (CharSequence)"_ALL_ENTITY_TYPES") ? AtlasEntityType.getEntityRoot().getEntityDef() : null;
            if (ret == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
            }
            return ret;
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", name});
        return ret;
    }

    @Override
    public AtlasEntityDef getEntityDefByGuid(String guid) throws AtlasBaseException {
        AtlasEntityDef ret = this.typeRegistry.getEntityDefByGuid(guid);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, (AtlasBaseTypeDef)ret), (Object[])new Object[]{"read type ", guid});
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntityDef updateEntityDefByName(String name, AtlasEntityDef entityDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByName(name, (AtlasBaseTypeDef)entityDef, ttr);
        return this.getEntityDefStore((AtlasTypeRegistry)ttr).updateByName(name, entityDef);
    }

    @Override
    @GraphTransaction
    public AtlasEntityDef updateEntityDefByGuid(String guid, AtlasEntityDef entityDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByGUID(guid, (AtlasBaseTypeDef)entityDef, ttr);
        return this.getEntityDefStore((AtlasTypeRegistry)ttr).updateByGuid(guid, entityDef);
    }

    @Override
    @GraphTransaction
    public AtlasRelationshipDef updateRelationshipDefByName(String name, AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByName(name, (AtlasBaseTypeDef)relationshipDef, ttr);
        return this.getRelationshipDefStore((AtlasTypeRegistry)ttr).updateByName(name, relationshipDef);
    }

    @Override
    @GraphTransaction
    public AtlasRelationshipDef updateRelationshipDefByGuid(String guid, AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryUpdateByGUID(guid, (AtlasBaseTypeDef)relationshipDef, ttr);
        return this.getRelationshipDefStore((AtlasTypeRegistry)ttr).updateByGuid(guid, relationshipDef);
    }

    @Override
    @GraphTransaction
    public AtlasTypesDef createTypesDef(AtlasTypesDef typesDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTypeDefGraphStore.createTypesDef(enums={}, structs={}, classifications={}, entities={}, relationships={}, businessMetadataDefs={})", new Object[]{CollectionUtils.size((Object)typesDef.getEnumDefs()), CollectionUtils.size((Object)typesDef.getStructDefs()), CollectionUtils.size((Object)typesDef.getClassificationDefs()), CollectionUtils.size((Object)typesDef.getEntityDefs()), CollectionUtils.size((Object)typesDef.getRelationshipDefs()), CollectionUtils.size((Object)typesDef.getBusinessMetadataDefs())});
        }
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        this.tryTypeCreation(typesDef, ttr);
        AtlasTypesDef ret = this.addToGraphStore(typesDef, ttr);
        try {
            ttr.updateTypes(ret);
        }
        catch (AtlasBaseException e) {
            LOG.error("failed to update the registry after updating the store", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTypeDefGraphStore.createTypesDef(enums={}, structs={}, classfications={}, entities={}, relationships={}, businessMetadataDefs={})", new Object[]{CollectionUtils.size((Object)typesDef.getEnumDefs()), CollectionUtils.size((Object)typesDef.getStructDefs()), CollectionUtils.size((Object)typesDef.getClassificationDefs()), CollectionUtils.size((Object)typesDef.getEntityDefs()), CollectionUtils.size((Object)typesDef.getRelationshipDefs()), CollectionUtils.size((Object)typesDef.getBusinessMetadataDefs())});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasTypesDef createUpdateTypesDef(AtlasTypesDef typesDef) throws AtlasBaseException {
        AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate(typesDef, this.typeRegistry);
        AtlasTypesDef typesToUpdate = AtlasTypeDefStoreInitializer.getTypesToUpdate(typesDef, this.typeRegistry, false);
        return this.createUpdateTypesDef(typesToCreate, typesToUpdate);
    }

    @Override
    @GraphTransaction
    public AtlasTypesDef createUpdateTypesDef(AtlasTypesDef typesToCreate, AtlasTypesDef typesToUpdate) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTypeDefGraphStore.createUpdateTypesDef({}, {})", (Object)typesToCreate, (Object)typesToUpdate);
        }
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        if (!typesToUpdate.isEmpty()) {
            ttr.updateTypesWithNoRefResolve(typesToUpdate);
        }
        this.tryTypeCreation(typesToCreate, ttr);
        AtlasTypesDef ret = this.addToGraphStore(typesToCreate, ttr);
        if (!typesToUpdate.isEmpty()) {
            AtlasTypesDef updatedTypes = this.updateGraphStore(typesToUpdate, ttr);
            if (CollectionUtils.isNotEmpty((Collection)updatedTypes.getEnumDefs())) {
                for (AtlasEnumDef enumDef : updatedTypes.getEnumDefs()) {
                    ret.getEnumDefs().add(enumDef);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updatedTypes.getStructDefs())) {
                for (AtlasStructDef structDef : updatedTypes.getStructDefs()) {
                    ret.getStructDefs().add(structDef);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updatedTypes.getClassificationDefs())) {
                for (AtlasClassificationDef classificationDef : updatedTypes.getClassificationDefs()) {
                    ret.getClassificationDefs().add(classificationDef);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updatedTypes.getEntityDefs())) {
                for (AtlasEntityDef entityDef : updatedTypes.getEntityDefs()) {
                    ret.getEntityDefs().add(entityDef);
                }
            }
        }
        try {
            ttr.updateTypes(ret);
        }
        catch (AtlasBaseException e) {
            LOG.error("failed to update the registry after updating the store", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTypeDefGraphStore.createUpdateTypesDef({}, {}): {}", new Object[]{typesToCreate, typesToUpdate, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasTypesDef updateTypesDef(AtlasTypesDef typesDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTypeDefGraphStore.updateTypesDef(enums={}, structs={}, classfications={}, entities={}, relationships{}, businessMetadataDefs={})", new Object[]{CollectionUtils.size((Object)typesDef.getEnumDefs()), CollectionUtils.size((Object)typesDef.getStructDefs()), CollectionUtils.size((Object)typesDef.getClassificationDefs()), CollectionUtils.size((Object)typesDef.getEntityDefs()), CollectionUtils.size((Object)typesDef.getRelationshipDefs()), CollectionUtils.size((Object)typesDef.getBusinessMetadataDefs())});
        }
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        try {
            ttr.updateTypes(typesDef);
        }
        catch (AtlasBaseException e) {
            if (AtlasErrorCode.TYPE_NAME_NOT_FOUND == e.getAtlasErrorCode()) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{e.getMessage()});
            }
            throw e;
        }
        AtlasTypesDef ret = this.updateGraphStore(typesDef, ttr);
        try {
            ttr.updateTypes(ret);
        }
        catch (AtlasBaseException e) {
            LOG.error("failed to update the registry after updating the store", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTypeDefGraphStore.updateTypesDef(enums={}, structs={}, classfications={}, entities={}, relationships={}, businessMetadataDefs={})", new Object[]{CollectionUtils.size((Object)typesDef.getEnumDefs()), CollectionUtils.size((Object)typesDef.getStructDefs()), CollectionUtils.size((Object)typesDef.getClassificationDefs()), CollectionUtils.size((Object)typesDef.getEntityDefs()), CollectionUtils.size((Object)typesDef.getRelationshipDefs()), CollectionUtils.size((Object)typesDef.getBusinessMetadataDefs())});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public void deleteTypesDef(AtlasTypesDef typesDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTypeDefGraphStore.deleteTypesDef(enums={}, structs={}, classfications={}, entities={}, relationships={}, businessMetadataDefs={})", new Object[]{CollectionUtils.size((Object)typesDef.getEnumDefs()), CollectionUtils.size((Object)typesDef.getStructDefs()), CollectionUtils.size((Object)typesDef.getClassificationDefs()), CollectionUtils.size((Object)typesDef.getEntityDefs()), CollectionUtils.size((Object)typesDef.getRelationshipDefs()), CollectionUtils.size((Object)typesDef.getBusinessMetadataDefs())});
        }
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.lockTypeRegistryAndReleasePostCommit();
        AtlasDefStore<AtlasEnumDef> enumDefStore = this.getEnumDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasStructDef> structDefStore = this.getStructDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasClassificationDef> classifiDefStore = this.getClassificationDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasEntityDef> entityDefStore = this.getEntityDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasRelationshipDef> relationshipDefStore = this.getRelationshipDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasBusinessMetadataDef> businessMetadataDefStore = this.getBusinessMetadataDefStore((AtlasTypeRegistry)ttr);
        ArrayList<AtlasVertex> preDeleteStructDefs = new ArrayList<AtlasVertex>();
        ArrayList<AtlasVertex> preDeleteClassifiDefs = new ArrayList<AtlasVertex>();
        ArrayList<AtlasVertex> preDeleteEntityDefs = new ArrayList<AtlasVertex>();
        ArrayList<AtlasVertex> preDeleteRelationshipDefs = new ArrayList<AtlasVertex>();
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                if (StringUtils.isNotBlank((CharSequence)relationshipDef.getGuid())) {
                    preDeleteRelationshipDefs.add(relationshipDefStore.preDeleteByGuid(relationshipDef.getGuid()));
                    continue;
                }
                preDeleteRelationshipDefs.add(relationshipDefStore.preDeleteByName(relationshipDef.getName()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                if (StringUtils.isNotBlank((CharSequence)structDef.getGuid())) {
                    preDeleteStructDefs.add(structDefStore.preDeleteByGuid(structDef.getGuid()));
                    continue;
                }
                preDeleteStructDefs.add(structDefStore.preDeleteByName(structDef.getName()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classifiDef : typesDef.getClassificationDefs()) {
                if (StringUtils.isNotBlank((CharSequence)classifiDef.getGuid())) {
                    preDeleteClassifiDefs.add(classifiDefStore.preDeleteByGuid(classifiDef.getGuid()));
                    continue;
                }
                preDeleteClassifiDefs.add(classifiDefStore.preDeleteByName(classifiDef.getName()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (Object entityDef : typesDef.getEntityDefs()) {
                if (StringUtils.isNotBlank((CharSequence)entityDef.getGuid())) {
                    preDeleteEntityDefs.add(entityDefStore.preDeleteByGuid(entityDef.getGuid()));
                    continue;
                }
                preDeleteEntityDefs.add(entityDefStore.preDeleteByName(entityDef.getName()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            int i = 0;
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                if (StringUtils.isNotBlank((CharSequence)relationshipDef.getGuid())) {
                    relationshipDefStore.deleteByGuid(relationshipDef.getGuid(), (AtlasVertex)preDeleteRelationshipDefs.get(i));
                } else {
                    relationshipDefStore.deleteByName(relationshipDef.getName(), (AtlasVertex)preDeleteRelationshipDefs.get(i));
                }
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            int i = 0;
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                if (StringUtils.isNotBlank((CharSequence)structDef.getGuid())) {
                    structDefStore.deleteByGuid(structDef.getGuid(), (AtlasVertex)preDeleteStructDefs.get(i));
                } else {
                    structDefStore.deleteByName(structDef.getName(), (AtlasVertex)preDeleteStructDefs.get(i));
                }
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            int i = 0;
            for (AtlasClassificationDef classifiDef : typesDef.getClassificationDefs()) {
                if (StringUtils.isNotBlank((CharSequence)classifiDef.getGuid())) {
                    classifiDefStore.deleteByGuid(classifiDef.getGuid(), (AtlasVertex)preDeleteClassifiDefs.get(i));
                } else {
                    classifiDefStore.deleteByName(classifiDef.getName(), (AtlasVertex)preDeleteClassifiDefs.get(i));
                }
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            int i = 0;
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                if (StringUtils.isNotBlank((CharSequence)entityDef.getGuid())) {
                    entityDefStore.deleteByGuid(entityDef.getGuid(), (AtlasVertex)preDeleteEntityDefs.get(i));
                } else {
                    entityDefStore.deleteByName(entityDef.getName(), (AtlasVertex)preDeleteEntityDefs.get(i));
                }
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumDefs())) {
            for (AtlasEnumDef enumDef : typesDef.getEnumDefs()) {
                if (StringUtils.isNotBlank((CharSequence)enumDef.getGuid())) {
                    enumDefStore.deleteByGuid(enumDef.getGuid(), null);
                    continue;
                }
                enumDefStore.deleteByName(enumDef.getName(), null);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getBusinessMetadataDefs())) {
            for (AtlasBusinessMetadataDef businessMetadataDef : typesDef.getBusinessMetadataDefs()) {
                if (StringUtils.isNotBlank((CharSequence)businessMetadataDef.getGuid())) {
                    businessMetadataDefStore.deleteByGuid(businessMetadataDef.getGuid(), null);
                    continue;
                }
                businessMetadataDefStore.deleteByName(businessMetadataDef.getName(), null);
            }
        }
        ttr.removeTypesDef(typesDef);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTypeDefGraphStore.deleteTypesDef(enums={}, structs={}, classfications={}, entities={})", new Object[]{CollectionUtils.size((Object)typesDef.getEnumDefs()), CollectionUtils.size((Object)typesDef.getStructDefs()), CollectionUtils.size((Object)typesDef.getClassificationDefs()), CollectionUtils.size((Object)typesDef.getEntityDefs())});
        }
    }

    @Override
    @GraphTransaction
    public void deleteTypeByName(String typeName) throws AtlasBaseException {
        AtlasType atlasType = this.typeRegistry.getType(typeName);
        if (atlasType == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{typeName});
        }
        AtlasTypesDef typesDef = new AtlasTypesDef();
        AtlasBaseTypeDef baseTypeDef = this.getByNameNoAuthz(typeName);
        if (baseTypeDef instanceof AtlasClassificationDef) {
            typesDef.setClassificationDefs(Collections.singletonList((AtlasClassificationDef)baseTypeDef));
        } else if (baseTypeDef instanceof AtlasEntityDef) {
            typesDef.setEntityDefs(Collections.singletonList((AtlasEntityDef)baseTypeDef));
        } else if (baseTypeDef instanceof AtlasEnumDef) {
            typesDef.setEnumDefs(Collections.singletonList((AtlasEnumDef)baseTypeDef));
        } else if (baseTypeDef instanceof AtlasRelationshipDef) {
            typesDef.setRelationshipDefs(Collections.singletonList((AtlasRelationshipDef)baseTypeDef));
        } else if (baseTypeDef instanceof AtlasBusinessMetadataDef) {
            typesDef.setBusinessMetadataDefs(Collections.singletonList((AtlasBusinessMetadataDef)baseTypeDef));
        } else if (baseTypeDef instanceof AtlasStructDef) {
            typesDef.setStructDefs(Collections.singletonList((AtlasStructDef)baseTypeDef));
        }
        this.deleteTypesDef(typesDef);
    }

    @Override
    public AtlasTypesDef searchTypesDef(SearchFilter searchFilter) throws AtlasBaseException {
        AtlasTypesDef typesDef = new AtlasTypesDef();
        Predicate searchPredicates = FilterUtil.getPredicateFromSearchFilter(searchFilter);
        for (AtlasEnumType enumType : this.typeRegistry.getAllEnumTypes()) {
            if (!searchPredicates.evaluate((Object)enumType)) continue;
            typesDef.getEnumDefs().add(enumType.getEnumDef());
        }
        for (AtlasStructType structType : this.typeRegistry.getAllStructTypes()) {
            if (!searchPredicates.evaluate((Object)structType)) continue;
            typesDef.getStructDefs().add(structType.getStructDef());
        }
        for (AtlasClassificationType classificationType : this.typeRegistry.getAllClassificationTypes()) {
            if (!searchPredicates.evaluate((Object)classificationType)) continue;
            typesDef.getClassificationDefs().add(classificationType.getClassificationDef());
        }
        for (AtlasEntityType entityType : this.typeRegistry.getAllEntityTypes()) {
            if (!searchPredicates.evaluate((Object)entityType)) continue;
            typesDef.getEntityDefs().add(entityType.getEntityDef());
        }
        for (AtlasRelationshipType relationshipType : this.typeRegistry.getAllRelationshipTypes()) {
            if (!searchPredicates.evaluate((Object)relationshipType)) continue;
            typesDef.getRelationshipDefs().add(relationshipType.getRelationshipDef());
        }
        for (AtlasBusinessMetadataType businessMetadataType : this.typeRegistry.getAllBusinessMetadataTypes()) {
            if (!searchPredicates.evaluate((Object)businessMetadataType)) continue;
            typesDef.getBusinessMetadataDefs().add(businessMetadataType.getBusinessMetadataDef());
        }
        AtlasAuthorizationUtils.filterTypesDef((AtlasTypesDefFilterRequest)new AtlasTypesDefFilterRequest(typesDef));
        return typesDef;
    }

    @Override
    public AtlasBaseTypeDef getByName(String name) throws AtlasBaseException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{"", name});
        }
        AtlasType type = this.typeRegistry.getType(name);
        AtlasBaseTypeDef ret = this.getTypeDefFromTypeWithNoAuthz(type);
        if (ret != null) {
            AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, ret), (Object[])new Object[]{"read type ", name});
        }
        return ret;
    }

    @Override
    public AtlasBaseTypeDef getByGuid(String guid) throws AtlasBaseException {
        if (StringUtils.isBlank((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasType type = this.typeRegistry.getTypeByGuid(guid);
        AtlasBaseTypeDef ret = this.getTypeDefFromTypeWithNoAuthz(type);
        if (ret != null) {
            AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_READ, ret), (Object[])new Object[]{"read type ", guid});
        }
        return ret;
    }

    private AtlasBaseTypeDef getByNameNoAuthz(String name) throws AtlasBaseException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{"", name});
        }
        AtlasType type = this.typeRegistry.getType(name);
        return this.getTypeDefFromTypeWithNoAuthz(type);
    }

    private AtlasBaseTypeDef getTypeDefFromTypeWithNoAuthz(AtlasType type) throws AtlasBaseException {
        AtlasEnumDef ret;
        switch (type.getTypeCategory()) {
            case ENUM: {
                ret = ((AtlasEnumType)type).getEnumDef();
                break;
            }
            case STRUCT: {
                ret = ((AtlasStructType)type).getStructDef();
                break;
            }
            case CLASSIFICATION: {
                ret = ((AtlasClassificationType)type).getClassificationDef();
                break;
            }
            case ENTITY: {
                ret = ((AtlasEntityType)type).getEntityDef();
                break;
            }
            case RELATIONSHIP: {
                ret = ((AtlasRelationshipType)type).getRelationshipDef();
                break;
            }
            case BUSINESS_METADATA: {
                ret = ((AtlasBusinessMetadataType)type).getBusinessMetadataDef();
                break;
            }
            default: {
                throw new AtlasBaseException(AtlasErrorCode.SYSTEM_TYPE, new String[]{type.getTypeCategory().name()});
            }
        }
        return ret;
    }

    private AtlasTypeRegistry.AtlasTransientTypeRegistry lockTypeRegistryAndReleasePostCommit() throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.typeRegistry.lockTypeRegistryForUpdate(this.typeUpdateLockMaxWaitTimeSeconds);
        new TypeRegistryUpdateHook(ttr);
        return ttr;
    }

    private void rectifyTypeErrorsIfAny(AtlasTypesDef typesDef) {
        HashSet<String> entityNames = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                entityNames.add(entityDef.getName());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                this.rectifyAttributesIfNeeded(entityNames, structDef);
            }
            this.removeDuplicateTypeIfAny(typesDef.getStructDefs());
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classificationDef : typesDef.getClassificationDefs()) {
                this.rectifyAttributesIfNeeded(entityNames, (AtlasStructDef)classificationDef);
            }
            this.removeDuplicateTypeIfAny(typesDef.getClassificationDefs());
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                this.rectifyAttributesIfNeeded(entityNames, (AtlasStructDef)entityDef);
            }
            this.removeDuplicateTypeIfAny(typesDef.getEntityDefs());
        }
    }

    private <T extends AtlasBaseTypeDef> void removeDuplicateTypeIfAny(List<T> defList) {
        HashSet<String> entityDefNames = new HashSet<String>();
        for (int i = 0; i < defList.size(); ++i) {
            if (entityDefNames.add(((AtlasBaseTypeDef)defList.get(i)).getName())) continue;
            LOG.warn(" Found Duplicate Type => " + ((AtlasBaseTypeDef)defList.get(i)).getName());
            defList.remove(i);
            --i;
        }
    }

    private void rectifyAttributesIfNeeded(Set<String> entityNames, AtlasStructDef structDef) {
        List attributeDefs = structDef.getAttributeDefs();
        if (CollectionUtils.isNotEmpty((Collection)attributeDefs)) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefs) {
                if (!this.hasOwnedReferenceConstraint(attributeDef.getConstraints())) continue;
                Set referencedTypeNames = AtlasTypeUtil.getReferencedTypeNames((String)attributeDef.getTypeName());
                boolean valid = false;
                for (String referencedTypeName : referencedTypeNames) {
                    if (!entityNames.contains(referencedTypeName)) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                this.rectifyOwnedReferenceError(structDef, attributeDef);
            }
        }
    }

    private boolean hasOwnedReferenceConstraint(List<AtlasStructDef.AtlasConstraintDef> constraints) {
        if (CollectionUtils.isNotEmpty(constraints)) {
            for (AtlasStructDef.AtlasConstraintDef constraint : constraints) {
                if (!constraint.isConstraintType("ownedRef")) continue;
                return true;
            }
        }
        return false;
    }

    private void rectifyOwnedReferenceError(AtlasStructDef structDef, AtlasStructDef.AtlasAttributeDef attributeDef) {
        List constraints = attributeDef.getConstraints();
        if (CollectionUtils.isNotEmpty((Collection)constraints)) {
            for (int i = 0; i < constraints.size(); ++i) {
                AtlasStructDef.AtlasConstraintDef constraint = (AtlasStructDef.AtlasConstraintDef)constraints.get(i);
                if (!constraint.isConstraintType("ownedRef")) continue;
                LOG.warn("Invalid constraint ownedRef for attribute {}.{}", (Object)structDef.getName(), (Object)attributeDef.getName());
                constraints.remove(i);
                --i;
            }
        }
    }

    private AtlasTypesDef addToGraphStore(AtlasTypesDef typesDef, AtlasTypeRegistry.AtlasTransientTypeRegistry ttr) throws AtlasBaseException {
        AtlasStructDef createdDef;
        AtlasTypesDef ret = new AtlasTypesDef();
        AtlasDefStore<AtlasEnumDef> enumDefStore = this.getEnumDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasStructDef> structDefStore = this.getStructDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasClassificationDef> classifiDefStore = this.getClassificationDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasEntityDef> entityDefStore = this.getEntityDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasRelationshipDef> relationshipDefStore = this.getRelationshipDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasBusinessMetadataDef> businessMetadataDefStore = this.getBusinessMetadataDefStore((AtlasTypeRegistry)ttr);
        ArrayList<AtlasVertex> preCreateStructDefs = new ArrayList<AtlasVertex>();
        ArrayList<AtlasVertex> preCreateClassifiDefs = new ArrayList<AtlasVertex>();
        ArrayList<AtlasVertex> preCreateEntityDefs = new ArrayList<AtlasVertex>();
        ArrayList<AtlasVertex> preCreateRelationshipDefs = new ArrayList<AtlasVertex>();
        ArrayList<AtlasVertex> preCreateBusinessMetadataDefs = new ArrayList<AtlasVertex>();
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumDefs())) {
            for (AtlasEnumDef enumDef : typesDef.getEnumDefs()) {
                AtlasEnumDef createdDef2 = enumDefStore.create(enumDef, null);
                ttr.updateGuid(createdDef2.getName(), createdDef2.getGuid());
                ret.getEnumDefs().add(createdDef2);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                preCreateStructDefs.add(structDefStore.preCreate(structDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classifiDef : typesDef.getClassificationDefs()) {
                preCreateClassifiDefs.add(classifiDefStore.preCreate(classifiDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                preCreateEntityDefs.add(entityDefStore.preCreate(entityDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                preCreateRelationshipDefs.add(relationshipDefStore.preCreate(relationshipDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getBusinessMetadataDefs())) {
            for (AtlasBusinessMetadataDef businessMetadataDef : typesDef.getBusinessMetadataDefs()) {
                preCreateBusinessMetadataDefs.add(businessMetadataDefStore.preCreate(businessMetadataDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            int i = 0;
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                createdDef = structDefStore.create(structDef, (AtlasVertex)preCreateStructDefs.get(i));
                ttr.updateGuid(createdDef.getName(), createdDef.getGuid());
                ret.getStructDefs().add(createdDef);
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            int i = 0;
            for (AtlasClassificationDef classifiDef : typesDef.getClassificationDefs()) {
                createdDef = classifiDefStore.create(classifiDef, (AtlasVertex)preCreateClassifiDefs.get(i));
                ttr.updateGuid(createdDef.getName(), createdDef.getGuid());
                ret.getClassificationDefs().add(createdDef);
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            int i = 0;
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                createdDef = entityDefStore.create(entityDef, (AtlasVertex)preCreateEntityDefs.get(i));
                ttr.updateGuid(createdDef.getName(), createdDef.getGuid());
                ret.getEntityDefs().add(createdDef);
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            int i = 0;
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                createdDef = relationshipDefStore.create(relationshipDef, (AtlasVertex)preCreateRelationshipDefs.get(i));
                ttr.updateGuid(createdDef.getName(), createdDef.getGuid());
                ret.getRelationshipDefs().add(createdDef);
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getBusinessMetadataDefs())) {
            int i = 0;
            for (AtlasBusinessMetadataDef businessMetadataDef : typesDef.getBusinessMetadataDefs()) {
                createdDef = businessMetadataDefStore.create(businessMetadataDef, (AtlasVertex)preCreateBusinessMetadataDefs.get(i));
                ttr.updateGuid(createdDef.getName(), createdDef.getGuid());
                ret.getBusinessMetadataDefs().add(createdDef);
                ++i;
            }
        }
        return ret;
    }

    private AtlasTypesDef updateGraphStore(AtlasTypesDef typesDef, AtlasTypeRegistry.AtlasTransientTypeRegistry ttr) throws AtlasBaseException {
        AtlasTypesDef ret = new AtlasTypesDef();
        AtlasDefStore<AtlasEnumDef> enumDefStore = this.getEnumDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasStructDef> structDefStore = this.getStructDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasClassificationDef> classifiDefStore = this.getClassificationDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasEntityDef> entityDefStore = this.getEntityDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasRelationshipDef> relationDefStore = this.getRelationshipDefStore((AtlasTypeRegistry)ttr);
        AtlasDefStore<AtlasBusinessMetadataDef> businessMetadataDefStore = this.getBusinessMetadataDefStore((AtlasTypeRegistry)ttr);
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEnumDefs())) {
            for (AtlasEnumDef enumDef : typesDef.getEnumDefs()) {
                ret.getEnumDefs().add(enumDefStore.update(enumDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                ret.getStructDefs().add(structDefStore.update(structDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classifiDef : typesDef.getClassificationDefs()) {
                ret.getClassificationDefs().add(classifiDefStore.update(classifiDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                ret.getEntityDefs().add(entityDefStore.update(entityDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                ret.getRelationshipDefs().add(relationDefStore.update(relationshipDef));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)typesDef.getBusinessMetadataDefs())) {
            for (AtlasBusinessMetadataDef businessMetadataDef : typesDef.getBusinessMetadataDefs()) {
                ret.getBusinessMetadataDefs().add(businessMetadataDefStore.update(businessMetadataDef));
            }
        }
        return ret;
    }

    @Override
    public void notifyLoadCompletion() {
        for (TypeDefChangeListener changeListener : this.typeDefChangeListeners) {
            try {
                changeListener.onLoadCompletion();
            }
            catch (Throwable t) {
                LOG.error("OnLoadCompletion failed for listener {}", (Object)changeListener.getClass().getName(), (Object)t);
            }
        }
    }

    private void tryUpdateByName(String name, AtlasBaseTypeDef typeDef, AtlasTypeRegistry.AtlasTransientTypeRegistry ttr) throws AtlasBaseException {
        try {
            ttr.updateTypeByName(name, typeDef);
        }
        catch (AtlasBaseException e) {
            if (AtlasErrorCode.TYPE_NAME_NOT_FOUND == e.getAtlasErrorCode()) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{e.getMessage()});
            }
            throw e;
        }
    }

    private void tryUpdateByGUID(String guid, AtlasBaseTypeDef typeDef, AtlasTypeRegistry.AtlasTransientTypeRegistry ttr) throws AtlasBaseException {
        try {
            ttr.updateTypeByGuid(guid, typeDef);
        }
        catch (AtlasBaseException e) {
            if (AtlasErrorCode.TYPE_GUID_NOT_FOUND == e.getAtlasErrorCode()) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{e.getMessage()});
            }
            throw e;
        }
    }

    private void tryTypeCreation(AtlasTypesDef typesDef, AtlasTypeRegistry.AtlasTransientTypeRegistry ttr) throws AtlasBaseException {
        try {
            ttr.addTypes(typesDef);
        }
        catch (AtlasBaseException e) {
            if (AtlasErrorCode.TYPE_NAME_NOT_FOUND == e.getAtlasErrorCode() || AtlasErrorCode.TYPE_GUID_NOT_FOUND == e.getAtlasErrorCode()) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{e.getMessage()});
            }
            throw e;
        }
    }

    private class TypeRegistryUpdateHook
    extends GraphTransactionInterceptor.PostTransactionHook {
        private final AtlasTypeRegistry.AtlasTransientTypeRegistry ttr;

        private TypeRegistryUpdateHook(AtlasTypeRegistry.AtlasTransientTypeRegistry ttr) {
            this.ttr = ttr;
        }

        @Override
        public void onComplete(boolean isSuccess) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> TypeRegistryUpdateHook.onComplete({})", (Object)isSuccess);
            }
            AtlasTypeDefGraphStore.this.typeRegistry.releaseTypeRegistryForUpdate(this.ttr, isSuccess);
            if (isSuccess) {
                this.notifyListeners(this.ttr);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== TypeRegistryUpdateHook.onComplete({})", (Object)isSuccess);
            }
        }

        private void notifyListeners(AtlasTypeRegistry.AtlasTransientTypeRegistry ttr) {
            if (CollectionUtils.isNotEmpty((Collection)AtlasTypeDefGraphStore.this.typeDefChangeListeners)) {
                ChangedTypeDefs changedTypeDefs = new ChangedTypeDefs(ttr.getAddedTypes(), ttr.getUpdatedTypes(), ttr.getDeleteedTypes());
                for (TypeDefChangeListener changeListener : AtlasTypeDefGraphStore.this.typeDefChangeListeners) {
                    try {
                        changeListener.onChange(changedTypeDefs);
                    }
                    catch (Throwable t) {
                        LOG.error("OnChange failed for listener {}", (Object)changeListener.getClass().getName(), (Object)t);
                    }
                }
            }
        }
    }
}

