/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.DeleteType;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasCheckStateRequest;
import org.apache.atlas.model.instance.AtlasCheckStateResult;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasEntityHeaders;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.EntityGraphDiscoveryContext;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityComparator;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityGraphDiscoveryV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.ClassificationAssociator;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityMutationContext;
import org.apache.atlas.repository.store.graph.v2.EntityStateChecker;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.util.FileUtils;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasEntityStoreV2
implements AtlasEntityStore {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityStoreV2.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"store.EntityStore");
    private final AtlasGraph graph;
    private final DeleteHandlerDelegate deleteDelegate;
    private final AtlasTypeRegistry typeRegistry;
    private final IAtlasEntityChangeNotifier entityChangeNotifier;
    private final EntityGraphMapper entityGraphMapper;
    private final EntityGraphRetriever entityRetriever;
    private boolean storeDifferentialAudits;

    @Inject
    public AtlasEntityStoreV2(AtlasGraph graph, DeleteHandlerDelegate deleteDelegate, AtlasTypeRegistry typeRegistry, IAtlasEntityChangeNotifier entityChangeNotifier, EntityGraphMapper entityGraphMapper) {
        this.graph = graph;
        this.deleteDelegate = deleteDelegate;
        this.typeRegistry = typeRegistry;
        this.entityChangeNotifier = entityChangeNotifier;
        this.entityGraphMapper = entityGraphMapper;
        this.entityRetriever = new EntityGraphRetriever(graph, typeRegistry);
        this.storeDifferentialAudits = AtlasConfiguration.STORE_DIFFERENTIAL_AUDITS.getBoolean();
    }

    @VisibleForTesting
    public void setStoreDifferentialAudits(boolean val) {
        this.storeDifferentialAudits = val;
    }

    @Override
    @GraphTransaction
    public List<String> getEntityGUIDS(String typename) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEntityGUIDS({})", (Object)typename);
        }
        if (StringUtils.isEmpty((CharSequence)typename) || !this.typeRegistry.isRegisteredType(typename)) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[0]);
        }
        List<String> ret = AtlasGraphUtilsV2.findEntityGUIDsByType(this.graph, typename);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEntityGUIDS({})", (Object)typename);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getById(String guid) throws AtlasBaseException {
        return this.getById(guid, false, false);
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getById(String guid, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntityWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getById({}, {})", (Object)guid, (Object)isMinExtInfo);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).toAtlasEntityWithExtInfo(guid, isMinExtInfo)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(ret.getEntity())), (Object[])new Object[]{"read entity: guid=", guid});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getById({}, {}): {}", new Object[]{guid, isMinExtInfo, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntityHeader getHeaderById(String guid) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntityHeader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getHeaderById({})", (Object)guid);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.graph, this.typeRegistry)).toAtlasEntityHeaderWithClassifications(guid)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, ret), (Object[])new Object[]{"read entity: guid=", guid});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getHeaderById({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getByIds(List<String> guids) throws AtlasBaseException {
        return this.getByIds(guids, false, false);
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getByIds(List<String> guids, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntitiesWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getByIds({}, {})", guids, (Object)isMinExtInfo);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).toAtlasEntitiesWithExtInfo(guids, isMinExtInfo)) != null) {
            for (String guid : guids) {
                AtlasEntity entity = ret.getEntity(guid);
                try {
                    AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity: guid=", guid});
                }
                catch (AtlasBaseException e) {
                    if (RequestContext.get().isSkipFailedEntities()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getByIds(): ignoring failure for entity {}: error code={}, message={}", new Object[]{guid, e.getAtlasErrorCode(), e.getMessage()});
                        }
                        ret.removeEntity(guid);
                        ret.removeEntity(entity);
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getByIds({}, {}): {}", new Object[]{guids, isMinExtInfo, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByUniqueAttributes(AtlasEntityType entityType, List<Map<String, Object>> uniqueAttributes, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntitiesWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEntitiesByUniqueAttributes({}, {})", (Object)entityType.getTypeName(), uniqueAttributes);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).getEntitiesByUniqueAttributes(entityType.getTypeName(), uniqueAttributes, isMinExtInfo)) != null && ret.getEntities() != null) {
            for (AtlasEntity entity : ret.getEntities()) {
                AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", guid=", entity.getGuid()});
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEntitiesByUniqueAttributes({}, {}): {}", new Object[]{entityType.getTypeName(), uniqueAttributes, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        return this.getByUniqueAttributes(entityType, uniqAttributes, false, false);
    }

    @Override
    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        AtlasVertex entityVertex;
        EntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntityWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getByUniqueAttribute({}, {})", (Object)entityType.getTypeName(), uniqAttributes);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).toAtlasEntityWithExtInfo(entityVertex = AtlasGraphUtilsV2.getVertexByUniqueAttributes(this.graph, entityType, uniqAttributes), isMinExtInfo)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), uniqAttributes.toString()});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(ret.getEntity())), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", uniqueAttributes=", uniqAttributes});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getByUniqueAttribute({}, {}): {}", new Object[]{entityType.getTypeName(), uniqAttributes, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasEntityHeader getEntityHeaderByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        AtlasVertex entityVertex;
        EntityGraphRetriever entityRetriever;
        AtlasEntityHeader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEntityHeaderByUniqueAttributes({}, {})", (Object)entityType.getTypeName(), uniqAttributes);
        }
        if ((ret = (entityRetriever = new EntityGraphRetriever(this.graph, this.typeRegistry)).toAtlasEntityHeader(entityVertex = AtlasGraphUtilsV2.getVertexByUniqueAttributes(this.graph, entityType, uniqAttributes))) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), uniqAttributes.toString()});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, ret), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", uniqueAttributes=", uniqAttributes});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEntityHeaderByUniqueAttributes({}, {}): {}", new Object[]{entityType.getTypeName(), uniqAttributes, ret});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasCheckStateResult checkState(AtlasCheckStateRequest request) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> checkState({})", (Object)request);
        }
        EntityStateChecker entityStateChecker = new EntityStateChecker(this.graph, this.typeRegistry);
        AtlasCheckStateResult ret = entityStateChecker.checkState(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== checkState({}, {})", (Object)request, (Object)ret);
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse createOrUpdate(EntityStream entityStream, boolean isPartialUpdate) throws AtlasBaseException {
        return this.createOrUpdate(entityStream, isPartialUpdate, false, false);
    }

    @Override
    @GraphTransaction(logRollback=false)
    public EntityMutationResponse createOrUpdateForImport(EntityStream entityStream) throws AtlasBaseException {
        return this.createOrUpdate(entityStream, false, true, true);
    }

    @Override
    public EntityMutationResponse createOrUpdateForImportNoCommit(EntityStream entityStream) throws AtlasBaseException {
        return this.createOrUpdate(entityStream, false, true, true);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse updateEntity(AtlasObjectId objectId, AtlasEntity.AtlasEntityWithExtInfo updatedEntityInfo, boolean isPartialUpdate) throws AtlasBaseException {
        String guid;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> updateEntity({}, {}, {})", new Object[]{objectId, updatedEntityInfo, isPartialUpdate});
        }
        if (objectId == null || updatedEntityInfo == null || updatedEntityInfo.getEntity() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"null entity-id/entity"});
        }
        if (AtlasTypeUtil.isAssignedGuid((String)objectId.getGuid())) {
            guid = objectId.getGuid();
        } else {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(objectId.getTypeName());
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{objectId.getTypeName()});
            }
            guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(this.graph, entityType, objectId.getUniqueAttributes());
        }
        AtlasEntity entity = updatedEntityInfo.getEntity();
        entity.setGuid(guid);
        return this.createOrUpdate(new AtlasEntityStream(updatedEntityInfo), isPartialUpdate, false, false);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse updateByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes, AtlasEntity.AtlasEntityWithExtInfo updatedEntityInfo) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> updateByUniqueAttributes({}, {})", (Object)entityType.getTypeName(), uniqAttributes);
        }
        if (updatedEntityInfo == null || updatedEntityInfo.getEntity() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entity to update."});
        }
        String guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(this.graph, entityType, uniqAttributes);
        AtlasEntity entity = updatedEntityInfo.getEntity();
        entity.setGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE, new AtlasEntityHeader(entity)), (Object[])new Object[]{"update entity ByUniqueAttributes"});
        return this.createOrUpdate(new AtlasEntityStream(updatedEntityInfo), true, false, false);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse updateEntityAttributeByGuid(String guid, String attrName, Object attrValue) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> updateEntityAttributeByGuid({}, {}, {})", new Object[]{guid, attrName, attrValue});
        }
        AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        AtlasEntityType entityType = (AtlasEntityType)this.typeRegistry.getType(entity.getTypeName());
        AtlasStructType.AtlasAttribute attr = entityType.getAttribute(attrName);
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE, entity), (Object[])new Object[]{"update entity ByUniqueAttributes : guid=", guid});
        if (attr == null && (attr = entityType.getRelationshipAttribute(attrName, AtlasEntityUtil.getRelationshipType((Object)attrValue))) == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{attrName, entity.getTypeName()});
        }
        AtlasType attrType = attr.getAttributeType();
        AtlasEntity updateEntity = new AtlasEntity();
        updateEntity.setGuid(guid);
        updateEntity.setTypeName(entity.getTypeName());
        switch (attrType.getTypeCategory()) {
            case PRIMITIVE: {
                updateEntity.setAttribute(attrName, attrValue);
                break;
            }
            case OBJECT_ID_TYPE: {
                AtlasObjectId objId = attrValue instanceof String ? new AtlasObjectId((String)attrValue, attr.getAttributeDef().getTypeName()) : (AtlasObjectId)attrType.getNormalizedValue(attrValue);
                updateEntity.setAttribute(attrName, (Object)objId);
                break;
            }
            default: {
                throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_UPDATE_NOT_SUPPORTED, new String[]{attrName, attrType.getTypeName()});
            }
        }
        return this.createOrUpdate(new AtlasEntityStream(updateEntity), true, false, false);
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse deleteById(String guid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        ArrayList<AtlasVertex> deletionCandidates = new ArrayList<AtlasVertex>();
        AtlasVertex vertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (vertex != null) {
            AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_DELETE, entityHeader), (Object[])new Object[]{"delete entity: guid=", guid});
            deletionCandidates.add(vertex);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Deletion request ignored for non-existent entity with guid " + guid);
        }
        EntityMutationResponse ret = this.deleteVertices(deletionCandidates);
        this.entityChangeNotifier.onEntitiesMutated(ret, false);
        return ret;
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse deleteByIds(List<String> guids) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(guids)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        ArrayList<AtlasVertex> deletionCandidates = new ArrayList<AtlasVertex>();
        for (String guid : guids) {
            AtlasVertex vertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
            if (vertex == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Deletion request ignored for non-existent entity with guid " + guid);
                continue;
            }
            AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_DELETE, entityHeader), (Object[])new Object[]{"delete entity: guid=", guid});
            deletionCandidates.add(vertex);
        }
        if (deletionCandidates.isEmpty()) {
            LOG.info("No deletion candidate entities were found for guids %s", guids);
        }
        EntityMutationResponse ret = this.deleteVertices(deletionCandidates);
        this.entityChangeNotifier.onEntitiesMutated(ret, false);
        return ret;
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse purgeByIds(Set<String> guids) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(guids)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasAdminAccessRequest)new AtlasAdminAccessRequest(AtlasPrivilege.ADMIN_PURGE), (Object[])new Object[]{"purge entity: guids=", guids});
        ArrayList<AtlasVertex> purgeCandidates = new ArrayList<AtlasVertex>();
        for (String guid : guids) {
            AtlasVertex vertex = AtlasGraphUtilsV2.findDeletedByGuid(this.graph, guid);
            if (vertex == null) {
                LOG.warn("Purge request ignored for non-existent/active entity with guid " + guid);
                continue;
            }
            purgeCandidates.add(vertex);
        }
        if (purgeCandidates.isEmpty()) {
            LOG.info("No purge candidate entities were found for guids: " + guids + " which is already deleted");
        }
        EntityMutationResponse ret = this.purgeVertices(purgeCandidates);
        this.entityChangeNotifier.onEntitiesMutated(ret, false);
        return ret;
    }

    @Override
    @GraphTransaction
    public EntityMutationResponse deleteByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        if (MapUtils.isEmpty(uniqAttributes)) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{uniqAttributes.toString()});
        }
        ArrayList<AtlasVertex> deletionCandidates = new ArrayList<AtlasVertex>();
        AtlasVertex vertex = AtlasGraphUtilsV2.findByUniqueAttributes(this.graph, entityType, uniqAttributes);
        if (vertex != null) {
            AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(vertex);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_DELETE, entityHeader), (Object[])new Object[]{"delete entity: typeName=", entityType.getTypeName(), ", uniqueAttributes=", uniqAttributes});
            deletionCandidates.add(vertex);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Deletion request ignored for non-existent entity with uniqueAttributes " + uniqAttributes);
        }
        EntityMutationResponse ret = this.deleteVertices(deletionCandidates);
        this.entityChangeNotifier.onEntitiesMutated(ret, false);
        return ret;
    }

    @Override
    @GraphTransaction
    public String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        return AtlasGraphUtilsV2.getGuidByUniqueAttributes(this.graph, entityType, uniqAttributes);
    }

    @Override
    @GraphTransaction
    public void addClassifications(String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding classifications={} to entity={}", classifications, (Object)guid);
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        if (CollectionUtils.isEmpty(classifications)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classifications(s) not specified"});
        }
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guid);
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        for (AtlasClassification classification : classifications) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_ADD_CLASSIFICATION, entityHeader, classification), (Object[])new Object[]{"add classification: guid=", guid, ", classification=", classification.getTypeName()});
        }
        EntityMutationContext context = new EntityMutationContext();
        context.cacheEntity(guid, entityVertex, this.typeRegistry.getEntityTypeByName(entityHeader.getTypeName()));
        for (AtlasClassification classification : classifications) {
            this.validateAndNormalize(classification);
        }
        this.validateEntityAssociations(guid, classifications);
        this.entityGraphMapper.addClassifications(context, guid, classifications);
    }

    @Override
    @GraphTransaction
    public void updateClassifications(String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating classifications={} for entity={}", classifications, (Object)guid);
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"AtlasEntityStoreV2.updateClassification()");
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid not specified"});
        }
        if (CollectionUtils.isEmpty(classifications)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classifications(s) not specified"});
        }
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guid);
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        for (AtlasClassification classification : classifications) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE_CLASSIFICATION, entityHeader, classification), (Object[])new Object[]{"update classification: guid=", guid, ", classification=", classification.getTypeName()});
        }
        EntityMutationContext context = new EntityMutationContext();
        context.cacheEntity(guid, entityVertex, this.typeRegistry.getEntityTypeByName(entityHeader.getTypeName()));
        for (AtlasClassification classification : classifications) {
            this.validateAndNormalize(classification);
        }
        this.entityGraphMapper.updateClassifications(context, guid, classifications);
        AtlasPerfTracer.log(perf);
    }

    @Override
    @GraphTransaction
    public void addClassification(List<String> guids, AtlasClassification classification) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding classification={} to entities={}", (Object)classification, guids);
        }
        if (CollectionUtils.isEmpty(guids)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        if (classification == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classification not specified"});
        }
        this.validateAndNormalize(classification);
        EntityMutationContext context = new EntityMutationContext();
        List<AtlasClassification> classifications = Collections.singletonList(classification);
        ArrayList<String> validGuids = new ArrayList<String>();
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guids);
        for (String guid : guids) {
            try {
                AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
                if (entityVertex == null) {
                    throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
                }
                AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
                AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_ADD_CLASSIFICATION, entityHeader, classification), (Object[])new Object[]{"add classification: guid=", guid, ", classification=", classification.getTypeName()});
                this.validateEntityAssociations(guid, classifications);
                validGuids.add(guid);
                context.cacheEntity(guid, entityVertex, this.typeRegistry.getEntityTypeByName(entityHeader.getTypeName()));
            }
            catch (AtlasBaseException abe) {
                if (RequestContext.get().isSkipFailedEntities()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("addClassification(): ignoring failure for entity {}: error code={}, message={}", new Object[]{guid, abe.getAtlasErrorCode(), abe.getMessage()});
                    continue;
                }
                throw abe;
            }
        }
        for (String guid : validGuids) {
            this.entityGraphMapper.addClassifications(context, guid, classifications);
        }
    }

    @Override
    @GraphTransaction
    public void deleteClassification(String guid, String classificationName) throws AtlasBaseException {
        this.deleteClassification(guid, classificationName, null);
    }

    @Override
    @GraphTransaction
    public void deleteClassification(String guid, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Guid(s) not specified"});
        }
        if (StringUtils.isEmpty((CharSequence)classificationName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"classifications not specified"});
        }
        GraphTransactionInterceptor.lockObjectAndReleasePostCommit(guid);
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        if (StringUtils.isEmpty((CharSequence)associatedEntityGuid) || guid.equals(associatedEntityGuid)) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_REMOVE_CLASSIFICATION, entityHeader, new AtlasClassification(classificationName)), (Object[])new Object[]{"remove classification: guid=", guid, ", classification=", classificationName});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting classification={} from entity={}", (Object)classificationName, (Object)guid);
        }
        this.entityGraphMapper.deleteClassification(guid, classificationName, associatedEntityGuid);
    }

    @GraphTransaction
    public List<AtlasClassification> retrieveClassifications(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retriving classifications for entity={}", (Object)guid);
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        return entityHeader.getClassifications();
    }

    @Override
    @GraphTransaction
    public List<AtlasClassification> getClassifications(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting classifications for entity={}", (Object)guid);
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, entityHeader), (Object[])new Object[]{"get classifications: guid=", guid});
        return entityHeader.getClassifications();
    }

    @Override
    @GraphTransaction
    public AtlasClassification getClassification(String guid, String classificationName) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting classifications for entities={}", (Object)guid);
        }
        AtlasClassification ret = null;
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        if (CollectionUtils.isNotEmpty((Collection)entityHeader.getClassifications())) {
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, entityHeader), (Object[])new Object[]{"get classification: guid=", guid, ", classification=", classificationName});
            for (AtlasClassification classification : entityHeader.getClassifications()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)classification.getTypeName(), (CharSequence)classificationName)) continue;
                if (StringUtils.isEmpty((CharSequence)classification.getEntityGuid()) || StringUtils.equalsIgnoreCase((CharSequence)classification.getEntityGuid(), (CharSequence)guid)) {
                    ret = classification;
                    break;
                }
                if (ret != null) continue;
                ret = classification;
            }
        }
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classificationName});
        }
        return ret;
    }

    @Override
    @GraphTransaction
    public String setClassifications(AtlasEntityHeaders entityHeaders) {
        ClassificationAssociator.Updater associator = new ClassificationAssociator.Updater(this.graph, this.typeRegistry, this);
        return associator.setClassifications(entityHeaders.getGuidHeaderMap());
    }

    @Override
    @GraphTransaction
    public void addOrUpdateBusinessAttributes(String guid, Map<String, Map<String, Object>> businessAttrbutes, boolean isOverwrite) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addOrUpdateBusinessAttributes(guid={}, businessAttributes={}, isOverwrite={})", new Object[]{guid, businessAttrbutes, isOverwrite});
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"guid is null/empty"});
        }
        if (MapUtils.isEmpty(businessAttrbutes)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"businessAttributes is null/empty"});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        String typeName = GraphHelper.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        Map<String, Map<String, Object>> currEntityBusinessAttributes = this.entityRetriever.getBusinessMetadata(entityVertex);
        HashSet<String> updatedBusinessMetadataNames = new HashSet<String>();
        for (String bmName : entityType.getBusinessAttributes().keySet()) {
            Map<String, Object> currBmAttrs;
            Map<String, Object> bmAttrs = businessAttrbutes.get(bmName);
            Map<String, Object> map = currBmAttrs = currEntityBusinessAttributes != null ? currEntityBusinessAttributes.get(bmName) : null;
            if (bmAttrs == null && !isOverwrite || MapUtils.isEmpty(bmAttrs) && MapUtils.isEmpty(currBmAttrs) || Objects.equals(bmAttrs, currBmAttrs)) continue;
            updatedBusinessMetadataNames.add(bmName);
        }
        AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder requestBuilder = new AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE_BUSINESS_METADATA, entityHeader);
        for (String bmName : updatedBusinessMetadataNames) {
            requestBuilder.setBusinessMetadata(bmName);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)requestBuilder.build(), (Object[])new Object[]{"add/update business-metadata: guid=", guid, ", business-metadata-name=", bmName});
        }
        this.validateBusinessAttributes(entityVertex, entityType, businessAttrbutes, isOverwrite);
        if (isOverwrite) {
            this.entityGraphMapper.setBusinessAttributes(entityVertex, entityType, businessAttrbutes);
        } else {
            this.entityGraphMapper.addOrUpdateBusinessAttributes(entityVertex, entityType, businessAttrbutes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addOrUpdateBusinessAttributes(guid={}, businessAttributes={}, isOverwrite={})", new Object[]{guid, businessAttrbutes, isOverwrite});
        }
    }

    @Override
    @GraphTransaction
    public void removeBusinessAttributes(String guid, Map<String, Map<String, Object>> businessAttributes) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> removeBusinessAttributes(guid={}, businessAttributes={})", (Object)guid, businessAttributes);
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"guid is null/empty"});
        }
        if (MapUtils.isEmpty(businessAttributes)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"businessAttributes is null/empty"});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        String typeName = GraphHelper.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder requestBuilder = new AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE_BUSINESS_METADATA, entityHeader);
        for (String bmName : businessAttributes.keySet()) {
            requestBuilder.setBusinessMetadata(bmName);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)requestBuilder.build(), (Object[])new Object[]{"remove business-metadata: guid=", guid, ", business-metadata=", bmName});
        }
        this.entityGraphMapper.removeBusinessAttributes(entityVertex, entityType, businessAttributes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== removeBusinessAttributes(guid={}, businessAttributes={})", (Object)guid, businessAttributes);
        }
    }

    @Override
    @GraphTransaction
    public void setLabels(String guid, Set<String> labels) throws AtlasBaseException {
        AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder requestBuilder;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> setLabels()");
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"guid is null/empty"});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        EntityGraphMapper.validateLabels(labels);
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        Set<Object> addedLabels = Collections.emptySet();
        HashSet removedLabels = Collections.emptySet();
        if (CollectionUtils.isEmpty((Collection)entityHeader.getLabels())) {
            addedLabels = labels;
        } else if (CollectionUtils.isEmpty(labels)) {
            removedLabels = entityHeader.getLabels();
        } else {
            addedLabels = new HashSet(CollectionUtils.subtract(labels, (Collection)entityHeader.getLabels()));
            removedLabels = new HashSet(CollectionUtils.subtract((Collection)entityHeader.getLabels(), labels));
        }
        if (addedLabels != null) {
            requestBuilder = new AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder(this.typeRegistry, AtlasPrivilege.ENTITY_ADD_LABEL, entityHeader);
            for (String string : addedLabels) {
                requestBuilder.setLabel(string);
                AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)requestBuilder.build(), (Object[])new Object[]{"add label: guid=", guid, ", label=", string});
            }
        }
        if (removedLabels != null) {
            requestBuilder = new AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder(this.typeRegistry, AtlasPrivilege.ENTITY_REMOVE_LABEL, entityHeader);
            for (String string : removedLabels) {
                requestBuilder.setLabel(string);
                AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)requestBuilder.build(), (Object[])new Object[]{"remove label: guid=", guid, ", label=", string});
            }
        }
        this.entityGraphMapper.setLabels(entityVertex, labels);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== setLabels()");
        }
    }

    @Override
    @GraphTransaction
    public void removeLabels(String guid, Set<String> labels) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> removeLabels()");
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"guid is null/empty"});
        }
        if (CollectionUtils.isEmpty(labels)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"labels is null/empty"});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder requestBuilder = new AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder(this.typeRegistry, AtlasPrivilege.ENTITY_REMOVE_LABEL, entityHeader);
        for (String label : labels) {
            requestBuilder.setLabel(label);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)requestBuilder.build(), (Object[])new Object[]{"remove label: guid=", guid, ", label=", label});
        }
        EntityGraphMapper.validateLabels(labels);
        this.entityGraphMapper.removeLabels(entityVertex, labels);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== removeLabels()");
        }
    }

    @Override
    @GraphTransaction
    public void addLabels(String guid, Set<String> labels) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addLabels()");
        }
        if (StringUtils.isEmpty((CharSequence)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"guid is null/empty"});
        }
        if (CollectionUtils.isEmpty(labels)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"labels is null/empty"});
        }
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasEntityHeader entityHeader = this.entityRetriever.toAtlasEntityHeaderWithClassifications(entityVertex);
        AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder requestBuilder = new AtlasEntityAccessRequest.AtlasEntityAccessRequestBuilder(this.typeRegistry, AtlasPrivilege.ENTITY_ADD_LABEL, entityHeader);
        for (String label : labels) {
            requestBuilder.setLabel(label);
            AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)requestBuilder.build(), (Object[])new Object[]{"add/update label: guid=", guid, ", label=", label});
        }
        EntityGraphMapper.validateLabels(labels);
        this.entityGraphMapper.addLabels(entityVertex, labels);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addLabels()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityMutationResponse createOrUpdate(EntityStream entityStream, boolean isPartialUpdate, boolean replaceClassifications, boolean replaceBusinessAttributes) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> createOrUpdate()");
        }
        if (entityStream == null || !entityStream.hasNext()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entities to create/update."});
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"createOrUpdate()");
        }
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("createOrUpdate");
        try {
            EntityMutationContext context = this.preCreateOrUpdate(entityStream, this.entityGraphMapper, isPartialUpdate);
            if (!RequestContext.get().isImportInProgress()) {
                for (AtlasEntity entity : context.getCreatedEntities()) {
                    AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_CREATE, new AtlasEntityHeader(entity)), (Object[])new Object[]{"create entity: type=", entity.getTypeName()});
                }
            }
            if (CollectionUtils.isNotEmpty(context.getUpdatedEntities())) {
                AtlasPerfMetrics.MetricRecorder checkForUnchangedEntities = RequestContext.get().startMetricRecord("checkForUnchangedEntities");
                ArrayList<AtlasEntity> entitiesToSkipUpdate = new ArrayList<AtlasEntity>();
                AtlasEntityComparator entityComparator = new AtlasEntityComparator(this.typeRegistry, this.entityRetriever, context.getGuidAssignments(), !replaceClassifications, !replaceBusinessAttributes);
                RequestContext reqContext = RequestContext.get();
                for (AtlasEntity entity : context.getUpdatedEntities()) {
                    if (entity.getStatus() == AtlasEntity.Status.DELETED) continue;
                    AtlasVertex storedVertex = context.getVertex(entity.getGuid());
                    AtlasEntityComparator.AtlasEntityDiffResult diffResult = entityComparator.getDiffResult(entity, storedVertex, !this.storeDifferentialAudits);
                    if (diffResult.hasDifference()) {
                        if (this.storeDifferentialAudits) {
                            diffResult.getDiffEntity().setGuid(entity.getGuid());
                            reqContext.cacheDifferentialEntity(diffResult.getDiffEntity());
                        }
                        if (diffResult.hasDifferenceOnlyInCustomAttributes()) {
                            reqContext.recordEntityWithCustomAttributeUpdate(entity.getGuid());
                        }
                        if (!diffResult.hasDifferenceOnlyInBusinessAttributes()) continue;
                        reqContext.recordEntityWithBusinessAttributeUpdate(entity.getGuid());
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("skipping unchanged entity: {}", (Object)entity);
                    }
                    entitiesToSkipUpdate.add(entity);
                    reqContext.recordEntityToSkip(entity.getGuid());
                }
                if (entitiesToSkipUpdate.size() > 0) {
                    context.getUpdatedEntities().removeAll(entitiesToSkipUpdate);
                }
                if (!reqContext.isImportInProgress()) {
                    for (AtlasEntity entity : context.getUpdatedEntities()) {
                        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE, new AtlasEntityHeader(entity)), (Object[])new Object[]{"update entity: type=", entity.getTypeName()});
                    }
                }
                reqContext.endMetricRecord(checkForUnchangedEntities);
            }
            EntityMutationResponse ret = this.entityGraphMapper.mapAttributesAndClassifications(context, isPartialUpdate, replaceClassifications, replaceBusinessAttributes);
            ret.setGuidAssignments(context.getGuidAssignments());
            this.entityChangeNotifier.onEntitiesMutated(ret, RequestContext.get().isImportInProgress());
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== createOrUpdate()");
            }
            EntityMutationResponse entityMutationResponse = ret;
            return entityMutationResponse;
        }
        finally {
            RequestContext.get().endMetricRecord(metric);
            AtlasPerfTracer.log((AtlasPerfTracer)perf);
        }
    }

    private EntityMutationContext preCreateOrUpdate(EntityStream entityStream, EntityGraphMapper entityGraphMapper, boolean isPartialUpdate) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("preCreateOrUpdate");
        AtlasEntityGraphDiscoveryV2 graphDiscoverer = new AtlasEntityGraphDiscoveryV2(this.graph, this.typeRegistry, entityStream, entityGraphMapper);
        EntityGraphDiscoveryContext discoveryContext = graphDiscoverer.discoverEntities();
        EntityMutationContext context = new EntityMutationContext(discoveryContext);
        RequestContext requestContext = RequestContext.get();
        for (String guid : discoveryContext.getReferencedGuids()) {
            AtlasEntity entity = entityStream.getByGuid(guid);
            if (entity == null) continue;
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), entity.getTypeName()});
            }
            this.compactAttributes(entity, entityType);
            AtlasVertex vertex = this.getResolvedEntityVertex(discoveryContext, entity);
            if (vertex != null) {
                String guidVertex;
                if (!isPartialUpdate) {
                    graphDiscoverer.validateAndNormalize(entity);
                    if (GraphHelper.isEntityIncomplete((AtlasElement)vertex).booleanValue()) {
                        vertex.removeProperty(Constants.IS_INCOMPLETE_PROPERTY_KEY);
                        entity.setIsIncomplete(Boolean.FALSE);
                    }
                } else {
                    graphDiscoverer.validateAndNormalizeForUpdate(entity);
                }
                if (!StringUtils.equals((CharSequence)(guidVertex = AtlasGraphUtilsV2.getIdFromVertex(vertex)), (CharSequence)guid)) {
                    entity.setGuid(guidVertex);
                    requestContext.recordEntityGuidUpdate(entity, guid);
                }
                context.addUpdated(guid, entity, entityType, vertex);
            } else {
                graphDiscoverer.validateAndNormalize(entity);
                vertex = RequestContext.get().isImportInProgress() && AtlasTypeUtil.isAssignedGuid((String)entity.getGuid()) ? entityGraphMapper.createVertexWithGuid(entity, entity.getGuid()) : entityGraphMapper.createVertex(entity);
                discoveryContext.addResolvedGuid(guid, vertex);
                discoveryContext.addResolvedIdByUniqAttribs(this.getAtlasObjectId(entity), vertex);
                String generatedGuid = AtlasGraphUtilsV2.getIdFromVertex(vertex);
                entity.setGuid(generatedGuid);
                requestContext.recordEntityGuidUpdate(entity, guid);
                context.addCreated(guid, entity, entityType, vertex);
            }
            if (!RequestContext.get().isImportInProgress()) continue;
            AtlasEntity.Status newStatus = entity.getStatus();
            if (newStatus != null) {
                AtlasEntity.Status currStatus = AtlasGraphUtilsV2.getState((AtlasElement)vertex);
                if (currStatus == AtlasEntity.Status.ACTIVE && newStatus == AtlasEntity.Status.DELETED) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("entity-delete via import - guid={}", (Object)guid);
                    }
                    context.addEntityToDelete(vertex);
                } else if (currStatus == AtlasEntity.Status.DELETED && newStatus == AtlasEntity.Status.ACTIVE) {
                    LOG.warn("Import is attempting to activate deleted entity (guid={}).", (Object)guid);
                    entityGraphMapper.importActivateEntity(vertex, entity);
                    context.addCreated(guid, entity, entityType, vertex);
                }
            }
            entityGraphMapper.updateSystemAttributes(vertex, entity);
        }
        RequestContext.get().endMetricRecord(metric);
        return context;
    }

    private AtlasVertex getResolvedEntityVertex(EntityGraphDiscoveryContext context, AtlasEntity entity) throws AtlasBaseException {
        AtlasObjectId objectId = this.getAtlasObjectId(entity);
        AtlasVertex ret = context.getResolvedEntityVertex(entity.getGuid());
        if (ret != null) {
            context.addResolvedIdByUniqAttribs(objectId, ret);
        } else {
            ret = context.getResolvedEntityVertex(objectId);
            if (ret != null) {
                context.addResolvedGuid(entity.getGuid(), ret);
            }
        }
        return ret;
    }

    private AtlasObjectId getAtlasObjectId(AtlasEntity entity) {
        AtlasObjectId ret = this.entityRetriever.toAtlasObjectId(entity);
        if (ret != null && !RequestContext.get().isImportInProgress() && MapUtils.isNotEmpty((Map)ret.getUniqueAttributes())) {
            ret.setGuid(null);
        }
        return ret;
    }

    private EntityMutationResponse deleteVertices(Collection<AtlasVertex> deletionCandidates) throws AtlasBaseException {
        EntityMutationResponse response = new EntityMutationResponse();
        RequestContext req = RequestContext.get();
        this.deleteDelegate.getHandler().deleteEntities(deletionCandidates);
        for (AtlasEntityHeader entity : req.getDeletedEntities()) {
            response.addEntity(EntityMutations.EntityOperation.DELETE, entity);
        }
        for (AtlasEntityHeader entity : req.getUpdatedEntities()) {
            response.addEntity(EntityMutations.EntityOperation.UPDATE, entity);
        }
        return response;
    }

    private EntityMutationResponse purgeVertices(Collection<AtlasVertex> purgeCandidates) throws AtlasBaseException {
        EntityMutationResponse response = new EntityMutationResponse();
        RequestContext req = RequestContext.get();
        req.setDeleteType(DeleteType.HARD);
        req.setPurgeRequested(true);
        this.deleteDelegate.getHandler().deleteEntities(purgeCandidates);
        for (AtlasEntityHeader entity : req.getDeletedEntities()) {
            response.addEntity(EntityMutations.EntityOperation.PURGE, entity);
        }
        return response;
    }

    private void validateAndNormalize(AtlasClassification classification) throws AtlasBaseException {
        AtlasClassificationType type = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
        if (type == null) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classification.getTypeName()});
        }
        ArrayList messages = new ArrayList();
        type.validateValue((Object)classification, classification.getTypeName(), messages);
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, messages);
        }
        type.getNormalizedValue((Object)classification);
    }

    private void validateEntityAssociations(String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        List<String> entityClassifications = this.getClassificationNames(guid);
        String entityTypeName = AtlasGraphUtilsV2.getTypeNameFromGuid(this.graph, guid);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        for (AtlasClassification classification : classifications) {
            String newClassification = classification.getTypeName();
            if (CollectionUtils.isNotEmpty(entityClassifications) && entityClassifications.contains(newClassification)) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"entity: " + guid + ", already associated with classification: " + newClassification});
            }
            AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(newClassification);
            if (classificationType.canApplyToEntityType(entityType)) continue;
            throw new AtlasBaseException(AtlasErrorCode.INVALID_ENTITY_FOR_CLASSIFICATION, new String[]{guid, entityTypeName, newClassification});
        }
    }

    private List<String> getClassificationNames(String guid) throws AtlasBaseException {
        ArrayList<String> ret = null;
        List<AtlasClassification> classifications = this.retrieveClassifications(guid);
        if (CollectionUtils.isNotEmpty(classifications)) {
            ret = new ArrayList<String>();
            for (AtlasClassification classification : classifications) {
                String entityGuid = classification.getEntityGuid();
                if (!StringUtils.isEmpty((CharSequence)entityGuid) && !StringUtils.equalsIgnoreCase((CharSequence)guid, (CharSequence)entityGuid)) continue;
                ret.add(classification.getTypeName());
            }
        }
        return ret;
    }

    private void compactAttributes(AtlasEntity entity, AtlasEntityType entityType) {
        if (entity != null) {
            for (String attrName : entityType.getRelationshipAttributes().keySet()) {
                Object attrValue;
                if (!entity.hasAttribute(attrName) || (attrValue = entity.removeAttribute(attrName)) == null) continue;
                Object relationshipAttrValue = entity.getRelationshipAttribute(attrName);
                if (relationshipAttrValue == null) {
                    entity.setRelationshipAttribute(attrName, attrValue);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("moved attribute {}.{} from attributes to relationshipAttributes", (Object)entityType.getTypeName(), (Object)attrName);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("attribute {}.{} is present in attributes and relationshipAttributes. Removed from attributes", (Object)entityType.getTypeName(), (Object)attrName);
            }
        }
    }

    private void validateBusinessAttributes(AtlasVertex entityVertex, AtlasEntityType entityType, Map<String, Map<String, Object>> businessAttributes, boolean isOverwrite) throws AtlasBaseException {
        ArrayList<String> messages = new ArrayList<String>();
        Map entityTypeBusinessMetadata = entityType.getBusinessAttributes();
        for (String bmName : businessAttributes.keySet()) {
            if (!entityTypeBusinessMetadata.containsKey(bmName)) {
                messages.add(bmName + ": invalid business-metadata for entity type " + entityType.getTypeName());
                continue;
            }
            Map entityTypeBusinessAttributes = (Map)entityTypeBusinessMetadata.get(bmName);
            Map<String, Object> entityBusinessAttributes = businessAttributes.get(bmName);
            for (AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute : entityTypeBusinessAttributes.values()) {
                boolean isAttrValuePresent;
                AtlasType attrType = bmAttribute.getAttributeType();
                String attrName = bmAttribute.getName();
                Object attrValue = entityBusinessAttributes.get(attrName);
                String fieldName = entityType.getTypeName() + "." + bmName + "." + attrName;
                if (attrValue != null) {
                    attrType.validateValue(attrValue, fieldName, messages);
                    boolean isValidLength = bmAttribute.isValidLength(attrValue);
                    if (isValidLength) continue;
                    messages.add(fieldName + ":  Business attribute-value exceeds maximum length limit");
                    continue;
                }
                if (bmAttribute.getAttributeDef().getIsOptional()) continue;
                if (isOverwrite) {
                    isAttrValuePresent = false;
                } else {
                    Object existingValue = AtlasGraphUtilsV2.getEncodedProperty(entityVertex, bmAttribute.getVertexPropertyName(), Object.class);
                    boolean bl = isAttrValuePresent = existingValue != null;
                }
                if (isAttrValuePresent) continue;
                messages.add(fieldName + ": mandatory business-metadata attribute value missing in type " + entityType.getTypeName());
            }
        }
        if (!messages.isEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS, messages);
        }
    }

    @Override
    @GraphTransaction
    public BulkImportResponse bulkCreateOrUpdateBusinessAttributes(InputStream inputStream, String fileName) throws AtlasBaseException {
        BulkImportResponse ret = new BulkImportResponse();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new AtlasBaseException(AtlasErrorCode.FILE_NAME_NOT_FOUND, new String[]{fileName});
        }
        List<String[]> fileData = FileUtils.readFileData(fileName, inputStream);
        Map<String, AtlasEntity> attributesToAssociate = this.getBusinessMetadataDefList(fileData, ret);
        for (AtlasEntity entity : attributesToAssociate.values()) {
            Map businessAttributes = entity.getBusinessAttributes();
            String guid = entity.getGuid();
            try {
                this.addOrUpdateBusinessAttributes(guid, businessAttributes, true);
                ret.addToSuccessImportInfoList(new BulkImportResponse.ImportInfo(guid, businessAttributes.toString()));
            }
            catch (Exception e) {
                LOG.error("Error occurred while updating BusinessMetadata Attributes for Entity " + guid);
                ret.addToFailedImportInfoList(new BulkImportResponse.ImportInfo(guid, businessAttributes.toString(), BulkImportResponse.ImportStatus.FAILED, e.getMessage()));
            }
        }
        return ret;
    }

    private Map<String, AtlasEntity> getBusinessMetadataDefList(List<String[]> fileData, BulkImportResponse bulkImportResponse) throws AtlasBaseException {
        HashMap<String, AtlasEntity> ret = new HashMap<String, AtlasEntity>();
        HashMap<String, AtlasVertex> vertexCache = new HashMap<String, AtlasVertex>();
        ArrayList<String> failedMsgList = new ArrayList<String>();
        for (int lineIndex = 0; lineIndex < fileData.size(); ++lineIndex) {
            AtlasEntity entity;
            Object attrValue;
            AtlasBusinessMetadataType.AtlasBusinessAttribute businessAttribute;
            AtlasStructType.AtlasAttribute uniqueAttribute;
            boolean missingFields;
            Object[] record = fileData.get(lineIndex);
            int lineIndexToLog = lineIndex + 2;
            boolean bl = missingFields = record.length < 4 || StringUtils.isBlank((CharSequence)record[0]) || StringUtils.isBlank((CharSequence)record[1]) || StringUtils.isBlank((CharSequence)record[2]) || StringUtils.isBlank((CharSequence)record[3]);
            if (missingFields) {
                failedMsgList.add("Line #" + lineIndexToLog + ": missing fields. " + Arrays.toString(record));
                continue;
            }
            String typeName = record[0];
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
            if (entityType == null) {
                failedMsgList.add("Line #" + lineIndexToLog + ": invalid entity-type '" + typeName + "'");
                continue;
            }
            Object uniqueAttrValue = record[1];
            Object bmAttribute = record[2];
            Object bmAttributeValue = record[3];
            Object uniqueAttrName = "qualifiedName";
            if (record.length > 4 && StringUtils.isNotBlank((CharSequence)record[4])) {
                uniqueAttrName = record[4];
            }
            if ((uniqueAttribute = entityType.getAttribute((String)uniqueAttrName)) == null) {
                failedMsgList.add("Line #" + lineIndexToLog + ": attribute '" + (String)uniqueAttrName + "' not found in entity-type '" + typeName + "'");
                continue;
            }
            if (!uniqueAttribute.getAttributeDef().getIsUnique()) {
                failedMsgList.add("Line #" + lineIndexToLog + ": attribute '" + (String)uniqueAttrName + "' is not an unique attribute in entity-type '" + typeName + "'");
                continue;
            }
            String vertexKey = uniqueAttribute.getVertexPropertyName() + "_" + (String)uniqueAttrValue;
            AtlasVertex vertex = (AtlasVertex)vertexCache.get(vertexKey);
            if (vertex == null) {
                vertex = AtlasGraphUtilsV2.findByTypeAndUniquePropertyName(this.graph, typeName, uniqueAttribute.getVertexUniquePropertyName(), uniqueAttrValue);
                if (vertex == null) {
                    failedMsgList.add("Line #" + lineIndexToLog + ": no " + typeName + " entity found with " + (String)uniqueAttrName + "=" + (String)uniqueAttrValue);
                    continue;
                }
                vertexCache.put(vertexKey, vertex);
            }
            if ((businessAttribute = entityType.getBusinesAAttribute((String)bmAttribute)) == null) {
                failedMsgList.add("Line #" + lineIndexToLog + ": invalid business-metadata '" + (String)bmAttribute + "' for entity type '" + entityType.getTypeName() + "'");
                continue;
            }
            if (businessAttribute.getAttributeType().getTypeCategory() == TypeCategory.ARRAY) {
                AtlasArrayType arrayType = (AtlasArrayType)businessAttribute.getAttributeType();
                List arrayValue = arrayType.getElementType() instanceof AtlasEnumType ? AtlasGraphUtilsV2.assignEnumValues((String)bmAttributeValue, (AtlasEnumType)arrayType.getElementType(), failedMsgList, lineIndex + 1) : this.assignMultipleValues((String)bmAttributeValue, arrayType.getElementTypeName(), failedMsgList, lineIndex + 1);
                attrValue = arrayValue;
            } else {
                attrValue = bmAttributeValue;
            }
            if (ret.containsKey(vertexKey)) {
                entity = (AtlasEntity)ret.get(vertexKey);
                entity.setBusinessAttribute(businessAttribute.getDefinedInType().getTypeName(), businessAttribute.getName(), attrValue);
                continue;
            }
            entity = new AtlasEntity();
            String guid = GraphHelper.getGuid(vertex);
            Map<String, Map<String, Object>> businessAttributes = this.entityRetriever.getBusinessMetadata(vertex);
            entity.setGuid(guid);
            entity.setTypeName(typeName);
            entity.setAttribute(uniqueAttribute.getName(), uniqueAttrValue);
            if (businessAttributes == null) {
                businessAttributes = new HashMap<String, Map<String, Object>>();
            }
            entity.setBusinessAttributes(businessAttributes);
            entity.setBusinessAttribute(businessAttribute.getDefinedInType().getTypeName(), businessAttribute.getName(), attrValue);
            ret.put(vertexKey, entity);
        }
        for (String failedMsg : failedMsgList) {
            LOG.error(failedMsg);
            bulkImportResponse.addToFailedImportInfoList(new BulkImportResponse.ImportInfo(BulkImportResponse.ImportStatus.FAILED, failedMsg));
        }
        return ret;
    }

    private List assignMultipleValues(String bmAttributeValues, String elementTypeName, List failedTermMsgList, int lineIndex) {
        String[] arr = bmAttributeValues.split("\\|");
        try {
            switch (elementTypeName) {
                case "float": {
                    return AtlasGraphUtilsV2.floatParser(arr, failedTermMsgList, lineIndex);
                }
                case "int": {
                    return AtlasGraphUtilsV2.intParser(arr, failedTermMsgList, lineIndex);
                }
                case "long": {
                    return AtlasGraphUtilsV2.longParser(arr, failedTermMsgList, lineIndex);
                }
                case "short": {
                    return AtlasGraphUtilsV2.shortParser(arr, failedTermMsgList, lineIndex);
                }
                case "double": {
                    return AtlasGraphUtilsV2.doubleParser(arr, failedTermMsgList, lineIndex);
                }
                case "date": {
                    return AtlasGraphUtilsV2.longParser(arr, failedTermMsgList, lineIndex);
                }
                case "boolean": {
                    return AtlasGraphUtilsV2.booleanParser(arr, failedTermMsgList, lineIndex);
                }
            }
            return Arrays.asList(arr);
        }
        catch (Exception e) {
            LOG.error("On line index " + lineIndex + "the provided BusinessMetadata AttributeValue " + bmAttributeValues + " are not of type - " + elementTypeName);
            failedTermMsgList.add("On line index " + lineIndex + "the provided BusinessMetadata AttributeValue " + bmAttributeValues + " are not of type - " + elementTypeName);
            return null;
        }
    }

    private boolean missingFieldsCheck(String[] record, BulkImportResponse bulkImportResponse, int lineIndex) {
        boolean missingFieldsCheck;
        boolean bl = missingFieldsCheck = record.length < 4 || StringUtils.isBlank((CharSequence)record[0]) || StringUtils.isBlank((CharSequence)record[1]) || StringUtils.isBlank((CharSequence)record[2]) || StringUtils.isBlank((CharSequence)record[3]);
        if (missingFieldsCheck) {
            LOG.error("Missing fields: " + Arrays.toString(record) + " at line #" + lineIndex);
            String failedTermMsgs = "Missing fields: " + Arrays.toString(record) + " at line #" + lineIndex;
            bulkImportResponse.addToFailedImportInfoList(new BulkImportResponse.ImportInfo(BulkImportResponse.ImportStatus.FAILED, failedTermMsgs, Integer.valueOf(lineIndex)));
        }
        return missingFieldsCheck;
    }
}

