/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.Iterator;
import java.util.List;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.store.graph.v2.EntityStream;

public class AtlasEntityStream
implements EntityStream {
    protected final AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo;
    protected final EntityStream entityStream;
    private Iterator<AtlasEntity> iterator;

    public AtlasEntityStream(AtlasEntity entity) {
        this(new AtlasEntity.AtlasEntitiesWithExtInfo(entity), null);
    }

    public AtlasEntityStream(List<AtlasEntity> entities) {
        this(new AtlasEntity.AtlasEntitiesWithExtInfo(entities), null);
    }

    public AtlasEntityStream(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        this(new AtlasEntity.AtlasEntitiesWithExtInfo(entityWithExtInfo), null);
    }

    public AtlasEntityStream(AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo) {
        this(entitiesWithExtInfo, null);
    }

    public AtlasEntityStream(AtlasEntity entity, EntityStream entityStream) {
        this(new AtlasEntity.AtlasEntitiesWithExtInfo(entity), entityStream);
    }

    public AtlasEntityStream(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, EntityStream entityStream) {
        this(new AtlasEntity.AtlasEntitiesWithExtInfo(entityWithExtInfo), entityStream);
    }

    public AtlasEntityStream(AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo, EntityStream entityStream) {
        this.entitiesWithExtInfo = entitiesWithExtInfo;
        this.iterator = this.entitiesWithExtInfo.getEntities().iterator();
        this.entityStream = entityStream;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public AtlasEntity next() {
        return this.iterator.hasNext() ? this.iterator.next() : null;
    }

    @Override
    public void reset() {
        this.iterator = this.entitiesWithExtInfo.getEntities().iterator();
    }

    @Override
    public AtlasEntity getByGuid(String guid) {
        return this.entityStream != null ? this.entityStream.getByGuid(guid) : this.entitiesWithExtInfo.getEntity(guid);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AtlasEntityStream{");
        sb.append("entitiesWithExtInfo=").append(this.entitiesWithExtInfo);
        sb.append(", iterator=").append(this.iterator);
        sb.append('}');
        return sb.toString();
    }
}

