/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.BulkImporter;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.repository.store.graph.v2.bulkimport.ImportStrategy;
import org.apache.atlas.repository.store.graph.v2.bulkimport.MigrationImport;
import org.apache.atlas.repository.store.graph.v2.bulkimport.RegularImport;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasStringUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BulkImporterImpl
implements BulkImporter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityStoreV2.class);
    private final AtlasEntityStore entityStore;
    private final AtlasGraph atlasGraph;
    private AtlasTypeRegistry typeRegistry;

    @Inject
    public BulkImporterImpl(AtlasGraph atlasGraph, AtlasEntityStore entityStore, AtlasTypeRegistry typeRegistry) {
        this.atlasGraph = atlasGraph;
        this.entityStore = entityStore;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public EntityMutationResponse bulkImport(EntityImportStream entityStream, AtlasImportResult importResult) throws AtlasBaseException {
        ImportStrategy importStrategy = null;
        importStrategy = AtlasStringUtil.hasOption((Map)importResult.getRequest().getOptions(), (String)"migration") ? new MigrationImport(this.atlasGraph, new AtlasGraphProvider(), this.typeRegistry) : new RegularImport(this.atlasGraph, this.entityStore, this.typeRegistry);
        LOG.info("BulkImportImpl: {}", (Object)importStrategy.getClass().getSimpleName());
        return importStrategy.run(entityStream, importResult);
    }

    @VisibleForTesting
    static String getJsonArray(String json, String vertexGuid) {
        String quotedGuid = String.format("\"%s\"", vertexGuid);
        json = StringUtils.isEmpty((String)json) ? String.format("[%s]", quotedGuid) : json.replace("]", "").concat(",").concat(quotedGuid).concat("]");
        return json;
    }

    @VisibleForTesting
    public static float updateImportProgress(Logger log, long currentIndex, long streamSize, float currentPercent, String additionalInfo) {
        float updatedPercent;
        boolean updateLog;
        long maxSize;
        double tolerance = 1.0E-6;
        int MAX_PERCENT = 100;
        long l = maxSize = currentIndex <= streamSize ? streamSize : currentIndex;
        if (maxSize <= 0L) {
            return currentPercent;
        }
        float percent = currentIndex * 100L / maxSize;
        boolean bl = updateLog = (double)Double.compare(percent, currentPercent) > 1.0E-6;
        float f = 100L < maxSize ? percent : (updatedPercent = updateLog ? (currentPercent = currentPercent + 1.0f) : currentPercent);
        if (updateLog) {
            log.info("bulkImport(): progress: {}% (of {}) - {}", new Object[]{(int)Math.ceil(percent), maxSize, additionalInfo});
        }
        return updatedPercent;
    }

    public static void updateImportMetrics(String prefix, List<AtlasEntityHeader> list, Set<String> processedGuids, AtlasImportResult importResult) {
        if (list == null) {
            return;
        }
        for (AtlasEntityHeader h : list) {
            if (processedGuids.contains(h.getGuid())) continue;
            processedGuids.add(h.getGuid());
            importResult.incrementMeticsCounter(String.format(prefix, h.getTypeName()));
        }
    }

    public static void updateVertexGuid(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, EntityGraphRetriever entityGraphRetriever, AtlasEntity entity) {
        String entityGuid = entity.getGuid();
        AtlasObjectId objectId = entityGraphRetriever.toAtlasObjectIdWithoutGuid(entity);
        AtlasEntityType entityType = typeRegistry.getEntityTypeByName(entity.getTypeName());
        String vertexGuid = null;
        try {
            vertexGuid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(atlasGraph, entityType, objectId.getUniqueAttributes());
        }
        catch (AtlasBaseException e) {
            LOG.warn("Entity: {}: Does not exist!", (Object)objectId);
            return;
        }
        if (StringUtils.isEmpty((String)vertexGuid) || vertexGuid.equals(entityGuid)) {
            return;
        }
        AtlasVertex v = AtlasGraphUtilsV2.findByGuid(atlasGraph, vertexGuid);
        if (v == null) {
            return;
        }
        BulkImporterImpl.addHistoricalGuid(v, vertexGuid);
        AtlasGraphUtilsV2.setProperty(v, org.apache.atlas.type.Constants.GUID_PROPERTY_KEY, entityGuid);
        LOG.warn("GUID Updated: Entity: {}: from: {}: to: {}", new Object[]{objectId, vertexGuid, entity.getGuid()});
    }

    public static void addHistoricalGuid(AtlasVertex v, String vertexGuid) {
        String existingJson = AtlasGraphUtilsV2.getProperty(v, Constants.HISTORICAL_GUID_PROPERTY_KEY, String.class);
        AtlasGraphUtilsV2.setProperty(v, Constants.HISTORICAL_GUID_PROPERTY_KEY, BulkImporterImpl.getJsonArray(existingJson, vertexGuid));
    }
}

