/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.tasks.ClassificationPropagationTasks;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.tasks.TaskFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClassificationPropagateTaskFactory
implements TaskFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationPropagateTaskFactory.class);
    public static final String CLASSIFICATION_PROPAGATION_ADD = "CLASSIFICATION_PROPAGATION_ADD";
    public static final String CLASSIFICATION_PROPAGATION_DELETE = "CLASSIFICATION_PROPAGATION_DELETE";
    public static final String CLASSIFICATION_PROPAGATION_RELATIONSHIP_UPDATE = "CLASSIFICATION_PROPAGATION_RELATIONSHIP_UPDATE";
    private static final List<String> supportedTypes = new ArrayList<String>(){
        {
            this.add(ClassificationPropagateTaskFactory.CLASSIFICATION_PROPAGATION_ADD);
            this.add(ClassificationPropagateTaskFactory.CLASSIFICATION_PROPAGATION_DELETE);
            this.add(ClassificationPropagateTaskFactory.CLASSIFICATION_PROPAGATION_RELATIONSHIP_UPDATE);
        }
    };
    private final AtlasGraph graph;
    private final EntityGraphMapper entityGraphMapper;
    private final DeleteHandlerDelegate deleteDelegate;
    private final AtlasRelationshipStore relationshipStore;

    @Inject
    public ClassificationPropagateTaskFactory(AtlasGraph graph, EntityGraphMapper entityGraphMapper, DeleteHandlerDelegate deleteDelegate, AtlasRelationshipStore relationshipStore) {
        this.graph = graph;
        this.entityGraphMapper = entityGraphMapper;
        this.deleteDelegate = deleteDelegate;
        this.relationshipStore = relationshipStore;
    }

    @Override
    public AbstractTask create(AtlasTask task) {
        String taskType = task.getType();
        String taskGuid = task.getGuid();
        switch (taskType) {
            case "CLASSIFICATION_PROPAGATION_ADD": {
                return new ClassificationPropagationTasks.Add(task, this.graph, this.entityGraphMapper, this.deleteDelegate, this.relationshipStore);
            }
            case "CLASSIFICATION_PROPAGATION_DELETE": {
                return new ClassificationPropagationTasks.Delete(task, this.graph, this.entityGraphMapper, this.deleteDelegate, this.relationshipStore);
            }
            case "CLASSIFICATION_PROPAGATION_RELATIONSHIP_UPDATE": {
                return new ClassificationPropagationTasks.UpdateRelationship(task, this.graph, this.entityGraphMapper, this.deleteDelegate, this.relationshipStore);
            }
        }
        LOG.warn("Type: {} - {} not found!. The task will be ignored.", (Object)taskType, (Object)taskGuid);
        return null;
    }

    @Override
    public List<String> getSupportedTypes() {
        return supportedTypes;
    }
}

