/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.exception.EntityNotFoundException;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassificationTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationTask.class);
    public static final String PARAM_ENTITY_GUID = "entityGuid";
    public static final String PARAM_CLASSIFICATION_VERTEX_ID = "classificationVertexId";
    public static final String PARAM_CLASSIFICATION_NAME = "classificationName";
    public static final String PARAM_RELATIONSHIP_GUID = "relationshipGuid";
    public static final String PARAM_RELATIONSHIP_OBJECT = "relationshipObject";
    public static final String PARAM_RELATIONSHIP_EDGE_ID = "relationshipEdgeId";
    protected final AtlasGraph graph;
    protected final EntityGraphMapper entityGraphMapper;
    protected final DeleteHandlerDelegate deleteDelegate;
    protected final AtlasRelationshipStore relationshipStore;

    public ClassificationTask(AtlasTask task, AtlasGraph graph, EntityGraphMapper entityGraphMapper, DeleteHandlerDelegate deleteDelegate, AtlasRelationshipStore relationshipStore) {
        super(task);
        this.graph = graph;
        this.entityGraphMapper = entityGraphMapper;
        this.deleteDelegate = deleteDelegate;
        this.relationshipStore = relationshipStore;
    }

    @Override
    public AtlasTask.Status perform() throws Exception {
        RequestContext.clear();
        Map params = this.getTaskDef().getParameters();
        if (MapUtils.isEmpty((Map)params)) {
            LOG.warn("Task: {}: Unable to process task: Parameters is not readable!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        String userName = this.getTaskDef().getCreatedBy();
        if (StringUtils.isEmpty((String)userName)) {
            LOG.warn("Task: {}: Unable to process task as user name is empty!", (Object)this.getTaskGuid());
            return AtlasTask.Status.FAILED;
        }
        RequestContext.get().setUser(userName, null);
        try {
            this.run(params);
            this.setStatus(AtlasTask.Status.COMPLETE);
        }
        catch (Exception e) {
            LOG.error("Task: {}: Error performing task!", (Object)this.getTaskGuid(), (Object)e);
            this.setStatus(AtlasTask.Status.FAILED);
            throw e;
        }
        finally {
            this.graph.commit();
            RequestContext.clear();
        }
        return this.getStatus();
    }

    public static Map<String, Object> toParameters(final String entityGuid, final String classificationVertexId, final String relationshipGuid, final String classificationName) {
        return new HashMap<String, Object>(){
            {
                this.put(ClassificationTask.PARAM_ENTITY_GUID, entityGuid);
                this.put(ClassificationTask.PARAM_CLASSIFICATION_VERTEX_ID, classificationVertexId);
                this.put(ClassificationTask.PARAM_CLASSIFICATION_NAME, classificationName);
                this.put(ClassificationTask.PARAM_RELATIONSHIP_GUID, relationshipGuid);
            }
        };
    }

    public static Map<String, Object> toParameters(final String relationshipEdgeId, final AtlasRelationship relationship) {
        return new HashMap<String, Object>(){
            {
                this.put(ClassificationTask.PARAM_RELATIONSHIP_EDGE_ID, relationshipEdgeId);
                this.put(ClassificationTask.PARAM_RELATIONSHIP_OBJECT, AtlasType.toJson((Object)relationship));
            }
        };
    }

    @Override
    protected void setStatus(AtlasTask.Status status) {
        super.setStatus(status);
        try {
            if (this.getTaskType() == "CLASSIFICATION_PROPAGATION_RELATIONSHIP_UPDATE") {
                this.entityGraphMapper.removePendingTaskFromEdge((String)this.getTaskDef().getParameters().get(PARAM_RELATIONSHIP_EDGE_ID), this.getTaskGuid());
            } else {
                this.entityGraphMapper.removePendingTaskFromEntity((String)this.getTaskDef().getParameters().get(PARAM_ENTITY_GUID), this.getTaskGuid());
            }
        }
        catch (AtlasBaseException | EntityNotFoundException e) {
            LOG.error("Error updating associated element for: {}", (Object)this.getTaskGuid(), (Object)e);
        }
    }

    protected abstract void run(Map<String, Object> var1) throws AtlasBaseException;
}

