/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.userprofile;

import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.profile.AtlasUserProfile;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasService
public class UserProfileService {
    private static final Logger LOG = LoggerFactory.getLogger(UserProfileService.class);
    private final DataAccess dataAccess;

    @Inject
    public UserProfileService(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public AtlasUserProfile saveUserProfile(AtlasUserProfile profile) throws AtlasBaseException {
        return this.dataAccess.save(profile);
    }

    public AtlasUserProfile getUserProfile(String userName) throws AtlasBaseException {
        AtlasUserProfile profile = new AtlasUserProfile(userName);
        return this.dataAccess.load(profile);
    }

    public AtlasUserSavedSearch addSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        String userName = savedSearch.getOwnerName();
        AtlasUserProfile userProfile = null;
        try {
            userProfile = this.getUserProfile(userName);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        if (userProfile == null) {
            userProfile = new AtlasUserProfile(userName);
        }
        this.checkIfQueryAlreadyExists(savedSearch, userProfile);
        userProfile.getSavedSearches().add(savedSearch);
        userProfile = this.dataAccess.save(userProfile);
        for (AtlasUserSavedSearch s : userProfile.getSavedSearches()) {
            if (!s.getName().equals(savedSearch.getName())) continue;
            return s;
        }
        return savedSearch;
    }

    private void checkIfQueryAlreadyExists(AtlasUserSavedSearch savedSearch, AtlasUserProfile userProfile) throws AtlasBaseException {
        for (AtlasUserSavedSearch exisingSearch : userProfile.getSavedSearches()) {
            if (!StringUtils.equals((String)exisingSearch.getOwnerName(), (String)savedSearch.getOwnerName()) || !StringUtils.equals((String)exisingSearch.getName(), (String)savedSearch.getName())) continue;
            throw new AtlasBaseException(AtlasErrorCode.SAVED_SEARCH_ALREADY_EXISTS, new String[]{savedSearch.getName(), savedSearch.getOwnerName()});
        }
    }

    public AtlasUserSavedSearch updateSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        if (StringUtils.isBlank((String)savedSearch.getGuid())) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_OBJECT_ID, new String[]{savedSearch.getGuid()});
        }
        AtlasUserSavedSearch existingSearch = this.getSavedSearch(savedSearch.getGuid());
        if (!StringUtils.equals((String)existingSearch.getOwnerName(), (String)savedSearch.getOwnerName())) {
            throw new AtlasBaseException(AtlasErrorCode.SAVED_SEARCH_CHANGE_USER, new String[]{existingSearch.getName(), existingSearch.getOwnerName(), savedSearch.getOwnerName()});
        }
        if (!StringUtils.equals((String)existingSearch.getName(), (String)savedSearch.getName())) {
            AtlasUserProfile userProfile = this.getUserProfile(existingSearch.getOwnerName());
            for (AtlasUserSavedSearch search : userProfile.getSavedSearches()) {
                if (!StringUtils.equals((String)search.getName(), (String)savedSearch.getName()) || StringUtils.equals((String)search.getGuid(), (String)savedSearch.getGuid())) continue;
                throw new AtlasBaseException(AtlasErrorCode.SAVED_SEARCH_ALREADY_EXISTS, new String[]{savedSearch.getName(), savedSearch.getOwnerName()});
            }
        }
        return this.dataAccess.save(savedSearch);
    }

    public List<AtlasUserSavedSearch> getSavedSearches(String userName) throws AtlasBaseException {
        AtlasUserProfile profile = null;
        try {
            profile = this.getUserProfile(userName);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        return profile != null ? profile.getSavedSearches() : null;
    }

    public AtlasUserSavedSearch getSavedSearch(String userName, String searchName) throws AtlasBaseException {
        AtlasUserSavedSearch ss = new AtlasUserSavedSearch(userName, searchName);
        return this.dataAccess.load(ss);
    }

    public AtlasUserSavedSearch getSavedSearch(String guid) throws AtlasBaseException {
        AtlasUserSavedSearch ss = new AtlasUserSavedSearch();
        ss.setGuid(guid);
        return this.dataAccess.load(ss);
    }

    public void deleteUserProfile(String userName) throws AtlasBaseException {
        AtlasUserProfile profile = this.getUserProfile(userName);
        this.dataAccess.delete(profile.getGuid());
    }

    public void deleteSavedSearch(String guid) throws AtlasBaseException {
        this.dataAccess.delete(guid);
    }

    public void deleteSearchBySearchName(String userName, String searchName) throws AtlasBaseException {
        this.dataAccess.delete(new AtlasUserSavedSearch(userName, searchName));
    }
}

