/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.tasks.TaskFactory;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.tasks.TaskRegistry;
import org.apache.atlas.type.AtlasType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutor.class);
    private static final TaskLogger TASK_LOG = TaskLogger.getLogger();
    private static final String TASK_NAME_FORMAT = "atlas-task-%d-";
    private final TaskRegistry registry;
    private final Map<String, TaskFactory> taskTypeFactoryMap;
    private final TaskManagement.Statistics statistics;
    private final ExecutorService executorService;

    public TaskExecutor(TaskRegistry registry, Map<String, TaskFactory> taskTypeFactoryMap, TaskManagement.Statistics statistics) {
        this.registry = registry;
        this.taskTypeFactoryMap = taskTypeFactoryMap;
        this.statistics = statistics;
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(TASK_NAME_FORMAT + Thread.currentThread().getName()).build());
    }

    public void addAll(List<AtlasTask> tasks) {
        for (AtlasTask task : tasks) {
            if (task == null) continue;
            TASK_LOG.log(task);
            this.executorService.submit(new TaskConsumer(task, this.registry, this.taskTypeFactoryMap, this.statistics));
        }
    }

    @VisibleForTesting
    void waitUntilDone() throws InterruptedException {
        Thread.sleep(5000L);
    }

    static class TaskLogger {
        private static final Logger LOG = LoggerFactory.getLogger((String)"TASKS");

        TaskLogger() {
        }

        public static TaskLogger getLogger() {
            return new TaskLogger();
        }

        public void info(String message) {
            LOG.info(message);
        }

        public void log(AtlasTask task) {
            LOG.info(AtlasType.toJson((Object)task));
        }

        public void warn(String message, AtlasTask task) {
            LOG.warn(message, (Object)AtlasType.toJson((Object)task));
        }

        public void error(String s, AtlasTask task, Exception exception) {
            LOG.error(s, (Object)AtlasType.toJson((Object)task), (Object)exception);
        }
    }

    static class TaskConsumer
    implements Runnable {
        private static final int MAX_ATTEMPT_COUNT = 3;
        private final Map<String, TaskFactory> taskTypeFactoryMap;
        private final TaskRegistry registry;
        private final TaskManagement.Statistics statistics;
        private final AtlasTask task;

        public TaskConsumer(AtlasTask task, TaskRegistry registry, Map<String, TaskFactory> taskTypeFactoryMap, TaskManagement.Statistics statistics) {
            this.task = task;
            this.registry = registry;
            this.taskTypeFactoryMap = taskTypeFactoryMap;
            this.statistics = statistics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AtlasVertex taskVertex = null;
            try {
                taskVertex = this.registry.getVertex(this.task.getGuid());
                if (this.task == null || taskVertex == null || this.task.getStatus() == AtlasTask.Status.COMPLETE) {
                    TASK_LOG.warn("Task not scheduled as it was not found or status was COMPLETE!", this.task);
                    return;
                }
                this.statistics.increment(1);
                int attemptCount = this.task.getAttemptCount();
                if (attemptCount >= 3) {
                    TASK_LOG.warn("Max retry count for task exceeded! Skipping!", this.task);
                    return;
                }
                this.performTask(taskVertex, this.task);
            }
            catch (InterruptedException exception) {
                if (this.task != null) {
                    this.registry.updateStatus(taskVertex, this.task);
                    TASK_LOG.error("{}: {}: Interrupted!", this.task, exception);
                } else {
                    LOG.error("Interrupted!", (Throwable)exception);
                }
                this.statistics.error();
            }
            catch (Exception exception) {
                if (this.task != null) {
                    this.task.updateStatusFromAttemptCount();
                    this.registry.updateStatus(taskVertex, this.task);
                    TASK_LOG.error("Error executing task. Please perform the operation again!", this.task, exception);
                } else {
                    LOG.error("Error executing. Please perform the operation again!", (Throwable)exception);
                }
                this.statistics.error();
            }
            finally {
                if (this.task != null) {
                    this.registry.commit();
                    TASK_LOG.log(this.task);
                }
            }
        }

        private void performTask(AtlasVertex taskVertex, AtlasTask task) throws Exception {
            TaskFactory factory = this.taskTypeFactoryMap.get(task.getType());
            if (factory == null) {
                LOG.error("taskTypeFactoryMap does not contain task of type: {}", (Object)task.getType());
                return;
            }
            AbstractTask runnableTask = factory.create(task);
            runnableTask.run();
            this.registry.deleteComplete(taskVertex, task);
            this.statistics.successPrint();
        }
    }
}

