/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPredicateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SearchPredicateUtil.class);
    private static Predicate ALWAYS_FALSE = new Predicate(){

        public boolean evaluate(Object object) {
            return false;
        }
    };

    public static ElementAttributePredicateGenerator getLTPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getLTPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getLTPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getLTPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getLTPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getLTPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getLTPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getLTPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getLTPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getLTPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getLTPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getLTPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getGTPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getGTPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getGTPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getGTPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getGTPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getGTPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getGTPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getGTPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getGTPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getGTPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getGTPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getGTPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getLTEPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getLTEPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getLTEPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getLTEPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getLTEPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getLTEPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getLTEPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getLTEPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getLTEPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getLTEPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getLTEPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getLTEPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getInRangePredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getInRangePredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                return this.generatePredicate(attrName, attrVal, attrVal, attrClass);
            }

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Object attrVal2, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null || attrVal2 == null ? ALWAYS_FALSE : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getInRangePredicate(attrName, attrClass, (Long)attrVal, (Long)attrVal2) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getInRangePredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getGTEPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getGTEPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getGTEPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getGTEPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getGTEPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getGTEPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getGTEPredicate(attrName, attrClass, (Double)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getGTEPredicate(attrName, attrClass, (Byte)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getGTEPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getGTEPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getGTEPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE)))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<- getGTEPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getEQPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEQPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (Boolean.class.isAssignableFrom(attrClass) ? BooleanPredicate.getEQPredicate(attrName, attrClass, (Boolean)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getEQPredicate(attrName, attrClass, (Byte)attrVal) : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getEQPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getEQPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getEQPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getEQPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getEQPredicate(attrName, attrClass, (Double)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getEQPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getEQPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getEQPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE))))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEQPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getNEQPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getNEQPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : (Boolean.class.isAssignableFrom(attrClass) ? BooleanPredicate.getNEQPredicate(attrName, attrClass, (Boolean)attrVal) : (Byte.class.isAssignableFrom(attrClass) ? BytePredicate.getNEQPredicate(attrName, attrClass, (Byte)attrVal) : (Short.class.isAssignableFrom(attrClass) ? ShortPredicate.getNEQPredicate(attrName, attrClass, (Short)attrVal) : (Integer.class.isAssignableFrom(attrClass) ? IntegerPredicate.getNEQPredicate(attrName, attrClass, (Integer)attrVal) : (Long.class.isAssignableFrom(attrClass) ? LongPredicate.getNEQPredicate(attrName, attrClass, (Long)attrVal) : (Float.class.isAssignableFrom(attrClass) ? FloatPredicate.getNEQPredicate(attrName, attrClass, (Float)attrVal) : (Double.class.isAssignableFrom(attrClass) ? DoublePredicate.getNEQPredicate(attrName, attrClass, (Double)attrVal) : (BigInteger.class.isAssignableFrom(attrClass) ? BigIntegerPredicate.getNEQPredicate(attrName, attrClass, (BigInteger)attrVal) : (BigDecimal.class.isAssignableFrom(attrClass) ? BigDecimalPredicate.getNEQPredicate(attrName, attrClass, (BigDecimal)attrVal) : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getNEQPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE))))))))));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getNEQPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getContainsAnyPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getContainsAnyPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null || !this.isValid(attrVal, attrClass) ? ALWAYS_FALSE : new ElementAttributePredicate(attrName, attrClass){

                    @Override
                    public boolean compareValue(Object vertexAttrVal) {
                        return CollectionUtils.containsAny((Collection)((Collection)attrVal), (Collection)((Collection)vertexAttrVal));
                    }
                };
                return ret;
            }

            private boolean isValid(Object attrVal, Class attrClass) {
                return attrVal instanceof Collection && Collection.class.isAssignableFrom(attrClass);
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getContainsAnyPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getContainsAllPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getContainsAllPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null || !this.isValid(attrVal, attrClass) ? ALWAYS_FALSE : new ElementAttributePredicate(attrName, attrClass){

                    @Override
                    public boolean compareValue(Object vertexAttrVal) {
                        return ((Collection)attrVal).containsAll((Collection)vertexAttrVal);
                    }
                };
                return ret;
            }

            private boolean isValid(Object attrVal, Class attrClass) {
                return attrVal instanceof Collection && Collection.class.isAssignableFrom(attrClass);
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getContainsAllPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getINPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getINPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null || !this.isValid(attrVal, attrClass) ? ALWAYS_FALSE : new ElementAttributePredicate(attrName, attrClass){

                    @Override
                    public boolean compareValue(Object vertexAttrVal) {
                        return ((Collection)attrVal).contains(vertexAttrVal);
                    }
                };
                return ret;
            }

            private boolean isValid(Object attrVal, Class attrClass) {
                return attrVal instanceof Collection;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getINPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getRegexPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getRegexPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getRegexPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getRegexPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getLIKEPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getLIKEPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getContainsPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getLIKEPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getStartsWithPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getStartsWithPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getStartsWithPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getStartsWithPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getEndsWithPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEndsWithPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getEndsWithPredicate(attrName, attrClass, (String)attrVal) : ALWAYS_FALSE);
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEndsWithPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getContainsPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getContainsPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null || attrVal == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getContainsPredicate(attrName, attrClass, (String)attrVal) : (Collection.class.isAssignableFrom(attrClass) ? new ElementAttributePredicate(attrName, attrClass){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        return ((Collection)vertexAttrVal).contains(attrVal);
                    }
                } : ALWAYS_FALSE));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getContainsPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getNotContainsPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getNotContainsPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, final Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : (String.class.isAssignableFrom(attrClass) ? StringPredicate.getNotContainsPredicate(attrName, attrClass, (String)attrVal) : (Collection.class.isAssignableFrom(attrClass) ? new ElementAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        return vertexAttrVal == null || !((Collection)vertexAttrVal).contains(attrVal);
                    }
                } : ALWAYS_FALSE));
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getNotContainsPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getIsNullPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getIsNullPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : new ElementAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        return vertexAttrVal == null;
                    }
                };
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getIsNullPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getNotNullPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getNotNullPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : new ElementAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        return vertexAttrVal != null;
                    }
                };
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getNotNullPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getNotEmptyPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getNotEmptyPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : new ElementAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        boolean ret = false;
                        if (vertexAttrVal != null) {
                            ret = vertexAttrVal instanceof Collection ? CollectionUtils.isNotEmpty((Collection)((Collection)vertexAttrVal)) : (vertexAttrVal instanceof String ? StringUtils.isNotEmpty((String)((String)vertexAttrVal)) : true);
                        }
                        return ret;
                    }
                };
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getNotEmptyPredicateGenerator");
        }
        return ret;
    }

    public static ElementAttributePredicateGenerator getIsNullOrEmptyPredicateGenerator() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getIsNullOrEmptyPredicateGenerator");
        }
        ElementAttributePredicateGenerator ret = new ElementAttributePredicateGenerator(){

            @Override
            public Predicate generatePredicate(String attrName, Object attrVal, Class attrClass) {
                Object ret = attrName == null || attrClass == null ? ALWAYS_FALSE : new ElementAttributePredicate(attrName, attrClass, true){

                    @Override
                    protected boolean compareValue(Object vertexAttrVal) {
                        boolean ret = vertexAttrVal == null ? true : (vertexAttrVal instanceof Collection ? CollectionUtils.isEmpty((Collection)((Collection)vertexAttrVal)) : (vertexAttrVal instanceof String ? StringUtils.isEmpty((String)((String)vertexAttrVal)) : false));
                        return ret;
                    }
                };
                return ret;
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getIsNullOrEmptyPredicateGenerator");
        }
        return ret;
    }

    public static Predicate generateIsEntityVertexPredicate(AtlasTypeRegistry typeRegistry) {
        return new IsEntityVertexPredicate(typeRegistry);
    }

    public static Predicate generateIsRelationshipEdgePredicate(AtlasTypeRegistry typeRegistry) {
        return new IsRelationshipEdgePredicate(typeRegistry);
    }

    static class IsRelationshipEdgePredicate
    implements Predicate {
        final AtlasTypeRegistry typeRegistry;

        public IsRelationshipEdgePredicate(AtlasTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
        }

        public boolean evaluate(Object object) {
            String typeName;
            AtlasRelationshipType type;
            AtlasEdge edge;
            AtlasEdge atlasEdge = edge = object instanceof AtlasEdge ? (AtlasEdge)object : null;
            boolean ret = edge != null ? (type = this.typeRegistry.getRelationshipTypeByName(typeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)edge))) != null : false;
            return ret;
        }
    }

    static class IsEntityVertexPredicate
    implements Predicate {
        final AtlasTypeRegistry typeRegistry;

        public IsEntityVertexPredicate(AtlasTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
        }

        public boolean evaluate(Object object) {
            String typeName;
            AtlasEntityType entityType;
            AtlasVertex vertex;
            AtlasVertex atlasVertex = vertex = object instanceof AtlasVertex ? (AtlasVertex)object : null;
            boolean ret = vertex != null ? (entityType = this.typeRegistry.getEntityTypeByName(typeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex))) != null && !entityType.isInternalType() : false;
            return ret;
        }
    }

    static abstract class StringPredicate
    extends ElementAttributePredicate {
        final String value;

        StringPredicate(String attrName, Class attrClass, String value) {
            super(attrName, attrClass);
            this.value = value;
        }

        StringPredicate(String attrName, Class attrClass, String value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((String)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }

        static ElementAttributePredicate getContainsPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).contains(this.value);
                }
            };
        }

        static ElementAttributePredicate getNotContainsPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || !((String)vertexAttrVal).contains(this.value);
                }
            };
        }

        static ElementAttributePredicate getStartsWithPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).startsWith(this.value);
                }
            };
        }

        static ElementAttributePredicate getEndsWithPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((String)vertexAttrVal).endsWith(this.value);
                }
            };
        }

        static ElementAttributePredicate getRegexPredicate(String attrName, Class attrClass, String value) {
            return new StringPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    Pattern pattern = Pattern.compile(this.value, 2);
                    Matcher matcher = pattern.matcher((String)vertexAttrVal);
                    return matcher.matches();
                }
            };
        }
    }

    static abstract class BigDecimalPredicate
    extends ElementAttributePredicate {
        final BigDecimal value;

        BigDecimalPredicate(String attrName, Class attrClass, BigDecimal value) {
            super(attrName, attrClass);
            this.value = value;
        }

        BigDecimalPredicate(String attrName, Class attrClass, BigDecimal value, boolean isNullValid) {
            super(attrName, attrClass, true);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((BigDecimal)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, BigDecimal value) {
            return new BigDecimalPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigDecimal)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class BigIntegerPredicate
    extends ElementAttributePredicate {
        final BigInteger value;

        BigIntegerPredicate(String attrName, Class attrClass, BigInteger value) {
            super(attrName, attrClass);
            this.value = value;
        }

        BigIntegerPredicate(String attrName, Class attrClass, BigInteger value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((BigInteger)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, BigInteger value) {
            return new BigIntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((BigInteger)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class BytePredicate
    extends ElementAttributePredicate {
        final Byte value;

        BytePredicate(String attrName, Class attrClass, Byte value) {
            super(attrName, attrClass);
            this.value = value;
        }

        BytePredicate(String attrName, Class attrClass, Byte value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((Byte)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, Byte value) {
            return new BytePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Byte)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class DoublePredicate
    extends ElementAttributePredicate {
        final Double value;

        DoublePredicate(String attrName, Class attrClass, Double value) {
            super(attrName, attrClass);
            this.value = value;
        }

        DoublePredicate(String attrName, Class attrClass, Double value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((Double)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, Double value) {
            return new DoublePredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Double)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class FloatPredicate
    extends ElementAttributePredicate {
        final Float value;

        FloatPredicate(String attrName, Class attrClass, Float value) {
            super(attrName, attrClass);
            this.value = value;
        }

        FloatPredicate(String attrName, Class attrClass, Float value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((Float)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, Float value) {
            return new FloatPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Float)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class LongPredicate
    extends ElementAttributePredicate {
        final Long value;
        final Long value2;

        LongPredicate(String attrName, Class attrClass, Long value) {
            super(attrName, attrClass);
            this.value = value;
            this.value2 = null;
        }

        LongPredicate(String attrName, Class attrClass, Long value, Long value2, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
            this.value2 = value2;
        }

        LongPredicate(String attrName, Class attrClass, Long value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
            this.value2 = null;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((Long)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, Long value) {
            return new LongPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }

        static ElementAttributePredicate getInRangePredicate(String attrName, Class attrClass, Long rangeStart, Long rangeEnd) {
            return new LongPredicate(attrName, attrClass, rangeStart, rangeEnd, false){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Long)vertexAttrVal).compareTo(this.value) >= 0 && ((Long)vertexAttrVal).compareTo(this.value2) <= 0;
                }
            };
        }
    }

    static abstract class IntegerPredicate
    extends ElementAttributePredicate {
        final Integer value;

        IntegerPredicate(String attrName, Class attrClass, Integer value) {
            super(attrName, attrClass);
            this.value = value;
        }

        IntegerPredicate(String attrName, Class attrClass, Integer value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((Integer)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, Integer value) {
            return new IntegerPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Integer)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class ShortPredicate
    extends ElementAttributePredicate {
        final Short value;

        ShortPredicate(String attrName, Class attrClass, Short value) {
            super(attrName, attrClass);
            this.value = value;
        }

        ShortPredicate(String attrName, Class attrClass, Short value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((Short)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }

        static ElementAttributePredicate getLTPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) < 0;
                }
            };
        }

        static ElementAttributePredicate getLTEPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) <= 0;
                }
            };
        }

        static ElementAttributePredicate getGTPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) > 0;
                }
            };
        }

        static ElementAttributePredicate getGTEPredicate(String attrName, Class attrClass, Short value) {
            return new ShortPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Short)vertexAttrVal).compareTo(this.value) >= 0;
                }
            };
        }
    }

    static abstract class BooleanPredicate
    extends ElementAttributePredicate {
        final Boolean value;

        BooleanPredicate(String attrName, Class attrClass, Boolean value) {
            super(attrName, attrClass);
            this.value = value;
        }

        BooleanPredicate(String attrName, Class attrClass, Boolean value, boolean isNullValid) {
            super(attrName, attrClass, isNullValid);
            this.value = value;
        }

        static ElementAttributePredicate getEQPredicate(String attrName, Class attrClass, Boolean value) {
            return new BooleanPredicate(attrName, attrClass, value){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return ((Boolean)vertexAttrVal).compareTo(this.value) == 0;
                }
            };
        }

        static ElementAttributePredicate getNEQPredicate(String attrName, Class attrClass, Boolean value) {
            return new BooleanPredicate(attrName, attrClass, value, true){

                @Override
                protected boolean compareValue(Object vertexAttrVal) {
                    return vertexAttrVal == null || ((Boolean)vertexAttrVal).compareTo(this.value) != 0;
                }
            };
        }
    }

    static abstract class ElementAttributePredicate
    implements Predicate {
        final String attrName;
        final Class attrClass;
        final boolean isNullValid;

        ElementAttributePredicate(String attrName, Class attrClass) {
            this(attrName, attrClass, false);
        }

        ElementAttributePredicate(String attrName, Class attrClass, boolean isNullValid) {
            this.attrName = attrName;
            this.attrClass = attrClass;
            this.isNullValid = isNullValid;
        }

        public boolean evaluate(Object object) {
            boolean ret;
            AtlasElement element;
            Object object2 = element = object instanceof AtlasVertex || object instanceof AtlasEdge ? (AtlasElement)object : null;
            if (element != null) {
                Collection<Object> attrValue = Collection.class.isAssignableFrom(this.attrClass) ? element.getPropertyValues(this.attrName, this.attrClass) : AtlasGraphUtilsV2.getProperty(element, this.attrName, this.attrClass);
                ret = (this.isNullValid || attrValue != null) && this.compareValue(attrValue);
            } else {
                ret = false;
            }
            return ret;
        }

        protected abstract boolean compareValue(Object var1);
    }

    public static interface ElementAttributePredicateGenerator {
        public Predicate generatePredicate(String var1, Object var2, Class var3);

        default public Predicate generatePredicate(String attrName, Object attrVal, Object attrVal2, Class attrClass) {
            return this.generatePredicate(attrName, attrVal, attrClass);
        }
    }
}

