/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.discovery.SearchContext;

@AtlasService
public class SearchTracker {
    private Map<String, SearchContext> activeSearches = new HashMap<String, SearchContext>();

    public String add(SearchContext context) {
        String searchId = Thread.currentThread().getName();
        this.activeSearches.put(searchId, context);
        return searchId;
    }

    public SearchContext terminate(String searchId) {
        SearchContext ret = null;
        if (this.activeSearches.containsKey(searchId)) {
            SearchContext pipelineToTerminate = this.activeSearches.remove(searchId);
            pipelineToTerminate.terminateSearch(true);
            ret = pipelineToTerminate;
        }
        return ret;
    }

    public SearchContext remove(String id) {
        return this.activeSearches.remove(id);
    }

    public Set<String> getActiveSearches() {
        return this.activeSearches.keySet();
    }
}

