/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.atlas.hbase.bridge.HBaseAtlasHook;
import org.apache.atlas.notification.hook.HookNotification;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.security.UserGroupInformation;

public class HBaseOperationContext {
    private final UserGroupInformation ugi;
    private final Map<String, String> hbaseConf;
    private final HBaseAtlasHook.OPERATION operation;
    private final String user;
    private final NamespaceDescriptor namespaceDescriptor;
    private final HTableDescriptor hTableDescriptor;
    private final HColumnDescriptor[] hColumnDescriptors;
    private final TableName tableName;
    private final String nameSpace;
    private final String columnFamily;
    private final String owner;
    private final HColumnDescriptor hColumnDescriptor;
    private List<HookNotification.HookNotificationMessage> messages = new ArrayList<HookNotification.HookNotificationMessage>();

    public HBaseOperationContext(NamespaceDescriptor namespaceDescriptor, String nameSpace, HTableDescriptor hTableDescriptor, TableName tableName, HColumnDescriptor[] hColumnDescriptors, HColumnDescriptor hColumnDescriptor, String columnFamily, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner, Map<String, String> hbaseConf) {
        this.namespaceDescriptor = namespaceDescriptor;
        this.nameSpace = nameSpace;
        this.hTableDescriptor = hTableDescriptor;
        this.tableName = tableName;
        this.hColumnDescriptors = hColumnDescriptors;
        this.hColumnDescriptor = hColumnDescriptor;
        this.columnFamily = columnFamily;
        this.operation = operation;
        this.ugi = ugi;
        this.user = user;
        this.owner = owner;
        this.hbaseConf = hbaseConf;
    }

    public HBaseOperationContext(NamespaceDescriptor namespaceDescriptor, String nameSpace, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner) {
        this(namespaceDescriptor, nameSpace, null, null, null, null, null, operation, ugi, user, owner, null);
    }

    public HBaseOperationContext(String nameSpace, HTableDescriptor hTableDescriptor, TableName tableName, HColumnDescriptor[] hColumnDescriptor, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner, Map<String, String> hbaseConf) {
        this(null, nameSpace, hTableDescriptor, tableName, hColumnDescriptor, null, null, operation, ugi, user, owner, hbaseConf);
    }

    public HBaseOperationContext(String nameSpace, TableName tableName, HColumnDescriptor hColumnDescriptor, String columnFamily, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner, Map<String, String> hbaseConf) {
        this(null, nameSpace, null, tableName, null, hColumnDescriptor, columnFamily, operation, ugi, user, owner, hbaseConf);
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public Map<String, String> getHbaseConf() {
        return this.hbaseConf;
    }

    public String getUser() {
        return this.user;
    }

    public HBaseAtlasHook.OPERATION getOperation() {
        return this.operation;
    }

    public NamespaceDescriptor getNamespaceDescriptor() {
        return this.namespaceDescriptor;
    }

    public HTableDescriptor gethTableDescriptor() {
        return this.hTableDescriptor;
    }

    public HColumnDescriptor[] gethColumnDescriptors() {
        return this.hColumnDescriptors;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public HColumnDescriptor gethColumnDescriptor() {
        return this.hColumnDescriptor;
    }

    public String getColummFamily() {
        return this.columnFamily;
    }

    public void addMessage(HookNotification.HookNotificationMessage message) {
        this.messages.add(message);
    }

    public String getOwner() {
        return this.owner;
    }

    public List<HookNotification.HookNotificationMessage> getMessages() {
        return this.messages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("HBaseOperationContext={");
        sb.append("Operation={").append((Object)this.operation).append("} ");
        sb.append("User ={").append(this.user).append("} ");
        if (this.nameSpace != null) {
            sb.append("NameSpace={").append(this.nameSpace).append("}");
        } else if (this.namespaceDescriptor != null) {
            sb.append("NameSpace={").append(this.namespaceDescriptor.toString()).append("}");
        }
        if (this.tableName != null) {
            sb.append("Table={").append(this.tableName).append("}");
        } else if (this.hColumnDescriptor != null) {
            sb.append("Table={").append(this.hTableDescriptor.toString()).append("}");
        }
        if (this.columnFamily != null) {
            sb.append("Columm Family={").append(this.columnFamily).append("}");
        } else if (this.hColumnDescriptor != null) {
            sb.append("Columm Family={").append(this.hColumnDescriptor.toString()).append("}");
        }
        sb.append("Message ={").append(this.getMessages()).append("} ");
        sb.append(" }");
        return sb;
    }
}

