/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHBaseEntitiesBase {
    private static final Logger LOG = LoggerFactory.getLogger(ImportHBaseEntitiesBase.class);
    static final String NAMESPACE_FLAG = "-n";
    static final String TABLE_FLAG = "-t";
    static final String NAMESPACE_FULL_FLAG = "--namespace";
    static final String TABLE_FULL_FLAG = "--tablename";
    static final String ATLAS_ENDPOINT = "atlas.rest.address";
    static final String DEFAULT_ATLAS_URL = "http://localhost:21000/";
    static final String NAMESPACE_TYPE = "hbase_namespace";
    static final String TABLE_TYPE = "hbase_table";
    static final String COLUMNFAMILY_TYPE = "hbase_column_family";
    static final String HBASE_CLUSTER_NAME = "atlas.cluster.name";
    static final String DEFAULT_CLUSTER_NAME = "primary";
    static final String QUALIFIED_NAME = "qualifiedName";
    static final String NAME = "name";
    static final String URI = "uri";
    static final String OWNER = "owner";
    static final String DESCRIPTION_ATTR = "description";
    static final String CLUSTERNAME = "clusterName";
    static final String NAMESPACE = "namespace";
    static final String TABLE = "table";
    static final String COLUMN_FAMILIES = "column_families";
    protected final HBaseAdmin hbaseAdmin;
    protected final boolean failOnError;
    protected final String namespaceToImport;
    protected final String tableToImport;
    private final AtlasClientV2 atlasClientV2;
    private final UserGroupInformation ugi;
    private final String clusterName;
    private final HashMap<String, AtlasEntity> nameSpaceCache = new HashMap();
    private final HashMap<String, AtlasEntity> tableCache = new HashMap();
    private final HashMap<String, AtlasEntity> columnFamilyCache = new HashMap();

    protected ImportHBaseEntitiesBase(String[] args) throws Exception {
        this.checkArgs(args);
        Configuration atlasConf = ApplicationProperties.get();
        String[] urls = atlasConf.getStringArray(ATLAS_ENDPOINT);
        if (urls == null || urls.length == 0) {
            urls = new String[]{DEFAULT_ATLAS_URL};
        }
        if (!AuthenticationUtil.isKerberosAuthenticationEnabled()) {
            String[] basicAuthUsernamePassword = AuthenticationUtil.getBasicAuthenticationInput();
            this.ugi = null;
            this.atlasClientV2 = new AtlasClientV2(urls, basicAuthUsernamePassword);
        } else {
            this.ugi = UserGroupInformation.getCurrentUser();
            this.atlasClientV2 = new AtlasClientV2(this.ugi, this.ugi.getShortUserName(), urls);
        }
        Options options = new Options();
        options.addOption("n", NAMESPACE, true, NAMESPACE);
        options.addOption("t", TABLE, true, "tablename");
        options.addOption("failOnError", false, "failOnError");
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        this.clusterName = atlasConf.getString(HBASE_CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        this.failOnError = cmd.hasOption("failOnError");
        this.namespaceToImport = cmd.getOptionValue("n");
        this.tableToImport = cmd.getOptionValue("t");
        org.apache.hadoop.conf.Configuration conf = HBaseConfiguration.create();
        LOG.info("createHBaseClient(): checking HBase availability..");
        HBaseAdmin.checkHBaseAvailable((org.apache.hadoop.conf.Configuration)conf);
        LOG.info("createHBaseClient(): HBase is available");
        this.hbaseAdmin = new HBaseAdmin(conf);
    }

    protected AtlasEntity createOrUpdateNameSpace(NamespaceDescriptor namespaceDescriptor) throws Exception {
        String nsName = namespaceDescriptor.getName();
        String nsQualifiedName = ImportHBaseEntitiesBase.getNameSpaceQualifiedName(this.clusterName, nsName);
        AtlasEntity nsEntity = this.findNameSpaceEntityInAtlas(nsQualifiedName);
        if (nsEntity == null) {
            LOG.info("Importing NameSpace: " + nsQualifiedName);
            AtlasEntity entity = this.getNameSpaceEntity(nsName);
            nsEntity = this.createEntityInAtlas(entity);
        }
        return nsEntity;
    }

    protected AtlasEntity createOrUpdateTable(String nameSpace, String tableName, AtlasEntity nameSapceEntity, HTableDescriptor htd, HColumnDescriptor[] hcdts) throws Exception {
        String owner = htd.getOwnerString();
        String tblQualifiedName = ImportHBaseEntitiesBase.getTableQualifiedName(this.clusterName, nameSpace, tableName);
        AtlasEntity tableEntity = this.findTableEntityInAtlas(tblQualifiedName);
        if (tableEntity == null) {
            LOG.info("Importing Table: " + tblQualifiedName);
            AtlasEntity entity = this.getTableEntity(nameSpace, tableName, owner, nameSapceEntity);
            tableEntity = this.createEntityInAtlas(entity);
        }
        List<AtlasEntity> cfEntities = this.createOrUpdateColumnFamilies(nameSpace, tableName, owner, hcdts, tableEntity);
        ArrayList<AtlasObjectId> cfIDs = new ArrayList<AtlasObjectId>();
        if (CollectionUtils.isNotEmpty(cfEntities)) {
            for (AtlasEntity cfEntity : cfEntities) {
                cfIDs.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)cfEntity));
            }
        }
        tableEntity.setAttribute(COLUMN_FAMILIES, cfIDs);
        return tableEntity;
    }

    protected List<AtlasEntity> createOrUpdateColumnFamilies(String nameSpace, String tableName, String owner, HColumnDescriptor[] hcdts, AtlasEntity tableEntity) throws Exception {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        if (hcdts != null) {
            AtlasObjectId tableId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)tableEntity);
            for (HColumnDescriptor hcdt : hcdts) {
                String cfName = hcdt.getNameAsString();
                String cfQualifiedName = ImportHBaseEntitiesBase.getColumnFamilyQualifiedName(this.clusterName, nameSpace, tableName, cfName);
                AtlasEntity cfEntity = this.findColumnFamiltyEntityInAtlas(cfQualifiedName);
                if (cfEntity == null) {
                    LOG.info("Importing Column-family: " + cfQualifiedName);
                    AtlasEntity entity = this.getColumnFamilyEntity(nameSpace, tableName, owner, hcdt, tableId);
                    cfEntity = this.createEntityInAtlas(entity);
                }
                ret.add(cfEntity);
            }
        }
        return ret;
    }

    private AtlasEntity findNameSpaceEntityInAtlas(String nsQualifiedName) {
        AtlasEntity ret = this.nameSpaceCache.get(nsQualifiedName);
        if (ret == null) {
            try {
                ret = this.findEntityInAtlas(NAMESPACE_TYPE, nsQualifiedName);
                if (ret != null) {
                    this.nameSpaceCache.put(nsQualifiedName, ret);
                }
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    private AtlasEntity findTableEntityInAtlas(String tableQualifiedName) {
        AtlasEntity ret = this.tableCache.get(tableQualifiedName);
        if (ret == null) {
            try {
                ret = this.findEntityInAtlas(TABLE_TYPE, tableQualifiedName);
                if (ret != null) {
                    this.tableCache.put(tableQualifiedName, ret);
                }
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    private AtlasEntity findColumnFamiltyEntityInAtlas(String columnFamilyQualifiedName) {
        AtlasEntity ret = this.columnFamilyCache.get(columnFamilyQualifiedName);
        if (ret == null) {
            try {
                ret = this.findEntityInAtlas(COLUMNFAMILY_TYPE, columnFamilyQualifiedName);
                if (ret != null) {
                    this.columnFamilyCache.put(columnFamilyQualifiedName, ret);
                }
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    private AtlasEntity findEntityInAtlas(String typeName, String qualifiedName) throws Exception {
        Map<String, String> attributes = Collections.singletonMap(QUALIFIED_NAME, qualifiedName);
        return this.atlasClientV2.getEntityByAttribute(typeName, attributes).getEntity();
    }

    private AtlasEntity getNameSpaceEntity(String nameSpace) {
        AtlasEntity ret = new AtlasEntity(NAMESPACE_TYPE);
        String qualifiedName = ImportHBaseEntitiesBase.getNameSpaceQualifiedName(this.clusterName, nameSpace);
        ret.setAttribute(QUALIFIED_NAME, (Object)qualifiedName);
        ret.setAttribute(CLUSTERNAME, (Object)this.clusterName);
        ret.setAttribute(NAME, (Object)nameSpace);
        ret.setAttribute(DESCRIPTION_ATTR, (Object)nameSpace);
        return ret;
    }

    private AtlasEntity getTableEntity(String nameSpace, String tableName, String owner, AtlasEntity nameSpaceEntity) {
        AtlasEntity ret = new AtlasEntity(TABLE_TYPE);
        String tableQualifiedName = ImportHBaseEntitiesBase.getTableQualifiedName(this.clusterName, nameSpace, tableName);
        ret.setAttribute(QUALIFIED_NAME, (Object)tableQualifiedName);
        ret.setAttribute(CLUSTERNAME, (Object)this.clusterName);
        ret.setAttribute(NAMESPACE, (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)nameSpaceEntity));
        ret.setAttribute(NAME, (Object)tableName);
        ret.setAttribute(DESCRIPTION_ATTR, (Object)tableName);
        ret.setAttribute(OWNER, (Object)owner);
        ret.setAttribute(URI, (Object)tableName);
        return ret;
    }

    private AtlasEntity getColumnFamilyEntity(String nameSpace, String tableName, String owner, HColumnDescriptor hcdt, AtlasObjectId tableId) {
        AtlasEntity ret = new AtlasEntity(COLUMNFAMILY_TYPE);
        String cfName = hcdt.getNameAsString();
        String cfQualifiedName = ImportHBaseEntitiesBase.getColumnFamilyQualifiedName(this.clusterName, nameSpace, tableName, cfName);
        ret.setAttribute(QUALIFIED_NAME, (Object)cfQualifiedName);
        ret.setAttribute(CLUSTERNAME, (Object)this.clusterName);
        ret.setAttribute(TABLE, (Object)tableId);
        ret.setAttribute(NAME, (Object)cfName);
        ret.setAttribute(DESCRIPTION_ATTR, (Object)cfName);
        ret.setAttribute(OWNER, (Object)owner);
        return ret;
    }

    private AtlasEntity createEntityInAtlas(AtlasEntity entity) throws Exception {
        AtlasEntity ret = null;
        EntityMutationResponse response = this.atlasClientV2.createEntity(new AtlasEntity.AtlasEntityWithExtInfo(entity));
        List entities = response.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            AtlasEntity.AtlasEntityWithExtInfo getByGuidResponse = this.atlasClientV2.getEntityByGuid(((AtlasEntityHeader)entities.get(0)).getGuid());
            ret = getByGuidResponse.getEntity();
            LOG.info("Created entity: type=" + ret.getTypeName() + ", guid=" + ret.getGuid());
        }
        return ret;
    }

    private void checkArgs(String[] args) throws Exception {
        String value;
        String option = args.length > 0 ? args[0] : null;
        String string = value = args.length > 1 ? args[1] : null;
        if (option != null && value == null && (option.equalsIgnoreCase(NAMESPACE_FLAG) || option.equalsIgnoreCase(NAMESPACE_FULL_FLAG) || option.equalsIgnoreCase(TABLE_FLAG) || option.equalsIgnoreCase(TABLE_FULL_FLAG))) {
            System.out.println("Usage: import-hbase.sh [-n <namespace> OR --namespace <namespace>] [-t <table> OR --table <table>]");
            throw new Exception("Incorrect arguments..");
        }
    }

    private static String getColumnFamilyQualifiedName(String clusterName, String nameSpace, String tableName, String columnFamily) {
        tableName = ImportHBaseEntitiesBase.stripNameSpace(tableName.toLowerCase());
        return String.format("%s.%s.%s@%s", nameSpace.toLowerCase(), tableName, columnFamily.toLowerCase(), clusterName);
    }

    private static String getTableQualifiedName(String clusterName, String nameSpace, String tableName) {
        tableName = ImportHBaseEntitiesBase.stripNameSpace(tableName.toLowerCase());
        return String.format("%s.%s@%s", nameSpace.toLowerCase(), tableName, clusterName);
    }

    private static String getNameSpaceQualifiedName(String clusterName, String nameSpace) {
        return String.format("%s@%s", nameSpace.toLowerCase(), clusterName);
    }

    private static String stripNameSpace(String tableName) {
        tableName = tableName.substring(tableName.indexOf(":") + 1);
        return tableName;
    }
}

