/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.bridge;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.hbase.model.HBaseDataTypes;
import org.apache.atlas.hbase.model.HBaseOperationContext;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.notification.HookNotificationV1;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAtlasHook
extends AtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseAtlasHook.class);
    public static final String CONF_PREFIX = "atlas.hook.hbase.";
    public static final String HOOK_NUM_RETRIES = "atlas.hook.hbase.numRetries";
    public static final String QUEUE_SIZE = "atlas.hook.hbase.queueSize";
    public static final String CONF_SYNC = "atlas.hook.hbase.synchronous";
    private static final String MIN_THREADS = "atlas.hook.hbase.minThreads";
    private static final String MAX_THREADS = "atlas.hook.hbase.maxThreads";
    private static final String KEEP_ALIVE_TIME = "atlas.hook.hbase.keepAliveTime";
    private static final int minThreadsDefault = 5;
    private static final int maxThreadsDefault = 5;
    private static final int queueSizeDefault = 10000;
    private static final long keepAliveTimeDefault = 10L;
    private static final int WAIT_TIME = 3;
    private static boolean sync;
    private static ExecutorService executor;
    public static final String HBASE_CLUSTER_NAME = "atlas.cluster.name";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_ATLAS_ENDPOINT = "atlas.rest.address";
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_PARAMETERS = "parameters";
    public static final String ATTR_URI = "uri";
    public static final String ATTR_NAMESPACE = "namespace";
    public static final String ATTR_TABLE = "table";
    public static final String ATTR_COLUMNFAMILIES = "column_families";
    public static final String ATTR_CREATE_TIME = "createTime";
    public static final String ATTR_MODIFIED_TIME = "modifiedTime";
    public static final String ATTR_OWNER = "owner";
    public static final String ATTR_NAME = "name";
    private static final String REFERENCEABLE_ATTRIBUTE_NAME = "qualifiedName";
    private String clusterName = null;
    private static volatile HBaseAtlasHook me;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HBaseAtlasHook getInstance() {
        HBaseAtlasHook ret = me;
        if (ret == null) {
            try {
                Class<HBaseAtlasHook> clazz = HBaseAtlasHook.class;
                synchronized (HBaseAtlasHook.class) {
                    ret = me;
                    if (ret == null) {
                        me = ret = new HBaseAtlasHook(atlasProperties);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOG.error("Caught exception instantiating the Atlas HBase hook.", (Throwable)e);
            }
        }
        {
            return ret;
        }
    }

    public HBaseAtlasHook(Configuration atlasProperties) {
        this(atlasProperties.getString(HBASE_CLUSTER_NAME, DEFAULT_CLUSTER_NAME));
    }

    public HBaseAtlasHook(String clusterName) {
        this.clusterName = clusterName;
    }

    protected String getNumberOfRetriesPropertyKey() {
        return HOOK_NUM_RETRIES;
    }

    public void createAtlasInstances(HBaseOperationContext hbaseOperationContext) {
        OPERATION operation = hbaseOperationContext.getOperation();
        LOG.info("HBaseAtlasHook(operation={})", (Object)operation);
        switch (operation) {
            case CREATE_NAMESPACE: 
            case ALTER_NAMESPACE: {
                this.createOrUpdateNamespaceInstance(hbaseOperationContext);
                break;
            }
            case DELETE_NAMESPACE: {
                this.deleteNameSpaceInstance(hbaseOperationContext);
                break;
            }
            case CREATE_TABLE: 
            case ALTER_TABLE: {
                this.createOrUpdateTableInstance(hbaseOperationContext);
                break;
            }
            case DELETE_TABLE: {
                this.deleteTableInstance(hbaseOperationContext);
                break;
            }
            case CREATE_COLUMN_FAMILY: 
            case ALTER_COLUMN_FAMILY: {
                this.createOrUpdateColumnFamilyInstance(hbaseOperationContext);
                break;
            }
            case DELETE_COLUMN_FAMILY: {
                this.deleteColumnFamilyInstance(hbaseOperationContext);
            }
        }
    }

    private void createOrUpdateNamespaceInstance(HBaseOperationContext hbaseOperationContext) {
        Referenceable nameSpaceRef = this.buildNameSpaceRef(hbaseOperationContext);
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_NAMESPACE: {
                LOG.info("Create NameSpace {}", nameSpaceRef.get(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityCreateRequest(hbaseOperationContext.getUser(), new Referenceable[]{nameSpaceRef}));
                break;
            }
            case ALTER_NAMESPACE: {
                LOG.info("Modify NameSpace {}", nameSpaceRef.get(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityUpdateRequest(hbaseOperationContext.getUser(), new Referenceable[]{nameSpaceRef}));
            }
        }
    }

    private void deleteNameSpaceInstance(HBaseOperationContext hbaseOperationContext) {
        String nameSpaceQualifiedName = HBaseAtlasHook.getNameSpaceQualifiedName(this.clusterName, hbaseOperationContext.getNameSpace());
        LOG.info("Delete NameSpace {}", (Object)nameSpaceQualifiedName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityDeleteRequest(hbaseOperationContext.getUser(), HBaseDataTypes.HBASE_NAMESPACE.getName(), REFERENCEABLE_ATTRIBUTE_NAME, nameSpaceQualifiedName));
    }

    private void createOrUpdateTableInstance(HBaseOperationContext hbaseOperationContext) {
        Referenceable nameSpaceRef = this.buildNameSpaceRef(hbaseOperationContext);
        Referenceable tableRef = this.buildTableRef(hbaseOperationContext, nameSpaceRef);
        List<Referenceable> columnFamilyRef = this.buildColumnFamiliesRef(hbaseOperationContext, nameSpaceRef, tableRef);
        tableRef.set(ATTR_COLUMNFAMILIES, columnFamilyRef);
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_TABLE: {
                LOG.info("Create Table {}", tableRef.get(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityCreateRequest(hbaseOperationContext.getUser(), new Referenceable[]{nameSpaceRef, tableRef}));
                break;
            }
            case ALTER_TABLE: {
                LOG.info("Modify Table {}", tableRef.get(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityUpdateRequest(hbaseOperationContext.getUser(), new Referenceable[]{nameSpaceRef, tableRef}));
            }
        }
    }

    private void deleteTableInstance(HBaseOperationContext hbaseOperationContext) {
        TableName tableName = hbaseOperationContext.getTableName();
        String tableNameSpace = tableName.getNamespaceAsString();
        if (tableNameSpace == null) {
            tableNameSpace = tableName.getNameWithNamespaceInclAsString();
        }
        String tableNameStr = tableName.getNameAsString();
        String tableQualifiedName = HBaseAtlasHook.getTableQualifiedName(this.clusterName, tableNameSpace, tableNameStr);
        LOG.info("Delete Table {}", (Object)tableQualifiedName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityDeleteRequest(hbaseOperationContext.getUser(), HBaseDataTypes.HBASE_TABLE.getName(), REFERENCEABLE_ATTRIBUTE_NAME, tableQualifiedName));
    }

    private void createOrUpdateColumnFamilyInstance(HBaseOperationContext hbaseOperationContext) {
        Referenceable nameSpaceRef = this.buildNameSpaceRef(hbaseOperationContext);
        Referenceable tableRef = this.buildTableRef(hbaseOperationContext, nameSpaceRef);
        Referenceable columnFamilyRef = this.buildColumnFamilyRef(hbaseOperationContext, hbaseOperationContext.gethColumnDescriptor(), nameSpaceRef, tableRef);
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_COLUMN_FAMILY: {
                LOG.info("Create ColumnFamily {}", columnFamilyRef.get(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityCreateRequest(hbaseOperationContext.getUser(), new Referenceable[]{nameSpaceRef, tableRef, columnFamilyRef}));
                break;
            }
            case ALTER_COLUMN_FAMILY: {
                LOG.info("Alter ColumnFamily {}", columnFamilyRef.get(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityUpdateRequest(hbaseOperationContext.getUser(), new Referenceable[]{nameSpaceRef, tableRef, columnFamilyRef}));
            }
        }
    }

    private void deleteColumnFamilyInstance(HBaseOperationContext hbaseOperationContext) {
        TableName tableName = hbaseOperationContext.getTableName();
        String tableNameSpace = tableName.getNamespaceAsString();
        if (tableNameSpace == null) {
            tableNameSpace = tableName.getNameWithNamespaceInclAsString();
        }
        String tableNameStr = tableName.getNameAsString();
        String columnFamilyName = hbaseOperationContext.getColummFamily();
        String columnFamilyQualifiedName = HBaseAtlasHook.getColumnFamilyQualifiedName(this.clusterName, tableNameSpace, tableNameStr, columnFamilyName);
        LOG.info("Delete ColumnFamily {}", (Object)columnFamilyQualifiedName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotificationV1.EntityDeleteRequest(hbaseOperationContext.getUser(), HBaseDataTypes.HBASE_COLUMN_FAMILY.getName(), REFERENCEABLE_ATTRIBUTE_NAME, columnFamilyQualifiedName));
    }

    public static String getColumnFamilyQualifiedName(String clusterName, String nameSpace, String tableName, String columnFamily) {
        return String.format("%s.%s.%s@%s", nameSpace.toLowerCase(), HBaseAtlasHook.stripNameSpace(tableName.toLowerCase()), columnFamily.toLowerCase(), clusterName);
    }

    public static String getTableQualifiedName(String clusterName, String nameSpace, String tableName) {
        return String.format("%s.%s@%s", nameSpace.toLowerCase(), HBaseAtlasHook.stripNameSpace(tableName.toLowerCase()), clusterName);
    }

    public static String getNameSpaceQualifiedName(String clusterName, String nameSpace) {
        return String.format("%s@%s", nameSpace.toLowerCase(), clusterName);
    }

    private static String stripNameSpace(String tableName) {
        return tableName.substring(tableName.indexOf(":") + 1);
    }

    private Referenceable buildNameSpaceRef(HBaseOperationContext hbaseOperationContext) {
        Referenceable nameSpaceRef = new Referenceable(HBaseDataTypes.HBASE_NAMESPACE.getName(), new String[0]);
        String nameSpace = null;
        NamespaceDescriptor nameSpaceDesc = hbaseOperationContext.getNamespaceDescriptor();
        if (nameSpaceDesc != null) {
            nameSpace = hbaseOperationContext.getNamespaceDescriptor().getName();
        }
        if (nameSpace == null) {
            nameSpace = hbaseOperationContext.getNameSpace();
        }
        nameSpaceRef.set(ATTR_NAME, (Object)nameSpace);
        nameSpaceRef.set(REFERENCEABLE_ATTRIBUTE_NAME, (Object)HBaseAtlasHook.getNameSpaceQualifiedName(this.clusterName, nameSpace));
        nameSpaceRef.set("clusterName", (Object)this.clusterName);
        nameSpaceRef.set(ATTR_DESCRIPTION, (Object)nameSpace);
        nameSpaceRef.set(ATTR_PARAMETERS, hbaseOperationContext.getHbaseConf());
        nameSpaceRef.set(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        Date now = new Date(System.currentTimeMillis());
        if (OPERATION.CREATE_NAMESPACE.equals((Object)hbaseOperationContext.getOperation())) {
            nameSpaceRef.set(ATTR_CREATE_TIME, (Object)now);
            nameSpaceRef.set(ATTR_MODIFIED_TIME, (Object)now);
        } else {
            nameSpaceRef.set(ATTR_MODIFIED_TIME, (Object)now);
        }
        return nameSpaceRef;
    }

    private Referenceable buildTableRef(HBaseOperationContext hbaseOperationContext, Referenceable nameSpaceRef) {
        Referenceable tableRef = new Referenceable(HBaseDataTypes.HBASE_TABLE.getName(), new String[0]);
        String tableName = this.getTableName(hbaseOperationContext);
        String tableNameSpace = hbaseOperationContext.getNameSpace();
        String tableQualifiedName = HBaseAtlasHook.getTableQualifiedName(this.clusterName, tableNameSpace, tableName);
        OPERATION operation = hbaseOperationContext.getOperation();
        Date now = new Date(System.currentTimeMillis());
        tableRef.set(REFERENCEABLE_ATTRIBUTE_NAME, (Object)tableQualifiedName);
        tableRef.set(ATTR_NAME, (Object)tableName);
        tableRef.set(ATTR_URI, (Object)tableName);
        tableRef.set(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        tableRef.set(ATTR_DESCRIPTION, (Object)tableName);
        tableRef.set(ATTR_PARAMETERS, hbaseOperationContext.getHbaseConf());
        switch (operation) {
            case CREATE_TABLE: {
                tableRef.set(ATTR_NAMESPACE, (Object)nameSpaceRef);
                tableRef.set(ATTR_CREATE_TIME, (Object)now);
                tableRef.set(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case ALTER_TABLE: {
                tableRef.set(ATTR_NAMESPACE, (Object)nameSpaceRef);
                tableRef.set(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            default: {
                tableRef.set(ATTR_NAMESPACE, (Object)nameSpaceRef.getId());
            }
        }
        return tableRef;
    }

    private List<Referenceable> buildColumnFamiliesRef(HBaseOperationContext hbaseOperationContext, Referenceable nameSpaceRef, Referenceable tableRef) {
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        HColumnDescriptor[] hColumnDescriptors = hbaseOperationContext.gethColumnDescriptors();
        if (hColumnDescriptors != null) {
            for (HColumnDescriptor hColumnDescriptor : hColumnDescriptors) {
                Referenceable columnFamilyRef = this.buildColumnFamilyRef(hbaseOperationContext, hColumnDescriptor, nameSpaceRef, tableRef);
                entities.add(columnFamilyRef);
            }
        }
        return entities;
    }

    private Referenceable buildColumnFamilyRef(HBaseOperationContext hbaseOperationContext, HColumnDescriptor hColumnDescriptor, Referenceable nameSpaceRef, Referenceable tableReference) {
        Referenceable columnFamilyRef = new Referenceable(HBaseDataTypes.HBASE_COLUMN_FAMILY.getName(), new String[0]);
        String columnFamilyName = hColumnDescriptor.getNameAsString();
        String tableName = (String)tableReference.get(ATTR_NAME);
        String namespace = (String)nameSpaceRef.get(ATTR_NAME);
        String columnFamilyQualifiedName = HBaseAtlasHook.getColumnFamilyQualifiedName(this.clusterName, namespace, tableName, columnFamilyName);
        columnFamilyRef.set(ATTR_NAME, (Object)columnFamilyName);
        columnFamilyRef.set(ATTR_DESCRIPTION, (Object)columnFamilyName);
        columnFamilyRef.set(REFERENCEABLE_ATTRIBUTE_NAME, (Object)columnFamilyQualifiedName);
        columnFamilyRef.set(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        Date now = new Date(System.currentTimeMillis());
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_COLUMN_FAMILY: {
                columnFamilyRef.set(ATTR_TABLE, (Object)tableReference);
                columnFamilyRef.set(ATTR_CREATE_TIME, (Object)now);
                columnFamilyRef.set(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case ALTER_COLUMN_FAMILY: {
                columnFamilyRef.set(ATTR_TABLE, (Object)tableReference);
                columnFamilyRef.set(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            default: {
                columnFamilyRef.set(ATTR_TABLE, (Object)tableReference.getId());
            }
        }
        return columnFamilyRef;
    }

    private String getTableName(HBaseOperationContext hbaseOperationContext) {
        HTableDescriptor tableDescriptor = hbaseOperationContext.gethTableDescriptor();
        return tableDescriptor != null ? tableDescriptor.getNameAsString() : null;
    }

    private void notifyAsPrivilegedAction(final HBaseOperationContext hbaseOperationContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.notifyAsPrivilegedAction({})", (Object)hbaseOperationContext);
        }
        final List<HookNotification> messages = hbaseOperationContext.getMessages();
        try {
            PrivilegedExceptionAction<Object> privilegedNotify = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    HBaseAtlasHook.this.notifyEntities(messages);
                    return hbaseOperationContext;
                }
            };
            UserGroupInformation realUser = hbaseOperationContext.getUgi().getRealUser();
            String numberOfMessages = Integer.toString(messages.size());
            String operation = hbaseOperationContext.getOperation().toString();
            String user = hbaseOperationContext.getUgi().getShortUserName();
            if (realUser != null) {
                LOG.info("Sending notification for event {} as service user {} #messages {}", new Object[]{operation, realUser.getShortUserName(), numberOfMessages});
                realUser.doAs((PrivilegedExceptionAction)privilegedNotify);
            } else {
                LOG.info("Sending notification for event {} as service user {} #messages {}", new Object[]{operation, user, numberOfMessages});
                hbaseOperationContext.getUgi().doAs((PrivilegedExceptionAction)privilegedNotify);
            }
        }
        catch (Throwable e) {
            LOG.error("Error during notify {} ", (Object)hbaseOperationContext.getOperation(), (Object)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.notifyAsPrivilegedAction()");
        }
    }

    protected void notifyEntities(List<HookNotification> messages) {
        int maxRetries = atlasProperties.getInt(HOOK_NUM_RETRIES, 3);
        HBaseAtlasHook.notifyEntities(messages, (int)maxRetries);
    }

    public void sendHBaseNameSpaceOperation(final NamespaceDescriptor namespaceDescriptor, final String nameSpace, final OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseNameSpaceOperation()");
        }
        try {
            final UserGroupInformation ugi = this.getUGI();
            HBaseOperationContext hbaseOperationContext = null;
            if (executor == null) {
                hbaseOperationContext = this.handleHBaseNameSpaceOperation(namespaceDescriptor, nameSpace, operation);
                if (hbaseOperationContext != null) {
                    this.notifyAsPrivilegedAction(hbaseOperationContext);
                }
            } else {
                executor.submit(new Runnable(){
                    HBaseOperationContext hbaseOperationContext = null;

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("==> HBaseAtlasHook.sendHBaseNameSpaceOperation():executor.submit()");
                        }
                        if (ugi != null) {
                            try {
                                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() {
                                        hbaseOperationContext = HBaseAtlasHook.this.handleHBaseNameSpaceOperation(namespaceDescriptor, nameSpace, operation);
                                        return hbaseOperationContext;
                                    }
                                });
                                HBaseAtlasHook.this.notifyAsPrivilegedAction(this.hbaseOperationContext);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(){}", (Object)this.hbaseOperationContext);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(): Atlas hook failed due to error ", e);
                            }
                        } else {
                            LOG.error("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(): Atlas hook failed, UserGroupInformation cannot be NULL!");
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.error("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(): Submitting to thread pool failed due to error ", t);
        }
    }

    public void sendHBaseTableOperation(final HTableDescriptor hTableDescriptor, final TableName tableName, final OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseTableOperation()");
        }
        try {
            final UserGroupInformation ugi = this.getUGI();
            HBaseOperationContext hbaseOperationContext = null;
            if (executor == null) {
                hbaseOperationContext = this.handleHBaseTableOperation(hTableDescriptor, tableName, operation);
                if (hbaseOperationContext != null) {
                    this.notifyAsPrivilegedAction(hbaseOperationContext);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== HBaseAtlasHook.sendHBaseTableOperation(){}", (Object)hbaseOperationContext);
                }
            } else {
                executor.submit(new Runnable(){
                    HBaseOperationContext hbaseOperationContext = null;

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("==> HBaseAtlasHook.sendHBaseTableOperation():executor.submit()");
                        }
                        if (ugi != null) {
                            try {
                                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() {
                                        hbaseOperationContext = HBaseAtlasHook.this.handleHBaseTableOperation(hTableDescriptor, tableName, operation);
                                        return hbaseOperationContext;
                                    }
                                });
                                HBaseAtlasHook.this.notifyAsPrivilegedAction(this.hbaseOperationContext);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("<== HBaseAtlasHook.sendHBaseTableOperation(){}", (Object)this.hbaseOperationContext);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("<== HBaseAtlasHook.sendHBaseTableOperation(): Atlas hook failed due to error ", e);
                            }
                        } else {
                            LOG.error("<== HBaseAtlasHook.sendHBasecolumnFamilyOperation(): Atlas hook failed, UserGroupInformation cannot be NULL!");
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.error("<== HBaseAtlasHook.sendHBaseTableOperation(): Submitting to thread pool failed due to error ", t);
        }
    }

    public void sendHBaseColumnFamilyOperation(final HColumnDescriptor hColumnDescriptor, final TableName tableName, final String columnFamily, final OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseColumnFamilyOperation()");
        }
        try {
            final UserGroupInformation ugi = this.getUGI();
            HBaseOperationContext hbaseOperationContext = null;
            if (executor == null) {
                hbaseOperationContext = this.handleHBaseColumnFamilyOperation(hColumnDescriptor, tableName, columnFamily, operation);
                if (hbaseOperationContext != null) {
                    this.notifyAsPrivilegedAction(hbaseOperationContext);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(){}", (Object)hbaseOperationContext);
                }
            } else {
                executor.submit(new Runnable(){
                    HBaseOperationContext hbaseOperationContext = null;

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("==> HBaseAtlasHook.sendHBaseColumnFamilyOperation():executor.submit()");
                        }
                        if (ugi != null) {
                            try {
                                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() {
                                        hbaseOperationContext = HBaseAtlasHook.this.handleHBaseColumnFamilyOperation(hColumnDescriptor, tableName, columnFamily, operation);
                                        return hbaseOperationContext;
                                    }
                                });
                                HBaseAtlasHook.this.notifyAsPrivilegedAction(this.hbaseOperationContext);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(){}", (Object)this.hbaseOperationContext);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(): Atlas hook failed due to error ", e);
                            }
                        } else {
                            LOG.error("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(): Atlas hook failed, UserGroupInformation cannot be NULL!");
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.error("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(): Submitting to thread pool failed due to error ", t);
        }
    }

    private HBaseOperationContext handleHBaseNameSpaceOperation(NamespaceDescriptor namespaceDescriptor, String nameSpace, OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseNameSpaceOperation()");
        }
        UserGroupInformation ugi = this.getUGI();
        User user = this.getActiveUser();
        String userName = user.getShortName();
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(namespaceDescriptor, nameSpace, operation, ugi, userName, userName);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseNameSpaceOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private HBaseOperationContext handleHBaseTableOperation(HTableDescriptor hTableDescriptor, TableName tableName, OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseTableOperation()");
        }
        UserGroupInformation ugi = this.getUGI();
        User user = this.getActiveUser();
        String userName = user.getShortName();
        Map hbaseConf = null;
        String owner = null;
        String tableNameSpace = null;
        TableName hbaseTableName = null;
        HColumnDescriptor[] hColumnDescriptors = null;
        if (hTableDescriptor != null) {
            owner = hTableDescriptor.getOwnerString();
            hbaseConf = hTableDescriptor.getConfiguration();
            hbaseTableName = hTableDescriptor.getTableName();
            if (hbaseTableName != null && (tableNameSpace = hbaseTableName.getNamespaceAsString()) == null) {
                tableNameSpace = hbaseTableName.getNameWithNamespaceInclAsString();
            }
        }
        if (owner == null) {
            owner = userName;
        }
        if (hTableDescriptor != null) {
            hColumnDescriptors = hTableDescriptor.getColumnFamilies();
        }
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(tableNameSpace, hTableDescriptor, tableName, hColumnDescriptors, operation, ugi, userName, owner, (Map<String, String>)hbaseConf);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseTableOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private HBaseOperationContext handleHBaseColumnFamilyOperation(HColumnDescriptor hColumnDescriptor, TableName tableName, String columnFamily, OPERATION operation) {
        String userName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseColumnFamilyOperation()");
        }
        UserGroupInformation ugi = this.getUGI();
        User user = this.getActiveUser();
        String owner = userName = user.getShortName();
        Map hbaseConf = null;
        String tableNameSpace = tableName.getNamespaceAsString();
        if (tableNameSpace == null) {
            tableNameSpace = tableName.getNameWithNamespaceInclAsString();
        }
        if (hColumnDescriptor != null) {
            hbaseConf = hColumnDescriptor.getConfiguration();
        }
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(tableNameSpace, tableName, hColumnDescriptor, columnFamily, operation, ugi, userName, owner, (Map<String, String>)hbaseConf);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseColumnFamilyOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private User getActiveUser() {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            try {
                user = User.getCurrent();
            }
            catch (IOException e) {
                LOG.error("Unable to find the current user");
                user = null;
            }
        }
        return user;
    }

    private UserGroupInformation getUGI() {
        UserGroupInformation ugi = null;
        User user = this.getActiveUser();
        try {
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ugi == null && user != null) {
            ugi = user.getUGI();
        }
        LOG.info("HBaseAtlasHook: UGI: {}", (Object)ugi);
        return ugi;
    }

    static {
        try {
            int minThreads = atlasProperties.getInt(MIN_THREADS, 5);
            int maxThreads = atlasProperties.getInt(MAX_THREADS, 5);
            int queueSize = atlasProperties.getInt(QUEUE_SIZE, 10000);
            long keepAliveTime = atlasProperties.getLong(KEEP_ALIVE_TIME, 10L);
            sync = atlasProperties.getBoolean(CONF_SYNC, false);
            executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat("Atlas Logger %d").build());
            ShutdownHookManager.get().addShutdownHook((Runnable)new Thread(){

                @Override
                public void run() {
                    try {
                        LOG.info("==> Shutdown of Atlas HBase Hook");
                        executor.shutdown();
                        executor.awaitTermination(3L, TimeUnit.SECONDS);
                        executor = null;
                    }
                    catch (InterruptedException ie) {
                        LOG.info("Interrupt received in shutdown.", (Throwable)ie);
                    }
                    finally {
                        LOG.info("<== Shutdown of Atlas HBase Hook");
                    }
                }
            }, 30);
        }
        catch (Exception e) {
            LOG.error("Caught exception initializing the Atlas HBase hook.", (Throwable)e);
        }
        LOG.info("Created Atlas Hook for HBase");
    }

    public static enum OPERATION {
        CREATE_NAMESPACE("create_namespace"),
        ALTER_NAMESPACE("alter_namespace"),
        DELETE_NAMESPACE("delete_namespace"),
        CREATE_TABLE("create_table"),
        ALTER_TABLE("alter_table"),
        DELETE_TABLE("delete_table"),
        CREATE_COLUMN_FAMILY("create_column_Family"),
        ALTER_COLUMN_FAMILY("alter_column_Family"),
        DELETE_COLUMN_FAMILY("delete_column_Family");

        private final String name;

        private OPERATION(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }
    }
}

