/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.util;

import org.apache.atlas.hbase.util.ImportHBaseEntitiesBase;
import org.apache.atlas.hook.AtlasHookException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHBaseEntities
extends ImportHBaseEntitiesBase {
    private static final Logger LOG = LoggerFactory.getLogger(ImportHBaseEntities.class);

    public static void main(String[] args) throws AtlasHookException {
        try {
            ImportHBaseEntities importHBaseEntities = new ImportHBaseEntities(args);
            importHBaseEntities.execute();
        }
        catch (Exception e) {
            throw new AtlasHookException("ImportHBaseEntities failed.", (Throwable)e);
        }
    }

    public ImportHBaseEntities(String[] args) throws Exception {
        super(args);
    }

    public boolean execute() throws Exception {
        boolean ret = false;
        if (this.hbaseAdmin != null) {
            if (StringUtils.isEmpty((String)this.namespaceToImport) && StringUtils.isEmpty((String)this.tableToImport)) {
                Object[] htds;
                Object[] namespaceDescriptors = this.hbaseAdmin.listNamespaceDescriptors();
                if (!ArrayUtils.isEmpty((Object[])namespaceDescriptors)) {
                    for (Object namespaceDescriptor : namespaceDescriptors) {
                        String namespace = namespaceDescriptor.getName();
                        this.importNameSpace(namespace);
                    }
                }
                if (!ArrayUtils.isEmpty((Object[])(htds = this.hbaseAdmin.listTables()))) {
                    for (Object htd : htds) {
                        String tableName = htd.getNameAsString();
                        this.importTable(tableName);
                    }
                }
                ret = true;
            } else if (StringUtils.isNotEmpty((String)this.namespaceToImport)) {
                this.importNameSpace(this.namespaceToImport);
                ret = true;
            } else if (StringUtils.isNotEmpty((String)this.tableToImport)) {
                this.importTable(this.tableToImport);
                ret = true;
            }
        }
        return ret;
    }

    public String importNameSpace(String nameSpace) throws Exception {
        NamespaceDescriptor namespaceDescriptor = this.hbaseAdmin.getNamespaceDescriptor(nameSpace);
        this.createOrUpdateNameSpace(namespaceDescriptor);
        return namespaceDescriptor.getName();
    }

    public String importTable(String tableName) throws Exception {
        byte[] tblName = tableName.getBytes();
        HTableDescriptor htd = this.hbaseAdmin.getTableDescriptor(tblName);
        String nsName = htd.getTableName().getNamespaceAsString();
        NamespaceDescriptor nsDescriptor = this.hbaseAdmin.getNamespaceDescriptor(nsName);
        AtlasEntity nsEntity = this.createOrUpdateNameSpace(nsDescriptor);
        HColumnDescriptor[] hcdts = htd.getColumnFamilies();
        this.createOrUpdateTable(nsName, tableName, nsEntity, htd, hcdts);
        return htd.getTableName().getNameAsString();
    }
}

