/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.bridge;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.hbase.model.HBaseDataTypes;
import org.apache.atlas.hbase.model.HBaseOperationContext;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAtlasHook
extends AtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseAtlasHook.class);
    public static final String CONF_PREFIX = "atlas.hook.hbase.";
    public static final String HOOK_NUM_RETRIES = "atlas.hook.hbase.numRetries";
    public static final String QUEUE_SIZE = "atlas.hook.hbase.queueSize";
    public static final String CONF_SYNC = "atlas.hook.hbase.synchronous";
    private static final String MIN_THREADS = "atlas.hook.hbase.minThreads";
    private static final String MAX_THREADS = "atlas.hook.hbase.maxThreads";
    private static final String KEEP_ALIVE_TIME = "atlas.hook.hbase.keepAliveTime";
    private static final int minThreadsDefault = 5;
    private static final int maxThreadsDefault = 5;
    private static final int queueSizeDefault = 10000;
    private static final long keepAliveTimeDefault = 10L;
    private static final int WAIT_TIME = 3;
    private static boolean sync;
    private static ExecutorService executor;
    public static final String HBASE_CLUSTER_NAME = "atlas.cluster.name";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_ATLAS_ENDPOINT = "atlas.rest.address";
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_PARAMETERS = "parameters";
    public static final String ATTR_URI = "uri";
    public static final String ATTR_NAMESPACE = "namespace";
    public static final String ATTR_TABLE = "table";
    public static final String ATTR_COLUMNFAMILIES = "column_families";
    public static final String ATTR_CREATE_TIME = "createTime";
    public static final String ATTR_MODIFIED_TIME = "modifiedTime";
    public static final String ATTR_OWNER = "owner";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TABLE_MAX_FILESIZE = "maxFileSize";
    public static final String ATTR_TABLE_ISREADONLY = "isReadOnly";
    public static final String ATTR_TABLE_ISCOMPACTION_ENABLED = "isCompactionEnabled";
    public static final String ATTR_TABLE_REPLICATION_PER_REGION = "replicasPerRegion";
    public static final String ATTR_TABLE_DURABLILITY = "durability";
    public static final String ATTR_CF_BLOOMFILTER_TYPE = "bloomFilterType";
    public static final String ATTR_CF_COMPRESSION_TYPE = "compressionType";
    public static final String ATTR_CF_COMPACTION_COMPRESSION_TYPE = "compactionCompressionType";
    public static final String ATTR_CF_ENCRYPTION_TYPE = "encryptionType";
    public static final String ATTR_CF_KEEP_DELETE_CELLS = "keepDeletedCells";
    public static final String ATTR_CF_MAX_VERSIONS = "maxVersions";
    public static final String ATTR_CF_MIN_VERSIONS = "minVersions";
    public static final String ATTR_CF_DATA_BLOCK_ENCODING = "dataBlockEncoding";
    public static final String ATTR_CF_TTL = "ttl";
    public static final String ATTR_CF_BLOCK_CACHE_ENABLED = "blockCacheEnabled";
    public static final String ATTR_CF_CACHED_BLOOM_ON_WRITE = "cacheBloomsOnWrite";
    public static final String ATTR_CF_CACHED_DATA_ON_WRITE = "cacheDataOnWrite";
    public static final String ATTR_CF_CACHED_INDEXES_ON_WRITE = "cacheIndexesOnWrite";
    public static final String ATTR_CF_EVICT_BLOCK_ONCLOSE = "evictBlocksOnClose";
    public static final String ATTR_CF_PREFETCH_BLOCK_ONOPEN = "prefetchBlocksOnOpen";
    public static final String HBASE_NAMESPACE_QUALIFIED_NAME = "%s@%s";
    public static final String HBASE_TABLE_QUALIFIED_NAME_FORMAT = "%s:%s@%s";
    public static final String HBASE_COLUMN_FAMILY_QUALIFIED_NAME_FORMAT = "%s:%s.%s@%s";
    private static final String REFERENCEABLE_ATTRIBUTE_NAME = "qualifiedName";
    private String clusterName = null;
    private static volatile HBaseAtlasHook me;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HBaseAtlasHook getInstance() {
        HBaseAtlasHook ret = me;
        if (ret == null) {
            try {
                Class<HBaseAtlasHook> clazz = HBaseAtlasHook.class;
                synchronized (HBaseAtlasHook.class) {
                    ret = me;
                    if (ret == null) {
                        me = ret = new HBaseAtlasHook(atlasProperties);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOG.error("Caught exception instantiating the Atlas HBase hook.", (Throwable)e);
            }
        }
        {
            return ret;
        }
    }

    public HBaseAtlasHook(Configuration atlasProperties) {
        this(atlasProperties.getString(HBASE_CLUSTER_NAME, DEFAULT_CLUSTER_NAME));
    }

    public HBaseAtlasHook(String clusterName) {
        this.clusterName = clusterName;
    }

    protected String getNumberOfRetriesPropertyKey() {
        return HOOK_NUM_RETRIES;
    }

    public void createAtlasInstances(HBaseOperationContext hbaseOperationContext) {
        OPERATION operation = hbaseOperationContext.getOperation();
        LOG.info("HBaseAtlasHook(operation={})", (Object)operation);
        switch (operation) {
            case CREATE_NAMESPACE: 
            case ALTER_NAMESPACE: {
                this.createOrUpdateNamespaceInstance(hbaseOperationContext);
                break;
            }
            case DELETE_NAMESPACE: {
                this.deleteNameSpaceInstance(hbaseOperationContext);
                break;
            }
            case CREATE_TABLE: 
            case ALTER_TABLE: {
                this.createOrUpdateTableInstance(hbaseOperationContext);
                break;
            }
            case DELETE_TABLE: {
                this.deleteTableInstance(hbaseOperationContext);
                break;
            }
            case CREATE_COLUMN_FAMILY: 
            case ALTER_COLUMN_FAMILY: {
                this.createOrUpdateColumnFamilyInstance(hbaseOperationContext);
                break;
            }
            case DELETE_COLUMN_FAMILY: {
                this.deleteColumnFamilyInstance(hbaseOperationContext);
            }
        }
    }

    private void createOrUpdateNamespaceInstance(HBaseOperationContext hbaseOperationContext) {
        AtlasEntity nameSpace = this.buildNameSpace(hbaseOperationContext);
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_NAMESPACE: {
                LOG.info("Create NameSpace {}", nameSpace.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityCreateRequestV2(hbaseOperationContext.getUser(), new AtlasEntity.AtlasEntitiesWithExtInfo(nameSpace)));
                break;
            }
            case ALTER_NAMESPACE: {
                LOG.info("Modify NameSpace {}", nameSpace.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityUpdateRequestV2(hbaseOperationContext.getUser(), new AtlasEntity.AtlasEntitiesWithExtInfo(nameSpace)));
            }
        }
    }

    private void deleteNameSpaceInstance(HBaseOperationContext hbaseOperationContext) {
        String nameSpaceQName = HBaseAtlasHook.getNameSpaceQualifiedName(this.clusterName, hbaseOperationContext.getNameSpace());
        AtlasObjectId nameSpaceId = new AtlasObjectId(HBaseDataTypes.HBASE_NAMESPACE.getName(), REFERENCEABLE_ATTRIBUTE_NAME, (Object)nameSpaceQName);
        LOG.info("Delete NameSpace {}", (Object)nameSpaceQName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityDeleteRequestV2(hbaseOperationContext.getUser(), Collections.singletonList(nameSpaceId)));
    }

    private void createOrUpdateTableInstance(HBaseOperationContext hbaseOperationContext) {
        AtlasEntity nameSpace = this.buildNameSpace(hbaseOperationContext);
        AtlasEntity table = this.buildTable(hbaseOperationContext, nameSpace);
        List<AtlasEntity> columnFamilies = this.buildColumnFamilies(hbaseOperationContext, nameSpace, table);
        table.setAttribute(ATTR_COLUMNFAMILIES, (Object)AtlasTypeUtil.getAtlasObjectIds(columnFamilies));
        AtlasEntity.AtlasEntitiesWithExtInfo entities = new AtlasEntity.AtlasEntitiesWithExtInfo(table);
        entities.addReferredEntity(nameSpace);
        if (CollectionUtils.isNotEmpty(columnFamilies)) {
            for (AtlasEntity columnFamily : columnFamilies) {
                entities.addReferredEntity(columnFamily);
            }
        }
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_TABLE: {
                LOG.info("Create Table {}", table.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityCreateRequestV2(hbaseOperationContext.getUser(), entities));
                break;
            }
            case ALTER_TABLE: {
                LOG.info("Modify Table {}", table.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityUpdateRequestV2(hbaseOperationContext.getUser(), entities));
            }
        }
    }

    private void deleteTableInstance(HBaseOperationContext hbaseOperationContext) {
        TableName tableName = hbaseOperationContext.getTableName();
        String nameSpaceName = tableName.getNamespaceAsString();
        if (nameSpaceName == null) {
            nameSpaceName = tableName.getNameWithNamespaceInclAsString();
        }
        String tableNameStr = tableName.getNameAsString();
        String tableQName = HBaseAtlasHook.getTableQualifiedName(this.clusterName, nameSpaceName, tableNameStr);
        AtlasObjectId tableId = new AtlasObjectId(HBaseDataTypes.HBASE_TABLE.getName(), REFERENCEABLE_ATTRIBUTE_NAME, (Object)tableQName);
        LOG.info("Delete Table {}", (Object)tableQName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityDeleteRequestV2(hbaseOperationContext.getUser(), Collections.singletonList(tableId)));
    }

    private void createOrUpdateColumnFamilyInstance(HBaseOperationContext hbaseOperationContext) {
        AtlasEntity nameSpace = this.buildNameSpace(hbaseOperationContext);
        AtlasEntity table = this.buildTable(hbaseOperationContext, nameSpace);
        AtlasEntity columnFamily = this.buildColumnFamily(hbaseOperationContext, hbaseOperationContext.gethColumnDescriptor(), nameSpace, table);
        AtlasEntity.AtlasEntitiesWithExtInfo entities = new AtlasEntity.AtlasEntitiesWithExtInfo(columnFamily);
        entities.addReferredEntity(nameSpace);
        entities.addReferredEntity(table);
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_COLUMN_FAMILY: {
                LOG.info("Create ColumnFamily {}", columnFamily.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityCreateRequestV2(hbaseOperationContext.getUser(), entities));
                break;
            }
            case ALTER_COLUMN_FAMILY: {
                LOG.info("Alter ColumnFamily {}", columnFamily.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityUpdateRequestV2(hbaseOperationContext.getUser(), entities));
            }
        }
    }

    private void deleteColumnFamilyInstance(HBaseOperationContext hbaseOperationContext) {
        TableName tableName = hbaseOperationContext.getTableName();
        String nameSpaceName = tableName.getNamespaceAsString();
        if (nameSpaceName == null) {
            nameSpaceName = tableName.getNameWithNamespaceInclAsString();
        }
        String tableNameStr = tableName.getNameAsString();
        String columnFamilyName = hbaseOperationContext.getColummFamily();
        String columnFamilyQName = HBaseAtlasHook.getColumnFamilyQualifiedName(this.clusterName, nameSpaceName, tableNameStr, columnFamilyName);
        AtlasObjectId columnFamilyId = new AtlasObjectId(HBaseDataTypes.HBASE_COLUMN_FAMILY.getName(), REFERENCEABLE_ATTRIBUTE_NAME, (Object)columnFamilyQName);
        LOG.info("Delete ColumnFamily {}", (Object)columnFamilyQName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityDeleteRequestV2(hbaseOperationContext.getUser(), Collections.singletonList(columnFamilyId)));
    }

    public static String getColumnFamilyQualifiedName(String clusterName, String nameSpace, String tableName, String columnFamily) {
        if (clusterName == null || nameSpace == null || tableName == null || columnFamily == null) {
            return null;
        }
        return String.format(HBASE_COLUMN_FAMILY_QUALIFIED_NAME_FORMAT, nameSpace.toLowerCase(), HBaseAtlasHook.stripNameSpace(tableName.toLowerCase()), columnFamily.toLowerCase(), clusterName);
    }

    public static String getTableQualifiedName(String clusterName, String nameSpace, String tableName) {
        if (clusterName == null || nameSpace == null || tableName == null) {
            return null;
        }
        return String.format(HBASE_TABLE_QUALIFIED_NAME_FORMAT, nameSpace.toLowerCase(), HBaseAtlasHook.stripNameSpace(tableName.toLowerCase()), clusterName);
    }

    public static String getNameSpaceQualifiedName(String clusterName, String nameSpace) {
        if (clusterName == null || nameSpace == null) {
            return null;
        }
        return String.format(HBASE_NAMESPACE_QUALIFIED_NAME, nameSpace.toLowerCase(), clusterName);
    }

    private static String stripNameSpace(String tableName) {
        return tableName.substring(tableName.indexOf(":") + 1);
    }

    private AtlasEntity buildNameSpace(HBaseOperationContext hbaseOperationContext) {
        String nameSpaceName;
        AtlasEntity nameSpace = new AtlasEntity(HBaseDataTypes.HBASE_NAMESPACE.getName());
        NamespaceDescriptor nameSpaceDesc = hbaseOperationContext.getNamespaceDescriptor();
        String string = nameSpaceName = nameSpaceDesc == null ? null : hbaseOperationContext.getNamespaceDescriptor().getName();
        if (nameSpaceName == null) {
            nameSpaceName = hbaseOperationContext.getNameSpace();
        }
        Date now = new Date(System.currentTimeMillis());
        nameSpace.setAttribute(ATTR_NAME, (Object)nameSpaceName);
        nameSpace.setAttribute(REFERENCEABLE_ATTRIBUTE_NAME, (Object)HBaseAtlasHook.getNameSpaceQualifiedName(this.clusterName, nameSpaceName));
        nameSpace.setAttribute("clusterName", (Object)this.clusterName);
        nameSpace.setAttribute(ATTR_DESCRIPTION, (Object)nameSpaceName);
        nameSpace.setAttribute(ATTR_PARAMETERS, hbaseOperationContext.getHbaseConf());
        nameSpace.setAttribute(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        nameSpace.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
        if (OPERATION.CREATE_NAMESPACE.equals((Object)hbaseOperationContext.getOperation())) {
            nameSpace.setAttribute(ATTR_CREATE_TIME, (Object)now);
        }
        return nameSpace;
    }

    private AtlasEntity buildTable(HBaseOperationContext hbaseOperationContext, AtlasEntity nameSpace) {
        AtlasEntity table = new AtlasEntity(HBaseDataTypes.HBASE_TABLE.getName());
        String tableName = this.getTableName(hbaseOperationContext);
        String nameSpaceName = (String)nameSpace.getAttribute(ATTR_NAME);
        String tableQName = HBaseAtlasHook.getTableQualifiedName(this.clusterName, nameSpaceName, tableName);
        OPERATION operation = hbaseOperationContext.getOperation();
        Date now = new Date(System.currentTimeMillis());
        table.setAttribute(REFERENCEABLE_ATTRIBUTE_NAME, (Object)tableQName);
        table.setAttribute(ATTR_NAME, (Object)tableName);
        table.setAttribute(ATTR_URI, (Object)tableName);
        table.setAttribute(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        table.setAttribute(ATTR_DESCRIPTION, (Object)tableName);
        table.setAttribute(ATTR_PARAMETERS, hbaseOperationContext.getHbaseConf());
        table.setAttribute(ATTR_NAMESPACE, (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)nameSpace));
        HTableDescriptor htableDescriptor = hbaseOperationContext.gethTableDescriptor();
        if (htableDescriptor != null) {
            table.setAttribute(ATTR_TABLE_MAX_FILESIZE, (Object)htableDescriptor.getMaxFileSize());
            table.setAttribute(ATTR_TABLE_REPLICATION_PER_REGION, (Object)htableDescriptor.getRegionReplication());
            table.setAttribute(ATTR_TABLE_ISREADONLY, (Object)htableDescriptor.isReadOnly());
            table.setAttribute(ATTR_TABLE_ISCOMPACTION_ENABLED, (Object)htableDescriptor.isCompactionEnabled());
            table.setAttribute(ATTR_TABLE_DURABLILITY, htableDescriptor.getDurability() != null ? htableDescriptor.getDurability().name() : null);
        }
        switch (operation) {
            case CREATE_TABLE: {
                table.setAttribute(ATTR_CREATE_TIME, (Object)now);
                table.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case CREATE_COLUMN_FAMILY: {
                table.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case ALTER_TABLE: 
            case ALTER_COLUMN_FAMILY: {
                table.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
        }
        return table;
    }

    private List<AtlasEntity> buildColumnFamilies(HBaseOperationContext hbaseOperationContext, AtlasEntity nameSpace, AtlasEntity table) {
        ArrayList<AtlasEntity> columnFamilies = new ArrayList<AtlasEntity>();
        HColumnDescriptor[] hColumnDescriptors = hbaseOperationContext.gethColumnDescriptors();
        if (hColumnDescriptors != null) {
            for (HColumnDescriptor hColumnDescriptor : hColumnDescriptors) {
                AtlasEntity columnFamily = this.buildColumnFamily(hbaseOperationContext, hColumnDescriptor, nameSpace, table);
                columnFamilies.add(columnFamily);
            }
        }
        return columnFamilies;
    }

    private AtlasEntity buildColumnFamily(HBaseOperationContext hbaseOperationContext, HColumnDescriptor hColumnDescriptor, AtlasEntity nameSpace, AtlasEntity table) {
        AtlasEntity columnFamily = new AtlasEntity(HBaseDataTypes.HBASE_COLUMN_FAMILY.getName());
        String columnFamilyName = hColumnDescriptor.getNameAsString();
        String tableName = (String)table.getAttribute(ATTR_NAME);
        String nameSpaceName = (String)nameSpace.getAttribute(ATTR_NAME);
        String columnFamilyQName = HBaseAtlasHook.getColumnFamilyQualifiedName(this.clusterName, nameSpaceName, tableName, columnFamilyName);
        Date now = new Date(System.currentTimeMillis());
        columnFamily.setAttribute(ATTR_NAME, (Object)columnFamilyName);
        columnFamily.setAttribute(ATTR_DESCRIPTION, (Object)columnFamilyName);
        columnFamily.setAttribute(REFERENCEABLE_ATTRIBUTE_NAME, (Object)columnFamilyQName);
        columnFamily.setAttribute(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        columnFamily.setAttribute(ATTR_TABLE, (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)table));
        if (hColumnDescriptor != null) {
            columnFamily.setAttribute(ATTR_CF_BLOCK_CACHE_ENABLED, (Object)hColumnDescriptor.isBlockCacheEnabled());
            columnFamily.setAttribute(ATTR_CF_BLOOMFILTER_TYPE, hColumnDescriptor.getBloomFilterType() != null ? hColumnDescriptor.getBloomFilterType().name() : null);
            columnFamily.setAttribute(ATTR_CF_CACHED_BLOOM_ON_WRITE, (Object)hColumnDescriptor.isCacheBloomsOnWrite());
            columnFamily.setAttribute(ATTR_CF_CACHED_DATA_ON_WRITE, (Object)hColumnDescriptor.isCacheDataOnWrite());
            columnFamily.setAttribute(ATTR_CF_CACHED_INDEXES_ON_WRITE, (Object)hColumnDescriptor.isCacheIndexesOnWrite());
            columnFamily.setAttribute(ATTR_CF_COMPACTION_COMPRESSION_TYPE, hColumnDescriptor.getCompactionCompressionType() != null ? hColumnDescriptor.getCompactionCompressionType().name() : null);
            columnFamily.setAttribute(ATTR_CF_COMPRESSION_TYPE, hColumnDescriptor.getCompressionType() != null ? hColumnDescriptor.getCompressionType().name() : null);
            columnFamily.setAttribute(ATTR_CF_DATA_BLOCK_ENCODING, hColumnDescriptor.getDataBlockEncoding() != null ? hColumnDescriptor.getDataBlockEncoding().name() : null);
            columnFamily.setAttribute(ATTR_CF_ENCRYPTION_TYPE, (Object)hColumnDescriptor.getEncryptionType());
            columnFamily.setAttribute(ATTR_CF_EVICT_BLOCK_ONCLOSE, (Object)hColumnDescriptor.isEvictBlocksOnClose());
            columnFamily.setAttribute(ATTR_CF_KEEP_DELETE_CELLS, hColumnDescriptor.getKeepDeletedCells() != null ? hColumnDescriptor.getKeepDeletedCells().name() : null);
            columnFamily.setAttribute(ATTR_CF_MAX_VERSIONS, (Object)hColumnDescriptor.getMaxVersions());
            columnFamily.setAttribute(ATTR_CF_MIN_VERSIONS, (Object)hColumnDescriptor.getMinVersions());
            columnFamily.setAttribute(ATTR_CF_PREFETCH_BLOCK_ONOPEN, (Object)hColumnDescriptor.isPrefetchBlocksOnOpen());
            columnFamily.setAttribute(ATTR_CF_TTL, (Object)hColumnDescriptor.getTimeToLive());
        }
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_TABLE: 
            case CREATE_COLUMN_FAMILY: {
                columnFamily.setAttribute(ATTR_CREATE_TIME, (Object)now);
                columnFamily.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case ALTER_COLUMN_FAMILY: {
                columnFamily.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
        }
        return columnFamily;
    }

    private String getTableName(HBaseOperationContext hbaseOperationContext) {
        HTableDescriptor tableDescriptor;
        TableName tableName = hbaseOperationContext.getTableName();
        String ret = tableName != null ? tableName.getNameAsString() : ((tableDescriptor = hbaseOperationContext.gethTableDescriptor()) != null ? tableDescriptor.getNameAsString() : null);
        return ret;
    }

    private void notifyAsPrivilegedAction(final HBaseOperationContext hbaseOperationContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.notifyAsPrivilegedAction({})", (Object)hbaseOperationContext);
        }
        final List<HookNotification> messages = hbaseOperationContext.getMessages();
        try {
            PrivilegedExceptionAction<Object> privilegedNotify = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    HBaseAtlasHook.this.notifyEntities(messages);
                    return hbaseOperationContext;
                }
            };
            UserGroupInformation realUser = hbaseOperationContext.getUgi().getRealUser();
            String numberOfMessages = Integer.toString(messages.size());
            String operation = hbaseOperationContext.getOperation().toString();
            String user = hbaseOperationContext.getUgi().getShortUserName();
            if (realUser != null) {
                LOG.info("Sending notification for event {} as service user {} #messages {}", new Object[]{operation, realUser.getShortUserName(), numberOfMessages});
                realUser.doAs((PrivilegedExceptionAction)privilegedNotify);
            } else {
                LOG.info("Sending notification for event {} as service user {} #messages {}", new Object[]{operation, user, numberOfMessages});
                hbaseOperationContext.getUgi().doAs((PrivilegedExceptionAction)privilegedNotify);
            }
        }
        catch (Throwable e) {
            LOG.error("Error during notify {} ", (Object)hbaseOperationContext.getOperation(), (Object)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.notifyAsPrivilegedAction()");
        }
    }

    protected void notifyEntities(List<HookNotification> messages) {
        int maxRetries = atlasProperties.getInt(HOOK_NUM_RETRIES, 3);
        HBaseAtlasHook.notifyEntities(messages, (int)maxRetries);
    }

    public void sendHBaseNameSpaceOperation(final NamespaceDescriptor namespaceDescriptor, final String nameSpace, final OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseNameSpaceOperation()");
        }
        try {
            final UserGroupInformation ugi = this.getUGI();
            HBaseOperationContext hbaseOperationContext = null;
            if (executor == null) {
                hbaseOperationContext = this.handleHBaseNameSpaceOperation(namespaceDescriptor, nameSpace, operation);
                if (hbaseOperationContext != null) {
                    this.notifyAsPrivilegedAction(hbaseOperationContext);
                }
            } else {
                executor.submit(new Runnable(){
                    HBaseOperationContext hbaseOperationContext = null;

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("==> HBaseAtlasHook.sendHBaseNameSpaceOperation():executor.submit()");
                        }
                        if (ugi != null) {
                            try {
                                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() {
                                        hbaseOperationContext = HBaseAtlasHook.this.handleHBaseNameSpaceOperation(namespaceDescriptor, nameSpace, operation);
                                        return hbaseOperationContext;
                                    }
                                });
                                HBaseAtlasHook.this.notifyAsPrivilegedAction(this.hbaseOperationContext);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(){}", (Object)this.hbaseOperationContext);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(): Atlas hook failed due to error ", e);
                            }
                        } else {
                            LOG.error("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(): Atlas hook failed, UserGroupInformation cannot be NULL!");
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.error("<== HBaseAtlasHook.sendHBaseNameSpaceOperation(): Submitting to thread pool failed due to error ", t);
        }
    }

    public void sendHBaseTableOperation(final HTableDescriptor hTableDescriptor, final TableName tableName, final OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseTableOperation()");
        }
        try {
            final UserGroupInformation ugi = this.getUGI();
            HBaseOperationContext hbaseOperationContext = null;
            if (executor == null) {
                hbaseOperationContext = this.handleHBaseTableOperation(hTableDescriptor, tableName, operation);
                if (hbaseOperationContext != null) {
                    this.notifyAsPrivilegedAction(hbaseOperationContext);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== HBaseAtlasHook.sendHBaseTableOperation(){}", (Object)hbaseOperationContext);
                }
            } else {
                executor.submit(new Runnable(){
                    HBaseOperationContext hbaseOperationContext = null;

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("==> HBaseAtlasHook.sendHBaseTableOperation():executor.submit()");
                        }
                        if (ugi != null) {
                            try {
                                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() {
                                        hbaseOperationContext = HBaseAtlasHook.this.handleHBaseTableOperation(hTableDescriptor, tableName, operation);
                                        return hbaseOperationContext;
                                    }
                                });
                                HBaseAtlasHook.this.notifyAsPrivilegedAction(this.hbaseOperationContext);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("<== HBaseAtlasHook.sendHBaseTableOperation(){}", (Object)this.hbaseOperationContext);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("<== HBaseAtlasHook.sendHBaseTableOperation(): Atlas hook failed due to error ", e);
                            }
                        } else {
                            LOG.error("<== HBaseAtlasHook.sendHBasecolumnFamilyOperation(): Atlas hook failed, UserGroupInformation cannot be NULL!");
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.error("<== HBaseAtlasHook.sendHBaseTableOperation(): Submitting to thread pool failed due to error ", t);
        }
    }

    public void sendHBaseColumnFamilyOperation(final HColumnDescriptor hColumnDescriptor, final TableName tableName, final String columnFamily, final OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseColumnFamilyOperation()");
        }
        try {
            final UserGroupInformation ugi = this.getUGI();
            HBaseOperationContext hbaseOperationContext = null;
            if (executor == null) {
                hbaseOperationContext = this.handleHBaseColumnFamilyOperation(hColumnDescriptor, tableName, columnFamily, operation);
                if (hbaseOperationContext != null) {
                    this.notifyAsPrivilegedAction(hbaseOperationContext);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(){}", (Object)hbaseOperationContext);
                }
            } else {
                executor.submit(new Runnable(){
                    HBaseOperationContext hbaseOperationContext = null;

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("==> HBaseAtlasHook.sendHBaseColumnFamilyOperation():executor.submit()");
                        }
                        if (ugi != null) {
                            try {
                                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() {
                                        hbaseOperationContext = HBaseAtlasHook.this.handleHBaseColumnFamilyOperation(hColumnDescriptor, tableName, columnFamily, operation);
                                        return hbaseOperationContext;
                                    }
                                });
                                HBaseAtlasHook.this.notifyAsPrivilegedAction(this.hbaseOperationContext);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(){}", (Object)this.hbaseOperationContext);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(): Atlas hook failed due to error ", e);
                            }
                        } else {
                            LOG.error("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(): Atlas hook failed, UserGroupInformation cannot be NULL!");
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.error("<== HBaseAtlasHook.sendHBaseColumnFamilyOperation(): Submitting to thread pool failed due to error ", t);
        }
    }

    private HBaseOperationContext handleHBaseNameSpaceOperation(NamespaceDescriptor namespaceDescriptor, String nameSpace, OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseNameSpaceOperation()");
        }
        UserGroupInformation ugi = this.getUGI();
        User user = this.getActiveUser();
        String userName = user != null ? user.getShortName() : null;
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(namespaceDescriptor, nameSpace, operation, ugi, userName, userName);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseNameSpaceOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private HBaseOperationContext handleHBaseTableOperation(HTableDescriptor hTableDescriptor, TableName tableName, OPERATION operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseTableOperation()");
        }
        UserGroupInformation ugi = this.getUGI();
        User user = this.getActiveUser();
        String userName = user != null ? user.getShortName() : null;
        Map hbaseConf = null;
        String owner = null;
        String tableNameSpace = null;
        TableName hbaseTableName = null;
        HColumnDescriptor[] hColumnDescriptors = null;
        if (hTableDescriptor != null) {
            owner = hTableDescriptor.getOwnerString();
            hbaseConf = hTableDescriptor.getConfiguration();
            hbaseTableName = hTableDescriptor.getTableName();
            if (hbaseTableName != null && (tableNameSpace = hbaseTableName.getNamespaceAsString()) == null) {
                tableNameSpace = hbaseTableName.getNameWithNamespaceInclAsString();
            }
        }
        if (owner == null) {
            owner = userName;
        }
        if (hTableDescriptor != null) {
            hColumnDescriptors = hTableDescriptor.getColumnFamilies();
        }
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(tableNameSpace, hTableDescriptor, tableName, hColumnDescriptors, operation, ugi, userName, owner, (Map<String, String>)hbaseConf);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseTableOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private HBaseOperationContext handleHBaseColumnFamilyOperation(HColumnDescriptor hColumnDescriptor, TableName tableName, String columnFamily, OPERATION operation) {
        String userName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseColumnFamilyOperation()");
        }
        UserGroupInformation ugi = this.getUGI();
        User user = this.getActiveUser();
        String owner = userName = user != null ? user.getShortName() : null;
        Map hbaseConf = null;
        String tableNameSpace = tableName.getNamespaceAsString();
        if (tableNameSpace == null) {
            tableNameSpace = tableName.getNameWithNamespaceInclAsString();
        }
        if (hColumnDescriptor != null) {
            hbaseConf = hColumnDescriptor.getConfiguration();
        }
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(tableNameSpace, tableName, hColumnDescriptor, columnFamily, operation, ugi, userName, owner, (Map<String, String>)hbaseConf);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseColumnFamilyOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private User getActiveUser() {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            try {
                user = User.getCurrent();
            }
            catch (IOException e) {
                LOG.error("Unable to find the current user");
                user = null;
            }
        }
        return user;
    }

    private UserGroupInformation getUGI() {
        UserGroupInformation ugi = null;
        User user = this.getActiveUser();
        try {
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ugi == null && user != null) {
            ugi = user.getUGI();
        }
        LOG.info("HBaseAtlasHook: UGI: {}", (Object)ugi);
        return ugi;
    }

    static {
        try {
            int minThreads = atlasProperties.getInt(MIN_THREADS, 5);
            int maxThreads = atlasProperties.getInt(MAX_THREADS, 5);
            int queueSize = atlasProperties.getInt(QUEUE_SIZE, 10000);
            long keepAliveTime = atlasProperties.getLong(KEEP_ALIVE_TIME, 10L);
            sync = atlasProperties.getBoolean(CONF_SYNC, false);
            executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat("Atlas Logger %d").build());
            ShutdownHookManager.get().addShutdownHook((Runnable)new Thread(){

                @Override
                public void run() {
                    try {
                        LOG.info("==> Shutdown of Atlas HBase Hook");
                        executor.shutdown();
                        executor.awaitTermination(3L, TimeUnit.SECONDS);
                        executor = null;
                    }
                    catch (InterruptedException ie) {
                        LOG.info("Interrupt received in shutdown.", (Throwable)ie);
                    }
                    finally {
                        LOG.info("<== Shutdown of Atlas HBase Hook");
                    }
                }
            }, 30);
        }
        catch (Exception e) {
            LOG.error("Caught exception initializing the Atlas HBase hook.", (Throwable)e);
        }
        LOG.info("Created Atlas Hook for HBase");
    }

    public static enum OPERATION {
        CREATE_NAMESPACE("create_namespace"),
        ALTER_NAMESPACE("alter_namespace"),
        DELETE_NAMESPACE("delete_namespace"),
        CREATE_TABLE("create_table"),
        ALTER_TABLE("alter_table"),
        DELETE_TABLE("delete_table"),
        CREATE_COLUMN_FAMILY("create_column_Family"),
        ALTER_COLUMN_FAMILY("alter_column_Family"),
        DELETE_COLUMN_FAMILY("delete_column_Family");

        private final String name;

        private OPERATION(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }
    }
}

