/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.bridge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.hbase.model.HBaseDataTypes;
import org.apache.atlas.hbase.model.HBaseOperationContext;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAtlasHook
extends AtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseAtlasHook.class);
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_ATLAS_ENDPOINT = "atlas.rest.address";
    public static final String ATTR_PARAMETERS = "parameters";
    public static final String ATTR_URI = "uri";
    public static final String ATTR_NAMESPACE = "namespace";
    public static final String ATTR_TABLE = "table";
    public static final String ATTR_COLUMNFAMILIES = "column_families";
    public static final String ATTR_CREATE_TIME = "createTime";
    public static final String ATTR_MODIFIED_TIME = "modifiedTime";
    public static final String ATTR_OWNER = "owner";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TABLE_MAX_FILESIZE = "maxFileSize";
    public static final String ATTR_TABLE_ISREADONLY = "isReadOnly";
    public static final String ATTR_TABLE_ISCOMPACTION_ENABLED = "isCompactionEnabled";
    public static final String ATTR_TABLE_ISNORMALIZATION_ENABLED = "isNormalizationEnabled";
    public static final String ATTR_TABLE_REPLICATION_PER_REGION = "replicasPerRegion";
    public static final String ATTR_TABLE_DURABLILITY = "durability";
    public static final String ATTR_TABLE_NORMALIZATION_ENABLED = "isNormalizationEnabled";
    public static final String ATTR_CF_BLOOMFILTER_TYPE = "bloomFilterType";
    public static final String ATTR_CF_COMPRESSION_TYPE = "compressionType";
    public static final String ATTR_CF_COMPACTION_COMPRESSION_TYPE = "compactionCompressionType";
    public static final String ATTR_CF_ENCRYPTION_TYPE = "encryptionType";
    public static final String ATTR_CF_INMEMORY_COMPACTION_POLICY = "inMemoryCompactionPolicy";
    public static final String ATTR_CF_KEEP_DELETE_CELLS = "keepDeletedCells";
    public static final String ATTR_CF_MAX_VERSIONS = "maxVersions";
    public static final String ATTR_CF_MIN_VERSIONS = "minVersions";
    public static final String ATTR_CF_DATA_BLOCK_ENCODING = "dataBlockEncoding";
    public static final String ATTR_CF_STORAGE_POLICY = "StoragePolicy";
    public static final String ATTR_CF_TTL = "ttl";
    public static final String ATTR_CF_BLOCK_CACHE_ENABLED = "blockCacheEnabled";
    public static final String ATTR_CF_CACHED_BLOOM_ON_WRITE = "cacheBloomsOnWrite";
    public static final String ATTR_CF_CACHED_DATA_ON_WRITE = "cacheDataOnWrite";
    public static final String ATTR_CF_CACHED_INDEXES_ON_WRITE = "cacheIndexesOnWrite";
    public static final String ATTR_CF_EVICT_BLOCK_ONCLOSE = "evictBlocksOnClose";
    public static final String ATTR_CF_PREFETCH_BLOCK_ONOPEN = "prefetchBlocksOnOpen";
    public static final String ATTR_CF_NEW_VERSION_BEHAVIOR = "newVersionBehavior";
    public static final String ATTR_CF_MOB_ENABLED = "isMobEnabled";
    public static final String ATTR_CF_MOB_COMPATCTPARTITION_POLICY = "mobCompactPartitionPolicy";
    public static final String HBASE_NAMESPACE_QUALIFIED_NAME = "%s@%s";
    public static final String HBASE_TABLE_QUALIFIED_NAME_FORMAT = "%s:%s@%s";
    public static final String HBASE_COLUMN_FAMILY_QUALIFIED_NAME_FORMAT = "%s:%s.%s@%s";
    private static final String REFERENCEABLE_ATTRIBUTE_NAME = "qualifiedName";
    public static final String RELATIONSHIP_HBASE_TABLE_COLUMN_FAMILIES = "hbase_table_column_families";
    public static final String RELATIONSHIP_HBASE_TABLE_NAMESPACE = "hbase_table_namespace";
    private static volatile HBaseAtlasHook me;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HBaseAtlasHook getInstance() {
        HBaseAtlasHook ret = me;
        if (ret == null) {
            try {
                Class<HBaseAtlasHook> clazz = HBaseAtlasHook.class;
                synchronized (HBaseAtlasHook.class) {
                    ret = me;
                    if (ret == null) {
                        me = ret = new HBaseAtlasHook();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOG.error("Caught exception instantiating the Atlas HBase hook.", (Throwable)e);
            }
        }
        {
            return ret;
        }
    }

    public void createAtlasInstances(HBaseOperationContext hbaseOperationContext) {
        OPERATION operation = hbaseOperationContext.getOperation();
        LOG.info("HBaseAtlasHook(operation={})", (Object)operation);
        switch (operation) {
            case CREATE_NAMESPACE: 
            case ALTER_NAMESPACE: {
                this.createOrUpdateNamespaceInstance(hbaseOperationContext);
                break;
            }
            case DELETE_NAMESPACE: {
                this.deleteNameSpaceInstance(hbaseOperationContext);
                break;
            }
            case CREATE_TABLE: 
            case ALTER_TABLE: {
                this.createOrUpdateTableInstance(hbaseOperationContext);
                break;
            }
            case DELETE_TABLE: {
                this.deleteTableInstance(hbaseOperationContext);
                break;
            }
            case CREATE_COLUMN_FAMILY: 
            case ALTER_COLUMN_FAMILY: {
                this.createOrUpdateColumnFamilyInstance(hbaseOperationContext);
                break;
            }
            case DELETE_COLUMN_FAMILY: {
                this.deleteColumnFamilyInstance(hbaseOperationContext);
            }
        }
    }

    private void createOrUpdateNamespaceInstance(HBaseOperationContext hbaseOperationContext) {
        AtlasEntity nameSpace = this.buildNameSpace(hbaseOperationContext);
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_NAMESPACE: {
                LOG.info("Create NameSpace {}", nameSpace.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityCreateRequestV2(hbaseOperationContext.getUser(), new AtlasEntity.AtlasEntitiesWithExtInfo(nameSpace)));
                break;
            }
            case ALTER_NAMESPACE: {
                LOG.info("Modify NameSpace {}", nameSpace.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityUpdateRequestV2(hbaseOperationContext.getUser(), new AtlasEntity.AtlasEntitiesWithExtInfo(nameSpace)));
            }
        }
    }

    private void deleteNameSpaceInstance(HBaseOperationContext hbaseOperationContext) {
        String nameSpaceQName = HBaseAtlasHook.getNameSpaceQualifiedName(this.getMetadataNamespace(), hbaseOperationContext.getNameSpace());
        AtlasObjectId nameSpaceId = new AtlasObjectId(HBaseDataTypes.HBASE_NAMESPACE.getName(), REFERENCEABLE_ATTRIBUTE_NAME, (Object)nameSpaceQName);
        LOG.info("Delete NameSpace {}", (Object)nameSpaceQName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityDeleteRequestV2(hbaseOperationContext.getUser(), Collections.singletonList(nameSpaceId)));
    }

    private void createOrUpdateTableInstance(HBaseOperationContext hbaseOperationContext) {
        AtlasEntity nameSpace = this.buildNameSpace(hbaseOperationContext);
        AtlasEntity table = this.buildTable(hbaseOperationContext, nameSpace);
        List<AtlasEntity> columnFamilies = this.buildColumnFamilies(hbaseOperationContext, nameSpace, table);
        table.setRelationshipAttribute(ATTR_COLUMNFAMILIES, (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(columnFamilies, (String)RELATIONSHIP_HBASE_TABLE_COLUMN_FAMILIES));
        AtlasEntity.AtlasEntitiesWithExtInfo entities = new AtlasEntity.AtlasEntitiesWithExtInfo(table);
        entities.addReferredEntity(nameSpace);
        if (CollectionUtils.isNotEmpty(columnFamilies)) {
            for (AtlasEntity columnFamily : columnFamilies) {
                entities.addReferredEntity(columnFamily);
            }
        }
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_TABLE: {
                LOG.info("Create Table {}", table.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityCreateRequestV2(hbaseOperationContext.getUser(), entities));
                break;
            }
            case ALTER_TABLE: {
                LOG.info("Modify Table {}", table.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityUpdateRequestV2(hbaseOperationContext.getUser(), entities));
            }
        }
    }

    private void deleteTableInstance(HBaseOperationContext hbaseOperationContext) {
        TableName tableName = hbaseOperationContext.getTableName();
        String nameSpaceName = tableName.getNamespaceAsString();
        if (nameSpaceName == null) {
            nameSpaceName = tableName.getNameWithNamespaceInclAsString();
        }
        String tableNameStr = tableName.getNameAsString();
        String tableQName = HBaseAtlasHook.getTableQualifiedName(this.getMetadataNamespace(), nameSpaceName, tableNameStr);
        AtlasObjectId tableId = new AtlasObjectId(HBaseDataTypes.HBASE_TABLE.getName(), REFERENCEABLE_ATTRIBUTE_NAME, (Object)tableQName);
        LOG.info("Delete Table {}", (Object)tableQName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityDeleteRequestV2(hbaseOperationContext.getUser(), Collections.singletonList(tableId)));
    }

    private void createOrUpdateColumnFamilyInstance(HBaseOperationContext hbaseOperationContext) {
        AtlasEntity nameSpace = this.buildNameSpace(hbaseOperationContext);
        AtlasEntity table = this.buildTable(hbaseOperationContext, nameSpace);
        AtlasEntity columnFamily = this.buildColumnFamily(hbaseOperationContext, hbaseOperationContext.gethColumnDescriptor(), nameSpace, table);
        AtlasEntity.AtlasEntitiesWithExtInfo entities = new AtlasEntity.AtlasEntitiesWithExtInfo(columnFamily);
        entities.addReferredEntity(nameSpace);
        entities.addReferredEntity(table);
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_COLUMN_FAMILY: {
                LOG.info("Create ColumnFamily {}", columnFamily.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityCreateRequestV2(hbaseOperationContext.getUser(), entities));
                break;
            }
            case ALTER_COLUMN_FAMILY: {
                LOG.info("Alter ColumnFamily {}", columnFamily.getAttribute(REFERENCEABLE_ATTRIBUTE_NAME));
                hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityUpdateRequestV2(hbaseOperationContext.getUser(), entities));
            }
        }
    }

    private void deleteColumnFamilyInstance(HBaseOperationContext hbaseOperationContext) {
        TableName tableName = hbaseOperationContext.getTableName();
        String nameSpaceName = tableName.getNamespaceAsString();
        if (nameSpaceName == null) {
            nameSpaceName = tableName.getNameWithNamespaceInclAsString();
        }
        String tableNameStr = tableName.getNameAsString();
        String columnFamilyName = hbaseOperationContext.getColummFamily();
        String columnFamilyQName = HBaseAtlasHook.getColumnFamilyQualifiedName(this.getMetadataNamespace(), nameSpaceName, tableNameStr, columnFamilyName);
        AtlasObjectId columnFamilyId = new AtlasObjectId(HBaseDataTypes.HBASE_COLUMN_FAMILY.getName(), REFERENCEABLE_ATTRIBUTE_NAME, (Object)columnFamilyQName);
        LOG.info("Delete ColumnFamily {}", (Object)columnFamilyQName);
        hbaseOperationContext.addMessage((HookNotification)new HookNotification.EntityDeleteRequestV2(hbaseOperationContext.getUser(), Collections.singletonList(columnFamilyId)));
    }

    public static String getColumnFamilyQualifiedName(String metadataNamespace, String nameSpace, String tableName, String columnFamily) {
        if (metadataNamespace == null || nameSpace == null || tableName == null || columnFamily == null) {
            return null;
        }
        return String.format(HBASE_COLUMN_FAMILY_QUALIFIED_NAME_FORMAT, nameSpace, HBaseAtlasHook.stripNameSpace(tableName), columnFamily, metadataNamespace);
    }

    public static String getTableQualifiedName(String metadataNamespace, String nameSpace, String tableName) {
        if (metadataNamespace == null || nameSpace == null || tableName == null) {
            return null;
        }
        return String.format(HBASE_TABLE_QUALIFIED_NAME_FORMAT, nameSpace, HBaseAtlasHook.stripNameSpace(tableName), metadataNamespace);
    }

    public static String getNameSpaceQualifiedName(String metadataNamespace, String nameSpace) {
        if (metadataNamespace == null || nameSpace == null) {
            return null;
        }
        return String.format(HBASE_NAMESPACE_QUALIFIED_NAME, nameSpace, metadataNamespace);
    }

    private static String stripNameSpace(String tableName) {
        return tableName.substring(tableName.indexOf(":") + 1);
    }

    private AtlasEntity buildNameSpace(HBaseOperationContext hbaseOperationContext) {
        String nameSpaceName;
        AtlasEntity nameSpace = new AtlasEntity(HBaseDataTypes.HBASE_NAMESPACE.getName());
        NamespaceDescriptor nameSpaceDesc = hbaseOperationContext.getNamespaceDescriptor();
        String string = nameSpaceName = nameSpaceDesc == null ? null : hbaseOperationContext.getNamespaceDescriptor().getName();
        if (nameSpaceName == null) {
            nameSpaceName = hbaseOperationContext.getNameSpace();
        }
        Date now = new Date(System.currentTimeMillis());
        nameSpace.setAttribute(ATTR_NAME, (Object)nameSpaceName);
        nameSpace.setAttribute(REFERENCEABLE_ATTRIBUTE_NAME, (Object)HBaseAtlasHook.getNameSpaceQualifiedName(this.getMetadataNamespace(), nameSpaceName));
        nameSpace.setAttribute("clusterName", (Object)this.getMetadataNamespace());
        nameSpace.setAttribute(ATTR_DESCRIPTION, (Object)nameSpaceName);
        nameSpace.setAttribute(ATTR_PARAMETERS, hbaseOperationContext.getHbaseConf());
        nameSpace.setAttribute(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        nameSpace.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
        if (OPERATION.CREATE_NAMESPACE.equals((Object)hbaseOperationContext.getOperation())) {
            nameSpace.setAttribute(ATTR_CREATE_TIME, (Object)now);
        }
        return nameSpace;
    }

    private AtlasEntity buildTable(HBaseOperationContext hbaseOperationContext, AtlasEntity nameSpace) {
        AtlasEntity table = new AtlasEntity(HBaseDataTypes.HBASE_TABLE.getName());
        String tableName = this.getTableName(hbaseOperationContext);
        String nameSpaceName = (String)nameSpace.getAttribute(ATTR_NAME);
        String tableQName = HBaseAtlasHook.getTableQualifiedName(this.getMetadataNamespace(), nameSpaceName, tableName);
        OPERATION operation = hbaseOperationContext.getOperation();
        Date now = new Date(System.currentTimeMillis());
        table.setAttribute(REFERENCEABLE_ATTRIBUTE_NAME, (Object)tableQName);
        table.setAttribute(ATTR_NAME, (Object)tableName);
        table.setAttribute(ATTR_URI, (Object)tableName);
        table.setAttribute(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        table.setAttribute(ATTR_DESCRIPTION, (Object)tableName);
        table.setAttribute(ATTR_PARAMETERS, hbaseOperationContext.getHbaseConf());
        table.setRelationshipAttribute(ATTR_NAMESPACE, (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)nameSpace, (String)RELATIONSHIP_HBASE_TABLE_NAMESPACE));
        TableDescriptor tableDescriptor = hbaseOperationContext.gethTableDescriptor();
        if (tableDescriptor != null) {
            table.setAttribute(ATTR_TABLE_MAX_FILESIZE, (Object)tableDescriptor.getMaxFileSize());
            table.setAttribute(ATTR_TABLE_REPLICATION_PER_REGION, (Object)tableDescriptor.getRegionReplication());
            table.setAttribute(ATTR_TABLE_ISREADONLY, (Object)tableDescriptor.isReadOnly());
            table.setAttribute("isNormalizationEnabled", (Object)tableDescriptor.isNormalizationEnabled());
            table.setAttribute(ATTR_TABLE_ISCOMPACTION_ENABLED, (Object)tableDescriptor.isCompactionEnabled());
            table.setAttribute(ATTR_TABLE_DURABLILITY, tableDescriptor.getDurability() != null ? tableDescriptor.getDurability().name() : null);
            table.setAttribute("isNormalizationEnabled", (Object)tableDescriptor.isNormalizationEnabled());
        }
        switch (operation) {
            case CREATE_TABLE: {
                table.setAttribute(ATTR_CREATE_TIME, (Object)now);
                table.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case CREATE_COLUMN_FAMILY: {
                table.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case ALTER_TABLE: 
            case ALTER_COLUMN_FAMILY: {
                table.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
        }
        return table;
    }

    private List<AtlasEntity> buildColumnFamilies(HBaseOperationContext hbaseOperationContext, AtlasEntity nameSpace, AtlasEntity table) {
        ArrayList<AtlasEntity> columnFamilies = new ArrayList<AtlasEntity>();
        ColumnFamilyDescriptor[] columnFamilyDescriptors = hbaseOperationContext.gethColumnDescriptors();
        if (columnFamilyDescriptors != null) {
            for (ColumnFamilyDescriptor columnFamilyDescriptor : columnFamilyDescriptors) {
                AtlasEntity columnFamily = this.buildColumnFamily(hbaseOperationContext, columnFamilyDescriptor, nameSpace, table);
                columnFamilies.add(columnFamily);
            }
        }
        return columnFamilies;
    }

    private AtlasEntity buildColumnFamily(HBaseOperationContext hbaseOperationContext, ColumnFamilyDescriptor columnFamilyDescriptor, AtlasEntity nameSpace, AtlasEntity table) {
        AtlasEntity columnFamily = new AtlasEntity(HBaseDataTypes.HBASE_COLUMN_FAMILY.getName());
        String columnFamilyName = columnFamilyDescriptor.getNameAsString();
        String tableName = (String)table.getAttribute(ATTR_NAME);
        String nameSpaceName = (String)nameSpace.getAttribute(ATTR_NAME);
        String columnFamilyQName = HBaseAtlasHook.getColumnFamilyQualifiedName(this.getMetadataNamespace(), nameSpaceName, tableName, columnFamilyName);
        Date now = new Date(System.currentTimeMillis());
        columnFamily.setAttribute(ATTR_NAME, (Object)columnFamilyName);
        columnFamily.setAttribute(ATTR_DESCRIPTION, (Object)columnFamilyName);
        columnFamily.setAttribute(REFERENCEABLE_ATTRIBUTE_NAME, (Object)columnFamilyQName);
        columnFamily.setAttribute(ATTR_OWNER, (Object)hbaseOperationContext.getOwner());
        columnFamily.setRelationshipAttribute(ATTR_TABLE, (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)table, (String)RELATIONSHIP_HBASE_TABLE_COLUMN_FAMILIES));
        if (columnFamilyDescriptor != null) {
            columnFamily.setAttribute(ATTR_CF_BLOCK_CACHE_ENABLED, (Object)columnFamilyDescriptor.isBlockCacheEnabled());
            columnFamily.setAttribute(ATTR_CF_BLOOMFILTER_TYPE, columnFamilyDescriptor.getBloomFilterType() != null ? columnFamilyDescriptor.getBloomFilterType().name() : null);
            columnFamily.setAttribute(ATTR_CF_CACHED_BLOOM_ON_WRITE, (Object)columnFamilyDescriptor.isCacheBloomsOnWrite());
            columnFamily.setAttribute(ATTR_CF_CACHED_DATA_ON_WRITE, (Object)columnFamilyDescriptor.isCacheDataOnWrite());
            columnFamily.setAttribute(ATTR_CF_CACHED_INDEXES_ON_WRITE, (Object)columnFamilyDescriptor.isCacheIndexesOnWrite());
            columnFamily.setAttribute(ATTR_CF_COMPACTION_COMPRESSION_TYPE, columnFamilyDescriptor.getCompactionCompressionType() != null ? columnFamilyDescriptor.getCompactionCompressionType().name() : null);
            columnFamily.setAttribute(ATTR_CF_COMPRESSION_TYPE, columnFamilyDescriptor.getCompressionType() != null ? columnFamilyDescriptor.getCompressionType().name() : null);
            columnFamily.setAttribute(ATTR_CF_DATA_BLOCK_ENCODING, columnFamilyDescriptor.getDataBlockEncoding() != null ? columnFamilyDescriptor.getDataBlockEncoding().name() : null);
            columnFamily.setAttribute(ATTR_CF_ENCRYPTION_TYPE, (Object)columnFamilyDescriptor.getEncryptionType());
            columnFamily.setAttribute(ATTR_CF_EVICT_BLOCK_ONCLOSE, (Object)columnFamilyDescriptor.isEvictBlocksOnClose());
            columnFamily.setAttribute(ATTR_CF_INMEMORY_COMPACTION_POLICY, columnFamilyDescriptor.getInMemoryCompaction() != null ? columnFamilyDescriptor.getInMemoryCompaction().name() : null);
            columnFamily.setAttribute(ATTR_CF_KEEP_DELETE_CELLS, columnFamilyDescriptor.getKeepDeletedCells() != null ? columnFamilyDescriptor.getKeepDeletedCells().name() : null);
            columnFamily.setAttribute(ATTR_CF_MAX_VERSIONS, (Object)columnFamilyDescriptor.getMaxVersions());
            columnFamily.setAttribute(ATTR_CF_MIN_VERSIONS, (Object)columnFamilyDescriptor.getMinVersions());
            columnFamily.setAttribute(ATTR_CF_NEW_VERSION_BEHAVIOR, (Object)columnFamilyDescriptor.isNewVersionBehavior());
            columnFamily.setAttribute(ATTR_CF_MOB_ENABLED, (Object)columnFamilyDescriptor.isMobEnabled());
            columnFamily.setAttribute(ATTR_CF_MOB_COMPATCTPARTITION_POLICY, columnFamilyDescriptor.getMobCompactPartitionPolicy() != null ? columnFamilyDescriptor.getMobCompactPartitionPolicy().name() : null);
            columnFamily.setAttribute(ATTR_CF_PREFETCH_BLOCK_ONOPEN, (Object)columnFamilyDescriptor.isPrefetchBlocksOnOpen());
            columnFamily.setAttribute(ATTR_CF_STORAGE_POLICY, (Object)columnFamilyDescriptor.getStoragePolicy());
            columnFamily.setAttribute(ATTR_CF_TTL, (Object)columnFamilyDescriptor.getTimeToLive());
        }
        switch (hbaseOperationContext.getOperation()) {
            case CREATE_TABLE: 
            case CREATE_COLUMN_FAMILY: {
                columnFamily.setAttribute(ATTR_CREATE_TIME, (Object)now);
                columnFamily.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
            case ALTER_COLUMN_FAMILY: {
                columnFamily.setAttribute(ATTR_MODIFIED_TIME, (Object)now);
                break;
            }
        }
        return columnFamily;
    }

    public String getMessageSource() {
        return "hbase";
    }

    private String getTableName(HBaseOperationContext hbaseOperationContext) {
        TableDescriptor tableDescriptor;
        TableName tableName = hbaseOperationContext.getTableName();
        String ret = tableName != null ? tableName.getNameAsString() : ((tableDescriptor = hbaseOperationContext.gethTableDescriptor()) != null ? tableDescriptor.getTableName().getNameAsString() : null);
        return ret;
    }

    public void sendHBaseNameSpaceOperation(NamespaceDescriptor namespaceDescriptor, String nameSpace, OPERATION operation, ObserverContext<MasterCoprocessorEnvironment> ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseNameSpaceOperation()");
        }
        try {
            UserGroupInformation ugi = this.getUGI(ctx);
            User user = this.getActiveUser(ctx);
            String userName = user != null ? user.getShortName() : null;
            HBaseOperationContext hbaseOperationContext = this.handleHBaseNameSpaceOperation(namespaceDescriptor, nameSpace, operation, ugi, userName);
            this.sendNotification(hbaseOperationContext);
        }
        catch (Throwable t) {
            LOG.error("HBaseAtlasHook.sendHBaseNameSpaceOperation(): failed to send notification", t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.sendHBaseNameSpaceOperation()");
        }
    }

    public void sendHBaseTableOperation(TableDescriptor tableDescriptor, TableName tableName, OPERATION operation, ObserverContext<MasterCoprocessorEnvironment> ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.sendHBaseTableOperation()");
        }
        try {
            UserGroupInformation ugi = this.getUGI(ctx);
            User user = this.getActiveUser(ctx);
            String userName = user != null ? user.getShortName() : null;
            HBaseOperationContext hbaseOperationContext = this.handleHBaseTableOperation(tableDescriptor, tableName, operation, ugi, userName);
            this.sendNotification(hbaseOperationContext);
        }
        catch (Throwable t) {
            LOG.error("<== HBaseAtlasHook.sendHBaseTableOperation(): failed to send notification", t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.sendHBaseTableOperation()");
        }
    }

    private void sendNotification(HBaseOperationContext hbaseOperationContext) {
        UserGroupInformation ugi = hbaseOperationContext.getUgi();
        if (ugi != null && ugi.getRealUser() != null) {
            ugi = ugi.getRealUser();
        }
        this.notifyEntities(hbaseOperationContext.getMessages(), ugi);
    }

    private HBaseOperationContext handleHBaseNameSpaceOperation(NamespaceDescriptor namespaceDescriptor, String nameSpace, OPERATION operation, UserGroupInformation ugi, String userName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseNameSpaceOperation()");
        }
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(namespaceDescriptor, nameSpace, operation, ugi, userName, userName);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseNameSpaceOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private HBaseOperationContext handleHBaseTableOperation(TableDescriptor tableDescriptor, TableName tableName, OPERATION operation, UserGroupInformation ugi, String userName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseTableOperation()");
        }
        Map<String, String> hbaseConf = null;
        String owner = null;
        String tableNameSpace = null;
        TableName hbaseTableName = null;
        ColumnFamilyDescriptor[] columnFamilyDescriptors = null;
        if (tableDescriptor != null) {
            owner = tableDescriptor.getOwnerString();
            hbaseConf = null;
            hbaseTableName = tableDescriptor.getTableName();
            if (hbaseTableName != null && (tableNameSpace = hbaseTableName.getNamespaceAsString()) == null) {
                tableNameSpace = hbaseTableName.getNameWithNamespaceInclAsString();
            }
        }
        if (owner == null) {
            owner = userName;
        }
        if (tableDescriptor != null) {
            columnFamilyDescriptors = tableDescriptor.getColumnFamilies();
        }
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(tableNameSpace, tableDescriptor, tableName, columnFamilyDescriptors, operation, ugi, userName, owner, hbaseConf);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseTableOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private HBaseOperationContext handleHBaseColumnFamilyOperation(ColumnFamilyDescriptor columnFamilyDescriptor, TableName tableName, String columnFamily, OPERATION operation, UserGroupInformation ugi, String userName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HBaseAtlasHook.handleHBaseColumnFamilyOperation()");
        }
        String owner = userName;
        HashMap<String, String> hbaseConf = new HashMap();
        String tableNameSpace = tableName.getNamespaceAsString();
        if (tableNameSpace == null) {
            tableNameSpace = tableName.getNameWithNamespaceInclAsString();
        }
        if (columnFamilyDescriptor != null) {
            hbaseConf = columnFamilyDescriptor.getConfiguration();
        }
        HBaseOperationContext hbaseOperationContext = new HBaseOperationContext(tableNameSpace, tableName, columnFamilyDescriptor, columnFamily, operation, ugi, userName, owner, hbaseConf);
        this.createAtlasInstances(hbaseOperationContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HBaseAtlasHook.handleHBaseColumnFamilyOperation(): {}", (Object)hbaseOperationContext);
        }
        return hbaseOperationContext;
    }

    private UserGroupInformation getUGI(ObserverContext<?> ctx) {
        UserGroupInformation ugi = null;
        User user = null;
        try {
            user = this.getActiveUser(ctx);
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ugi == null && user != null) {
            ugi = user.getUGI();
        }
        LOG.info("HBaseAtlasHook: UGI: {}", (Object)ugi);
        return ugi;
    }

    private User getActiveUser(ObserverContext<?> ctx) throws IOException {
        return ctx.getCaller().orElse(User.getCurrent());
    }

    public static enum OPERATION {
        CREATE_NAMESPACE("create_namespace"),
        ALTER_NAMESPACE("alter_namespace"),
        DELETE_NAMESPACE("delete_namespace"),
        CREATE_TABLE("create_table"),
        ALTER_TABLE("alter_table"),
        DELETE_TABLE("delete_table"),
        CREATE_COLUMN_FAMILY("create_column_Family"),
        ALTER_COLUMN_FAMILY("alter_column_Family"),
        DELETE_COLUMN_FAMILY("delete_column_Family");

        private final String name;

        private OPERATION(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }
    }
}

