/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.atlas.hbase.bridge.HBaseAtlasHook;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.security.UserGroupInformation;

public class HBaseOperationContext {
    private final UserGroupInformation ugi;
    private final Map<String, String> hbaseConf;
    private final HBaseAtlasHook.OPERATION operation;
    private final String user;
    private final NamespaceDescriptor namespaceDescriptor;
    private final TableDescriptor tableDescriptor;
    private final ColumnFamilyDescriptor[] columnFamilyDescriptors;
    private final TableName tableName;
    private final String nameSpace;
    private final String columnFamily;
    private final String owner;
    private final ColumnFamilyDescriptor columnFamilyDescriptor;
    private List<HookNotification> messages = new ArrayList<HookNotification>();

    public HBaseOperationContext(NamespaceDescriptor namespaceDescriptor, String nameSpace, TableDescriptor tableDescriptor, TableName tableName, ColumnFamilyDescriptor[] columnFamilyDescriptors, ColumnFamilyDescriptor columnFamilyDescriptor, String columnFamily, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner, Map<String, String> hbaseConf) {
        this.namespaceDescriptor = namespaceDescriptor;
        this.nameSpace = nameSpace;
        this.tableDescriptor = tableDescriptor;
        this.tableName = tableName;
        this.columnFamilyDescriptors = columnFamilyDescriptors;
        this.columnFamilyDescriptor = columnFamilyDescriptor;
        this.columnFamily = columnFamily;
        this.operation = operation;
        this.ugi = ugi;
        this.user = user;
        this.owner = owner;
        this.hbaseConf = hbaseConf;
    }

    public HBaseOperationContext(NamespaceDescriptor namespaceDescriptor, String nameSpace, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner) {
        this(namespaceDescriptor, nameSpace, null, null, null, null, null, operation, ugi, user, owner, null);
    }

    public HBaseOperationContext(String nameSpace, TableDescriptor tableDescriptor, TableName tableName, ColumnFamilyDescriptor[] columnFamilyDescriptors, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner, Map<String, String> hbaseConf) {
        this(null, nameSpace, tableDescriptor, tableName, columnFamilyDescriptors, null, null, operation, ugi, user, owner, hbaseConf);
    }

    public HBaseOperationContext(String nameSpace, TableName tableName, ColumnFamilyDescriptor columnFamilyDescriptor, String columnFamily, HBaseAtlasHook.OPERATION operation, UserGroupInformation ugi, String user, String owner, Map<String, String> hbaseConf) {
        this(null, nameSpace, null, tableName, null, columnFamilyDescriptor, columnFamily, operation, ugi, user, owner, hbaseConf);
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public Map<String, String> getHbaseConf() {
        return this.hbaseConf;
    }

    public String getUser() {
        return this.user;
    }

    public HBaseAtlasHook.OPERATION getOperation() {
        return this.operation;
    }

    public NamespaceDescriptor getNamespaceDescriptor() {
        return this.namespaceDescriptor;
    }

    public TableDescriptor gethTableDescriptor() {
        return this.tableDescriptor;
    }

    public ColumnFamilyDescriptor[] gethColumnDescriptors() {
        return this.columnFamilyDescriptors;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public ColumnFamilyDescriptor gethColumnDescriptor() {
        return this.columnFamilyDescriptor;
    }

    public String getColummFamily() {
        return this.columnFamily;
    }

    public void addMessage(HookNotification message) {
        this.messages.add(message);
    }

    public String getOwner() {
        return this.owner;
    }

    public List<HookNotification> getMessages() {
        return this.messages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("HBaseOperationContext={");
        sb.append("Operation={").append((Object)this.operation).append("} ");
        sb.append("User ={").append(this.user).append("} ");
        if (this.nameSpace != null) {
            sb.append("NameSpace={").append(this.nameSpace).append("}");
        } else if (this.namespaceDescriptor != null) {
            sb.append("NameSpace={").append(this.namespaceDescriptor.toString()).append("}");
        }
        if (this.tableName != null) {
            sb.append("Table={").append(this.tableName).append("}");
        } else if (this.columnFamilyDescriptor != null) {
            sb.append("Table={").append(this.tableDescriptor.toString()).append("}");
        }
        if (this.columnFamily != null) {
            sb.append("Columm Family={").append(this.columnFamily).append("}");
        } else if (this.columnFamilyDescriptor != null) {
            sb.append("Columm Family={").append(this.columnFamilyDescriptor.toString()).append("}");
        }
        sb.append("Message ={").append(this.getMessages()).append("} ");
        sb.append(" }");
        return sb;
    }
}

