/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.bridge;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridgeV2;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.hook.AtlasHookException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasConfigurationUtil;
import org.apache.atlas.utils.AtlasPathExtractorUtil;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.atlas.utils.HdfsNameServiceResolver;
import org.apache.atlas.utils.PathExtractorContext;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreBridge {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreBridge.class);
    public static final String CONF_PREFIX = "atlas.hook.hive.";
    public static final String CLUSTER_NAME_KEY = "atlas.cluster.name";
    public static final String HIVE_USERNAME = "atlas.hook.hive.default.username";
    public static final String HIVE_METADATA_NAMESPACE = "atlas.metadata.namespace";
    public static final String HDFS_PATH_CONVERT_TO_LOWER_CASE = "atlas.hook.hive.hdfs_path.convert_to_lowercase";
    public static final String HOOK_AWS_S3_ATLAS_MODEL_VERSION = "atlas.hook.hive.aws_s3.atlas.model.version";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    public static final String TEMP_TABLE_PREFIX = "_temp-";
    public static final String ATLAS_ENDPOINT = "atlas.rest.address";
    public static final String SEP = ":".intern();
    public static final String HDFS_PATH = "hdfs_path";
    public static final String DEFAULT_METASTORE_CATALOG = "hive";
    public static final String HIVE_TABLE_DB_EDGE_LABEL = "__hive_table.db";
    public static final String HOOK_HIVE_PAGE_LIMIT = "atlas.hook.hive.page.limit";
    static final String OPTION_OUTPUT_FILEPATH_SHORT = "o";
    static final String OPTION_OUTPUT_FILEPATH_LONG = "output";
    static final String OPTION_IGNORE_BULK_IMPORT_SHORT = "i";
    static final String OPTION_IGNORE_BULK_IMPORT_LONG = "ignoreBulkImport";
    static final String OPTION_DATABASE_SHORT = "d";
    static final String OPTION_DATABASE_LONG = "database";
    static final String OPTION_TABLE_SHORT = "t";
    static final String OPTION_TABLE_LONG = "table";
    static final String OPTION_IMPORT_DATA_FILE_SHORT = "f";
    static final String OPTION_IMPORT_DATA_FILE_LONG = "filename";
    static final String OPTION_FAIL_ON_ERROR = "failOnError";
    static final String OPTION_DELETE_NON_EXISTING = "deleteNonExisting";
    static final String OPTION_HELP_SHORT = "h";
    static final String OPTION_HELP_LONG = "help";
    public static final String HOOK_AWS_S3_ATLAS_MODEL_VERSION_V2 = "v2";
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_FAILED = 1;
    private static final int EXIT_CODE_INVALID_ARG = 2;
    private static final String DEFAULT_ATLAS_URL = "http://localhost:21000/";
    private static int pageLimit = 10000;
    private final String metadataNamespace;
    private final Hive hiveClient;
    private final AtlasClientV2 atlasClientV2;
    private final boolean convertHdfsPathToLowerCase;
    private String awsS3AtlasModelVersion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitCode = 1;
        Options acceptedCliOptions = HiveMetaStoreBridge.prepareCommandLineOptions();
        try (AtlasClientV2 atlasClientV2 = null;){
            CommandLine cmd = new BasicParser().parse(acceptedCliOptions, args);
            List argsNotProcessed = cmd.getArgList();
            if (argsNotProcessed != null && argsNotProcessed.size() > 0) {
                throw new ParseException("Unrecognized arguments.");
            }
            if (cmd.hasOption(OPTION_HELP_SHORT)) {
                HiveMetaStoreBridge.printUsage(acceptedCliOptions);
                exitCode = 0;
            } else {
                Configuration atlasConf = ApplicationProperties.get();
                String[] atlasEndpoint = atlasConf.getStringArray(ATLAS_ENDPOINT);
                if (atlasEndpoint == null || atlasEndpoint.length == 0) {
                    atlasEndpoint = new String[]{DEFAULT_ATLAS_URL};
                }
                if (!AuthenticationUtil.isKerberosAuthenticationEnabled()) {
                    String[] basicAuthUsernamePassword = AuthenticationUtil.getBasicAuthenticationInput();
                    atlasClientV2 = new AtlasClientV2(atlasEndpoint, basicAuthUsernamePassword);
                } else {
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    atlasClientV2 = new AtlasClientV2(ugi, ugi.getShortUserName(), atlasEndpoint);
                }
                boolean createZip = cmd.hasOption(OPTION_OUTPUT_FILEPATH_LONG);
                if (createZip) {
                    HiveMetaStoreBridgeV2 hiveMetaStoreBridgeV2 = new HiveMetaStoreBridgeV2(atlasConf, new HiveConf(), atlasClientV2);
                    if (hiveMetaStoreBridgeV2.exportDataToZipAndRunAtlasImport(cmd)) {
                        exitCode = 0;
                    }
                } else {
                    HiveMetaStoreBridge hiveMetaStoreBridge = new HiveMetaStoreBridge(atlasConf, new HiveConf(), atlasClientV2);
                    if (hiveMetaStoreBridge.importDataDirectlyToAtlas(cmd)) {
                        exitCode = 0;
                    }
                }
            }
        }
        System.exit(exitCode);
    }

    private static Options prepareCommandLineOptions() {
        Options acceptedCliOptions = new Options();
        return acceptedCliOptions.addOption(OPTION_OUTPUT_FILEPATH_SHORT, OPTION_OUTPUT_FILEPATH_LONG, true, "Output path or file for Zip import").addOption(OPTION_IGNORE_BULK_IMPORT_SHORT, OPTION_IGNORE_BULK_IMPORT_LONG, false, "Ignore bulk Import for Zip import").addOption(OPTION_DATABASE_SHORT, OPTION_DATABASE_LONG, true, "Database name").addOption(OPTION_TABLE_SHORT, OPTION_TABLE_LONG, true, "Table name").addOption(OPTION_IMPORT_DATA_FILE_SHORT, OPTION_IMPORT_DATA_FILE_LONG, true, "Filename").addOption(OPTION_FAIL_ON_ERROR, false, OPTION_FAIL_ON_ERROR).addOption(OPTION_DELETE_NON_EXISTING, false, "Delete database and table entities in Atlas if not present in Hive").addOption(OPTION_HELP_SHORT, OPTION_HELP_LONG, false, "Print this help message");
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("import-hive.sh", options);
        System.out.println();
        System.out.println("Usage options:");
        System.out.println("    Usage 1: import-hive.sh [-d <database> OR --database <database>] ");
        System.out.println("        Imports specified database and its tables ...");
        System.out.println();
        System.out.println("    Usage 2: import-hive.sh [-d <database> OR --database <database>] [-t <table> OR --table <table>]");
        System.out.println("        Imports specified table within that database ...");
        System.out.println();
        System.out.println("    Usage 3: import-hive.sh");
        System.out.println("        Imports all databases and tables...");
        System.out.println();
        System.out.println("    Usage 4: import-hive.sh -f <filename>");
        System.out.println("        Imports all databases and tables in the file...");
        System.out.println("        Format:");
        System.out.println("            database1:tbl1");
        System.out.println("            database1:tbl2");
        System.out.println("            database2:tbl2");
        System.out.println();
        System.out.println("    Usage 5: import-hive.sh [-deleteNonExisting] ");
        System.out.println("        Deletes databases and tables which are not in Hive ...");
        System.out.println();
        System.out.println("    Usage 6: import-hive.sh -o <output Path or file> [-f <filename>] [-d <database> OR --database <database>] [-t <table> OR --table <table>]");
        System.out.println("        To create zip file with exported data and import the zip file at Atlas ...");
        System.out.println();
        System.out.println("    Usage 7: import-hive.sh -i -o <output Path or file> [-f <filename>] [-d <database> OR --database <database>] [-t <table> OR --table <table>]");
        System.out.println("        To create zip file with exported data without importing to Atlas which can be imported later ...");
        System.out.println();
        System.out.println("    Usage 8: import-hive.sh [-d <database> OR --database <database>] [-t <table> OR --table <table>] [-deleteNonExisting] ");
        System.out.println("        Delete database and table wise which are not present in ATLAS and present in HIVE ...");
        System.out.println();
    }

    public HiveMetaStoreBridge(Configuration atlasProperties, HiveConf hiveConf, AtlasClientV2 atlasClientV2) throws Exception {
        this.metadataNamespace = this.getMetadataNamespace(atlasProperties);
        this.hiveClient = Hive.get((HiveConf)hiveConf);
        this.atlasClientV2 = atlasClientV2;
        this.convertHdfsPathToLowerCase = atlasProperties.getBoolean(HDFS_PATH_CONVERT_TO_LOWER_CASE, false);
        this.awsS3AtlasModelVersion = atlasProperties.getString(HOOK_AWS_S3_ATLAS_MODEL_VERSION, HOOK_AWS_S3_ATLAS_MODEL_VERSION_V2);
        if (atlasProperties != null) {
            pageLimit = atlasProperties.getInteger(HOOK_HIVE_PAGE_LIMIT, Integer.valueOf(10000));
        }
    }

    public HiveMetaStoreBridge(Configuration atlasProperties, HiveConf hiveConf) throws Exception {
        this(atlasProperties, hiveConf, null);
    }

    HiveMetaStoreBridge(String metadataNamespace, Hive hiveClient, AtlasClientV2 atlasClientV2) {
        this(metadataNamespace, hiveClient, atlasClientV2, true);
    }

    HiveMetaStoreBridge(String metadataNamespace, Hive hiveClient, AtlasClientV2 atlasClientV2, boolean convertHdfsPathToLowerCase) {
        this.metadataNamespace = metadataNamespace;
        this.hiveClient = hiveClient;
        this.atlasClientV2 = atlasClientV2;
        this.convertHdfsPathToLowerCase = convertHdfsPathToLowerCase;
    }

    public String getMetadataNamespace(Configuration config) {
        return AtlasConfigurationUtil.getRecentString((Configuration)config, (String)HIVE_METADATA_NAMESPACE, (String)this.getClusterName(config));
    }

    private String getClusterName(Configuration config) {
        return config.getString(CLUSTER_NAME_KEY, DEFAULT_CLUSTER_NAME);
    }

    public String getMetadataNamespace() {
        return this.metadataNamespace;
    }

    public Hive getHiveClient() {
        return this.hiveClient;
    }

    public boolean isConvertHdfsPathToLowerCase() {
        return this.convertHdfsPathToLowerCase;
    }

    public boolean importDataDirectlyToAtlas(CommandLine cmd) throws Exception {
        LOG.info("Importing Hive metadata");
        boolean ret = false;
        Object databaseToImport = cmd.getOptionValue(OPTION_DATABASE_SHORT);
        Object tableToImport = cmd.getOptionValue(OPTION_TABLE_SHORT);
        String fileToImport = cmd.getOptionValue(OPTION_IMPORT_DATA_FILE_SHORT);
        boolean failOnError = cmd.hasOption(OPTION_FAIL_ON_ERROR);
        boolean deleteNonExisting = cmd.hasOption(OPTION_DELETE_NON_EXISTING);
        LOG.info("delete non existing flag : {} ", (Object)deleteNonExisting);
        if (deleteNonExisting) {
            this.deleteEntitiesForNonExistingHiveMetadata(failOnError, (String)databaseToImport, (String)tableToImport);
            ret = true;
        } else if (StringUtils.isNotEmpty((String)fileToImport)) {
            File f = new File(fileToImport);
            if (f.exists() && f.canRead()) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String line = null;
                while ((line = br.readLine()) != null) {
                    Object[] val = line.split(":");
                    if (!ArrayUtils.isNotEmpty((Object[])val)) continue;
                    databaseToImport = val[0];
                    tableToImport = val.length > 1 ? val[1] : "";
                    this.importDatabases(failOnError, (String)databaseToImport, (String)tableToImport);
                }
                ret = true;
            } else {
                LOG.error("Failed to read the input file: " + fileToImport);
            }
        } else {
            this.importDatabases(failOnError, (String)databaseToImport, (String)tableToImport);
            ret = true;
        }
        return ret;
    }

    @VisibleForTesting
    public void importHiveMetadata(String databaseToImport, String tableToImport, boolean failOnError) throws Exception {
        LOG.info("Importing Hive metadata");
        this.importDatabases(failOnError, databaseToImport, tableToImport);
    }

    private void importDatabases(boolean failOnError, String databaseToImport, String tableToImport) throws Exception {
        List databaseNames = null;
        if (StringUtils.isEmpty((String)databaseToImport) && StringUtils.isEmpty((String)tableToImport)) {
            databaseNames = this.hiveClient.getAllDatabases();
        } else if (StringUtils.isEmpty((String)databaseToImport) && StringUtils.isNotEmpty((String)tableToImport)) {
            if (this.isTableWithDatabaseName(tableToImport)) {
                String[] val = tableToImport.split("\\.");
                if (val.length > 1) {
                    databaseToImport = val[0];
                    tableToImport = val[1];
                }
                databaseNames = this.hiveClient.getDatabasesByPattern(databaseToImport);
            } else {
                databaseNames = this.hiveClient.getAllDatabases();
            }
        } else {
            databaseNames = this.hiveClient.getDatabasesByPattern(databaseToImport);
        }
        if (!CollectionUtils.isEmpty((Collection)databaseNames)) {
            LOG.info("Found {} databases", (Object)databaseNames.size());
            for (String databaseName : databaseNames) {
                AtlasEntity.AtlasEntityWithExtInfo dbEntity = this.registerDatabase(databaseName);
                if (dbEntity == null) continue;
                this.importTables(dbEntity.getEntity(), databaseName, tableToImport, failOnError);
            }
        } else {
            LOG.error("No database found");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int importTables(AtlasEntity dbEntity, String databaseName, String tblName, boolean failOnError) throws Exception {
        int tablesImported;
        block7: {
            block6: {
                List tableNames;
                block5: {
                    tablesImported = 0;
                    tableNames = StringUtils.isEmpty((String)tblName) ? this.hiveClient.getAllTables(databaseName) : this.hiveClient.getTablesByPattern(databaseName, tblName);
                    if (CollectionUtils.isEmpty((Collection)tableNames)) break block6;
                    LOG.info("Found {} tables to import in database {}", (Object)tableNames.size(), (Object)databaseName);
                    try {
                        for (String tableName : tableNames) {
                            int imported = this.importTable(dbEntity, databaseName, tableName, failOnError);
                            tablesImported += imported;
                        }
                        if (tablesImported != tableNames.size()) break block5;
                    }
                    catch (Throwable throwable) {
                        if (tablesImported == tableNames.size()) {
                            LOG.info("Successfully imported {} tables from database {}", (Object)tablesImported, (Object)databaseName);
                        } else {
                            LOG.error("Imported {} of {} tables from database {}. Please check logs for errors during import", new Object[]{tablesImported, tableNames.size(), databaseName});
                        }
                        throw throwable;
                    }
                    LOG.info("Successfully imported {} tables from database {}", (Object)tablesImported, (Object)databaseName);
                    break block7;
                }
                LOG.error("Imported {} of {} tables from database {}. Please check logs for errors during import", new Object[]{tablesImported, tableNames.size(), databaseName});
                break block7;
            }
            LOG.error("No tables to import in database {}", (Object)databaseName);
        }
        return tablesImported;
    }

    @VisibleForTesting
    public int importTable(AtlasEntity dbEntity, String databaseName, String tableName, boolean failOnError) throws Exception {
        try {
            Table table = this.hiveClient.getTable(databaseName, tableName);
            AtlasEntity.AtlasEntityWithExtInfo tableEntity = this.registerTable(dbEntity, table);
            if (table.getTableType() == TableType.EXTERNAL_TABLE) {
                String processQualifiedName = HiveMetaStoreBridge.getTableProcessQualifiedName(this.metadataNamespace, table);
                AtlasEntity.AtlasEntityWithExtInfo processEntity = this.findProcessEntity(processQualifiedName);
                if (processEntity == null) {
                    String tableLocationString = this.isConvertHdfsPathToLowerCase() ? this.lower(table.getDataLocation().toString()) : table.getDataLocation().toString();
                    Path location = table.getDataLocation();
                    String query = this.getCreateTableString(table, tableLocationString);
                    PathExtractorContext pathExtractorCtx = new PathExtractorContext(this.getMetadataNamespace(), this.isConvertHdfsPathToLowerCase(), this.awsS3AtlasModelVersion);
                    AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)location, (PathExtractorContext)pathExtractorCtx);
                    AtlasEntity pathInst = entityWithExtInfo.getEntity();
                    AtlasEntity tableInst = tableEntity.getEntity();
                    AtlasEntity processInst = new AtlasEntity(HiveDataTypes.HIVE_PROCESS.getName());
                    long now = System.currentTimeMillis();
                    processInst.setAttribute("qualifiedName", (Object)processQualifiedName);
                    processInst.setAttribute("name", (Object)query);
                    processInst.setAttribute("clusterName", (Object)this.metadataNamespace);
                    processInst.setRelationshipAttribute("inputs", Collections.singletonList(AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)pathInst, (String)"dataset_process_inputs")));
                    processInst.setRelationshipAttribute("outputs", Collections.singletonList(AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)tableInst, (String)"process_dataset_outputs")));
                    String userName = table.getOwner();
                    if (StringUtils.isEmpty((String)userName)) {
                        userName = ApplicationProperties.get().getString(HIVE_USERNAME, DEFAULT_METASTORE_CATALOG);
                    }
                    processInst.setAttribute("userName", (Object)userName);
                    processInst.setAttribute("startTime", (Object)now);
                    processInst.setAttribute("endTime", (Object)now);
                    processInst.setAttribute("operationType", (Object)"CREATETABLE");
                    processInst.setAttribute("queryText", (Object)query);
                    processInst.setAttribute("queryId", (Object)query);
                    processInst.setAttribute("queryPlan", (Object)"{}");
                    processInst.setAttribute("recentQueries", Collections.singletonList(query));
                    AtlasEntity.AtlasEntitiesWithExtInfo createTableProcess = new AtlasEntity.AtlasEntitiesWithExtInfo();
                    createTableProcess.addEntity(processInst);
                    if (pathExtractorCtx.getKnownEntities() != null) {
                        pathExtractorCtx.getKnownEntities().values().forEach(entity -> createTableProcess.addEntity(entity));
                    } else {
                        createTableProcess.addEntity(pathInst);
                    }
                    this.registerInstances(createTableProcess);
                } else {
                    LOG.info("Process {} is already registered", (Object)processQualifiedName);
                }
            }
            return 1;
        }
        catch (Exception e) {
            LOG.error("Import failed for hive_table {}", (Object)tableName, (Object)e);
            if (failOnError) {
                throw e;
            }
            return 0;
        }
    }

    private AtlasEntity.AtlasEntityWithExtInfo registerDatabase(String databaseName) throws Exception {
        AtlasEntity.AtlasEntityWithExtInfo ret = null;
        Database db = this.hiveClient.getDatabase(databaseName);
        if (db != null) {
            ret = this.findDatabase(this.metadataNamespace, databaseName);
            if (ret == null) {
                ret = this.registerInstance(new AtlasEntity.AtlasEntityWithExtInfo(this.toDbEntity(db)));
            } else {
                LOG.info("Database {} is already registered - id={}. Updating it.", (Object)databaseName, (Object)ret.getEntity().getGuid());
                ret.setEntity(this.toDbEntity(db, ret.getEntity()));
                this.updateInstance(ret);
            }
        }
        return ret;
    }

    private AtlasEntity.AtlasEntityWithExtInfo registerTable(AtlasEntity dbEntity, Table table) throws AtlasHookException {
        try {
            AtlasEntity.AtlasEntityWithExtInfo ret;
            AtlasEntity.AtlasEntityWithExtInfo tableEntity = this.findTableEntity(table);
            if (tableEntity == null) {
                tableEntity = this.toTableEntity(dbEntity, table);
                ret = this.registerInstance(tableEntity);
            } else {
                LOG.info("Table {}.{} is already registered with id {}. Updating entity.", new Object[]{table.getDbName(), table.getTableName(), tableEntity.getEntity().getGuid()});
                ret = this.toTableEntity(dbEntity, table, tableEntity);
                this.updateInstance(ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw new AtlasHookException("HiveMetaStoreBridge.registerTable() failed.", (Throwable)e);
        }
    }

    private AtlasEntity.AtlasEntityWithExtInfo registerInstance(AtlasEntity.AtlasEntityWithExtInfo entity) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating {} entity: {}", (Object)entity.getEntity().getTypeName(), (Object)entity);
        }
        AtlasEntity.AtlasEntityWithExtInfo ret = null;
        EntityMutationResponse response = this.atlasClientV2.createEntity(entity);
        List createdEntities = response.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE);
        if (CollectionUtils.isNotEmpty((Collection)createdEntities)) {
            for (AtlasEntityHeader createdEntity : createdEntities) {
                if (ret == null) {
                    ret = this.atlasClientV2.getEntityByGuid(createdEntity.getGuid());
                    LOG.info("Created {} entity: name={}, guid={}", new Object[]{ret.getEntity().getTypeName(), ret.getEntity().getAttribute("qualifiedName"), ret.getEntity().getGuid()});
                    continue;
                }
                if (ret.getEntity(createdEntity.getGuid()) != null) continue;
                AtlasEntity.AtlasEntityWithExtInfo newEntity = this.atlasClientV2.getEntityByGuid(createdEntity.getGuid());
                ret.addReferredEntity(newEntity.getEntity());
                if (MapUtils.isNotEmpty((Map)newEntity.getReferredEntities())) {
                    for (Map.Entry entry : newEntity.getReferredEntities().entrySet()) {
                        ret.addReferredEntity((String)entry.getKey(), (AtlasEntity)entry.getValue());
                    }
                }
                LOG.info("Created {} entity: name={}, guid={}", new Object[]{newEntity.getEntity().getTypeName(), newEntity.getEntity().getAttribute("qualifiedName"), newEntity.getEntity().getGuid()});
            }
        }
        this.clearRelationshipAttributes(ret);
        return ret;
    }

    private AtlasEntity.AtlasEntitiesWithExtInfo registerInstances(AtlasEntity.AtlasEntitiesWithExtInfo entities) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating {} entities: {}", (Object)entities.getEntities().size(), (Object)entities);
        }
        AtlasEntity.AtlasEntitiesWithExtInfo ret = null;
        EntityMutationResponse response = this.atlasClientV2.createEntities(entities);
        List createdEntities = response.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE);
        if (CollectionUtils.isNotEmpty((Collection)createdEntities)) {
            ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
            for (AtlasEntityHeader createdEntity : createdEntities) {
                AtlasEntity.AtlasEntityWithExtInfo entity = this.atlasClientV2.getEntityByGuid(createdEntity.getGuid());
                ret.addEntity(entity.getEntity());
                if (MapUtils.isNotEmpty((Map)entity.getReferredEntities())) {
                    for (Map.Entry entry : entity.getReferredEntities().entrySet()) {
                        ret.addReferredEntity((String)entry.getKey(), (AtlasEntity)entry.getValue());
                    }
                }
                LOG.info("Created {} entity: name={}, guid={}", new Object[]{entity.getEntity().getTypeName(), entity.getEntity().getAttribute("qualifiedName"), entity.getEntity().getGuid()});
            }
        }
        this.clearRelationshipAttributes(ret);
        return ret;
    }

    private void updateInstance(AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasServiceException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updating {} entity: {}", (Object)entity.getEntity().getTypeName(), (Object)entity);
        }
        this.atlasClientV2.updateEntity(entity);
        LOG.info("Updated {} entity: name={}, guid={}", new Object[]{entity.getEntity().getTypeName(), entity.getEntity().getAttribute("qualifiedName"), entity.getEntity().getGuid()});
    }

    private AtlasEntity toDbEntity(Database hiveDB) throws HiveException {
        return this.toDbEntity(hiveDB, null);
    }

    private AtlasEntity toDbEntity(Database hiveDB, AtlasEntity dbEntity) {
        if (dbEntity == null) {
            dbEntity = new AtlasEntity(HiveDataTypes.HIVE_DB.getName());
        }
        String dbName = HiveMetaStoreBridge.getDatabaseName(hiveDB);
        dbEntity.setAttribute("qualifiedName", (Object)HiveMetaStoreBridge.getDBQualifiedName(this.metadataNamespace, dbName));
        dbEntity.setAttribute("name", (Object)dbName);
        dbEntity.setAttribute("description", (Object)hiveDB.getDescription());
        dbEntity.setAttribute("owner", (Object)hiveDB.getOwnerName());
        dbEntity.setAttribute("clusterName", (Object)this.metadataNamespace);
        dbEntity.setAttribute("location", (Object)HdfsNameServiceResolver.getPathWithNameServiceID((String)hiveDB.getLocationUri()));
        dbEntity.setAttribute("parameters", (Object)hiveDB.getParameters());
        if (hiveDB.getOwnerType() != null) {
            dbEntity.setAttribute("ownerType", (Object)BaseHiveEvent.OWNER_TYPE_TO_ENUM_VALUE.get(hiveDB.getOwnerType().getValue()));
        }
        return dbEntity;
    }

    public static String getDatabaseName(Database hiveDB) {
        String catalogName;
        String dbName = hiveDB.getName().toLowerCase();
        String string = catalogName = hiveDB.getCatalogName() != null ? hiveDB.getCatalogName().toLowerCase() : null;
        if (StringUtils.isNotEmpty((String)catalogName) && !StringUtils.equals((String)catalogName, (String)DEFAULT_METASTORE_CATALOG)) {
            dbName = catalogName + SEP + dbName;
        }
        return dbName;
    }

    private AtlasEntity.AtlasEntityWithExtInfo toTableEntity(AtlasEntity database, Table hiveTable) throws AtlasHookException {
        return this.toTableEntity(database, hiveTable, null);
    }

    private AtlasEntity.AtlasEntityWithExtInfo toTableEntity(AtlasEntity database, Table hiveTable, AtlasEntity.AtlasEntityWithExtInfo table) throws AtlasHookException {
        if (table == null) {
            table = new AtlasEntity.AtlasEntityWithExtInfo(new AtlasEntity(HiveDataTypes.HIVE_TABLE.getName()));
        }
        AtlasEntity tableEntity = table.getEntity();
        String tableQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(this.metadataNamespace, hiveTable);
        long createTime = BaseHiveEvent.getTableCreateTime(hiveTable);
        long lastAccessTime = hiveTable.getLastAccessTime() > 0 ? (long)hiveTable.getLastAccessTime() : createTime;
        tableEntity.setRelationshipAttribute("db", (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)database, (String)"hive_table_db"));
        tableEntity.setAttribute("qualifiedName", (Object)tableQualifiedName);
        tableEntity.setAttribute("name", (Object)hiveTable.getTableName().toLowerCase());
        tableEntity.setAttribute("owner", (Object)hiveTable.getOwner());
        tableEntity.setAttribute("createTime", (Object)createTime);
        tableEntity.setAttribute("lastAccessTime", (Object)lastAccessTime);
        tableEntity.setAttribute("retention", (Object)hiveTable.getRetention());
        tableEntity.setAttribute("parameters", (Object)hiveTable.getParameters());
        tableEntity.setAttribute("comment", hiveTable.getParameters().get("comment"));
        tableEntity.setAttribute("tableType", (Object)hiveTable.getTableType().name());
        tableEntity.setAttribute("temporary", (Object)hiveTable.isTemporary());
        if (hiveTable.getViewOriginalText() != null) {
            tableEntity.setAttribute("viewOriginalText", (Object)hiveTable.getViewOriginalText());
        }
        if (hiveTable.getViewExpandedText() != null) {
            tableEntity.setAttribute("viewExpandedText", (Object)hiveTable.getViewExpandedText());
        }
        AtlasEntity sdEntity = this.toStorageDescEntity(hiveTable.getSd(), tableQualifiedName, HiveMetaStoreBridge.getStorageDescQFName(tableQualifiedName), AtlasTypeUtil.getObjectId((AtlasEntity)tableEntity));
        List<AtlasEntity> partKeys = this.toColumns(hiveTable.getPartitionKeys(), tableEntity, "hive_table_partitionkeys");
        List<AtlasEntity> columns = this.toColumns(hiveTable.getCols(), tableEntity, "hive_table_columns");
        tableEntity.setRelationshipAttribute("sd", (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)sdEntity, (String)"hive_table_storagedesc"));
        tableEntity.setRelationshipAttribute("partitionKeys", (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(partKeys, (String)"hive_table_partitionkeys"));
        tableEntity.setRelationshipAttribute("columns", (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(columns, (String)"hive_table_columns"));
        table.addReferredEntity(database);
        table.addReferredEntity(sdEntity);
        if (partKeys != null) {
            for (AtlasEntity partKey : partKeys) {
                table.addReferredEntity(partKey);
            }
        }
        if (columns != null) {
            for (AtlasEntity column : columns) {
                table.addReferredEntity(column);
            }
        }
        table.setEntity(tableEntity);
        return table;
    }

    private AtlasEntity toStorageDescEntity(StorageDescriptor storageDesc, String tableQualifiedName, String sdQualifiedName, AtlasObjectId tableId) throws AtlasHookException {
        AtlasEntity ret = new AtlasEntity(HiveDataTypes.HIVE_STORAGEDESC.getName());
        ret.setRelationshipAttribute(OPTION_TABLE_LONG, (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasObjectId)tableId, (String)"hive_table_storagedesc"));
        ret.setAttribute("qualifiedName", (Object)sdQualifiedName);
        ret.setAttribute("parameters", (Object)storageDesc.getParameters());
        ret.setAttribute("location", (Object)HdfsNameServiceResolver.getPathWithNameServiceID((String)storageDesc.getLocation()));
        ret.setAttribute("inputFormat", (Object)storageDesc.getInputFormat());
        ret.setAttribute("outputFormat", (Object)storageDesc.getOutputFormat());
        ret.setAttribute("compressed", (Object)storageDesc.isCompressed());
        ret.setAttribute("numBuckets", (Object)storageDesc.getNumBuckets());
        ret.setAttribute("storedAsSubDirectories", (Object)storageDesc.isStoredAsSubDirectories());
        if (storageDesc.getBucketCols().size() > 0) {
            ret.setAttribute("bucketCols", (Object)storageDesc.getBucketCols());
        }
        if (storageDesc.getSerdeInfo() != null) {
            SerDeInfo serdeInfo = storageDesc.getSerdeInfo();
            LOG.debug("serdeInfo = {}", (Object)serdeInfo);
            AtlasStruct serdeInfoStruct = new AtlasStruct(HiveDataTypes.HIVE_SERDE.getName());
            serdeInfoStruct.setAttribute("name", (Object)serdeInfo.getName());
            serdeInfoStruct.setAttribute("serializationLib", (Object)serdeInfo.getSerializationLib());
            serdeInfoStruct.setAttribute("parameters", (Object)serdeInfo.getParameters());
            ret.setAttribute("serdeInfo", (Object)serdeInfoStruct);
        }
        if (CollectionUtils.isNotEmpty((Collection)storageDesc.getSortCols())) {
            ArrayList<AtlasStruct> sortColsStruct = new ArrayList<AtlasStruct>();
            for (Order sortcol : storageDesc.getSortCols()) {
                String hiveOrderName = HiveDataTypes.HIVE_ORDER.getName();
                AtlasStruct colStruct = new AtlasStruct(hiveOrderName);
                colStruct.setAttribute("col", (Object)sortcol.getCol());
                colStruct.setAttribute("order", (Object)sortcol.getOrder());
                sortColsStruct.add(colStruct);
            }
            ret.setAttribute("sortCols", sortColsStruct);
        }
        return ret;
    }

    private List<AtlasEntity> toColumns(List<FieldSchema> schemaList, AtlasEntity table, String relationshipType) throws AtlasHookException {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        int columnPosition = 0;
        for (FieldSchema fs : schemaList) {
            LOG.debug("Processing field {}", (Object)fs);
            AtlasEntity column = new AtlasEntity(HiveDataTypes.HIVE_COLUMN.getName());
            column.setRelationshipAttribute(OPTION_TABLE_LONG, (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)table, (String)relationshipType));
            column.setAttribute("qualifiedName", (Object)HiveMetaStoreBridge.getColumnQualifiedName((String)table.getAttribute("qualifiedName"), fs.getName()));
            column.setAttribute("name", (Object)fs.getName());
            column.setAttribute("owner", table.getAttribute("owner"));
            column.setAttribute("type", (Object)fs.getType());
            column.setAttribute("position", (Object)columnPosition++);
            column.setAttribute("comment", (Object)fs.getComment());
            ret.add(column);
        }
        return ret;
    }

    private AtlasEntity.AtlasEntityWithExtInfo findDatabase(String metadataNamespace, String databaseName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching Atlas for database {}", (Object)databaseName);
        }
        String typeName = HiveDataTypes.HIVE_DB.getName();
        return this.findEntity(typeName, HiveMetaStoreBridge.getDBQualifiedName(metadataNamespace, databaseName), true, true);
    }

    private AtlasEntity.AtlasEntityWithExtInfo findTableEntity(Table hiveTable) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching Atlas for table {}.{}", (Object)hiveTable.getDbName(), (Object)hiveTable.getTableName());
        }
        String typeName = HiveDataTypes.HIVE_TABLE.getName();
        String tblQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(this.getMetadataNamespace(), hiveTable.getDbName(), hiveTable.getTableName());
        return this.findEntity(typeName, tblQualifiedName, true, true);
    }

    private AtlasEntity.AtlasEntityWithExtInfo findProcessEntity(String qualifiedName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching Atlas for process {}", (Object)qualifiedName);
        }
        String typeName = HiveDataTypes.HIVE_PROCESS.getName();
        return this.findEntity(typeName, qualifiedName, true, true);
    }

    private AtlasEntity.AtlasEntityWithExtInfo findEntity(String typeName, String qualifiedName, boolean minExtInfo, boolean ignoreRelationship) throws AtlasServiceException {
        AtlasEntity.AtlasEntityWithExtInfo ret = null;
        try {
            ret = this.atlasClientV2.getEntityByAttribute(typeName, Collections.singletonMap("qualifiedName", qualifiedName), minExtInfo, ignoreRelationship);
        }
        catch (AtlasServiceException e) {
            if (e.getStatus() == ClientResponse.Status.NOT_FOUND) {
                return null;
            }
            throw e;
        }
        return ret;
    }

    private String getCreateTableString(Table table, String location) {
        String colString = "";
        List colList = table.getAllCols();
        if (colList != null) {
            for (FieldSchema col : colList) {
                colString = colString + col.getName() + " " + col.getType() + ",";
            }
            if (colList.size() > 0) {
                colString = colString.substring(0, colString.length() - 1);
                colString = "(" + colString + ")";
            }
        }
        String query = "create external table " + table.getTableName() + colString + " location '" + location + "'";
        return query;
    }

    private String lower(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        return str.toLowerCase().trim();
    }

    private static String getTableQualifiedName(String metadataNamespace, Table table) {
        return HiveMetaStoreBridge.getTableQualifiedName(metadataNamespace, table.getDbName(), table.getTableName(), table.isTemporary());
    }

    private String getHdfsPathQualifiedName(String hdfsPath) {
        return String.format("%s@%s", hdfsPath, this.metadataNamespace);
    }

    public static String getDBQualifiedName(String metadataNamespace, String dbName) {
        return String.format("%s@%s", dbName.toLowerCase(), metadataNamespace);
    }

    public static String getTableQualifiedName(String metadataNamespace, String dbName, String tableName, boolean isTemporaryTable) {
        String tableTempName = tableName;
        if (isTemporaryTable) {
            tableTempName = SessionState.get() != null && SessionState.get().getSessionId() != null ? tableName + TEMP_TABLE_PREFIX + SessionState.get().getSessionId() : tableName + TEMP_TABLE_PREFIX + RandomStringUtils.random((int)10);
        }
        return String.format("%s.%s@%s", dbName.toLowerCase(), tableTempName.toLowerCase(), metadataNamespace);
    }

    public static String getTableProcessQualifiedName(String metadataNamespace, Table table) {
        String tableQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(metadataNamespace, table);
        long createdTime = HiveMetaStoreBridge.getTableCreatedTime(table);
        return tableQualifiedName + SEP + createdTime;
    }

    public static String getTableQualifiedName(String metadataNamespace, String dbName, String tableName) {
        return HiveMetaStoreBridge.getTableQualifiedName(metadataNamespace, dbName, tableName, false);
    }

    public static String getStorageDescQFName(String tableQualifiedName) {
        return tableQualifiedName + "_storage";
    }

    public static String getColumnQualifiedName(String tableQualifiedName, String colName) {
        String[] parts = tableQualifiedName.split("@");
        String tableName = parts[0];
        String metadataNamespace = parts[1];
        return String.format("%s.%s@%s", tableName, colName.toLowerCase(), metadataNamespace);
    }

    public static long getTableCreatedTime(Table table) {
        return (long)table.getTTable().getCreateTime() * 1000L;
    }

    private void clearRelationshipAttributes(AtlasEntity.AtlasEntitiesWithExtInfo entities) {
        if (entities != null) {
            if (entities.getEntities() != null) {
                for (AtlasEntity entity : entities.getEntities()) {
                    this.clearRelationshipAttributes(entity);
                }
            }
            if (entities.getReferredEntities() != null) {
                this.clearRelationshipAttributes(entities.getReferredEntities().values());
            }
        }
    }

    private void clearRelationshipAttributes(AtlasEntity.AtlasEntityWithExtInfo entity) {
        if (entity != null) {
            this.clearRelationshipAttributes(entity.getEntity());
            if (entity.getReferredEntities() != null) {
                this.clearRelationshipAttributes(entity.getReferredEntities().values());
            }
        }
    }

    private void clearRelationshipAttributes(Collection<AtlasEntity> entities) {
        if (entities != null) {
            for (AtlasEntity entity : entities) {
                this.clearRelationshipAttributes(entity);
            }
        }
    }

    private void clearRelationshipAttributes(AtlasEntity entity) {
        if (entity != null && entity.getRelationshipAttributes() != null) {
            entity.getRelationshipAttributes().clear();
        }
    }

    private boolean isTableWithDatabaseName(String tableName) {
        boolean ret = false;
        if (tableName.contains(".")) {
            ret = true;
        }
        return ret;
    }

    private List<AtlasEntityHeader> getAllDatabaseInCluster() throws AtlasServiceException {
        ArrayList<AtlasEntityHeader> entities = new ArrayList<AtlasEntityHeader>();
        int pageSize = pageLimit;
        SearchParameters.FilterCriteria fc = new SearchParameters.FilterCriteria();
        fc.setAttributeName("clusterName");
        fc.setAttributeValue(this.metadataNamespace);
        fc.setOperator(SearchParameters.Operator.EQ);
        int i = 0;
        while (true) {
            int offset = pageSize * i;
            LOG.info("Retrieving databases: offset={}, pageSize={}", (Object)offset, (Object)pageSize);
            AtlasSearchResult searchResult = this.atlasClientV2.basicSearch("hive_db", fc, null, null, true, pageSize, offset);
            List entityHeaders = searchResult == null ? null : searchResult.getEntities();
            int dbCount = entityHeaders == null ? 0 : entityHeaders.size();
            LOG.info("Retrieved {} databases of {} cluster", (Object)dbCount, (Object)this.metadataNamespace);
            if (dbCount > 0) {
                entities.addAll(entityHeaders);
            }
            if (dbCount < pageSize) break;
            ++i;
        }
        return entities;
    }

    private List<AtlasEntityHeader> getAllTablesInDb(String databaseGuid) throws AtlasServiceException {
        ArrayList<AtlasEntityHeader> entities = new ArrayList<AtlasEntityHeader>();
        int pageSize = pageLimit;
        int i = 0;
        while (true) {
            int offset = pageSize * i;
            LOG.info("Retrieving tables: offset={}, pageSize={}", (Object)offset, (Object)pageSize);
            AtlasSearchResult searchResult = this.atlasClientV2.relationshipSearch(databaseGuid, HIVE_TABLE_DB_EDGE_LABEL, null, null, true, pageSize, offset);
            List entityHeaders = searchResult == null ? null : searchResult.getEntities();
            int tableCount = entityHeaders == null ? 0 : entityHeaders.size();
            LOG.info("Retrieved {} tables of {} database", (Object)tableCount, (Object)databaseGuid);
            if (tableCount > 0) {
                entities.addAll(entityHeaders);
            }
            if (tableCount < pageSize) break;
            ++i;
        }
        return entities;
    }

    public String getHiveDatabaseName(String qualifiedName) {
        String[] split;
        if (StringUtils.isNotEmpty((String)qualifiedName) && (split = qualifiedName.split("@")).length > 0) {
            return split[0];
        }
        return null;
    }

    public String getHiveTableName(String qualifiedName, boolean isTemporary) {
        if (StringUtils.isNotEmpty((String)qualifiedName)) {
            String[] splitTemp;
            String tableName = StringUtils.substringBetween((String)qualifiedName, (String)".", (String)"@");
            if (!isTemporary) {
                return tableName;
            }
            if (StringUtils.isNotEmpty((String)tableName) && (splitTemp = tableName.split(TEMP_TABLE_PREFIX)).length > 0) {
                return splitTemp[0];
            }
        }
        return null;
    }

    private void deleteByGuid(List<String> guidTodelete) throws AtlasServiceException {
        if (CollectionUtils.isNotEmpty(guidTodelete)) {
            for (String guid : guidTodelete) {
                EntityMutationResponse response = this.atlasClientV2.deleteEntityByGuid(guid);
                if (response.getDeletedEntities().size() < 1) {
                    LOG.info("Entity with guid : {} is not deleted", (Object)guid);
                    continue;
                }
                LOG.info("Entity with guid : {} is deleted", (Object)guid);
            }
        } else {
            LOG.info("No Entity to delete from Atlas");
        }
    }

    public void deleteEntitiesForNonExistingHiveMetadata(boolean failOnError, String databaseToDelete, String tableToDelete) throws Exception {
        List<AtlasEntityHeader> dbs;
        block24: {
            dbs = null;
            try {
                if (!StringUtils.isEmpty((String)databaseToDelete)) {
                    dbs = this.getSingleDatabaseInCluster(databaseToDelete);
                } else {
                    dbs = this.getAllDatabaseInCluster();
                    LOG.info("Total Databases in cluster {} : {} ", (Object)this.metadataNamespace, (Object)dbs.size());
                }
            }
            catch (AtlasServiceException e) {
                LOG.error("Failed to retrieve database entities for cluster {} from Atlas", (Object)this.metadataNamespace, (Object)e);
                if (!failOnError) break block24;
                throw e;
            }
        }
        if (CollectionUtils.isNotEmpty(dbs)) {
            for (AtlasEntityHeader db : dbs) {
                List<AtlasEntityHeader> tables;
                String dbGuid = db.getGuid();
                String hiveDbName = this.getHiveDatabaseName((String)db.getAttribute("qualifiedName"));
                if (StringUtils.isEmpty((String)hiveDbName)) {
                    LOG.error("Failed to get database from qualifiedName: {}, guid: {} ", db.getAttribute("qualifiedName"), (Object)dbGuid);
                    continue;
                }
                try {
                    if (!StringUtils.isEmpty((String)tableToDelete)) {
                        tables = this.getSingleTableInCluster(databaseToDelete, tableToDelete);
                    } else {
                        tables = this.getAllTablesInDb(dbGuid);
                        LOG.info("Total Tables in database {} : {} ", (Object)hiveDbName, (Object)tables.size());
                    }
                }
                catch (AtlasServiceException e) {
                    LOG.error("Failed to retrieve table entities for database {} from Atlas", (Object)hiveDbName, (Object)e);
                    if (!failOnError) continue;
                    throw e;
                }
                ArrayList<String> guidsToDelete = new ArrayList<String>();
                if (!this.hiveClient.databaseExists(hiveDbName)) {
                    if (CollectionUtils.isNotEmpty(tables)) {
                        for (AtlasEntityHeader table : tables) {
                            guidsToDelete.add(table.getGuid());
                        }
                    }
                    guidsToDelete.add(db.getGuid());
                    LOG.info("Added database {}.{} and its {} tables to delete", new Object[]{this.metadataNamespace, hiveDbName, tables.size()});
                } else if (CollectionUtils.isNotEmpty(tables)) {
                    for (AtlasEntityHeader table : tables) {
                        String hiveTableName = this.getHiveTableName((String)table.getAttribute("qualifiedName"), true);
                        if (StringUtils.isEmpty((String)hiveTableName)) {
                            LOG.error("Failed to get table from qualifiedName: {}, guid: {} ", table.getAttribute("qualifiedName"), (Object)table.getGuid());
                            continue;
                        }
                        try {
                            this.hiveClient.getTable(hiveDbName, hiveTableName, true);
                        }
                        catch (InvalidTableException e) {
                            LOG.info("Added table {}.{} to delete", (Object)hiveDbName, (Object)hiveTableName);
                            guidsToDelete.add(table.getGuid());
                        }
                        catch (HiveException e) {
                            LOG.error("Failed to get table {}.{} from Hive", new Object[]{hiveDbName, hiveTableName, e});
                            if (!failOnError) continue;
                            throw e;
                        }
                    }
                }
                if (!CollectionUtils.isNotEmpty(guidsToDelete)) continue;
                try {
                    this.deleteByGuid(guidsToDelete);
                }
                catch (AtlasServiceException e) {
                    LOG.error("Failed to delete Atlas entities for database {}", (Object)hiveDbName, (Object)e);
                    if (!failOnError) continue;
                    throw e;
                }
            }
        } else {
            LOG.info("No database found in service.");
        }
    }

    private List<AtlasEntityHeader> getSingleDatabaseInCluster(String databaseName) throws AtlasServiceException {
        String dbQualifiedName = HiveMetaStoreBridge.getDBQualifiedName(this.metadataNamespace, databaseName.toLowerCase());
        SearchParameters.FilterCriteria fc = new SearchParameters.FilterCriteria();
        fc.setAttributeName("qualifiedName");
        fc.setAttributeValue(dbQualifiedName);
        fc.setOperator(SearchParameters.Operator.EQ);
        fc.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        LOG.info("Searching for database : {}", (Object)dbQualifiedName);
        AtlasSearchResult searchResult = this.atlasClientV2.basicSearch("hive_db", fc, null, null, true, 25, 0);
        List entityHeaders = searchResult == null ? null : searchResult.getEntities();
        return entityHeaders;
    }

    private List<AtlasEntityHeader> getSingleTableInCluster(String databaseName, String tableName) throws AtlasServiceException {
        String tableQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(this.metadataNamespace, databaseName.toLowerCase(), tableName.toLowerCase());
        SearchParameters.FilterCriteria fc = new SearchParameters.FilterCriteria();
        fc.setAttributeName("qualifiedName");
        fc.setAttributeValue(tableQualifiedName);
        fc.setOperator(SearchParameters.Operator.EQ);
        fc.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        LOG.info("Searching for table : {}", (Object)tableQualifiedName);
        AtlasSearchResult searchResult = this.atlasClientV2.basicSearch("hive_table", fc, null, null, true, 25, 0);
        List entityHeaders = searchResult == null ? null : searchResult.getEntities();
        return entityHeaders;
    }
}

