/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.bridge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.hook.AtlasHookException;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasConfigurationUtil;
import org.apache.atlas.utils.AtlasPathExtractorUtil;
import org.apache.atlas.utils.HdfsNameServiceResolver;
import org.apache.atlas.utils.LruCache;
import org.apache.atlas.utils.PathExtractorContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreBridgeV2 {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreBridgeV2.class);
    private static final String OPTION_DATABASE_SHORT = "d";
    private static final String OPTION_TABLE_SHORT = "t";
    private static final String OPTION_IMPORT_DATA_FILE_SHORT = "f";
    private static final String OPTION_OUTPUT_FILEPATH_SHORT = "o";
    private static final String OPTION_IGNORE_BULK_IMPORT_SHORT = "i";
    public static final String CONF_PREFIX = "atlas.hook.hive.";
    public static final String HDFS_PATH_CONVERT_TO_LOWER_CASE = "atlas.hook.hive.hdfs_path.convert_to_lowercase";
    public static final String HOOK_AWS_S3_ATLAS_MODEL_VERSION = "atlas.hook.hive.aws_s3.atlas.model.version";
    public static final String CLUSTER_NAME_KEY = "atlas.cluster.name";
    public static final String HIVE_USERNAME = "atlas.hook.hive.default.username";
    public static final String HIVE_METADATA_NAMESPACE = "atlas.metadata.namespace";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    public static final String TEMP_TABLE_PREFIX = "_temp-";
    public static final String SEP = ":".intern();
    public static final String DEFAULT_METASTORE_CATALOG = "hive";
    public static final String HOOK_HIVE_PAGE_LIMIT = "atlas.hook.hive.page.limit";
    private static final String HOOK_AWS_S3_ATLAS_MODEL_VERSION_V2 = "v2";
    private static final String ZIP_FILE_COMMENT_FORMAT = "{\"entitiesCount\":%d, \"total\":%d}";
    private static final int DEFAULT_PAGE_LIMIT = 10000;
    private static final String DEFAULT_ZIP_FILE_NAME = "import-hive-output.zip";
    private static final String ZIP_ENTRY_ENTITIES = "entities.json";
    private static final String TYPES_DEF_JSON = "atlas-typesdef.json";
    private static final String JSON_ARRAY_START = "[";
    private static final String JSON_COMMA = ",";
    private static final String JSON_EMPTY_OBJECT = "{}";
    private static final String JSON_ARRAY_END = "]";
    private static int pageLimit = 10000;
    private String awsS3AtlasModelVersion = null;
    private final String metadataNamespace;
    private final Hive hiveClient;
    private final AtlasClientV2 atlasClientV2;
    private final boolean convertHdfsPathToLowerCase;
    private ZipOutputStream zipOutputStream;
    private String outZipFileName;
    private int totalProcessedEntities = 0;
    private final Map<String, AtlasEntity.AtlasEntityWithExtInfo> entityLRUCache = new LruCache(10000, 0);
    private final Map<Table, AtlasEntity> hiveTablesAndAtlasEntity = new HashMap<Table, AtlasEntity>();
    private final Map<String, AtlasEntity> dbEntities = new HashMap<String, AtlasEntity>();
    private final List<Map<String, String>> databaseAndTableListToImport = new ArrayList<Map<String, String>>();
    private final Map<String, String> qualifiedNameGuidMap = new HashMap<String, String>();

    public HiveMetaStoreBridgeV2(Configuration atlasProperties, HiveConf hiveConf, AtlasClientV2 atlasClientV2) throws Exception {
        this.metadataNamespace = this.getMetadataNamespace(atlasProperties);
        this.hiveClient = Hive.get((HiveConf)hiveConf);
        this.atlasClientV2 = atlasClientV2;
        this.convertHdfsPathToLowerCase = atlasProperties.getBoolean(HDFS_PATH_CONVERT_TO_LOWER_CASE, false);
        this.awsS3AtlasModelVersion = atlasProperties.getString(HOOK_AWS_S3_ATLAS_MODEL_VERSION, HOOK_AWS_S3_ATLAS_MODEL_VERSION_V2);
        if (atlasProperties != null) {
            pageLimit = atlasProperties.getInteger(HOOK_HIVE_PAGE_LIMIT, Integer.valueOf(10000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportDataToZipAndRunAtlasImport(CommandLine cmd) throws MissingArgumentException, IOException, HiveException, AtlasBaseException {
        boolean ret = true;
        boolean failOnError = cmd.hasOption("failOnError");
        Object databaseToImport = cmd.getOptionValue(OPTION_DATABASE_SHORT);
        Object tableToImport = cmd.getOptionValue(OPTION_TABLE_SHORT);
        String importDataFile = cmd.getOptionValue(OPTION_IMPORT_DATA_FILE_SHORT);
        String outputFileOrPath = cmd.getOptionValue(OPTION_OUTPUT_FILEPATH_SHORT);
        boolean ignoreBulkImport = cmd.hasOption(OPTION_IGNORE_BULK_IMPORT_SHORT);
        this.validateOutputFileOrPath(outputFileOrPath);
        try {
            this.initializeZipStream();
            if (this.isValidImportDataFile(importDataFile)) {
                File f = new File(importDataFile);
                BufferedReader br = new BufferedReader(new FileReader(f));
                String line = null;
                while ((line = br.readLine()) != null) {
                    Object[] val = line.split(":");
                    if (!ArrayUtils.isNotEmpty((Object[])val)) continue;
                    databaseToImport = val[0];
                    tableToImport = val.length > 1 ? val[1] : "";
                    this.importHiveDatabases((String)databaseToImport, (String)tableToImport, failOnError);
                }
            } else {
                this.importHiveDatabases((String)databaseToImport, (String)tableToImport, failOnError);
            }
            this.importHiveTables(failOnError);
            this.importHiveColumns(failOnError);
        }
        finally {
            this.endWritingAndZipStream();
        }
        if (!ignoreBulkImport) {
            this.runAtlasImport();
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateOutputFileOrPath(String outputFileOrPath) throws MissingArgumentException {
        if (StringUtils.isBlank((String)outputFileOrPath)) {
            throw new MissingArgumentException("Output Path/File can't be empty");
        }
        File fileOrDirToImport = new File(outputFileOrPath);
        if (fileOrDirToImport.exists()) {
            if (!fileOrDirToImport.isDirectory()) throw new MissingArgumentException("output file: " + outputFileOrPath + " already present");
            this.outZipFileName = outputFileOrPath + File.separator + DEFAULT_ZIP_FILE_NAME;
            LOG.info("The default output zip file {} will be created at {}", (Object)DEFAULT_ZIP_FILE_NAME, (Object)outputFileOrPath);
            return;
        } else {
            if (!fileOrDirToImport.getParentFile().isDirectory() || !outputFileOrPath.endsWith(".zip")) throw new MissingArgumentException("Invalid File/Path");
            LOG.info("The mentioned output zip file {} will be created", (Object)outputFileOrPath);
            this.outZipFileName = outputFileOrPath;
        }
    }

    private boolean isValidImportDataFile(String importDataFile) throws MissingArgumentException {
        boolean ret = false;
        if (StringUtils.isNotBlank((String)importDataFile)) {
            File dataFile = new File(importDataFile);
            if (!dataFile.exists() || !dataFile.canRead()) {
                throw new MissingArgumentException("Invalid import data file");
            }
            ret = true;
        }
        return ret;
    }

    private void initializeZipStream() throws IOException, AtlasBaseException {
        this.zipOutputStream = new ZipOutputStream(this.getOutputStream(this.outZipFileName));
        this.storeTypesDefToZip(new AtlasTypesDef());
        this.startWritingEntitiesToZip();
    }

    private void storeTypesDefToZip(AtlasTypesDef typesDef) throws AtlasBaseException {
        String jsonData = AtlasType.toJson((Object)typesDef);
        this.saveToZip(TYPES_DEF_JSON, jsonData);
    }

    private void saveToZip(String fileName, String jsonData) throws AtlasBaseException {
        try {
            ZipEntry e = new ZipEntry(fileName);
            this.zipOutputStream.putNextEntry(e);
            this.writeBytes(jsonData);
            this.zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new AtlasBaseException(String.format("Error writing file %s.", fileName), (Throwable)e);
        }
    }

    private void startWritingEntitiesToZip() throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry(ZIP_ENTRY_ENTITIES));
        this.writeBytes(JSON_ARRAY_START);
    }

    private String getDatabaseToImport(String TableWithDatabase) {
        String ret = null;
        String[] val = TableWithDatabase.split("\\.");
        if (val.length > 1) {
            ret = val[0];
        }
        return ret;
    }

    private String getTableToImport(String TableWithDatabase) {
        String ret = null;
        String[] val = TableWithDatabase.split("\\.");
        if (val.length > 1) {
            ret = val[1];
        }
        return ret;
    }

    private void importHiveDatabases(String databaseToImport, String tableWithDatabaseToImport, boolean failOnError) throws HiveException, AtlasBaseException {
        LOG.info("Importing Hive Databases");
        List databaseNames = null;
        if (StringUtils.isEmpty((String)databaseToImport) && StringUtils.isNotEmpty((String)tableWithDatabaseToImport) && this.isTableWithDatabaseName(tableWithDatabaseToImport)) {
            databaseToImport = this.getDatabaseToImport(tableWithDatabaseToImport);
            tableWithDatabaseToImport = this.getTableToImport(tableWithDatabaseToImport);
        }
        if (!CollectionUtils.isEmpty((Collection)(databaseNames = StringUtils.isEmpty((String)databaseToImport) ? this.hiveClient.getAllDatabases() : this.hiveClient.getDatabasesByPattern(databaseToImport)))) {
            LOG.info("Found {} databases", (Object)databaseNames.size());
            for (String databaseName : databaseNames) {
                try {
                    if (!this.dbEntities.containsKey(databaseName)) {
                        LOG.info("Importing Hive Database {}", (Object)databaseName);
                        AtlasEntity.AtlasEntityWithExtInfo dbEntity = this.writeDatabase(databaseName);
                        if (dbEntity != null) {
                            this.dbEntities.put(databaseName, dbEntity.getEntity());
                        }
                    }
                    this.databaseAndTableListToImport.add(Collections.singletonMap(databaseName, tableWithDatabaseToImport));
                }
                catch (IOException e) {
                    LOG.error("Import failed for hive database {}", (Object)databaseName, (Object)e);
                    if (!failOnError) continue;
                    throw new AtlasBaseException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            LOG.error("No database found");
            if (failOnError) {
                throw new AtlasBaseException("No database found");
            }
        }
    }

    private void writeEntity(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws IOException {
        if (MapUtils.isNotEmpty((Map)entityWithExtInfo.getReferredEntities())) {
            Iterator itr = entityWithExtInfo.getReferredEntities().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry eachEntity = itr.next();
                if (!((AtlasEntity)eachEntity.getValue()).getTypeName().equalsIgnoreCase(HiveDataTypes.HIVE_DB.getName())) continue;
                itr.remove();
            }
        }
        if (!this.entityLRUCache.containsKey(entityWithExtInfo.getEntity().getGuid())) {
            this.entityLRUCache.put(entityWithExtInfo.getEntity().getGuid(), entityWithExtInfo);
            this.writeBytes(AtlasType.toJson((Object)entityWithExtInfo) + JSON_COMMA);
        }
        ++this.totalProcessedEntities;
    }

    private void endWritingAndZipStream() throws IOException {
        this.writeBytes(JSON_EMPTY_OBJECT);
        this.writeBytes(JSON_ARRAY_END);
        this.setStreamSize(this.totalProcessedEntities);
        this.close();
    }

    private void flush() {
        try {
            this.zipOutputStream.flush();
        }
        catch (IOException e) {
            LOG.error("Error: Flush: ", (Throwable)e);
        }
    }

    private void close() throws IOException {
        this.zipOutputStream.flush();
        this.zipOutputStream.closeEntry();
        this.zipOutputStream.close();
    }

    private void writeBytes(String payload) throws IOException {
        this.zipOutputStream.write(payload.getBytes());
    }

    private OutputStream getOutputStream(String fileToWrite) throws IOException {
        return FileUtils.openOutputStream((File)new File(fileToWrite));
    }

    public String getMetadataNamespace(Configuration config) {
        return AtlasConfigurationUtil.getRecentString((Configuration)config, (String)HIVE_METADATA_NAMESPACE, (String)this.getClusterName(config));
    }

    private String getClusterName(Configuration config) {
        return config.getString(CLUSTER_NAME_KEY, DEFAULT_CLUSTER_NAME);
    }

    public String getMetadataNamespace() {
        return this.metadataNamespace;
    }

    public boolean isConvertHdfsPathToLowerCase() {
        return this.convertHdfsPathToLowerCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importHiveTables(boolean failOnError) throws HiveException, AtlasBaseException {
        LOG.info("Importing Hive Tables");
        int totalTablesImported = 0;
        if (CollectionUtils.isNotEmpty(this.databaseAndTableListToImport) && MapUtils.isNotEmpty(this.dbEntities)) {
            for (Map<String, String> eachEntry : this.databaseAndTableListToImport) {
                ArrayList<Table> tableObjects;
                String databaseName = eachEntry.keySet().iterator().next();
                if (StringUtils.isEmpty((String)eachEntry.values().iterator().next())) {
                    tableObjects = this.hiveClient.getAllTableObjects(databaseName);
                    this.populateQualifiedNameGuidMap(HiveDataTypes.HIVE_DB.getName(), (String)this.dbEntities.get(databaseName).getAttribute("qualifiedName"));
                } else {
                    List tableNames = this.hiveClient.getTablesByPattern(databaseName, eachEntry.values().iterator().next());
                    tableObjects = new ArrayList<Table>();
                    for (String tableName : tableNames) {
                        Table table = this.hiveClient.getTable(databaseName, tableName);
                        tableObjects.add(table);
                        this.populateQualifiedNameGuidMap(HiveDataTypes.HIVE_TABLE.getName(), HiveMetaStoreBridgeV2.getTableQualifiedName(this.metadataNamespace, table));
                    }
                }
                if (!CollectionUtils.isEmpty(tableObjects)) {
                    int importedInOneRun;
                    block11: {
                        LOG.info("Found {} tables to import in database {}", (Object)tableObjects.size(), (Object)databaseName);
                        importedInOneRun = 0;
                        try {
                            for (Table table : tableObjects) {
                                int imported = this.importTable(this.dbEntities.get(databaseName), table, failOnError);
                                totalTablesImported += imported;
                                importedInOneRun += imported;
                            }
                            if (importedInOneRun != tableObjects.size()) break block11;
                        }
                        catch (Throwable throwable) {
                            if (importedInOneRun == tableObjects.size()) {
                                LOG.info("Successfully imported {} tables from database {}", (Object)importedInOneRun, (Object)databaseName);
                                LOG.info("Successfully total {} tables imported", (Object)totalTablesImported);
                            } else {
                                LOG.error("Imported {} of {} tables from database {}. Please check logs for errors during import", new Object[]{importedInOneRun, tableObjects.size(), databaseName});
                            }
                            throw throwable;
                        }
                        LOG.info("Successfully imported {} tables from database {}", (Object)importedInOneRun, (Object)databaseName);
                        LOG.info("Successfully total {} tables imported", (Object)totalTablesImported);
                        continue;
                    }
                    LOG.error("Imported {} of {} tables from database {}. Please check logs for errors during import", new Object[]{importedInOneRun, tableObjects.size(), databaseName});
                    continue;
                }
                LOG.error("No tables to import in database {}", (Object)databaseName);
                if (!failOnError) continue;
                throw new AtlasBaseException("No tables to import in database - " + databaseName);
            }
        }
        this.dbEntities.clear();
    }

    private void populateQualifiedNameGuidMap(String typeName, String qualifiedName) {
        try {
            AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = this.atlasClientV2.getEntitiesByAttribute(typeName, Collections.singletonList(Collections.singletonMap("qualifiedName", qualifiedName)), true, false);
            if (entitiesWithExtInfo != null && entitiesWithExtInfo.getEntities() != null) {
                for (AtlasEntity entity : entitiesWithExtInfo.getEntities()) {
                    this.qualifiedNameGuidMap.put((String)entity.getAttribute("qualifiedName"), entity.getGuid());
                    for (Map.Entry eachEntry : entitiesWithExtInfo.getReferredEntities().entrySet()) {
                        this.qualifiedNameGuidMap.put((String)((AtlasEntity)eachEntry.getValue()).getAttribute("qualifiedName"), (String)eachEntry.getKey());
                    }
                    if (!typeName.equals(HiveDataTypes.HIVE_DB.getName())) continue;
                    for (String eachRelatedGuid : this.getAllRelatedGuids(entity)) {
                        AtlasEntity.AtlasEntityWithExtInfo relatedEntity = this.atlasClientV2.getEntityByGuid(eachRelatedGuid, true, false);
                        this.qualifiedNameGuidMap.put((String)relatedEntity.getEntity().getAttribute("qualifiedName"), relatedEntity.getEntity().getGuid());
                        for (Map.Entry eachEntry : relatedEntity.getReferredEntities().entrySet()) {
                            this.qualifiedNameGuidMap.put((String)((AtlasEntity)eachEntry.getValue()).getAttribute("qualifiedName"), (String)eachEntry.getKey());
                        }
                    }
                }
            }
        }
        catch (AtlasServiceException e) {
            LOG.info("Unable to load the related entities for type {} and qualified name {} from Atlas", new Object[]{typeName, qualifiedName, e});
        }
    }

    private Set<String> getAllRelatedGuids(AtlasEntity entity) {
        HashSet<String> relGuidsSet = new HashSet<String>();
        for (Object o : entity.getRelationshipAttributes().values()) {
            if (o instanceof AtlasObjectId) {
                relGuidsSet.add(((AtlasObjectId)o).getGuid());
                continue;
            }
            if (!(o instanceof List)) continue;
            for (Object id : (List)o) {
                if (id instanceof AtlasObjectId) {
                    relGuidsSet.add(((AtlasObjectId)id).getGuid());
                }
                if (!(id instanceof Map)) continue;
                relGuidsSet.add((String)((Map)id).get("guid"));
            }
        }
        return relGuidsSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importHiveColumns(boolean failOnError) throws AtlasBaseException {
        LOG.info("Importing Hive Columns");
        if (MapUtils.isEmpty(this.hiveTablesAndAtlasEntity)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No hive table present to import columns");
            }
            return;
        }
        for (Map.Entry<Table, AtlasEntity> eachTable : this.hiveTablesAndAtlasEntity.entrySet()) {
            ArrayList columnEntities;
            int columnsImported;
            block11: {
                columnsImported = 0;
                columnEntities = new ArrayList();
                try {
                    List<AtlasEntity> partKeys = this.toColumns(eachTable.getKey().getPartitionKeys(), eachTable.getValue(), "hive_table_partitionkeys");
                    List<AtlasEntity> columns = this.toColumns(eachTable.getKey().getCols(), eachTable.getValue(), "hive_table_columns");
                    partKeys.stream().collect(Collectors.toCollection(() -> columnEntities));
                    columns.stream().collect(Collectors.toCollection(() -> columnEntities));
                    for (AtlasEntity eachColumnEntity : columnEntities) {
                        this.writeEntityToZip(new AtlasEntity.AtlasEntityWithExtInfo(eachColumnEntity));
                        ++columnsImported;
                    }
                    if (columnsImported != columnEntities.size()) break block11;
                }
                catch (IOException e) {
                    block12: {
                        try {
                            LOG.error("Column Import failed for hive table {}", eachTable.getValue().getAttribute("qualifiedName"), (Object)e);
                            if (failOnError) {
                                throw new AtlasBaseException(e.getMessage(), (Throwable)e);
                            }
                            if (columnsImported != columnEntities.size()) break block12;
                        }
                        catch (Throwable throwable) {
                            if (columnsImported == columnEntities.size()) {
                                LOG.info("Successfully imported {} columns for table {}", (Object)columnsImported, eachTable.getValue().getAttribute("qualifiedName"));
                            } else {
                                LOG.error("Imported {} of {} columns for table {}. Please check logs for errors during import", new Object[]{columnsImported, columnEntities.size(), eachTable.getValue().getAttribute("qualifiedName")});
                            }
                            throw throwable;
                        }
                        LOG.info("Successfully imported {} columns for table {}", (Object)columnsImported, eachTable.getValue().getAttribute("qualifiedName"));
                        continue;
                    }
                    LOG.error("Imported {} of {} columns for table {}. Please check logs for errors during import", new Object[]{columnsImported, columnEntities.size(), eachTable.getValue().getAttribute("qualifiedName")});
                    continue;
                }
                LOG.info("Successfully imported {} columns for table {}", (Object)columnsImported, eachTable.getValue().getAttribute("qualifiedName"));
                continue;
            }
            LOG.error("Imported {} of {} columns for table {}. Please check logs for errors during import", new Object[]{columnsImported, columnEntities.size(), eachTable.getValue().getAttribute("qualifiedName")});
        }
    }

    private void runAtlasImport() {
        AtlasImportRequest request = new AtlasImportRequest();
        request.setOption("updateTypeDefinition", "false");
        request.setOption("format", "zipDirect");
        try {
            AtlasImportResult importResult = this.atlasClientV2.importData(request, this.outZipFileName);
            if (importResult.getOperationStatus() == AtlasImportResult.OperationStatus.SUCCESS) {
                LOG.info("Successfully imported the zip file {} at Atlas and imported {} entities. Number of entities to be imported {}.", new Object[]{this.outZipFileName, importResult.getProcessedEntities().size(), this.totalProcessedEntities});
            } else {
                LOG.error("Failed to import or get the status of import for the zip file {} at Atlas. Number of entities to be imported {}.", (Object)this.outZipFileName, (Object)this.totalProcessedEntities);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get the status or import the zip file {} at Atlas. Number of entities to be imported {}.", new Object[]{this.outZipFileName, this.totalProcessedEntities, e});
            LOG.info("Please check Atlas for the import status of the zip file {}.", (Object)this.outZipFileName);
        }
    }

    public int importTable(AtlasEntity dbEntity, Table table, boolean failOnError) throws AtlasBaseException {
        try {
            AtlasEntity.AtlasEntityWithExtInfo tableEntity = this.writeTable(dbEntity, table);
            this.hiveTablesAndAtlasEntity.put(table, tableEntity.getEntity());
            if (table.getTableType() == TableType.EXTERNAL_TABLE) {
                String processQualifiedName = HiveMetaStoreBridgeV2.getTableProcessQualifiedName(this.metadataNamespace, table);
                String tableLocationString = this.isConvertHdfsPathToLowerCase() ? this.lower(table.getDataLocation().toString()) : table.getDataLocation().toString();
                Path location = table.getDataLocation();
                String query = this.getCreateTableString(table, tableLocationString);
                PathExtractorContext pathExtractorCtx = new PathExtractorContext(this.getMetadataNamespace(), this.isConvertHdfsPathToLowerCase(), this.awsS3AtlasModelVersion);
                AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)location, (PathExtractorContext)pathExtractorCtx);
                AtlasEntity pathInst = entityWithExtInfo.getEntity();
                AtlasEntity tableInst = tableEntity.getEntity();
                AtlasEntity processInst = new AtlasEntity(HiveDataTypes.HIVE_PROCESS.getName());
                long now = System.currentTimeMillis();
                processInst.setGuid(this.getGuid(processQualifiedName));
                processInst.setAttribute("qualifiedName", (Object)processQualifiedName);
                processInst.setAttribute("name", (Object)query);
                processInst.setAttribute("clusterName", (Object)this.metadataNamespace);
                processInst.setRelationshipAttribute("inputs", Collections.singletonList(AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)pathInst, (String)"dataset_process_inputs")));
                processInst.setRelationshipAttribute("outputs", Collections.singletonList(AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)tableInst, (String)"process_dataset_outputs")));
                String userName = table.getOwner();
                if (StringUtils.isEmpty((String)userName)) {
                    userName = ApplicationProperties.get().getString(HIVE_USERNAME, DEFAULT_METASTORE_CATALOG);
                }
                processInst.setAttribute("userName", (Object)userName);
                processInst.setAttribute("startTime", (Object)now);
                processInst.setAttribute("endTime", (Object)now);
                processInst.setAttribute("operationType", (Object)"CREATETABLE");
                processInst.setAttribute("queryText", (Object)query);
                processInst.setAttribute("queryId", (Object)query);
                processInst.setAttribute("queryPlan", (Object)JSON_EMPTY_OBJECT);
                processInst.setAttribute("recentQueries", Collections.singletonList(query));
                AtlasEntity.AtlasEntitiesWithExtInfo createTableProcess = new AtlasEntity.AtlasEntitiesWithExtInfo();
                createTableProcess.addEntity(processInst);
                if (pathExtractorCtx.getKnownEntities() != null) {
                    pathExtractorCtx.getKnownEntities().values().forEach(entity -> createTableProcess.addEntity(entity));
                } else {
                    createTableProcess.addEntity(pathInst);
                }
                this.writeEntitiesToZip(createTableProcess);
            }
            return 1;
        }
        catch (Exception e) {
            LOG.error("Import failed for hive_table {}", (Object)table.getTableName(), (Object)e);
            if (failOnError) {
                throw new AtlasBaseException(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
    }

    private AtlasEntity.AtlasEntityWithExtInfo writeDatabase(String databaseName) throws HiveException, IOException {
        AtlasEntity.AtlasEntityWithExtInfo ret = null;
        Database db = this.hiveClient.getDatabase(databaseName);
        if (db != null) {
            ret = new AtlasEntity.AtlasEntityWithExtInfo(this.toDbEntity(db));
            this.writeEntityToZip(ret);
        }
        return ret;
    }

    private AtlasEntity.AtlasEntityWithExtInfo writeTable(AtlasEntity dbEntity, Table table) throws AtlasHookException {
        try {
            AtlasEntity.AtlasEntityWithExtInfo tableEntity = this.toTableEntity(dbEntity, table);
            this.writeEntityToZip(tableEntity);
            return tableEntity;
        }
        catch (Exception e) {
            throw new AtlasHookException("HiveMetaStoreBridgeV2.registerTable() failed.", (Throwable)e);
        }
    }

    private void writeEntityToZip(AtlasEntity.AtlasEntityWithExtInfo entity) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} entity: {}", (Object)entity.getEntity().getTypeName(), (Object)entity);
        }
        this.writeEntity(entity);
        this.clearRelationshipAttributes(entity.getEntity());
        this.flush();
    }

    private void writeEntitiesToZip(AtlasEntity.AtlasEntitiesWithExtInfo entities) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} entities: {}", (Object)entities.getEntities().size(), (Object)entities);
        }
        for (AtlasEntity entity : entities.getEntities()) {
            this.writeEntity(new AtlasEntity.AtlasEntityWithExtInfo(entity));
        }
        this.flush();
        this.clearRelationshipAttributes(entities);
    }

    private AtlasEntity toDbEntity(Database hiveDB) {
        return this.toDbEntity(hiveDB, null);
    }

    private AtlasEntity toDbEntity(Database hiveDB, AtlasEntity dbEntity) {
        if (dbEntity == null) {
            dbEntity = new AtlasEntity(HiveDataTypes.HIVE_DB.getName());
        }
        String dbName = HiveMetaStoreBridgeV2.getDatabaseName(hiveDB);
        String qualifiedName = HiveMetaStoreBridgeV2.getDBQualifiedName(this.metadataNamespace, dbName);
        dbEntity.setAttribute("qualifiedName", (Object)qualifiedName);
        dbEntity.setGuid(this.getGuid(true, qualifiedName));
        dbEntity.setAttribute("name", (Object)dbName);
        dbEntity.setAttribute("description", (Object)hiveDB.getDescription());
        dbEntity.setAttribute("owner", (Object)hiveDB.getOwnerName());
        dbEntity.setAttribute("clusterName", (Object)this.metadataNamespace);
        dbEntity.setAttribute("location", (Object)HdfsNameServiceResolver.getPathWithNameServiceID((String)hiveDB.getLocationUri()));
        dbEntity.setAttribute("parameters", (Object)hiveDB.getParameters());
        if (hiveDB.getOwnerType() != null) {
            dbEntity.setAttribute("ownerType", (Object)BaseHiveEvent.OWNER_TYPE_TO_ENUM_VALUE.get(hiveDB.getOwnerType().getValue()));
        }
        return dbEntity;
    }

    private String getDBGuidFromAtlas(String dBQualifiedName) {
        String guid = null;
        try {
            guid = this.atlasClientV2.getEntityHeaderByAttribute(HiveDataTypes.HIVE_DB.getName(), Collections.singletonMap("qualifiedName", dBQualifiedName)).getGuid();
        }
        catch (AtlasServiceException e) {
            LOG.warn("Failed to get DB guid from Atlas with qualified name {}", (Object)dBQualifiedName, (Object)e);
        }
        return guid;
    }

    public static String getDatabaseName(Database hiveDB) {
        String catalogName;
        String dbName = hiveDB.getName().toLowerCase();
        String string = catalogName = hiveDB.getCatalogName() != null ? hiveDB.getCatalogName().toLowerCase() : null;
        if (StringUtils.isNotEmpty((String)catalogName) && !StringUtils.equals((String)catalogName, (String)DEFAULT_METASTORE_CATALOG)) {
            dbName = catalogName + SEP + dbName;
        }
        return dbName;
    }

    private AtlasEntity.AtlasEntityWithExtInfo toTableEntity(AtlasEntity database, Table hiveTable) throws AtlasHookException {
        AtlasEntity.AtlasEntityWithExtInfo table = new AtlasEntity.AtlasEntityWithExtInfo(new AtlasEntity(HiveDataTypes.HIVE_TABLE.getName()));
        AtlasEntity tableEntity = table.getEntity();
        String tableQualifiedName = HiveMetaStoreBridgeV2.getTableQualifiedName(this.metadataNamespace, hiveTable);
        long createTime = BaseHiveEvent.getTableCreateTime(hiveTable);
        long lastAccessTime = hiveTable.getLastAccessTime() > 0 ? (long)hiveTable.getLastAccessTime() : createTime;
        tableEntity.setGuid(this.getGuid(tableQualifiedName));
        tableEntity.setRelationshipAttribute("db", (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)database, (String)"hive_table_db"));
        tableEntity.setAttribute("qualifiedName", (Object)tableQualifiedName);
        tableEntity.setAttribute("name", (Object)hiveTable.getTableName().toLowerCase());
        tableEntity.setAttribute("owner", (Object)hiveTable.getOwner());
        tableEntity.setAttribute("createTime", (Object)createTime);
        tableEntity.setAttribute("lastAccessTime", (Object)lastAccessTime);
        tableEntity.setAttribute("retention", (Object)hiveTable.getRetention());
        tableEntity.setAttribute("parameters", (Object)hiveTable.getParameters());
        tableEntity.setAttribute("comment", hiveTable.getParameters().get("comment"));
        tableEntity.setAttribute("tableType", (Object)hiveTable.getTableType().name());
        tableEntity.setAttribute("temporary", (Object)hiveTable.isTemporary());
        if (hiveTable.getViewOriginalText() != null) {
            tableEntity.setAttribute("viewOriginalText", (Object)hiveTable.getViewOriginalText());
        }
        if (hiveTable.getViewExpandedText() != null) {
            tableEntity.setAttribute("viewExpandedText", (Object)hiveTable.getViewExpandedText());
        }
        AtlasEntity sdEntity = this.toStorageDescEntity(hiveTable.getSd(), HiveMetaStoreBridgeV2.getStorageDescQFName(tableQualifiedName), AtlasTypeUtil.getObjectId((AtlasEntity)tableEntity));
        tableEntity.setRelationshipAttribute("sd", (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)sdEntity, (String)"hive_table_storagedesc"));
        table.addReferredEntity(database);
        table.addReferredEntity(sdEntity);
        table.setEntity(tableEntity);
        return table;
    }

    private AtlasEntity toStorageDescEntity(StorageDescriptor storageDesc, String sdQualifiedName, AtlasObjectId tableId) {
        AtlasEntity ret = new AtlasEntity(HiveDataTypes.HIVE_STORAGEDESC.getName());
        ret.setGuid(this.getGuid(sdQualifiedName));
        ret.setRelationshipAttribute("table", (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasObjectId)tableId, (String)"hive_table_storagedesc"));
        ret.setAttribute("qualifiedName", (Object)sdQualifiedName);
        ret.setAttribute("parameters", (Object)storageDesc.getParameters());
        ret.setAttribute("location", (Object)HdfsNameServiceResolver.getPathWithNameServiceID((String)storageDesc.getLocation()));
        ret.setAttribute("inputFormat", (Object)storageDesc.getInputFormat());
        ret.setAttribute("outputFormat", (Object)storageDesc.getOutputFormat());
        ret.setAttribute("compressed", (Object)storageDesc.isCompressed());
        ret.setAttribute("numBuckets", (Object)storageDesc.getNumBuckets());
        ret.setAttribute("storedAsSubDirectories", (Object)storageDesc.isStoredAsSubDirectories());
        if (storageDesc.getBucketCols().size() > 0) {
            ret.setAttribute("bucketCols", (Object)storageDesc.getBucketCols());
        }
        if (storageDesc.getSerdeInfo() != null) {
            SerDeInfo serdeInfo = storageDesc.getSerdeInfo();
            LOG.info("serdeInfo = {}", (Object)serdeInfo);
            AtlasStruct serdeInfoStruct = new AtlasStruct(HiveDataTypes.HIVE_SERDE.getName());
            serdeInfoStruct.setAttribute("name", (Object)serdeInfo.getName());
            serdeInfoStruct.setAttribute("serializationLib", (Object)serdeInfo.getSerializationLib());
            serdeInfoStruct.setAttribute("parameters", (Object)serdeInfo.getParameters());
            ret.setAttribute("serdeInfo", (Object)serdeInfoStruct);
        }
        if (CollectionUtils.isNotEmpty((Collection)storageDesc.getSortCols())) {
            ArrayList<AtlasStruct> sortColsStruct = new ArrayList<AtlasStruct>();
            for (Order sortcol : storageDesc.getSortCols()) {
                String hiveOrderName = HiveDataTypes.HIVE_ORDER.getName();
                AtlasStruct colStruct = new AtlasStruct(hiveOrderName);
                colStruct.setAttribute("col", (Object)sortcol.getCol());
                colStruct.setAttribute("order", (Object)sortcol.getOrder());
                sortColsStruct.add(colStruct);
            }
            ret.setAttribute("sortCols", sortColsStruct);
        }
        return ret;
    }

    private List<AtlasEntity> toColumns(List<FieldSchema> schemaList, AtlasEntity table, String relationshipType) {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        int columnPosition = 0;
        for (FieldSchema fs : schemaList) {
            LOG.debug("Processing field {}", (Object)fs);
            AtlasEntity column = new AtlasEntity(HiveDataTypes.HIVE_COLUMN.getName());
            String columnQualifiedName = HiveMetaStoreBridgeV2.getColumnQualifiedName((String)table.getAttribute("qualifiedName"), fs.getName());
            column.setAttribute("qualifiedName", (Object)columnQualifiedName);
            column.setGuid(this.getGuid(columnQualifiedName));
            column.setRelationshipAttribute("table", (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)table, (String)relationshipType));
            column.setAttribute("name", (Object)fs.getName());
            column.setAttribute("owner", table.getAttribute("owner"));
            column.setAttribute("type", (Object)fs.getType());
            column.setAttribute("position", (Object)columnPosition++);
            column.setAttribute("comment", (Object)fs.getComment());
            ret.add(column);
        }
        return ret;
    }

    private String getCreateTableString(Table table, String location) {
        String colString = "";
        List colList = table.getAllCols();
        if (colList != null) {
            for (FieldSchema col : colList) {
                colString = colString + col.getName() + " " + col.getType() + JSON_COMMA;
            }
            if (colList.size() > 0) {
                colString = colString.substring(0, colString.length() - 1);
                colString = "(" + colString + ")";
            }
        }
        String query = "create external table " + table.getTableName() + colString + " location '" + location + "'";
        return query;
    }

    private String lower(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        return str.toLowerCase().trim();
    }

    private static String getTableQualifiedName(String metadataNamespace, Table table) {
        return HiveMetaStoreBridgeV2.getTableQualifiedName(metadataNamespace, table.getDbName(), table.getTableName(), table.isTemporary());
    }

    public static String getDBQualifiedName(String metadataNamespace, String dbName) {
        return String.format("%s@%s", dbName.toLowerCase(), metadataNamespace);
    }

    public static String getTableQualifiedName(String metadataNamespace, String dbName, String tableName, boolean isTemporaryTable) {
        String tableTempName = tableName;
        if (isTemporaryTable) {
            tableTempName = SessionState.get() != null && SessionState.get().getSessionId() != null ? tableName + TEMP_TABLE_PREFIX + SessionState.get().getSessionId() : tableName + TEMP_TABLE_PREFIX + RandomStringUtils.random((int)10);
        }
        return String.format("%s.%s@%s", dbName.toLowerCase(), tableTempName.toLowerCase(), metadataNamespace);
    }

    public static String getTableProcessQualifiedName(String metadataNamespace, Table table) {
        String tableQualifiedName = HiveMetaStoreBridgeV2.getTableQualifiedName(metadataNamespace, table);
        long createdTime = HiveMetaStoreBridgeV2.getTableCreatedTime(table);
        return tableQualifiedName + SEP + createdTime;
    }

    public static String getStorageDescQFName(String tableQualifiedName) {
        return tableQualifiedName + "_storage";
    }

    public static String getColumnQualifiedName(String tableQualifiedName, String colName) {
        String[] parts = tableQualifiedName.split("@");
        String tableName = parts[0];
        String metadataNamespace = parts[1];
        return String.format("%s.%s@%s", tableName, colName.toLowerCase(), metadataNamespace);
    }

    public static long getTableCreatedTime(Table table) {
        return (long)table.getTTable().getCreateTime() * 1000L;
    }

    private void clearRelationshipAttributes(AtlasEntity.AtlasEntitiesWithExtInfo entities) {
        if (entities != null) {
            if (entities.getEntities() != null) {
                for (AtlasEntity entity : entities.getEntities()) {
                    this.clearRelationshipAttributes(entity);
                }
            }
            if (entities.getReferredEntities() != null) {
                this.clearRelationshipAttributes(entities.getReferredEntities().values());
            }
        }
    }

    private void clearRelationshipAttributes(Collection<AtlasEntity> entities) {
        if (entities != null) {
            for (AtlasEntity entity : entities) {
                this.clearRelationshipAttributes(entity);
            }
        }
    }

    private void clearRelationshipAttributes(AtlasEntity entity) {
        if (entity != null && entity.getRelationshipAttributes() != null) {
            entity.getRelationshipAttributes().clear();
        }
    }

    private boolean isTableWithDatabaseName(String tableName) {
        boolean ret = false;
        if (tableName.contains(".")) {
            ret = true;
        }
        return ret;
    }

    private String getGuid(String qualifiedName) {
        return this.getGuid(false, qualifiedName);
    }

    private String getGuid(boolean isDBType, String qualifiedName) {
        String guid = null;
        if (this.qualifiedNameGuidMap.containsKey(qualifiedName)) {
            guid = this.qualifiedNameGuidMap.get(qualifiedName);
        } else if (isDBType) {
            guid = this.getDBGuidFromAtlas(qualifiedName);
        }
        if (StringUtils.isBlank(guid)) {
            guid = this.generateGuid();
        }
        return guid;
    }

    private String generateGuid() {
        return UUID.randomUUID().toString();
    }

    public void setStreamSize(long size) {
        this.zipOutputStream.setComment(String.format(ZIP_FILE_COMMENT_FORMAT, size, -1));
    }
}

