/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridge;
import org.apache.atlas.hive.hook.HiveHook;
import org.apache.atlas.hive.hook.HiveMetastoreHookImpl;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public class AtlasHiveHookContext {
    public static final char QNAME_SEP_METADATA_NAMESPACE = '@';
    public static final char QNAME_SEP_ENTITY_NAME = '.';
    public static final char QNAME_SEP_PROCESS = ':';
    public static final String TEMP_TABLE_PREFIX = "_temp-";
    public static final String CREATE_OPERATION = "CREATE";
    public static final String ALTER_OPERATION = "ALTER";
    private final HiveHook hook;
    private final HiveOperation hiveOperation;
    private final HookContext hiveContext;
    private final Hive hive;
    private final Map<String, AtlasEntity> qNameEntityMap = new HashMap<String, AtlasEntity>();
    private final HiveHook.HiveHookObjectNamesCache knownObjects;
    private final HiveMetastoreHookImpl.HiveMetastoreHook metastoreHook;
    private final ListenerEvent metastoreEvent;
    private final IHMSHandler metastoreHandler;
    private boolean isSkippedInputEntity;
    private boolean isSkippedOutputEntity;
    private boolean skipTempTables;

    public AtlasHiveHookContext(HiveHook hook, HiveOperation hiveOperation, HookContext hiveContext, HiveHook.HiveHookObjectNamesCache knownObjects, boolean skipTempTables) throws Exception {
        this(hook, hiveOperation, hiveContext, knownObjects, null, null, skipTempTables);
    }

    public AtlasHiveHookContext(HiveHook hook, HiveOperation hiveOperation, HiveHook.HiveHookObjectNamesCache knownObjects, HiveMetastoreHookImpl.HiveMetastoreHook metastoreHook, ListenerEvent listenerEvent, boolean skipTempTables) throws Exception {
        this(hook, hiveOperation, null, knownObjects, metastoreHook, listenerEvent, skipTempTables);
    }

    public AtlasHiveHookContext(HiveHook hook, HiveOperation hiveOperation, HookContext hiveContext, HiveHook.HiveHookObjectNamesCache knownObjects, HiveMetastoreHookImpl.HiveMetastoreHook metastoreHook, ListenerEvent listenerEvent, boolean skipTempTables) throws Exception {
        this.hook = hook;
        this.hiveOperation = hiveOperation;
        this.hiveContext = hiveContext;
        this.hive = hiveContext != null ? Hive.get((HiveConf)hiveContext.getConf()) : null;
        this.knownObjects = knownObjects;
        this.metastoreHook = metastoreHook;
        this.metastoreEvent = listenerEvent;
        this.metastoreHandler = listenerEvent != null ? this.metastoreEvent.getIHMSHandler() : null;
        this.skipTempTables = skipTempTables;
        this.init();
    }

    public boolean isMetastoreHook() {
        return this.metastoreHook != null;
    }

    public ListenerEvent getMetastoreEvent() {
        return this.metastoreEvent;
    }

    public IHMSHandler getMetastoreHandler() {
        return this.metastoreHandler;
    }

    public Set<ReadEntity> getInputs() {
        return this.hiveContext != null ? this.hiveContext.getInputs() : Collections.emptySet();
    }

    public Set<WriteEntity> getOutputs() {
        return this.hiveContext != null ? this.hiveContext.getOutputs() : Collections.emptySet();
    }

    public boolean isSkippedInputEntity() {
        return this.isSkippedInputEntity;
    }

    public boolean isSkippedOutputEntity() {
        return this.isSkippedOutputEntity;
    }

    public void registerSkippedEntity(Entity entity) {
        if (entity instanceof ReadEntity) {
            this.registerSkippedInputEntity();
        } else if (entity instanceof WriteEntity) {
            this.registerSkippedOutputEntity();
        }
    }

    public void registerSkippedInputEntity() {
        if (!this.isSkippedInputEntity) {
            this.isSkippedInputEntity = true;
        }
    }

    public void registerSkippedOutputEntity() {
        if (!this.isSkippedOutputEntity) {
            this.isSkippedOutputEntity = true;
        }
    }

    public boolean isSkipTempTables() {
        return this.skipTempTables;
    }

    public LineageInfo getLineageInfo() {
        return this.hiveContext != null ? this.hiveContext.getLinfo() : null;
    }

    public HookContext getHiveContext() {
        return this.hiveContext;
    }

    public Hive getHive() {
        return this.hive;
    }

    public HiveOperation getHiveOperation() {
        return this.hiveOperation;
    }

    public void putEntity(String qualifiedName, AtlasEntity entity) {
        this.qNameEntityMap.put(qualifiedName, entity);
    }

    public AtlasEntity getEntity(String qualifiedName) {
        return this.qNameEntityMap.get(qualifiedName);
    }

    public Collection<AtlasEntity> getEntities() {
        return this.qNameEntityMap.values();
    }

    public Map<String, AtlasEntity> getQNameToEntityMap() {
        return this.qNameEntityMap;
    }

    public String getMetadataNamespace() {
        return this.hook.getMetadataNamespace();
    }

    public String getHostName() {
        return this.hook.getHostName();
    }

    public boolean isConvertHdfsPathToLowerCase() {
        return this.hook.isConvertHdfsPathToLowerCase();
    }

    public String getAwsS3AtlasModelVersion() {
        return this.hook.getAwsS3AtlasModelVersion();
    }

    public boolean getSkipHiveColumnLineageHive20633() {
        return this.hook.getSkipHiveColumnLineageHive20633();
    }

    public int getSkipHiveColumnLineageHive20633InputsThreshold() {
        return this.hook.getSkipHiveColumnLineageHive20633InputsThreshold();
    }

    public HiveHook.PreprocessAction getPreprocessActionForHiveTable(String qualifiedName) {
        return this.hook.getPreprocessActionForHiveTable(qualifiedName);
    }

    public List getIgnoreDummyDatabaseName() {
        return this.hook.getIgnoreDummyDatabaseName();
    }

    public List getIgnoreDummyTableName() {
        return this.hook.getIgnoreDummyTableName();
    }

    public String getIgnoreValuesTmpTableNamePrefix() {
        return this.hook.getIgnoreValuesTmpTableNamePrefix();
    }

    public String getQualifiedName(Database db) {
        return HiveMetaStoreBridge.getDatabaseName(db) + '@' + this.getMetadataNamespace();
    }

    public String getQualifiedName(Table table) {
        String tableName = table.getTableName();
        if (table.isTemporary()) {
            tableName = SessionState.get() != null && SessionState.get().getSessionId() != null ? tableName + TEMP_TABLE_PREFIX + SessionState.get().getSessionId() : tableName + TEMP_TABLE_PREFIX + RandomStringUtils.random((int)10);
        }
        return (table.getDbName() + '.' + tableName + '@').toLowerCase() + this.getMetadataNamespace();
    }

    public boolean isKnownDatabase(String dbQualifiedName) {
        return this.knownObjects != null && dbQualifiedName != null ? this.knownObjects.isKnownDatabase(dbQualifiedName) : false;
    }

    public boolean isKnownTable(String tblQualifiedName) {
        return this.knownObjects != null && tblQualifiedName != null ? this.knownObjects.isKnownTable(tblQualifiedName) : false;
    }

    public void addToKnownEntities(Collection<AtlasEntity> entities) {
        if (this.knownObjects != null && entities != null) {
            this.knownObjects.addToKnownEntities(entities);
        }
    }

    public void removeFromKnownDatabase(String dbQualifiedName) {
        if (this.knownObjects != null && dbQualifiedName != null) {
            this.knownObjects.removeFromKnownDatabase(dbQualifiedName);
        }
    }

    public void removeFromKnownTable(String tblQualifiedName) {
        if (this.knownObjects != null && tblQualifiedName != null) {
            this.knownObjects.removeFromKnownTable(tblQualifiedName);
        }
    }

    public boolean isHiveProcessPopulateDeprecatedAttributes() {
        return this.hook.isHiveProcessPopulateDeprecatedAttributes();
    }

    private void init() {
        if (this.hiveOperation == null) {
            return;
        }
        String operation = this.hiveOperation.getOperationName();
        if (this.knownObjects == null || !AtlasHiveHookContext.isCreateAlterOperation(operation)) {
            return;
        }
        ArrayList<Database> databases = new ArrayList<Database>();
        ArrayList<Table> tables = new ArrayList<Table>();
        if (this.isMetastoreHook()) {
            switch (this.hiveOperation) {
                case CREATEDATABASE: {
                    databases.add(((CreateDatabaseEvent)this.metastoreEvent).getDatabase());
                    break;
                }
                case ALTERDATABASE: {
                    databases.add(((AlterDatabaseEvent)this.metastoreEvent).getOldDatabase());
                    databases.add(((AlterDatabaseEvent)this.metastoreEvent).getNewDatabase());
                    break;
                }
                case CREATETABLE: {
                    tables.add(BaseHiveEvent.toTable(((CreateTableEvent)this.metastoreEvent).getTable()));
                    break;
                }
                case ALTERTABLE_PROPERTIES: 
                case ALTERTABLE_RENAME: 
                case ALTERTABLE_RENAMECOL: {
                    tables.add(BaseHiveEvent.toTable(((AlterTableEvent)this.metastoreEvent).getOldTable()));
                    tables.add(BaseHiveEvent.toTable(((AlterTableEvent)this.metastoreEvent).getNewTable()));
                }
            }
        } else if (this.getOutputs() != null) {
            for (WriteEntity output : this.hiveContext.getOutputs()) {
                switch (output.getType()) {
                    case DATABASE: {
                        databases.add(output.getDatabase());
                        break;
                    }
                    case TABLE: {
                        tables.add(output.getTable());
                    }
                }
            }
        }
        for (Database database : databases) {
            this.knownObjects.removeFromKnownDatabase(this.getQualifiedName(database));
        }
        for (Table table : tables) {
            this.knownObjects.removeFromKnownTable(this.getQualifiedName(table));
        }
    }

    private static boolean isCreateAlterOperation(String operationName) {
        return operationName != null && operationName.startsWith(CREATE_OPERATION) || operationName.startsWith(ALTER_OPERATION);
    }
}

