/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.events.AlterDatabase;
import org.apache.atlas.hive.hook.events.AlterTable;
import org.apache.atlas.hive.hook.events.AlterTableRename;
import org.apache.atlas.hive.hook.events.AlterTableRenameCol;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.hive.hook.events.CreateDatabase;
import org.apache.atlas.hive.hook.events.CreateHiveProcess;
import org.apache.atlas.hive.hook.events.CreateTable;
import org.apache.atlas.hive.hook.events.DropDatabase;
import org.apache.atlas.hive.hook.events.DropTable;
import org.apache.atlas.hive.hook.utils.ActiveEntityFilter;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.utils.LruCache;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHook
extends AtlasHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(HiveHook.class);
    public static final String CONF_PREFIX = "atlas.hook.hive.";
    public static final String HDFS_PATH_CONVERT_TO_LOWER_CASE = "atlas.hook.hive.hdfs_path.convert_to_lowercase";
    public static final String HOOK_NAME_CACHE_ENABLED = "atlas.hook.hive.name.cache.enabled";
    public static final String HOOK_NAME_CACHE_DATABASE_COUNT = "atlas.hook.hive.name.cache.database.count";
    public static final String HOOK_NAME_CACHE_TABLE_COUNT = "atlas.hook.hive.name.cache.table.count";
    public static final String HOOK_NAME_CACHE_REBUID_INTERVAL_SEC = "atlas.hook.hive.name.cache.rebuild.interval.seconds";
    public static final String HOOK_AWS_S3_ATLAS_MODEL_VERSION = "atlas.hook.hive.aws_s3.atlas.model.version";
    public static final String HOOK_AWS_S3_ATLAS_MODEL_VERSION_V2 = "v2";
    public static final String HOOK_HIVE_PROCESS_POPULATE_DEPRECATED_ATTRIBUTES = "atlas.hook.hive.hive_process.populate.deprecated.attributes";
    public static final String HOOK_SKIP_HIVE_COLUMN_LINEAGE_HIVE_20633 = "atlas.hook.hive.skip.hive_column_lineage.hive-20633";
    public static final String HOOK_SKIP_HIVE_COLUMN_LINEAGE_HIVE_20633_INPUTS_THRESHOLD = "atlas.hook.hive.skip.hive_column_lineage.hive-20633.inputs.threshold";
    public static final String HOOK_HIVE_TABLE_IGNORE_PATTERN = "atlas.hook.hive.hive_table.ignore.pattern";
    public static final String HOOK_HIVE_TABLE_PRUNE_PATTERN = "atlas.hook.hive.hive_table.prune.pattern";
    public static final String HOOK_HIVE_TABLE_CACHE_SIZE = "atlas.hook.hive.hive_table.cache.size";
    public static final String HOOK_HIVE_IGNORE_DDL_OPERATIONS = "atlas.hook.hive.hs2.ignore.ddl.operations";
    public static final String HOOK_HIVE_FILTER_ENTITY_ADDITIONAL_TYPES_TO_RETAIN = "atlas.hook.hive.hs2.filter.entity.additional.types.to.retain";
    public static final String HOOK_HIVE_SKIP_TEMP_TABLES = "atlas.hook.hive.skip.temp.tables";
    public static final String HOOK_HIVE_SKIP_ALL_TEMP_TABLES = "atlas.hook.hive.skip.all.temp.tables";
    public static final String DEFAULT_HOST_NAME = "localhost";
    private static final Map<String, HiveOperation> OPERATION_MAP = new HashMap<String, HiveOperation>();
    private static final boolean convertHdfsPathToLowerCase;
    private static final boolean nameCacheEnabled;
    private static final int nameCacheDatabaseMaxCount;
    private static final int nameCacheTableMaxCount;
    private static final int nameCacheRebuildIntervalSeconds;
    private static final String awsS3AtlasModelVersion;
    private static final boolean skipHiveColumnLineageHive20633;
    private static final int skipHiveColumnLineageHive20633InputsThreshold;
    private static final List<Pattern> hiveTablesToIgnore;
    private static final List<Pattern> hiveTablesToPrune;
    private static final Map<String, PreprocessAction> hiveTablesCache;
    private static final List ignoreDummyDatabaseName;
    private static final List ignoreDummyTableName;
    private static final String ignoreValuesTmpTableNamePrefix;
    private static final boolean hiveProcessPopulateDeprecatedAttributes;
    private static HiveHookObjectNamesCache knownObjects;
    private static String hostName;
    private static boolean skipAllTempTablesIncludingExternal;
    private static boolean skipTempTables;

    public HiveHook() {
    }

    public HiveHook(String name) {
        super(name);
    }

    public String getMessageSource() {
        return "hive_server2";
    }

    public void run(HookContext hookContext) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveHook.run({})", (Object)hookContext.getOperationName());
        }
        try {
            HiveOperation oper = OPERATION_MAP.get(hookContext.getOperationName());
            AtlasHiveHookContext context = new AtlasHiveHookContext(this, oper, hookContext, HiveHook.getKnownObjects(), HiveHook.isSkipTempTables());
            BaseHiveEvent event = null;
            switch (oper) {
                case CREATEDATABASE: {
                    event = new CreateDatabase(context);
                    break;
                }
                case DROPDATABASE: {
                    event = new DropDatabase(context);
                    break;
                }
                case ALTERDATABASE: 
                case ALTERDATABASE_OWNER: 
                case ALTERDATABASE_LOCATION: {
                    event = new AlterDatabase(context);
                    break;
                }
                case CREATETABLE: {
                    event = new CreateTable(context);
                    break;
                }
                case DROPTABLE: 
                case DROPVIEW: 
                case DROP_MATERIALIZED_VIEW: {
                    event = new DropTable(context);
                    break;
                }
                case CREATETABLE_AS_SELECT: 
                case CREATE_MATERIALIZED_VIEW: 
                case CREATEVIEW: 
                case ALTERVIEW_AS: 
                case LOAD: 
                case EXPORT: 
                case IMPORT: 
                case QUERY: {
                    event = new CreateHiveProcess(context);
                    break;
                }
                case ALTERTABLE_FILEFORMAT: 
                case ALTERTABLE_CLUSTER_SORT: 
                case ALTERTABLE_BUCKETNUM: 
                case ALTERTABLE_PROPERTIES: 
                case ALTERVIEW_PROPERTIES: 
                case ALTERTABLE_SERDEPROPERTIES: 
                case ALTERTABLE_SERIALIZER: 
                case ALTERTABLE_ADDCOLS: 
                case ALTERTABLE_REPLACECOLS: 
                case ALTERTABLE_PARTCOLTYPE: 
                case ALTERTABLE_LOCATION: {
                    event = new AlterTable(context);
                    break;
                }
                case ALTERTABLE_RENAME: 
                case ALTERVIEW_RENAME: {
                    event = new AlterTableRename(context);
                    break;
                }
                case ALTERTABLE_RENAMECOL: {
                    event = new AlterTableRenameCol(context);
                    break;
                }
                default: {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("HiveHook.run({}): operation ignored", (Object)hookContext.getOperationName());
                }
            }
            if (event != null) {
                UserGroupInformation ugi = hookContext.getUgi() == null ? Utils.getUGI() : hookContext.getUgi();
                super.notifyEntities(ActiveEntityFilter.apply(event.getNotificationMessages()), ugi);
            }
        }
        catch (Throwable t) {
            LOG.error("HiveHook.run(): failed to process operation {}", (Object)hookContext.getOperationName(), (Object)t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveHook.run({})", (Object)hookContext.getOperationName());
        }
    }

    public boolean isConvertHdfsPathToLowerCase() {
        return convertHdfsPathToLowerCase;
    }

    public String getAwsS3AtlasModelVersion() {
        return awsS3AtlasModelVersion;
    }

    public boolean getSkipHiveColumnLineageHive20633() {
        return skipHiveColumnLineageHive20633;
    }

    public int getSkipHiveColumnLineageHive20633InputsThreshold() {
        return skipHiveColumnLineageHive20633InputsThreshold;
    }

    public List getIgnoreDummyDatabaseName() {
        return ignoreDummyDatabaseName;
    }

    public List getIgnoreDummyTableName() {
        return ignoreDummyTableName;
    }

    public String getIgnoreValuesTmpTableNamePrefix() {
        return ignoreValuesTmpTableNamePrefix;
    }

    public boolean isHiveProcessPopulateDeprecatedAttributes() {
        return hiveProcessPopulateDeprecatedAttributes;
    }

    public static boolean isSkipTempTables() {
        return skipTempTables;
    }

    public static boolean isSkipAllTempTablesIncludingExternal() {
        return skipAllTempTablesIncludingExternal;
    }

    public PreprocessAction getPreprocessActionForHiveTable(String qualifiedName) {
        PreprocessAction ret = PreprocessAction.NONE;
        if (qualifiedName != null && (CollectionUtils.isNotEmpty(hiveTablesToIgnore) || CollectionUtils.isNotEmpty(hiveTablesToPrune)) && (ret = hiveTablesCache.get(qualifiedName)) == null) {
            ret = this.isMatch(qualifiedName, hiveTablesToIgnore) ? PreprocessAction.IGNORE : (this.isMatch(qualifiedName, hiveTablesToPrune) ? PreprocessAction.PRUNE : PreprocessAction.NONE);
            hiveTablesCache.put(qualifiedName, ret);
        }
        return ret;
    }

    private boolean isMatch(String name, List<Pattern> patterns) {
        boolean ret = false;
        for (Pattern p : patterns) {
            if (!p.matcher(name).matches()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static HiveHookObjectNamesCache getKnownObjects() {
        if (knownObjects != null && knownObjects.isCacheExpired()) {
            LOG.info("HiveHook.run(): purging cached databaseNames ({}) and tableNames ({})", (Object)knownObjects.getCachedDbCount(), (Object)knownObjects.getCachedTableCount());
            knownObjects = new HiveHookObjectNamesCache(nameCacheDatabaseMaxCount, nameCacheTableMaxCount, nameCacheRebuildIntervalSeconds);
        }
        return knownObjects;
    }

    public String getHostName() {
        return hostName;
    }

    static {
        hiveTablesToIgnore = new ArrayList<Pattern>();
        hiveTablesToPrune = new ArrayList<Pattern>();
        knownObjects = null;
        skipTempTables = true;
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            OPERATION_MAP.put(hiveOperation.getOperationName(), hiveOperation);
        }
        convertHdfsPathToLowerCase = atlasProperties.getBoolean(HDFS_PATH_CONVERT_TO_LOWER_CASE, false);
        nameCacheEnabled = atlasProperties.getBoolean(HOOK_NAME_CACHE_ENABLED, true);
        nameCacheDatabaseMaxCount = atlasProperties.getInt(HOOK_NAME_CACHE_DATABASE_COUNT, 10000);
        nameCacheTableMaxCount = atlasProperties.getInt(HOOK_NAME_CACHE_TABLE_COUNT, 10000);
        nameCacheRebuildIntervalSeconds = atlasProperties.getInt(HOOK_NAME_CACHE_REBUID_INTERVAL_SEC, 3600);
        awsS3AtlasModelVersion = atlasProperties.getString(HOOK_AWS_S3_ATLAS_MODEL_VERSION, HOOK_AWS_S3_ATLAS_MODEL_VERSION_V2);
        skipHiveColumnLineageHive20633 = atlasProperties.getBoolean(HOOK_SKIP_HIVE_COLUMN_LINEAGE_HIVE_20633, false);
        skipHiveColumnLineageHive20633InputsThreshold = atlasProperties.getInt(HOOK_SKIP_HIVE_COLUMN_LINEAGE_HIVE_20633_INPUTS_THRESHOLD, 15);
        hiveProcessPopulateDeprecatedAttributes = atlasProperties.getBoolean(HOOK_HIVE_PROCESS_POPULATE_DEPRECATED_ATTRIBUTES, false);
        String[] patternHiveTablesToIgnore = atlasProperties.getStringArray(HOOK_HIVE_TABLE_IGNORE_PATTERN);
        String[] patternHiveTablesToPrune = atlasProperties.getStringArray(HOOK_HIVE_TABLE_PRUNE_PATTERN);
        if (patternHiveTablesToIgnore != null) {
            String[] stringArray = patternHiveTablesToIgnore;
            int hiveOperation = stringArray.length;
            for (int i = 0; i < hiveOperation; ++i) {
                String pattern = stringArray[i];
                try {
                    hiveTablesToIgnore.add(Pattern.compile(pattern));
                    LOG.info("{}={}", (Object)HOOK_HIVE_TABLE_IGNORE_PATTERN, (Object)pattern);
                    continue;
                }
                catch (Throwable t) {
                    LOG.warn("failed to compile pattern {}", (Object)pattern, (Object)t);
                    LOG.warn("Ignoring invalid pattern in configuration {}: {}", (Object)HOOK_HIVE_TABLE_IGNORE_PATTERN, (Object)pattern);
                }
            }
        }
        if (patternHiveTablesToPrune != null) {
            for (String pattern : patternHiveTablesToPrune) {
                try {
                    hiveTablesToPrune.add(Pattern.compile(pattern));
                    LOG.info("{}={}", (Object)HOOK_HIVE_TABLE_PRUNE_PATTERN, (Object)pattern);
                }
                catch (Throwable t) {
                    LOG.warn("failed to compile pattern {}", (Object)pattern, (Object)t);
                    LOG.warn("Ignoring invalid pattern in configuration {}: {}", (Object)HOOK_HIVE_TABLE_PRUNE_PATTERN, (Object)pattern);
                }
            }
        }
        hiveTablesCache = !hiveTablesToIgnore.isEmpty() || !hiveTablesToPrune.isEmpty() ? new LruCache(atlasProperties.getInt(HOOK_HIVE_TABLE_CACHE_SIZE, 10000), 0) : Collections.emptyMap();
        knownObjects = nameCacheEnabled ? new HiveHookObjectNamesCache(nameCacheDatabaseMaxCount, nameCacheTableMaxCount, nameCacheRebuildIntervalSeconds) : null;
        ArrayList<String> defaultDummyDatabase = new ArrayList<String>();
        ArrayList<String> defaultDummyTable = new ArrayList<String>();
        defaultDummyDatabase.add("_dummy_database");
        defaultDummyTable.add("_dummy_table");
        ignoreDummyDatabaseName = atlasProperties.getList("atlas.hook.hive.ignore.dummy.database.name", defaultDummyDatabase);
        ignoreDummyTableName = atlasProperties.getList("atlas.hook.hive.ignore.dummy.table.name", defaultDummyTable);
        ignoreValuesTmpTableNamePrefix = atlasProperties.getString("atlas.hook.hive.ignore.values.tmp.table.name.prefix", "Values__Tmp__Table__");
        skipAllTempTablesIncludingExternal = atlasProperties.getBoolean(HOOK_HIVE_SKIP_ALL_TEMP_TABLES, false);
        skipTempTables = skipAllTempTablesIncludingExternal || atlasProperties.getBoolean(HOOK_HIVE_SKIP_TEMP_TABLES, true);
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("No hostname found. Setting the hostname to default value {}", (Object)DEFAULT_HOST_NAME, (Object)e);
            hostName = DEFAULT_HOST_NAME;
        }
        ActiveEntityFilter.init(atlasProperties);
    }

    public static class HiveHookObjectNamesCache {
        private final int dbMaxCacheCount;
        private final int tblMaxCacheCount;
        private final long cacheExpiryTimeMs;
        private final Set<String> knownDatabases;
        private final Set<String> knownTables;

        public HiveHookObjectNamesCache(int dbMaxCacheCount, int tblMaxCacheCount, long nameCacheRebuildIntervalSeconds) {
            this.dbMaxCacheCount = dbMaxCacheCount;
            this.tblMaxCacheCount = tblMaxCacheCount;
            this.cacheExpiryTimeMs = nameCacheRebuildIntervalSeconds <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + nameCacheRebuildIntervalSeconds * 1000L;
            this.knownDatabases = Collections.synchronizedSet(new HashSet());
            this.knownTables = Collections.synchronizedSet(new HashSet());
        }

        public int getCachedDbCount() {
            return this.knownDatabases.size();
        }

        public int getCachedTableCount() {
            return this.knownTables.size();
        }

        public boolean isCacheExpired() {
            return System.currentTimeMillis() > this.cacheExpiryTimeMs;
        }

        public boolean isKnownDatabase(String dbQualifiedName) {
            return this.knownDatabases.contains(dbQualifiedName);
        }

        public boolean isKnownTable(String tblQualifiedName) {
            return this.knownTables.contains(tblQualifiedName);
        }

        public void addToKnownEntities(Collection<AtlasEntity> entities) {
            for (AtlasEntity entity : entities) {
                if (StringUtils.equalsIgnoreCase((String)entity.getTypeName(), (String)"hive_db")) {
                    this.addToKnownDatabase((String)entity.getAttribute("qualifiedName"));
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((String)entity.getTypeName(), (String)"hive_table")) continue;
                this.addToKnownTable((String)entity.getAttribute("qualifiedName"));
            }
        }

        public void addToKnownDatabase(String dbQualifiedName) {
            if (this.knownDatabases.size() < this.dbMaxCacheCount) {
                this.knownDatabases.add(dbQualifiedName);
            }
        }

        public void addToKnownTable(String tblQualifiedName) {
            if (this.knownTables.size() < this.tblMaxCacheCount) {
                this.knownTables.add(tblQualifiedName);
            }
        }

        public void removeFromKnownDatabase(String dbQualifiedName) {
            this.knownDatabases.remove(dbQualifiedName);
        }

        public void removeFromKnownTable(String tblQualifiedName) {
            if (tblQualifiedName != null) {
                this.knownTables.remove(tblQualifiedName);
            }
        }
    }

    public static enum PreprocessAction {
        NONE,
        IGNORE,
        PRUNE;

    }
}

