/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook;

import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.HiveHook;
import org.apache.atlas.hive.hook.HiveOperationContext;
import org.apache.atlas.hive.hook.events.AlterDatabase;
import org.apache.atlas.hive.hook.events.AlterTable;
import org.apache.atlas.hive.hook.events.AlterTableRename;
import org.apache.atlas.hive.hook.events.AlterTableRenameCol;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.hive.hook.events.CreateDatabase;
import org.apache.atlas.hive.hook.events.CreateTable;
import org.apache.atlas.hive.hook.events.DropDatabase;
import org.apache.atlas.hive.hook.events.DropTable;
import org.apache.atlas.hook.AtlasHook;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetastoreHookImpl
extends MetaStoreEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetastoreHookImpl.class);
    private final HiveHook hiveHook = new HiveHook(((Object)((Object)this)).getClass().getSimpleName());
    private final HiveMetastoreHook hook = new HiveMetastoreHook();

    public HiveMetastoreHookImpl(Configuration config) {
        super(config);
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) {
        HiveOperationContext context = new HiveOperationContext(HiveOperation.CREATEDATABASE, (ListenerEvent)dbEvent);
        this.hook.handleEvent(context);
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) {
        HiveOperationContext context = new HiveOperationContext(HiveOperation.DROPDATABASE, (ListenerEvent)dbEvent);
        this.hook.handleEvent(context);
    }

    public void onAlterDatabase(AlterDatabaseEvent dbEvent) {
        HiveOperationContext context = new HiveOperationContext(HiveOperation.ALTERDATABASE, (ListenerEvent)dbEvent);
        this.hook.handleEvent(context);
    }

    public void onCreateTable(CreateTableEvent tableEvent) {
        HiveOperationContext context = new HiveOperationContext(HiveOperation.CREATETABLE, (ListenerEvent)tableEvent);
        this.hook.handleEvent(context);
    }

    public void onDropTable(DropTableEvent tableEvent) {
        HiveOperationContext context = new HiveOperationContext(HiveOperation.DROPTABLE, (ListenerEvent)tableEvent);
        this.hook.handleEvent(context);
    }

    public void onAlterTable(AlterTableEvent tableEvent) {
        Table newTable;
        HiveOperationContext context = new HiveOperationContext((ListenerEvent)tableEvent);
        Table oldTable = BaseHiveEvent.toTable(tableEvent.getOldTable());
        if (HiveMetastoreHookImpl.isTableRename(oldTable, newTable = BaseHiveEvent.toTable(tableEvent.getNewTable()))) {
            context.setOperation(HiveOperation.ALTERTABLE_RENAME);
        } else if (HiveMetastoreHookImpl.isColumnRename(oldTable, newTable, context)) {
            context.setOperation(HiveOperation.ALTERTABLE_RENAMECOL);
        } else if (this.isAlterTableProperty(tableEvent, "last_modified_time") || this.isAlterTableProperty(tableEvent, "transient_lastDdlTime")) {
            context.setOperation(HiveOperation.ALTERTABLE_PROPERTIES);
        }
        this.hook.handleEvent(context);
    }

    private static boolean isTableRename(Table oldTable, Table newTable) {
        String newTableName;
        String oldTableName = oldTable.getTableName();
        return !StringUtils.equalsIgnoreCase((String)oldTableName, (String)(newTableName = newTable.getTableName()));
    }

    private static boolean isColumnRename(Table oldTable, Table newTable, HiveOperationContext context) {
        boolean isColumnRename;
        FieldSchema columnOld = AlterTableRenameCol.findRenamedColumn(oldTable, newTable);
        FieldSchema columnNew = AlterTableRenameCol.findRenamedColumn(newTable, oldTable);
        boolean bl = isColumnRename = columnOld != null && columnNew != null;
        if (isColumnRename) {
            context.setColumnOld(columnOld);
            context.setColumnNew(columnNew);
        }
        return isColumnRename;
    }

    private boolean isAlterTableProperty(AlterTableEvent tableEvent, String propertyToCheck) {
        String oldTableModifiedTime = (String)tableEvent.getOldTable().getParameters().get(propertyToCheck);
        String newTableModifiedTime = (String)tableEvent.getNewTable().getParameters().get(propertyToCheck);
        boolean ret = oldTableModifiedTime == null ? newTableModifiedTime != null : !oldTableModifiedTime.equals(newTableModifiedTime);
        return ret;
    }

    public class HiveMetastoreHook
    extends AtlasHook {
        public String getMessageSource() {
            return "hive_metastore";
        }

        public void handleEvent(HiveOperationContext operContext) {
            ListenerEvent listenerEvent = operContext.getEvent();
            if (!listenerEvent.getStatus()) {
                return;
            }
            try {
                HiveOperation oper = operContext.getOperation();
                HiveHook hiveHook = HiveMetastoreHookImpl.this.hiveHook;
                HiveMetastoreHookImpl.this.hiveHook;
                HiveHook.HiveHookObjectNamesCache hiveHookObjectNamesCache = HiveHook.getKnownObjects();
                HiveMetastoreHookImpl.this.hiveHook;
                AtlasHiveHookContext context = new AtlasHiveHookContext(hiveHook, oper, hiveHookObjectNamesCache, this, listenerEvent, HiveHook.isSkipTempTables());
                BaseHiveEvent event = null;
                switch (oper) {
                    case CREATEDATABASE: {
                        event = new CreateDatabase(context);
                        break;
                    }
                    case DROPDATABASE: {
                        event = new DropDatabase(context);
                        break;
                    }
                    case ALTERDATABASE: {
                        event = new AlterDatabase(context);
                        break;
                    }
                    case CREATETABLE: {
                        event = new CreateTable(context);
                        break;
                    }
                    case DROPTABLE: {
                        event = new DropTable(context);
                        break;
                    }
                    case ALTERTABLE_PROPERTIES: {
                        event = new AlterTable(context);
                        break;
                    }
                    case ALTERTABLE_RENAME: {
                        event = new AlterTableRename(context);
                        break;
                    }
                    case ALTERTABLE_RENAMECOL: {
                        FieldSchema columnOld = operContext.getColumnOld();
                        FieldSchema columnNew = operContext.getColumnNew();
                        event = new AlterTableRenameCol(columnOld, columnNew, context);
                        break;
                    }
                    default: {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("HiveMetastoreHook.handleEvent({}): operation ignored.", (Object)listenerEvent);
                    }
                }
                if (event != null) {
                    UserGroupInformation ugi = SecurityUtils.getUGI() == null ? Utils.getUGI() : SecurityUtils.getUGI();
                    super.notifyEntities(event.getNotificationMessages(), ugi);
                }
            }
            catch (Throwable t) {
                LOG.error("HiveMetastoreHook.handleEvent({}): failed to process operation {}", (Object)listenerEvent, (Object)t);
            }
        }
    }
}

