/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.events.CreateDatabase;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterDatabase
extends CreateDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(AlterDatabase.class);

    public AlterDatabase(AtlasHiveHookContext context) {
        super(context);
    }

    @Override
    public List<HookNotification> getNotificationMessages() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo entities;
        List<HookNotification.EntityUpdateRequestV2> ret = null;
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = entities = this.context.isMetastoreHook() ? this.getHiveMetastoreEntities() : this.getHiveEntities();
        if (entities != null && CollectionUtils.isNotEmpty((Collection)entities.getEntities())) {
            ret = Collections.singletonList(new HookNotification.EntityUpdateRequestV2(this.getUserName(), entities));
        }
        return ret;
    }

    @Override
    public AtlasEntity.AtlasEntitiesWithExtInfo getHiveMetastoreEntities() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        AlterDatabaseEvent dbEvent = (AlterDatabaseEvent)this.context.getMetastoreEvent();
        Database oldDb = dbEvent.getOldDatabase();
        Database newDb = dbEvent.getNewDatabase();
        if (newDb != null) {
            AtlasEntity dbEntity = this.toDbEntity(newDb);
            ret.addEntity(dbEntity);
            this.addLocationEntities(dbEntity, ret);
        } else {
            LOG.error("AlterDatabase.getEntities(): failed to retrieve db");
        }
        this.addProcessedEntities(ret);
        return ret;
    }

    @Override
    public AtlasEntity.AtlasEntitiesWithExtInfo getHiveEntities() throws Exception {
        return super.getHiveEntities();
    }
}

