/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableRename
extends BaseHiveEvent {
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableRename.class);

    public AlterTableRename(AtlasHiveHookContext context) {
        super(context);
    }

    @Override
    public List<HookNotification> getNotificationMessages() throws Exception {
        return this.context.isMetastoreHook() ? this.getHiveMetastoreMessages() : this.getHiveMessages();
    }

    public List<HookNotification> getHiveMetastoreMessages() throws Exception {
        ArrayList<HookNotification> ret = new ArrayList<HookNotification>();
        AlterTableEvent tblEvent = (AlterTableEvent)this.context.getMetastoreEvent();
        Table oldTable = AlterTableRename.toTable(tblEvent.getOldTable());
        Table newTable = AlterTableRename.toTable(tblEvent.getNewTable());
        if (newTable == null) {
            LOG.error("AlterTableRename: renamed table not found in outputs list");
            return ret;
        }
        this.processTables(oldTable, newTable, ret);
        return ret;
    }

    public List<HookNotification> getHiveMessages() throws Exception {
        ArrayList<HookNotification> ret = new ArrayList<HookNotification>();
        if (CollectionUtils.isEmpty(this.getInputs())) {
            LOG.error("AlterTableRename: old-table not found in inputs list");
            return ret;
        }
        Table oldTable = this.getInputs().iterator().next().getTable();
        Table newTable = null;
        if (CollectionUtils.isNotEmpty(this.getOutputs())) {
            for (WriteEntity entity : this.getOutputs()) {
                if (entity.getType() != Entity.Type.TABLE) continue;
                newTable = entity.getTable();
                if (StringUtils.equalsIgnoreCase((CharSequence)newTable.getDbName(), (CharSequence)oldTable.getDbName()) && StringUtils.equalsIgnoreCase((CharSequence)newTable.getTableName(), (CharSequence)oldTable.getTableName())) {
                    newTable = null;
                    continue;
                }
                newTable = this.getHive().getTable(newTable.getDbName(), newTable.getTableName());
                break;
            }
        }
        if (newTable == null) {
            LOG.error("AlterTableRename: renamed table not found in outputs list");
            return ret;
        }
        this.processTables(oldTable, newTable, ret);
        return ret;
    }

    private void processTables(Table oldTable, Table newTable, List<HookNotification> ret) throws Exception {
        AtlasEntity ddlEntity;
        AtlasEntity.AtlasEntityWithExtInfo oldTableEntity = this.toTableEntity(oldTable);
        AtlasEntity.AtlasEntityWithExtInfo renamedTableEntity = this.toTableEntity(newTable);
        if (oldTableEntity == null || renamedTableEntity == null) {
            return;
        }
        String renamedTableQualifiedName = (String)renamedTableEntity.getEntity().getAttribute("qualifiedName");
        this.renameColumns((List)oldTableEntity.getEntity().getRelationshipAttribute("columns"), (AtlasEntity.AtlasEntityExtInfo)oldTableEntity, renamedTableQualifiedName, ret);
        this.renameColumns((List)oldTableEntity.getEntity().getRelationshipAttribute("partitionKeys"), (AtlasEntity.AtlasEntityExtInfo)oldTableEntity, renamedTableQualifiedName, ret);
        this.renameStorageDesc(oldTableEntity, renamedTableEntity, ret);
        renamedTableEntity.getEntity().setAttribute("aliases", Collections.singletonList(oldTable.getTableName()));
        AtlasEntity renamedTableEntityForPartialUpdate = new AtlasEntity(renamedTableEntity.getEntity());
        renamedTableEntityForPartialUpdate.setRelationshipAttributes(null);
        String oldTableQualifiedName = (String)oldTableEntity.getEntity().getAttribute("qualifiedName");
        AtlasObjectId oldTableId = new AtlasObjectId(oldTableEntity.getEntity().getTypeName(), "qualifiedName", (Object)oldTableQualifiedName);
        ret.add((HookNotification)new HookNotification.EntityPartialUpdateRequestV2(this.getUserName(), oldTableId, new AtlasEntity.AtlasEntityWithExtInfo(renamedTableEntityForPartialUpdate)));
        ret.add((HookNotification)new HookNotification.EntityUpdateRequestV2(this.getUserName(), new AtlasEntity.AtlasEntitiesWithExtInfo(renamedTableEntity)));
        if (!this.context.isMetastoreHook() && (ddlEntity = this.createHiveDDLEntity(renamedTableEntity.getEntity(), true)) != null) {
            ret.add((HookNotification)new HookNotification.EntityCreateRequestV2(this.getUserName(), new AtlasEntity.AtlasEntitiesWithExtInfo(ddlEntity)));
        }
        this.context.removeFromKnownTable(oldTableQualifiedName);
    }

    private void renameColumns(List<AtlasObjectId> columns, AtlasEntity.AtlasEntityExtInfo oldEntityExtInfo, String newTableQualifiedName, List<HookNotification> notifications) {
        if (CollectionUtils.isNotEmpty(columns)) {
            for (AtlasObjectId columnId : columns) {
                AtlasEntity oldColumn = oldEntityExtInfo.getEntity(columnId.getGuid());
                AtlasObjectId oldColumnId = new AtlasObjectId(oldColumn.getTypeName(), "qualifiedName", oldColumn.getAttribute("qualifiedName"));
                AtlasEntity newColumn = new AtlasEntity(oldColumn.getTypeName(), "qualifiedName", (Object)this.getColumnQualifiedName(newTableQualifiedName, (String)oldColumn.getAttribute("name")));
                notifications.add((HookNotification)new HookNotification.EntityPartialUpdateRequestV2(this.getUserName(), oldColumnId, new AtlasEntity.AtlasEntityWithExtInfo(newColumn)));
            }
        }
    }

    private void renameStorageDesc(AtlasEntity.AtlasEntityWithExtInfo oldEntityExtInfo, AtlasEntity.AtlasEntityWithExtInfo newEntityExtInfo, List<HookNotification> notifications) {
        AtlasEntity oldSd = this.getStorageDescEntity(oldEntityExtInfo);
        AtlasEntity newSd = new AtlasEntity(this.getStorageDescEntity(newEntityExtInfo));
        if (oldSd != null && newSd != null) {
            AtlasObjectId oldSdId = new AtlasObjectId(oldSd.getTypeName(), "qualifiedName", oldSd.getAttribute("qualifiedName"));
            newSd.removeAttribute("table");
            newSd.setRelationshipAttributes(null);
            notifications.add((HookNotification)new HookNotification.EntityPartialUpdateRequestV2(this.getUserName(), oldSdId, new AtlasEntity.AtlasEntityWithExtInfo(newSd)));
        }
    }

    private AtlasEntity getStorageDescEntity(AtlasEntity.AtlasEntityWithExtInfo tableEntity) {
        Object attrSdId;
        AtlasEntity ret = null;
        if (tableEntity != null && tableEntity.getEntity() != null && (attrSdId = tableEntity.getEntity().getRelationshipAttribute("sd")) instanceof AtlasObjectId) {
            ret = tableEntity.getReferredEntity(((AtlasObjectId)attrSdId).getGuid());
        }
        return ret;
    }
}

