/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.events.AlterTable;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableRenameCol
extends AlterTable {
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableRenameCol.class);
    private final FieldSchema columnOld;
    private final FieldSchema columnNew;

    public AlterTableRenameCol(AtlasHiveHookContext context) {
        this(null, null, context);
    }

    public AlterTableRenameCol(FieldSchema columnOld, FieldSchema columnNew, AtlasHiveHookContext context) {
        super(context);
        this.columnOld = columnOld;
        this.columnNew = columnNew;
    }

    @Override
    public List<HookNotification> getNotificationMessages() throws Exception {
        return this.context.isMetastoreHook() ? this.getHiveMetastoreMessages() : this.getHiveMessages();
    }

    public List<HookNotification> getHiveMetastoreMessages() throws Exception {
        List<HookNotification> baseMsgs = super.getNotificationMessages();
        ArrayList<HookNotification> ret = new ArrayList<HookNotification>(baseMsgs);
        AlterTableEvent tblEvent = (AlterTableEvent)this.context.getMetastoreEvent();
        Table oldTable = AlterTableRenameCol.toTable(tblEvent.getOldTable());
        Table newTable = AlterTableRenameCol.toTable(tblEvent.getNewTable());
        this.processColumns(oldTable, newTable, ret);
        return ret;
    }

    public List<HookNotification> getHiveMessages() throws Exception {
        List<HookNotification> baseMsgs = super.getNotificationMessages();
        if (CollectionUtils.isEmpty(this.getInputs())) {
            LOG.error("AlterTableRenameCol: old-table not found in inputs list");
            return null;
        }
        if (CollectionUtils.isEmpty(this.getOutputs())) {
            LOG.error("AlterTableRenameCol: new-table not found in outputs list");
            return null;
        }
        if (CollectionUtils.isEmpty(baseMsgs)) {
            LOG.debug("Skipped processing of column-rename (on a temporary table?)");
            return null;
        }
        ArrayList<HookNotification> ret = new ArrayList<HookNotification>(baseMsgs);
        Table oldTable = this.getInputs().iterator().next().getTable();
        Table newTable = this.getOutputs().iterator().next().getTable();
        if (newTable != null) {
            newTable = this.getHive().getTable(newTable.getDbName(), newTable.getTableName());
        }
        this.processColumns(oldTable, newTable, ret);
        return ret;
    }

    private void processColumns(Table oldTable, Table newTable, List<HookNotification> ret) {
        FieldSchema changedColumnNew;
        FieldSchema changedColumnOld = this.columnOld == null ? AlterTableRenameCol.findRenamedColumn(oldTable, newTable) : this.columnOld;
        FieldSchema fieldSchema = changedColumnNew = this.columnNew == null ? AlterTableRenameCol.findRenamedColumn(newTable, oldTable) : this.columnNew;
        if (changedColumnOld != null && changedColumnNew != null) {
            AtlasObjectId oldColumnId = new AtlasObjectId("hive_column", "qualifiedName", (Object)this.getQualifiedName(oldTable, changedColumnOld));
            AtlasEntity newColumn = new AtlasEntity("hive_column");
            newColumn.setAttribute("name", (Object)changedColumnNew.getName());
            newColumn.setAttribute("qualifiedName", (Object)this.getQualifiedName(newTable, changedColumnNew));
            ret.add(0, (HookNotification)new HookNotification.EntityPartialUpdateRequestV2(this.getUserName(), oldColumnId, new AtlasEntity.AtlasEntityWithExtInfo(newColumn)));
        } else {
            LOG.error("AlterTableRenameCol: no renamed column detected");
        }
    }

    public static FieldSchema findRenamedColumn(Table inputTable, Table outputTable) {
        FieldSchema ret = null;
        List inputColumns = inputTable.getCols();
        List outputColumns = outputTable.getCols();
        for (FieldSchema inputColumn : inputColumns) {
            if (outputColumns.contains(inputColumn)) continue;
            ret = inputColumn;
            break;
        }
        return ret;
    }
}

