/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridge;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.HiveHook;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasPathExtractorUtil;
import org.apache.atlas.utils.HdfsNameServiceResolver;
import org.apache.atlas.utils.PathExtractorContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHiveEvent {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHiveEvent.class);
    public static final String HIVE_TYPE_DB = "hive_db";
    public static final String HIVE_TYPE_TABLE = "hive_table";
    public static final String HIVE_TYPE_STORAGEDESC = "hive_storagedesc";
    public static final String HIVE_TYPE_COLUMN = "hive_column";
    public static final String HIVE_TYPE_PROCESS = "hive_process";
    public static final String HIVE_TYPE_COLUMN_LINEAGE = "hive_column_lineage";
    public static final String HIVE_TYPE_SERDE = "hive_serde";
    public static final String HIVE_TYPE_ORDER = "hive_order";
    public static final String HIVE_TYPE_PROCESS_EXECUTION = "hive_process_execution";
    public static final String HIVE_DB_DDL = "hive_db_ddl";
    public static final String HIVE_TABLE_DDL = "hive_table_ddl";
    public static final String HBASE_TYPE_TABLE = "hbase_table";
    public static final String HBASE_TYPE_NAMESPACE = "hbase_namespace";
    public static final String ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_OWNER = "owner";
    public static final String ATTRIBUTE_CLUSTER_NAME = "clusterName";
    public static final String ATTRIBUTE_LOCATION = "location";
    public static final String ATTRIBUTE_LOCATION_PATH = "locationPath";
    public static final String ATTRIBUTE_PARAMETERS = "parameters";
    public static final String ATTRIBUTE_OWNER_TYPE = "ownerType";
    public static final String ATTRIBUTE_COMMENT = "comment";
    public static final String ATTRIBUTE_CREATE_TIME = "createTime";
    public static final String ATTRIBUTE_LAST_ACCESS_TIME = "lastAccessTime";
    public static final String ATTRIBUTE_VIEW_ORIGINAL_TEXT = "viewOriginalText";
    public static final String ATTRIBUTE_VIEW_EXPANDED_TEXT = "viewExpandedText";
    public static final String ATTRIBUTE_TABLE_TYPE = "tableType";
    public static final String ATTRIBUTE_TEMPORARY = "temporary";
    public static final String ATTRIBUTE_RETENTION = "retention";
    public static final String ATTRIBUTE_DB = "db";
    public static final String ATTRIBUTE_HIVE_DB = "hiveDb";
    public static final String ATTRIBUTE_STORAGEDESC = "sd";
    public static final String ATTRIBUTE_PARTITION_KEYS = "partitionKeys";
    public static final String ATTRIBUTE_COLUMNS = "columns";
    public static final String ATTRIBUTE_INPUT_FORMAT = "inputFormat";
    public static final String ATTRIBUTE_OUTPUT_FORMAT = "outputFormat";
    public static final String ATTRIBUTE_COMPRESSED = "compressed";
    public static final String ATTRIBUTE_BUCKET_COLS = "bucketCols";
    public static final String ATTRIBUTE_NUM_BUCKETS = "numBuckets";
    public static final String ATTRIBUTE_STORED_AS_SUB_DIRECTORIES = "storedAsSubDirectories";
    public static final String ATTRIBUTE_TABLE = "table";
    public static final String ATTRIBUTE_SERDE_INFO = "serdeInfo";
    public static final String ATTRIBUTE_SERIALIZATION_LIB = "serializationLib";
    public static final String ATTRIBUTE_SORT_COLS = "sortCols";
    public static final String ATTRIBUTE_COL_TYPE = "type";
    public static final String ATTRIBUTE_COL_POSITION = "position";
    public static final String ATTRIBUTE_PATH = "path";
    public static final String ATTRIBUTE_NAMESERVICE_ID = "nameServiceId";
    public static final String ATTRIBUTE_INPUTS = "inputs";
    public static final String ATTRIBUTE_OUTPUTS = "outputs";
    public static final String ATTRIBUTE_OPERATION_TYPE = "operationType";
    public static final String ATTRIBUTE_START_TIME = "startTime";
    public static final String ATTRIBUTE_USER_NAME = "userName";
    public static final String ATTRIBUTE_QUERY_TEXT = "queryText";
    public static final String ATTRIBUTE_PROCESS = "process";
    public static final String ATTRIBUTE_PROCESS_EXECUTIONS = "processExecutions";
    public static final String ATTRIBUTE_QUERY_ID = "queryId";
    public static final String ATTRIBUTE_QUERY_PLAN = "queryPlan";
    public static final String ATTRIBUTE_END_TIME = "endTime";
    public static final String ATTRIBUTE_RECENT_QUERIES = "recentQueries";
    public static final String ATTRIBUTE_QUERY = "query";
    public static final String ATTRIBUTE_DEPENDENCY_TYPE = "depenendencyType";
    public static final String ATTRIBUTE_EXPRESSION = "expression";
    public static final String ATTRIBUTE_ALIASES = "aliases";
    public static final String ATTRIBUTE_URI = "uri";
    public static final String ATTRIBUTE_STORAGE_HANDLER = "storage_handler";
    public static final String ATTRIBUTE_NAMESPACE = "namespace";
    public static final String ATTRIBUTE_HOSTNAME = "hostName";
    public static final String ATTRIBUTE_EXEC_TIME = "execTime";
    public static final String ATTRIBUTE_DDL_QUERIES = "ddlQueries";
    public static final String ATTRIBUTE_SERVICE_TYPE = "serviceType";
    public static final String ATTRIBUTE_GUID = "guid";
    public static final String ATTRIBUTE_UNIQUE_ATTRIBUTES = "uniqueAttributes";
    public static final String HBASE_STORAGE_HANDLER_CLASS = "org.apache.hadoop.hive.hbase.HBaseStorageHandler";
    public static final String HBASE_DEFAULT_NAMESPACE = "default";
    public static final String HBASE_NAMESPACE_TABLE_DELIMITER = ":";
    public static final String HBASE_PARAM_TABLE_NAME = "hbase.table.name";
    public static final long MILLIS_CONVERT_FACTOR = 1000L;
    public static final String HDFS_PATH_PREFIX = "hdfs://";
    public static final String EMPTY_ATTRIBUTE_VALUE = "";
    public static final String RELATIONSHIP_DATASET_PROCESS_INPUTS = "dataset_process_inputs";
    public static final String RELATIONSHIP_PROCESS_DATASET_OUTPUTS = "process_dataset_outputs";
    public static final String RELATIONSHIP_HIVE_PROCESS_COLUMN_LINEAGE = "hive_process_column_lineage";
    public static final String RELATIONSHIP_HIVE_TABLE_DB = "hive_table_db";
    public static final String RELATIONSHIP_HIVE_TABLE_PART_KEYS = "hive_table_partitionkeys";
    public static final String RELATIONSHIP_HIVE_TABLE_COLUMNS = "hive_table_columns";
    public static final String RELATIONSHIP_HIVE_TABLE_STORAGE_DESC = "hive_table_storagedesc";
    public static final String RELATIONSHIP_HIVE_PROCESS_PROCESS_EXE = "hive_process_process_executions";
    public static final String RELATIONSHIP_HIVE_DB_DDL_QUERIES = "hive_db_ddl_queries";
    public static final String RELATIONSHIP_HIVE_DB_LOCATION = "hive_db_location";
    public static final String RELATIONSHIP_HIVE_TABLE_DDL_QUERIES = "hive_table_ddl_queries";
    public static final String RELATIONSHIP_HBASE_TABLE_NAMESPACE = "hbase_table_namespace";
    public static final Map<Integer, String> OWNER_TYPE_TO_ENUM_VALUE = new HashMap<Integer, String>();
    protected final boolean skipTempTables;
    protected final AtlasHiveHookContext context;
    static final Comparator<Entity> entityComparator;

    protected BaseHiveEvent(AtlasHiveHookContext context) {
        this.context = context;
        this.skipTempTables = context.isSkipTempTables();
    }

    public AtlasHiveHookContext getContext() {
        return this.context;
    }

    public List<HookNotification> getNotificationMessages() throws Exception {
        return null;
    }

    public static long getTableCreateTime(Table table) {
        return table.getTTable() != null ? (long)table.getTTable().getCreateTime() * 1000L : System.currentTimeMillis();
    }

    public static String getTableOwner(Table table) {
        return table.getTTable() != null ? table.getOwner() : EMPTY_ATTRIBUTE_VALUE;
    }

    public static List<AtlasObjectId> getObjectIds(List<AtlasEntity> entities) {
        List<AtlasObjectId> ret;
        if (CollectionUtils.isNotEmpty(entities)) {
            ret = new ArrayList<AtlasObjectId>(entities.size());
            for (AtlasEntity entity : entities) {
                ret.add(AtlasTypeUtil.getObjectId((AtlasEntity)entity));
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    protected void addProcessedEntities(AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo) {
        for (AtlasEntity entity : this.context.getEntities()) {
            entitiesWithExtInfo.addReferredEntity(entity);
        }
        entitiesWithExtInfo.compact();
        this.context.addToKnownEntities(entitiesWithExtInfo.getEntities());
        if (entitiesWithExtInfo.getReferredEntities() != null) {
            this.context.addToKnownEntities(entitiesWithExtInfo.getReferredEntities().values());
        }
    }

    protected AtlasEntity getInputOutputEntity(Entity entity, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean skipTempTables) throws Exception {
        AtlasEntity ret = null;
        switch (entity.getType()) {
            case TABLE: 
            case PARTITION: 
            case DFS_DIR: 
            case LOCAL_DIR: {
                ret = this.toAtlasEntity(entity, entityExtInfo, skipTempTables);
            }
        }
        return ret;
    }

    protected AtlasEntity toAtlasEntity(Entity entity, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean skipTempTables) throws Exception {
        AtlasEntity ret = null;
        switch (entity.getType()) {
            case DATABASE: {
                String dbName = HiveMetaStoreBridge.getDatabaseName(entity.getDatabase());
                if (this.context.getIgnoreDummyDatabaseName().contains(dbName)) break;
                Database db = this.getHive().getDatabase(dbName);
                ret = this.toDbEntity(db);
                break;
            }
            case TABLE: 
            case PARTITION: {
                boolean skipTable;
                String dbName = entity.getTable().getDbName();
                String tableName = entity.getTable().getTableName();
                boolean bl = skipTable = StringUtils.isNotEmpty((CharSequence)this.context.getIgnoreValuesTmpTableNamePrefix()) && tableName.toLowerCase().startsWith(this.context.getIgnoreValuesTmpTableNamePrefix());
                if (!skipTable) {
                    boolean bl2 = skipTable = this.context.getIgnoreDummyTableName().contains(tableName) && this.context.getIgnoreDummyDatabaseName().contains(dbName);
                }
                if (!skipTable) {
                    boolean bl3 = skipTable = skipTempTables && entity.getTable().isTemporary();
                }
                if (!skipTable) {
                    Table table = this.getHive().getTable(dbName, tableName);
                    ret = this.toTableEntity(table, entityExtInfo);
                    break;
                }
                this.context.registerSkippedEntity(entity);
                break;
            }
            case DFS_DIR: 
            case LOCAL_DIR: {
                URI location = entity.getLocation();
                if (location == null) break;
                ret = this.getPathEntity(new Path(entity.getLocation()), entityExtInfo);
                break;
            }
        }
        return ret;
    }

    protected AtlasEntity toDbEntity(Database db) throws Exception {
        String dbName = HiveMetaStoreBridge.getDatabaseName(db);
        String dbQualifiedName = this.getQualifiedName(db);
        boolean isKnownDatabase = this.context.isKnownDatabase(dbQualifiedName);
        AtlasEntity ret = this.context.getEntity(dbQualifiedName);
        if (ret == null) {
            ret = new AtlasEntity(HIVE_TYPE_DB);
            if (isKnownDatabase) {
                ret.setGuid(null);
            }
            ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)dbQualifiedName);
            ret.setAttribute(ATTRIBUTE_NAME, (Object)dbName);
            if (StringUtils.isNotEmpty((CharSequence)db.getDescription())) {
                ret.setAttribute(ATTRIBUTE_DESCRIPTION, (Object)db.getDescription());
            }
            ret.setAttribute(ATTRIBUTE_OWNER, (Object)db.getOwnerName());
            ret.setAttribute(ATTRIBUTE_CLUSTER_NAME, (Object)this.getMetadataNamespace());
            ret.setAttribute(ATTRIBUTE_LOCATION, (Object)HdfsNameServiceResolver.getPathWithNameServiceID((String)db.getLocationUri()));
            ret.setAttribute(ATTRIBUTE_PARAMETERS, (Object)db.getParameters());
            if (db.getOwnerType() != null) {
                ret.setAttribute(ATTRIBUTE_OWNER_TYPE, (Object)OWNER_TYPE_TO_ENUM_VALUE.get(db.getOwnerType().getValue()));
            }
            this.context.putEntity(dbQualifiedName, ret);
        }
        return ret;
    }

    protected AtlasEntity.AtlasEntityWithExtInfo toTableEntity(Table table) throws Exception {
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo();
        AtlasEntity entity = this.toTableEntity(table, (AtlasEntity.AtlasEntityExtInfo)ret);
        if (entity != null) {
            ret.setEntity(entity);
        } else {
            ret = null;
        }
        return ret;
    }

    protected AtlasEntity toTableEntity(Table table, AtlasEntity.AtlasEntitiesWithExtInfo entities) throws Exception {
        AtlasEntity ret = this.toTableEntity(table, (AtlasEntity.AtlasEntityExtInfo)entities);
        if (ret != null) {
            entities.addEntity(ret);
        }
        return ret;
    }

    protected AtlasEntity toTableEntity(Table table, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws Exception {
        Database db = this.getDatabases(table.getDbName());
        AtlasEntity dbEntity = this.toDbEntity(db);
        if (entityExtInfo != null && dbEntity != null) {
            entityExtInfo.addReferredEntity(dbEntity);
        }
        AtlasEntity ret = this.toTableEntity(AtlasTypeUtil.getObjectId((AtlasEntity)dbEntity), table, entityExtInfo);
        return ret;
    }

    protected AtlasEntity toTableEntity(AtlasObjectId dbId, Table table, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws Exception {
        String tblQualifiedName = this.getQualifiedName(table);
        boolean isKnownTable = this.context.isKnownTable(tblQualifiedName);
        AtlasEntity ret = this.context.getEntity(tblQualifiedName);
        if (ret == null) {
            HiveHook.PreprocessAction action = this.context.getPreprocessActionForHiveTable(tblQualifiedName);
            if (action == HiveHook.PreprocessAction.IGNORE) {
                LOG.info("ignoring table {}", (Object)tblQualifiedName);
            } else {
                boolean pruneTable;
                ret = new AtlasEntity(HIVE_TYPE_TABLE);
                if (isKnownTable && !this.isAlterTableOperation()) {
                    ret.setGuid(null);
                }
                long createTime = BaseHiveEvent.getTableCreateTime(table);
                long lastAccessTime = table.getLastAccessTime() > 0 ? (long)table.getLastAccessTime() * 1000L : createTime;
                AtlasRelatedObjectId dbRelatedObject = new AtlasRelatedObjectId(dbId, RELATIONSHIP_HIVE_TABLE_DB);
                ret.setRelationshipAttribute(ATTRIBUTE_DB, (Object)dbRelatedObject);
                ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)tblQualifiedName);
                ret.setAttribute(ATTRIBUTE_NAME, (Object)table.getTableName().toLowerCase());
                ret.setAttribute(ATTRIBUTE_OWNER, (Object)table.getOwner());
                ret.setAttribute(ATTRIBUTE_CREATE_TIME, (Object)createTime);
                ret.setAttribute(ATTRIBUTE_LAST_ACCESS_TIME, (Object)lastAccessTime);
                ret.setAttribute(ATTRIBUTE_RETENTION, (Object)table.getRetention());
                ret.setAttribute(ATTRIBUTE_PARAMETERS, (Object)table.getParameters());
                ret.setAttribute(ATTRIBUTE_COMMENT, table.getParameters().get(ATTRIBUTE_COMMENT));
                ret.setAttribute(ATTRIBUTE_TABLE_TYPE, (Object)table.getTableType().name());
                ret.setAttribute(ATTRIBUTE_TEMPORARY, (Object)table.isTemporary());
                if (table.getViewOriginalText() != null) {
                    ret.setAttribute(ATTRIBUTE_VIEW_ORIGINAL_TEXT, (Object)table.getViewOriginalText());
                }
                if (table.getViewExpandedText() != null) {
                    ret.setAttribute(ATTRIBUTE_VIEW_EXPANDED_TEXT, (Object)table.getViewExpandedText());
                }
                boolean bl = pruneTable = table.isTemporary() || action == HiveHook.PreprocessAction.PRUNE;
                if (pruneTable) {
                    LOG.info("ignoring details of table {}", (Object)tblQualifiedName);
                } else {
                    AtlasObjectId tableId = AtlasTypeUtil.getObjectId((AtlasEntity)ret);
                    AtlasEntity sd = this.getStorageDescEntity(tableId, table);
                    List<AtlasEntity> partitionKeys = this.getColumnEntities(tableId, table, table.getPartitionKeys(), RELATIONSHIP_HIVE_TABLE_PART_KEYS);
                    List<AtlasEntity> columns = this.getColumnEntities(tableId, table, table.getCols(), RELATIONSHIP_HIVE_TABLE_COLUMNS);
                    if (entityExtInfo != null) {
                        entityExtInfo.addReferredEntity(sd);
                        if (partitionKeys != null) {
                            for (AtlasEntity partitionKey : partitionKeys) {
                                entityExtInfo.addReferredEntity(partitionKey);
                            }
                        }
                        if (columns != null) {
                            for (AtlasEntity column : columns) {
                                entityExtInfo.addReferredEntity(column);
                            }
                        }
                    }
                    ret.setRelationshipAttribute(ATTRIBUTE_STORAGEDESC, (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)sd, (String)RELATIONSHIP_HIVE_TABLE_STORAGE_DESC));
                    ret.setRelationshipAttribute(ATTRIBUTE_PARTITION_KEYS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(partitionKeys, (String)RELATIONSHIP_HIVE_TABLE_PART_KEYS));
                    ret.setRelationshipAttribute(ATTRIBUTE_COLUMNS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(columns, (String)RELATIONSHIP_HIVE_TABLE_COLUMNS));
                }
                this.context.putEntity(tblQualifiedName, ret);
            }
        }
        return ret;
    }

    protected AtlasEntity getStorageDescEntity(AtlasObjectId tableId, Table table) {
        String sdQualifiedName = this.getQualifiedName(table, table.getSd());
        boolean isKnownTable = tableId.getGuid() == null;
        AtlasEntity ret = this.context.getEntity(sdQualifiedName);
        if (ret == null) {
            ret = new AtlasEntity(HIVE_TYPE_STORAGEDESC);
            if (isKnownTable) {
                ret.setGuid(null);
            }
            StorageDescriptor sd = table.getSd();
            AtlasRelatedObjectId tableRelatedObject = new AtlasRelatedObjectId(tableId, RELATIONSHIP_HIVE_TABLE_STORAGE_DESC);
            ret.setRelationshipAttribute(ATTRIBUTE_TABLE, (Object)tableRelatedObject);
            ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)sdQualifiedName);
            ret.setAttribute(ATTRIBUTE_PARAMETERS, (Object)sd.getParameters());
            ret.setAttribute(ATTRIBUTE_LOCATION, (Object)HdfsNameServiceResolver.getPathWithNameServiceID((String)sd.getLocation()));
            ret.setAttribute(ATTRIBUTE_INPUT_FORMAT, (Object)sd.getInputFormat());
            ret.setAttribute(ATTRIBUTE_OUTPUT_FORMAT, (Object)sd.getOutputFormat());
            ret.setAttribute(ATTRIBUTE_COMPRESSED, (Object)sd.isCompressed());
            ret.setAttribute(ATTRIBUTE_NUM_BUCKETS, (Object)sd.getNumBuckets());
            ret.setAttribute(ATTRIBUTE_STORED_AS_SUB_DIRECTORIES, (Object)sd.isStoredAsSubDirectories());
            if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
                ret.setAttribute(ATTRIBUTE_BUCKET_COLS, (Object)sd.getBucketCols());
            }
            if (sd.getSerdeInfo() != null) {
                AtlasStruct serdeInfo = new AtlasStruct(HIVE_TYPE_SERDE);
                SerDeInfo sdSerDeInfo = sd.getSerdeInfo();
                serdeInfo.setAttribute(ATTRIBUTE_NAME, (Object)sdSerDeInfo.getName());
                serdeInfo.setAttribute(ATTRIBUTE_SERIALIZATION_LIB, (Object)sdSerDeInfo.getSerializationLib());
                serdeInfo.setAttribute(ATTRIBUTE_PARAMETERS, (Object)sdSerDeInfo.getParameters());
                ret.setAttribute(ATTRIBUTE_SERDE_INFO, (Object)serdeInfo);
            }
            if (CollectionUtils.isNotEmpty((Collection)sd.getSortCols())) {
                ArrayList<AtlasStruct> sortCols = new ArrayList<AtlasStruct>(sd.getSortCols().size());
                for (Order sdSortCol : sd.getSortCols()) {
                    AtlasStruct sortcol = new AtlasStruct(HIVE_TYPE_ORDER);
                    sortcol.setAttribute("col", (Object)sdSortCol.getCol());
                    sortcol.setAttribute("order", (Object)sdSortCol.getOrder());
                    sortCols.add(sortcol);
                }
                ret.setAttribute(ATTRIBUTE_SORT_COLS, sortCols);
            }
            this.context.putEntity(sdQualifiedName, ret);
        }
        return ret;
    }

    protected List<AtlasEntity> getColumnEntities(AtlasObjectId tableId, Table table, List<FieldSchema> fieldSchemas, String relationshipType) {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        boolean isKnownTable = tableId.getGuid() == null;
        int columnPosition = 0;
        if (CollectionUtils.isNotEmpty(fieldSchemas)) {
            for (FieldSchema fieldSchema : fieldSchemas) {
                String colQualifiedName = this.getQualifiedName(table, fieldSchema);
                AtlasEntity column = this.context.getEntity(colQualifiedName);
                if (column == null) {
                    column = new AtlasEntity(HIVE_TYPE_COLUMN);
                    if (isKnownTable) {
                        column.setGuid(null);
                    }
                    AtlasRelatedObjectId relatedObjectId = new AtlasRelatedObjectId(tableId, relationshipType);
                    column.setRelationshipAttribute(ATTRIBUTE_TABLE, (Object)relatedObjectId);
                    column.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)colQualifiedName);
                    column.setAttribute(ATTRIBUTE_NAME, (Object)fieldSchema.getName());
                    column.setAttribute(ATTRIBUTE_OWNER, (Object)table.getOwner());
                    column.setAttribute(ATTRIBUTE_COL_TYPE, (Object)fieldSchema.getType());
                    column.setAttribute(ATTRIBUTE_COL_POSITION, (Object)columnPosition++);
                    column.setAttribute(ATTRIBUTE_COMMENT, (Object)fieldSchema.getComment());
                    this.context.putEntity(colQualifiedName, column);
                }
                ret.add(column);
            }
        }
        return ret;
    }

    protected AtlasEntity getPathEntity(Path path, AtlasEntity.AtlasEntityExtInfo extInfo) {
        String strPath = path.toString();
        String metadataNamespace = this.getMetadataNamespace();
        boolean isConvertPathToLowerCase = strPath.startsWith(HDFS_PATH_PREFIX) && this.context.isConvertHdfsPathToLowerCase();
        PathExtractorContext pathExtractorContext = new PathExtractorContext(metadataNamespace, this.context.getQNameToEntityMap(), isConvertPathToLowerCase, this.context.getAwsS3AtlasModelVersion());
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)pathExtractorContext);
        if (entityWithExtInfo.getReferredEntities() != null) {
            for (AtlasEntity entity : entityWithExtInfo.getReferredEntities().values()) {
                extInfo.addReferredEntity(entity);
            }
        }
        return entityWithExtInfo.getEntity();
    }

    protected AtlasEntity getHiveProcessEntity(List<AtlasEntity> inputs, List<AtlasEntity> outputs) throws Exception {
        HiveOperation operation;
        AtlasEntity ret = new AtlasEntity(HIVE_TYPE_PROCESS);
        String queryStr = this.getQueryString();
        String qualifiedName = this.getQualifiedName(inputs, outputs);
        if (queryStr != null) {
            queryStr = queryStr.toLowerCase().trim();
        }
        ret.setAttribute(ATTRIBUTE_OPERATION_TYPE, (Object)this.getOperationName());
        if (this.context.isMetastoreHook() && ((operation = this.context.getHiveOperation()) == HiveOperation.CREATETABLE || operation == HiveOperation.CREATETABLE_AS_SELECT)) {
            AtlasEntity table = outputs.get(0);
            long createTime = (Long)table.getAttribute(ATTRIBUTE_CREATE_TIME);
            qualifiedName = (String)table.getAttribute(ATTRIBUTE_QUALIFIED_NAME) + ':' + createTime;
            ret.setAttribute(ATTRIBUTE_NAME, (Object)("dummyProcess:" + UUID.randomUUID()));
            ret.setAttribute(ATTRIBUTE_OPERATION_TYPE, (Object)operation.getOperationName());
        }
        ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)qualifiedName);
        ret.setAttribute(ATTRIBUTE_NAME, (Object)qualifiedName);
        ret.setRelationshipAttribute(ATTRIBUTE_INPUTS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(inputs, (String)RELATIONSHIP_DATASET_PROCESS_INPUTS));
        ret.setRelationshipAttribute(ATTRIBUTE_OUTPUTS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(outputs, (String)RELATIONSHIP_PROCESS_DATASET_OUTPUTS));
        ret.setAttribute(ATTRIBUTE_START_TIME, (Object)System.currentTimeMillis());
        ret.setAttribute(ATTRIBUTE_END_TIME, (Object)System.currentTimeMillis());
        if (this.context.isHiveProcessPopulateDeprecatedAttributes()) {
            ret.setAttribute(ATTRIBUTE_USER_NAME, (Object)this.getUserName());
            ret.setAttribute(ATTRIBUTE_QUERY_TEXT, (Object)(StringUtils.isNotEmpty((CharSequence)queryStr) ? queryStr : EMPTY_ATTRIBUTE_VALUE));
            ret.setAttribute(ATTRIBUTE_QUERY_ID, (Object)(StringUtils.isNotEmpty((CharSequence)this.getQueryId()) ? this.getQueryId() : EMPTY_ATTRIBUTE_VALUE));
        } else {
            ret.setAttribute(ATTRIBUTE_USER_NAME, (Object)EMPTY_ATTRIBUTE_VALUE);
            ret.setAttribute(ATTRIBUTE_QUERY_TEXT, (Object)EMPTY_ATTRIBUTE_VALUE);
            ret.setAttribute(ATTRIBUTE_QUERY_ID, (Object)EMPTY_ATTRIBUTE_VALUE);
        }
        ret.setAttribute(ATTRIBUTE_QUERY_PLAN, (Object)"Not Supported");
        ret.setAttribute(ATTRIBUTE_RECENT_QUERIES, Collections.singletonList(queryStr));
        ret.setAttribute(ATTRIBUTE_CLUSTER_NAME, (Object)this.getMetadataNamespace());
        return ret;
    }

    protected AtlasEntity getHiveProcessExecutionEntity(AtlasEntity hiveProcess) throws Exception {
        AtlasEntity ret = new AtlasEntity(HIVE_TYPE_PROCESS_EXECUTION);
        String queryStr = this.getQueryString();
        if (queryStr != null) {
            queryStr = queryStr.toLowerCase().trim();
        }
        Long endTime = System.currentTimeMillis();
        ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)(hiveProcess.getAttribute(ATTRIBUTE_QUALIFIED_NAME).toString() + ':' + this.getQueryStartTime().toString() + ':' + endTime.toString()));
        ret.setAttribute(ATTRIBUTE_NAME, ret.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
        ret.setAttribute(ATTRIBUTE_START_TIME, (Object)this.getQueryStartTime());
        ret.setAttribute(ATTRIBUTE_END_TIME, (Object)endTime);
        ret.setAttribute(ATTRIBUTE_USER_NAME, (Object)this.getUserName());
        ret.setAttribute(ATTRIBUTE_QUERY_TEXT, (Object)queryStr);
        ret.setAttribute(ATTRIBUTE_QUERY_ID, (Object)this.getQueryId());
        ret.setAttribute(ATTRIBUTE_QUERY_PLAN, (Object)"Not Supported");
        ret.setAttribute(ATTRIBUTE_HOSTNAME, (Object)this.getContext().getHostName());
        AtlasRelatedObjectId hiveProcessRelationObjectId = AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)hiveProcess, (String)RELATIONSHIP_HIVE_PROCESS_PROCESS_EXE);
        ret.setRelationshipAttribute(ATTRIBUTE_PROCESS, (Object)hiveProcessRelationObjectId);
        return ret;
    }

    protected AtlasEntity createHiveDDLEntity(AtlasEntity dbOrTable) {
        return this.createHiveDDLEntity(dbOrTable, false);
    }

    protected AtlasEntity createHiveDDLEntity(AtlasEntity dbOrTable, boolean excludeEntityGuid) {
        AtlasObjectId objId = AtlasTypeUtil.getObjectId((AtlasEntity)dbOrTable);
        AtlasEntity hiveDDL = null;
        if (excludeEntityGuid) {
            objId.setGuid(null);
        }
        AtlasRelatedObjectId objIdRelatedObject = new AtlasRelatedObjectId(objId);
        if (StringUtils.equals((CharSequence)objId.getTypeName(), (CharSequence)HIVE_TYPE_DB)) {
            hiveDDL = new AtlasEntity(HIVE_DB_DDL);
            objIdRelatedObject.setRelationshipType(RELATIONSHIP_HIVE_DB_DDL_QUERIES);
            hiveDDL.setRelationshipAttribute(ATTRIBUTE_DB, (Object)objIdRelatedObject);
        } else if (StringUtils.equals((CharSequence)objId.getTypeName(), (CharSequence)HIVE_TYPE_TABLE)) {
            hiveDDL = new AtlasEntity(HIVE_TABLE_DDL);
            objIdRelatedObject.setRelationshipType(RELATIONSHIP_HIVE_TABLE_DDL_QUERIES);
            hiveDDL.setRelationshipAttribute(ATTRIBUTE_TABLE, (Object)objIdRelatedObject);
        }
        if (hiveDDL != null) {
            hiveDDL.setAttribute(ATTRIBUTE_SERVICE_TYPE, (Object)"hive");
            hiveDDL.setAttribute(ATTRIBUTE_EXEC_TIME, (Object)this.getQueryStartTime());
            hiveDDL.setAttribute(ATTRIBUTE_QUERY_TEXT, (Object)this.getQueryString());
            hiveDDL.setAttribute(ATTRIBUTE_USER_NAME, (Object)this.getUserName());
            hiveDDL.setAttribute(ATTRIBUTE_NAME, (Object)this.getQueryString());
            hiveDDL.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)(dbOrTable.getAttribute(ATTRIBUTE_QUALIFIED_NAME).toString() + ':' + this.getQueryStartTime().toString()));
        }
        return hiveDDL;
    }

    protected AtlasEntity createHiveLocationEntity(AtlasEntity dbEntity, AtlasEntity.AtlasEntitiesWithExtInfo extInfoEntity) {
        AtlasEntity ret = null;
        String locationUri = (String)dbEntity.getAttribute(ATTRIBUTE_LOCATION);
        if (StringUtils.isNotEmpty((CharSequence)locationUri)) {
            Path path = null;
            try {
                path = new Path(locationUri);
            }
            catch (IllegalArgumentException excp) {
                LOG.warn("failed to create Path from locationUri {}", (Object)locationUri, (Object)excp);
            }
            if (path != null && (ret = this.getPathEntity(path, (AtlasEntity.AtlasEntityExtInfo)extInfoEntity)) != null) {
                AtlasRelatedObjectId dbRelatedObjectId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)dbEntity, (String)RELATIONSHIP_HIVE_DB_LOCATION);
                ret.setRelationshipAttribute(ATTRIBUTE_HIVE_DB, (Object)dbRelatedObjectId);
            }
        }
        return ret;
    }

    protected String getMetadataNamespace() {
        return this.context.getMetadataNamespace();
    }

    protected Database getDatabases(String dbName) throws Exception {
        return this.context.isMetastoreHook() ? this.context.getMetastoreHandler().get_database(dbName) : this.context.getHive().getDatabase(dbName);
    }

    protected Hive getHive() {
        return this.context.getHive();
    }

    protected Set<ReadEntity> getInputs() {
        return this.context != null ? this.context.getInputs() : Collections.emptySet();
    }

    protected Set<WriteEntity> getOutputs() {
        return this.context != null ? this.context.getOutputs() : Collections.emptySet();
    }

    protected LineageInfo getLineageInfo() {
        return this.context != null ? this.context.getLineageInfo() : null;
    }

    protected String getQueryString() {
        return this.isHiveContextValid() ? this.context.getHiveContext().getQueryPlan().getQueryStr() : null;
    }

    protected String getOperationName() {
        return this.isHiveContextValid() ? this.context.getHiveContext().getOperationName() : null;
    }

    protected String getHiveUserName() {
        return this.isHiveContextValid() ? this.context.getHiveContext().getUserName() : null;
    }

    protected UserGroupInformation getUgi() {
        return this.isHiveContextValid() ? this.context.getHiveContext().getUgi() : null;
    }

    protected Long getQueryStartTime() {
        Long queryStartTime = null;
        if (this.isHiveContextValid() && this.context.getHiveContext().getQueryPlan() != null) {
            queryStartTime = this.context.getHiveContext().getQueryPlan().getQueryStartTime();
        }
        return queryStartTime == null ? System.currentTimeMillis() : queryStartTime;
    }

    protected String getQueryId() {
        return this.isHiveContextValid() ? this.context.getHiveContext().getQueryPlan().getQueryId() : null;
    }

    private boolean isHiveContextValid() {
        return this.context != null && this.context.getHiveContext() != null;
    }

    protected String getUserName() {
        String ret = null;
        UserGroupInformation ugi = null;
        if (this.context.isMetastoreHook()) {
            try {
                ugi = SecurityUtils.getUGI();
            }
            catch (Exception exception) {}
        } else {
            ret = this.getHiveUserName();
            if (StringUtils.isEmpty((CharSequence)ret)) {
                ugi = this.getUgi();
            }
        }
        if (ugi != null) {
            ret = ugi.getShortUserName();
        }
        if (StringUtils.isEmpty((CharSequence)ret)) {
            try {
                ret = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                LOG.warn("Failed for UserGroupInformation.getCurrentUser() ", (Throwable)e);
                ret = System.getProperty("user.name");
            }
        }
        return ret;
    }

    protected String getQualifiedName(Entity entity) throws Exception {
        switch (entity.getType()) {
            case DATABASE: {
                return this.getQualifiedName(entity.getDatabase());
            }
            case TABLE: 
            case PARTITION: {
                return this.getQualifiedName(entity.getTable());
            }
            case DFS_DIR: 
            case LOCAL_DIR: {
                return this.getQualifiedName(entity.getLocation());
            }
        }
        return null;
    }

    protected String getQualifiedName(Database db) {
        return this.context.getQualifiedName(db);
    }

    protected String getQualifiedName(Table table) {
        return this.context.getQualifiedName(table);
    }

    protected String getQualifiedName(Table table, StorageDescriptor sd) {
        return this.getQualifiedName(table) + "_storage";
    }

    protected String getQualifiedName(Table table, FieldSchema column) {
        String tblQualifiedName = this.getQualifiedName(table);
        int sepPos = tblQualifiedName.lastIndexOf(64);
        if (sepPos == -1) {
            return tblQualifiedName + '.' + column.getName().toLowerCase();
        }
        return tblQualifiedName.substring(0, sepPos) + '.' + column.getName().toLowerCase() + tblQualifiedName.substring(sepPos);
    }

    protected String getQualifiedName(LineageInfo.DependencyKey column) {
        String dbName = column.getDataContainer().getTable().getDbName();
        String tableName = column.getDataContainer().getTable().getTableName();
        String colName = column.getFieldSchema().getName();
        return this.getQualifiedName(dbName, tableName, colName);
    }

    protected String getQualifiedName(LineageInfo.BaseColumnInfo column) {
        String dbName = column.getTabAlias().getTable().getDbName();
        String tableName = column.getTabAlias().getTable().getTableName();
        String colName = column.getColumn() != null ? column.getColumn().getName() : null;
        String metadataNamespace = this.getMetadataNamespace();
        if (colName == null) {
            return (dbName + '.' + tableName + '@').toLowerCase() + metadataNamespace;
        }
        return (dbName + '.' + tableName + '.' + colName + '@').toLowerCase() + metadataNamespace;
    }

    protected String getQualifiedName(String dbName, String tableName, String colName) {
        return (dbName + '.' + tableName + '.' + colName + '@').toLowerCase() + this.getMetadataNamespace();
    }

    protected String getQualifiedName(URI location) {
        String nameServiceID;
        String strPath = new Path(location).toString();
        if (strPath.startsWith(HDFS_PATH_PREFIX) && this.context.isConvertHdfsPathToLowerCase()) {
            strPath = strPath.toLowerCase();
        }
        String attrPath = StringUtils.isEmpty((CharSequence)(nameServiceID = HdfsNameServiceResolver.getNameServiceIDForPath((String)strPath))) ? strPath : HdfsNameServiceResolver.getPathWithNameServiceID((String)strPath);
        return this.getQualifiedName(attrPath);
    }

    protected String getQualifiedName(String path) {
        if (path.startsWith(HDFS_PATH_PREFIX)) {
            return path + '@' + this.getMetadataNamespace();
        }
        return path.toLowerCase();
    }

    protected String getColumnQualifiedName(String tblQualifiedName, String columnName) {
        int sepPos = tblQualifiedName.lastIndexOf(64);
        if (sepPos == -1) {
            return tblQualifiedName + '.' + columnName.toLowerCase();
        }
        return tblQualifiedName.substring(0, sepPos) + '.' + columnName.toLowerCase() + tblQualifiedName.substring(sepPos);
    }

    protected String getQualifiedName(List<AtlasEntity> inputs, List<AtlasEntity> outputs) throws Exception {
        HiveOperation operation = this.context.getHiveOperation();
        if (operation == HiveOperation.CREATETABLE || operation == HiveOperation.CREATETABLE_AS_SELECT || operation == HiveOperation.CREATEVIEW || operation == HiveOperation.ALTERVIEW_AS || operation == HiveOperation.ALTERTABLE_LOCATION) {
            ArrayList<WriteEntity> sortedEntities = new ArrayList<WriteEntity>(this.getOutputs());
            Collections.sort(sortedEntities, entityComparator);
            for (Entity entity : sortedEntities) {
                if (entity.getType() != Entity.Type.TABLE) continue;
                Table table = entity.getTable();
                table = this.getHive().getTable(table.getDbName(), table.getTableName());
                long createTime = BaseHiveEvent.getTableCreateTime(table);
                return this.getQualifiedName(table) + ':' + createTime;
            }
        }
        String qualifiedName = null;
        String operationName = this.getOperationName();
        if (operationName != null) {
            StringBuilder stringBuilder = new StringBuilder(operationName);
            boolean ignoreHDFSPaths = this.ignoreHDFSPathsinProcessQualifiedName();
            this.addToProcessQualifiedName(stringBuilder, this.getInputs(), ignoreHDFSPaths);
            stringBuilder.append("->");
            this.addToProcessQualifiedName(stringBuilder, this.getOutputs(), ignoreHDFSPaths);
            qualifiedName = stringBuilder.toString();
        }
        return qualifiedName;
    }

    protected AtlasEntity toReferencedHBaseTable(Table table, AtlasEntity.AtlasEntitiesWithExtInfo entities) {
        AtlasEntity ret = null;
        HBaseTableInfo hBaseTableInfo = new HBaseTableInfo(table);
        String hbaseNameSpace = hBaseTableInfo.getHbaseNameSpace();
        String hbaseTableName = hBaseTableInfo.getHbaseTableName();
        String metadataNamespace = this.getMetadataNamespace();
        if (hbaseTableName != null) {
            AtlasEntity nsEntity = new AtlasEntity(HBASE_TYPE_NAMESPACE);
            nsEntity.setAttribute(ATTRIBUTE_NAME, (Object)hbaseNameSpace);
            nsEntity.setAttribute(ATTRIBUTE_CLUSTER_NAME, (Object)metadataNamespace);
            nsEntity.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)BaseHiveEvent.getHBaseNameSpaceQualifiedName(metadataNamespace, hbaseNameSpace));
            ret = new AtlasEntity(HBASE_TYPE_TABLE);
            ret.setAttribute(ATTRIBUTE_NAME, (Object)hbaseTableName);
            ret.setAttribute(ATTRIBUTE_URI, (Object)hbaseTableName);
            AtlasRelatedObjectId objIdRelatedObject = new AtlasRelatedObjectId(AtlasTypeUtil.getObjectId((AtlasEntity)nsEntity), RELATIONSHIP_HBASE_TABLE_NAMESPACE);
            ret.setRelationshipAttribute(ATTRIBUTE_NAMESPACE, (Object)objIdRelatedObject);
            ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)BaseHiveEvent.getHBaseTableQualifiedName(metadataNamespace, hbaseNameSpace, hbaseTableName));
            entities.addReferredEntity(nsEntity);
            entities.addEntity(ret);
        }
        return ret;
    }

    protected boolean isHBaseStore(Table table) {
        boolean ret = false;
        Map parameters = table.getParameters();
        if (MapUtils.isNotEmpty((Map)parameters)) {
            String storageHandler = (String)parameters.get(ATTRIBUTE_STORAGE_HANDLER);
            ret = storageHandler != null && storageHandler.equals(HBASE_STORAGE_HANDLER_CLASS);
        }
        return ret;
    }

    private static String getHBaseTableQualifiedName(String metadataNamespace, String nameSpace, String tableName) {
        return String.format("%s:%s@%s", nameSpace.toLowerCase(), tableName.toLowerCase(), metadataNamespace);
    }

    private static String getHBaseNameSpaceQualifiedName(String metadataNamespace, String nameSpace) {
        return String.format("%s@%s", nameSpace.toLowerCase(), metadataNamespace);
    }

    private boolean ignoreHDFSPathsinProcessQualifiedName() {
        switch (this.context.getHiveOperation()) {
            case LOAD: 
            case IMPORT: {
                return this.hasPartitionEntity(this.getOutputs());
            }
            case EXPORT: {
                return this.hasPartitionEntity(this.getInputs());
            }
            case QUERY: {
                return true;
            }
        }
        return false;
    }

    private boolean hasPartitionEntity(Collection<? extends Entity> entities) {
        if (entities != null) {
            for (Entity entity : entities) {
                if (entity.getType() != Entity.Type.PARTITION) continue;
                return true;
            }
        }
        return false;
    }

    private void addToProcessQualifiedName(StringBuilder processQualifiedName, Collection<? extends Entity> entities, boolean ignoreHDFSPaths) {
        if (entities == null) {
            return;
        }
        ArrayList<? extends Entity> sortedEntities = new ArrayList<Entity>(entities);
        Collections.sort(sortedEntities, entityComparator);
        HashSet<String> dataSetsProcessed = new HashSet<String>();
        HashMap<String, Table> tableMap = new HashMap<String, Table>();
        for (Entity entity : sortedEntities) {
            WriteEntity writeEntity;
            if (ignoreHDFSPaths && (Entity.Type.DFS_DIR.equals((Object)entity.getType()) || Entity.Type.LOCAL_DIR.equals((Object)entity.getType()))) continue;
            String qualifiedName = null;
            long createTime = 0L;
            try {
                if (entity.getType() == Entity.Type.PARTITION || entity.getType() == Entity.Type.TABLE) {
                    String tableKey = entity.getTable().getDbName() + "." + entity.getTable().getTableName();
                    Table table = (Table)tableMap.get(tableKey);
                    if (table == null) {
                        table = this.getHive().getTable(entity.getTable().getDbName(), entity.getTable().getTableName());
                        tableMap.put(tableKey, table);
                    }
                    if (table != null) {
                        createTime = BaseHiveEvent.getTableCreateTime(table);
                        qualifiedName = this.getQualifiedName(table);
                    }
                } else {
                    qualifiedName = this.getQualifiedName(entity);
                }
            }
            catch (Exception excp) {
                LOG.error("error while computing qualifiedName for process", (Throwable)excp);
            }
            if (qualifiedName == null || !dataSetsProcessed.add(qualifiedName)) continue;
            if (entity instanceof WriteEntity && (writeEntity = (WriteEntity)entity).getWriteType() != null && HiveOperation.QUERY.equals((Object)this.context.getHiveOperation())) {
                boolean addWriteType = false;
                switch (((WriteEntity)entity).getWriteType()) {
                    case INSERT: 
                    case INSERT_OVERWRITE: 
                    case UPDATE: 
                    case DELETE: {
                        addWriteType = true;
                        break;
                    }
                    case PATH_WRITE: {
                        boolean bl = addWriteType = !Entity.Type.LOCAL_DIR.equals((Object)entity.getType());
                    }
                }
                if (addWriteType) {
                    processQualifiedName.append(':').append(writeEntity.getWriteType().name());
                }
            }
            processQualifiedName.append(':').append(qualifiedName.toLowerCase().replaceAll("/", EMPTY_ATTRIBUTE_VALUE));
            if (createTime == 0L) continue;
            processQualifiedName.append(':').append(createTime);
        }
    }

    private boolean isAlterTableOperation() {
        switch (this.context.getHiveOperation()) {
            case ALTERTABLE_FILEFORMAT: 
            case ALTERTABLE_CLUSTER_SORT: 
            case ALTERTABLE_BUCKETNUM: 
            case ALTERTABLE_PROPERTIES: 
            case ALTERTABLE_SERDEPROPERTIES: 
            case ALTERTABLE_SERIALIZER: 
            case ALTERTABLE_ADDCOLS: 
            case ALTERTABLE_REPLACECOLS: 
            case ALTERTABLE_PARTCOLTYPE: 
            case ALTERTABLE_LOCATION: 
            case ALTERTABLE_RENAME: 
            case ALTERTABLE_RENAMECOL: 
            case ALTERVIEW_PROPERTIES: 
            case ALTERVIEW_RENAME: 
            case ALTERVIEW_AS: {
                return true;
            }
        }
        return false;
    }

    public static Table toTable(org.apache.hadoop.hive.metastore.api.Table table) {
        return new Table(table);
    }

    static {
        OWNER_TYPE_TO_ENUM_VALUE.put(1, "USER");
        OWNER_TYPE_TO_ENUM_VALUE.put(2, "ROLE");
        OWNER_TYPE_TO_ENUM_VALUE.put(3, "GROUP");
        entityComparator = new EntityComparator();
    }

    static final class HBaseTableInfo {
        String hbaseNameSpace = null;
        String hbaseTableName = null;

        HBaseTableInfo(Table table) {
            Map parameters = table.getParameters();
            if (MapUtils.isNotEmpty((Map)parameters)) {
                String[] hbaseTableInfo;
                this.hbaseNameSpace = BaseHiveEvent.HBASE_DEFAULT_NAMESPACE;
                this.hbaseTableName = (String)parameters.get(BaseHiveEvent.HBASE_PARAM_TABLE_NAME);
                if (this.hbaseTableName != null && this.hbaseTableName.contains(BaseHiveEvent.HBASE_NAMESPACE_TABLE_DELIMITER) && (hbaseTableInfo = this.hbaseTableName.split(BaseHiveEvent.HBASE_NAMESPACE_TABLE_DELIMITER)).length > 1) {
                    this.hbaseNameSpace = hbaseTableInfo[0];
                    this.hbaseTableName = hbaseTableInfo[1];
                }
            }
        }

        public String getHbaseNameSpace() {
            return this.hbaseNameSpace;
        }

        public String getHbaseTableName() {
            return this.hbaseTableName;
        }
    }

    static final class EntityComparator
    implements Comparator<Entity> {
        EntityComparator() {
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            String name1 = entity1.getName();
            String name2 = entity2.getName();
            if (name1 == null || name2 == null) {
                name1 = entity1.getD().toString();
                name2 = entity2.getD().toString();
            }
            return name1.toLowerCase().compareTo(name2.toLowerCase());
        }
    }
}

