/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridge;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDatabase
extends BaseHiveEvent {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDatabase.class);

    public CreateDatabase(AtlasHiveHookContext context) {
        super(context);
    }

    @Override
    public List<HookNotification> getNotificationMessages() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo entities;
        List<HookNotification.EntityCreateRequestV2> ret = null;
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = entities = this.context.isMetastoreHook() ? this.getHiveMetastoreEntities() : this.getHiveEntities();
        if (entities != null && CollectionUtils.isNotEmpty((Collection)entities.getEntities())) {
            ret = Collections.singletonList(new HookNotification.EntityCreateRequestV2(this.getUserName(), entities));
        }
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getHiveMetastoreEntities() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        CreateDatabaseEvent dbEvent = (CreateDatabaseEvent)this.context.getMetastoreEvent();
        Database db = dbEvent.getDatabase();
        if (db != null) {
            db = this.context.getMetastoreHandler().get_database(db.getName());
        }
        if (db != null) {
            AtlasEntity dbEntity = this.toDbEntity(db);
            ret.addEntity(dbEntity);
            this.addLocationEntities(dbEntity, ret);
        } else {
            LOG.error("CreateDatabase.getEntities(): failed to retrieve db");
        }
        this.addProcessedEntities(ret);
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getHiveEntities() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        for (Entity entity : this.getOutputs()) {
            if (entity.getType() != Entity.Type.DATABASE) continue;
            Database db = entity.getDatabase();
            if (db != null) {
                db = this.getHive().getDatabase(HiveMetaStoreBridge.getDatabaseName(db));
            }
            if (db != null) {
                AtlasEntity dbEntity = this.toDbEntity(db);
                AtlasEntity dbDDLEntity = this.createHiveDDLEntity(dbEntity);
                ret.addEntity(dbEntity);
                if (dbDDLEntity != null) {
                    ret.addEntity(dbDDLEntity);
                }
                this.addLocationEntities(dbEntity, ret);
                continue;
            }
            LOG.error("CreateDatabase.getEntities(): failed to retrieve db");
        }
        this.addProcessedEntities(ret);
        return ret;
    }

    public void addLocationEntities(AtlasEntity dbEntity, AtlasEntity.AtlasEntitiesWithExtInfo ret) {
        AtlasEntity dbLocationEntity = this.createHiveLocationEntity(dbEntity, ret);
        if (dbLocationEntity != null) {
            ret.addEntity(dbLocationEntity);
        }
    }
}

