/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateHiveProcess
extends BaseHiveEvent {
    private static final Logger LOG = LoggerFactory.getLogger(CreateHiveProcess.class);

    public CreateHiveProcess(AtlasHiveHookContext context) {
        super(context);
    }

    @Override
    public List<HookNotification> getNotificationMessages() throws Exception {
        List<HookNotification.EntityCreateRequestV2> ret = null;
        AtlasEntity.AtlasEntitiesWithExtInfo entities = this.getEntities();
        if (entities != null && CollectionUtils.isNotEmpty((Collection)entities.getEntities())) {
            ret = Collections.singletonList(new HookNotification.EntityCreateRequestV2(this.getUserName(), entities));
        }
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntities() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = null;
        if (!this.skipProcess()) {
            boolean skipProcess;
            AtlasEntity entity;
            String qualifiedName;
            ArrayList<AtlasEntity> inputs = new ArrayList<AtlasEntity>();
            ArrayList<AtlasEntity> outputs = new ArrayList<AtlasEntity>();
            HashSet<String> processedNames = new HashSet<String>();
            ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
            if (this.getInputs() != null) {
                for (ReadEntity input : this.getInputs()) {
                    qualifiedName = this.getQualifiedName((Entity)input);
                    if (qualifiedName == null || !processedNames.add(qualifiedName)) continue;
                    entity = this.getInputOutputEntity((Entity)input, (AtlasEntity.AtlasEntityExtInfo)ret, this.skipTempTables);
                    if (!input.isDirect() || entity == null) continue;
                    inputs.add(entity);
                }
            }
            if (this.getOutputs() != null) {
                for (WriteEntity output : this.getOutputs()) {
                    AtlasEntity ddlEntity;
                    qualifiedName = this.getQualifiedName((Entity)output);
                    if (qualifiedName == null || !processedNames.add(qualifiedName)) continue;
                    entity = this.getInputOutputEntity((Entity)output, (AtlasEntity.AtlasEntityExtInfo)ret, this.skipTempTables);
                    if (entity != null) {
                        outputs.add(entity);
                    }
                    if (!this.isDdlOperation(entity) || (ddlEntity = this.createHiveDDLEntity(entity)) == null) continue;
                    ret.addEntity(ddlEntity);
                }
            }
            boolean bl = skipProcess = inputs.isEmpty() && outputs.isEmpty();
            if (!skipProcess) {
                if (inputs.isEmpty() && this.context.isSkippedInputEntity()) {
                    skipProcess = true;
                } else if (outputs.isEmpty() && this.context.isSkippedOutputEntity()) {
                    skipProcess = true;
                }
            }
            if (!skipProcess && !this.context.isMetastoreHook()) {
                AtlasEntity process = this.getHiveProcessEntity(inputs, outputs);
                ret.addEntity(process);
                AtlasEntity processExecution = this.getHiveProcessExecutionEntity(process);
                ret.addEntity(processExecution);
                this.processColumnLineage(process, ret);
                this.addProcessedEntities(ret);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    private void processColumnLineage(AtlasEntity hiveProcess, AtlasEntity.AtlasEntitiesWithExtInfo entities) {
        boolean skipColumnLineage;
        LineageInfo lineageInfo = this.getLineageInfo();
        if (lineageInfo == null || CollectionUtils.isEmpty((Collection)lineageInfo.entrySet())) {
            return;
        }
        ArrayList<AtlasEntity> columnLineages = new ArrayList<AtlasEntity>();
        int lineageInputsCount = 0;
        HashSet<String> processedOutputCols = new HashSet<String>();
        for (Map.Entry entry : lineageInfo.entrySet()) {
            String outputColName = this.getQualifiedName((LineageInfo.DependencyKey)entry.getKey());
            AtlasEntity outputColumn = this.context.getEntity(outputColName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("processColumnLineage(): DependencyKey={}; Dependency={}", entry.getKey(), entry.getValue());
            }
            if (outputColumn == null) {
                LOG.warn("column-lineage: non-existing output-column {}", (Object)outputColName);
                continue;
            }
            if (processedOutputCols.contains(outputColName)) {
                LOG.warn("column-lineage: duplicate for output-column {}", (Object)outputColName);
                continue;
            }
            processedOutputCols.add(outputColName);
            ArrayList<AtlasEntity> inputColumns = new ArrayList<AtlasEntity>();
            for (LineageInfo.BaseColumnInfo baseColumn : this.getBaseCols((LineageInfo.Dependency)entry.getValue())) {
                String inputColName = this.getQualifiedName(baseColumn);
                AtlasEntity inputColumn = this.context.getEntity(inputColName);
                if (inputColumn == null) {
                    LOG.warn("column-lineage: non-existing input-column {} for output-column={}", (Object)inputColName, (Object)outputColName);
                    continue;
                }
                inputColumns.add(inputColumn);
            }
            if (inputColumns.isEmpty()) continue;
            lineageInputsCount += inputColumns.size();
            AtlasEntity columnLineageProcess = new AtlasEntity("hive_column_lineage");
            columnLineageProcess.setAttribute("name", (Object)(hiveProcess.getAttribute("qualifiedName") + ":" + outputColumn.getAttribute("name")));
            columnLineageProcess.setAttribute("qualifiedName", (Object)(hiveProcess.getAttribute("qualifiedName") + ":" + outputColumn.getAttribute("name")));
            columnLineageProcess.setRelationshipAttribute("inputs", (Object)AtlasTypeUtil.getAtlasRelatedObjectIds(inputColumns, (String)"dataset_process_inputs"));
            columnLineageProcess.setRelationshipAttribute("outputs", Collections.singletonList(AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)outputColumn, (String)"process_dataset_outputs")));
            columnLineageProcess.setRelationshipAttribute("query", (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)hiveProcess, (String)"hive_process_column_lineage"));
            columnLineageProcess.setAttribute("depenendencyType", (Object)((LineageInfo.Dependency)entry.getValue()).getType());
            columnLineageProcess.setAttribute("expression", (Object)((LineageInfo.Dependency)entry.getValue()).getExpr());
            columnLineages.add(columnLineageProcess);
        }
        float avgInputsCount = columnLineages.size() > 0 ? (float)lineageInputsCount / (float)columnLineages.size() : 0.0f;
        boolean bl = skipColumnLineage = this.context.getSkipHiveColumnLineageHive20633() && avgInputsCount > (float)this.context.getSkipHiveColumnLineageHive20633InputsThreshold();
        if (!skipColumnLineage) {
            for (AtlasEntity columnLineage : columnLineages) {
                entities.addEntity(columnLineage);
            }
        } else {
            LOG.warn("skipped {} hive_column_lineage entities. Average # of inputs={}, threshold={}, total # of inputs={}", new Object[]{columnLineages.size(), Float.valueOf(avgInputsCount), this.context.getSkipHiveColumnLineageHive20633InputsThreshold(), lineageInputsCount});
        }
    }

    private Collection<LineageInfo.BaseColumnInfo> getBaseCols(LineageInfo.Dependency lInfoDep) {
        Collection<Object> ret = Collections.emptyList();
        if (lInfoDep != null) {
            try {
                Method getBaseColsMethod = lInfoDep.getClass().getMethod("getBaseCols", new Class[0]);
                Object retGetBaseCols = getBaseColsMethod.invoke((Object)lInfoDep, new Object[0]);
                if (retGetBaseCols != null) {
                    if (retGetBaseCols instanceof Collection) {
                        ret = (Collection)retGetBaseCols;
                    } else {
                        LOG.warn("{}: unexpected return type from LineageInfo.Dependency.getBaseCols(), expected type {}", (Object)retGetBaseCols.getClass().getName(), (Object)"Collection");
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.warn("getBaseCols()", (Throwable)ex);
            }
        }
        return ret;
    }

    private boolean skipProcess() {
        boolean ret;
        Set<ReadEntity> inputs = this.getInputs();
        Set<WriteEntity> outputs = this.getOutputs();
        boolean bl = ret = CollectionUtils.isEmpty(inputs) && CollectionUtils.isEmpty(outputs);
        if (!ret && this.getContext().getHiveOperation() == HiveOperation.QUERY && outputs.size() == 1) {
            WriteEntity output = outputs.iterator().next();
            if ((output.getType() == Entity.Type.DFS_DIR || output.getType() == Entity.Type.LOCAL_DIR) && output.getWriteType() == WriteEntity.WriteType.PATH_WRITE && output.isTempURI()) {
                ret = true;
            }
            if (output.getWriteType() == WriteEntity.WriteType.DELETE || output.getWriteType() == WriteEntity.WriteType.UPDATE) {
                ret = true;
            }
        }
        return ret;
    }

    private boolean isDdlOperation(AtlasEntity entity) {
        return entity != null && !this.context.isMetastoreHook() && (this.context.getHiveOperation().equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || this.context.getHiveOperation().equals((Object)HiveOperation.CREATEVIEW) || this.context.getHiveOperation().equals((Object)HiveOperation.ALTERVIEW_AS) || this.context.getHiveOperation().equals((Object)HiveOperation.CREATE_MATERIALIZED_VIEW));
    }
}

