/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.HiveHook;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTable
extends BaseHiveEvent {
    private static final Logger LOG = LoggerFactory.getLogger(CreateTable.class);

    public CreateTable(AtlasHiveHookContext context) {
        super(context);
    }

    @Override
    public List<HookNotification> getNotificationMessages() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo entities;
        List<HookNotification.EntityCreateRequestV2> ret = null;
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = entities = this.context.isMetastoreHook() ? this.getHiveMetastoreEntities() : this.getHiveEntities();
        if (entities != null && CollectionUtils.isNotEmpty((Collection)entities.getEntities())) {
            ret = Collections.singletonList(new HookNotification.EntityCreateRequestV2(this.getUserName(), entities));
        }
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getHiveMetastoreEntities() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        ListenerEvent event = this.context.getMetastoreEvent();
        HiveOperation oper = this.context.getHiveOperation();
        Table table = CreateTable.isAlterTable(oper) ? CreateTable.toTable(((AlterTableEvent)event).getNewTable()) : CreateTable.toTable(((CreateTableEvent)event).getTable());
        if (this.skipTemporaryTable(table)) {
            table = null;
        }
        this.processTable(table, ret);
        this.addProcessedEntities(ret);
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getHiveEntities() throws Exception {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        Table table = null;
        if (CollectionUtils.isNotEmpty(this.getOutputs())) {
            for (Entity entity : this.getOutputs()) {
                if (entity.getType() != Entity.Type.TABLE || (table = entity.getTable()) == null || (table = this.getHive().getTable(table.getDbName(), table.getTableName())) == null) continue;
                if (!this.skipTemporaryTable(table)) break;
                table = null;
            }
        }
        this.processTable(table, ret);
        this.addProcessedEntities(ret);
        return ret;
    }

    private void processTable(Table table, AtlasEntity.AtlasEntitiesWithExtInfo ret) throws Exception {
        AtlasEntity tblEntity;
        if (table != null && (tblEntity = this.toTableEntity(table, ret)) != null) {
            AtlasEntity tableDDLEntity;
            AtlasEntity hdfsPathEntity;
            if (this.isHBaseStore(table)) {
                AtlasEntity hbaseTableEntity;
                if (!this.context.isMetastoreHook() && (hbaseTableEntity = this.toReferencedHBaseTable(table, ret)) != null) {
                    AtlasEntity processEntity = TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) ? this.getHiveProcessEntity(Collections.singletonList(hbaseTableEntity), Collections.singletonList(tblEntity)) : this.getHiveProcessEntity(Collections.singletonList(tblEntity), Collections.singletonList(hbaseTableEntity));
                    ret.addEntity(processEntity);
                    AtlasEntity processExecution = this.getHiveProcessExecutionEntity(processEntity);
                    ret.addEntity(processExecution);
                }
            } else if (this.context.isMetastoreHook()) {
                if (this.isCreateExtTableOperation(table)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating a dummy process with lineage from hdfs path to hive table");
                    }
                    hdfsPathEntity = this.getPathEntity(table.getDataLocation(), (AtlasEntity.AtlasEntityExtInfo)ret);
                    AtlasEntity processEntity = this.getHiveProcessEntity(Collections.singletonList(hdfsPathEntity), Collections.singletonList(tblEntity));
                    ret.addEntity(processEntity);
                    ret.addReferredEntity(hdfsPathEntity);
                }
            } else if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
                hdfsPathEntity = this.getPathEntity(table.getDataLocation(), (AtlasEntity.AtlasEntityExtInfo)ret);
                AtlasEntity processEntity = this.getHiveProcessEntity(Collections.singletonList(hdfsPathEntity), Collections.singletonList(tblEntity));
                ret.addEntity(processEntity);
                ret.addReferredEntity(hdfsPathEntity);
                AtlasEntity processExecution = this.getHiveProcessExecutionEntity(processEntity);
                ret.addEntity(processExecution);
            }
            if (!this.context.isMetastoreHook() && (tableDDLEntity = this.createHiveDDLEntity(tblEntity)) != null) {
                ret.addEntity(tableDDLEntity);
            }
        }
    }

    private static boolean isAlterTable(HiveOperation oper) {
        return oper == HiveOperation.ALTERTABLE_PROPERTIES || oper == HiveOperation.ALTERTABLE_RENAME || oper == HiveOperation.ALTERTABLE_RENAMECOL;
    }

    private boolean skipTemporaryTable(Table table) {
        return table != null && this.skipTempTables && table.isTemporary() && (!TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) || HiveHook.isSkipAllTempTablesIncludingExternal());
    }

    private boolean isCreateExtTableOperation(Table table) {
        HiveOperation oper = this.context.getHiveOperation();
        TableType tableType = table.getTableType();
        return TableType.EXTERNAL_TABLE.equals((Object)tableType) && (oper == HiveOperation.CREATETABLE || oper == HiveOperation.CREATETABLE_AS_SELECT);
    }
}

