/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.atlas.hive.hook.AtlasHiveHookContext;
import org.apache.atlas.hive.hook.events.BaseHiveEvent;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.metadata.Table;

public class DropTable
extends BaseHiveEvent {
    public DropTable(AtlasHiveHookContext context) {
        super(context);
    }

    @Override
    public List<HookNotification> getNotificationMessages() {
        List<AtlasObjectId> entities;
        ArrayList<HookNotification.EntityDeleteRequestV2> ret = null;
        List<AtlasObjectId> list = entities = this.context.isMetastoreHook() ? this.getHiveMetastoreEntities() : this.getHiveEntities();
        if (CollectionUtils.isNotEmpty(entities)) {
            ret = new ArrayList<HookNotification.EntityDeleteRequestV2>(entities.size());
            for (AtlasObjectId entity : entities) {
                ret.add(new HookNotification.EntityDeleteRequestV2(this.getUserName(), Collections.singletonList(entity)));
            }
        }
        return ret;
    }

    public List<AtlasObjectId> getHiveMetastoreEntities() {
        ArrayList<AtlasObjectId> ret = new ArrayList<AtlasObjectId>();
        DropTableEvent tblEvent = (DropTableEvent)this.context.getMetastoreEvent();
        Table table = new Table(tblEvent.getTable());
        String tblQName = this.getQualifiedName(table);
        AtlasObjectId tblId = new AtlasObjectId("hive_table", "qualifiedName", (Object)tblQName);
        this.context.removeFromKnownTable(tblQName);
        ret.add(tblId);
        return ret;
    }

    public List<AtlasObjectId> getHiveEntities() {
        ArrayList<AtlasObjectId> ret = new ArrayList<AtlasObjectId>();
        for (Entity entity : this.getOutputs()) {
            if (entity.getType() != Entity.Type.TABLE) continue;
            String tblQName = this.getQualifiedName(entity.getTable());
            AtlasObjectId tblId = new AtlasObjectId("hive_table", "qualifiedName", (Object)tblQName);
            this.context.removeFromKnownTable(tblQName);
            ret.add(tblId);
        }
        return ret;
    }
}

