/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import org.apache.atlas.hive.hook.utils.EntityFilter;
import org.apache.atlas.hive.hook.utils.HiveDDLEntityFilter;
import org.apache.atlas.hive.hook.utils.PassthroughFilter;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveEntityFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveEntityFilter.class);
    private static EntityFilter entityFilter;

    public static void init(Configuration configuration) {
        boolean skipDdlOperations = configuration.getBoolean("atlas.hook.hive.hs2.ignore.ddl.operations", false);
        List<String> additionalTypesToRetain = ActiveEntityFilter.getConfiguredTypesToRetainForDDLEntityFilter(configuration);
        ActiveEntityFilter.init(skipDdlOperations, additionalTypesToRetain);
        LOG.info("atlas.hook.hive.ignore.ddl.operations={} - {}", (Object)skipDdlOperations, (Object)entityFilter.getClass().getSimpleName());
    }

    @VisibleForTesting
    static void init(boolean lineageOnlyFilter, List<String> additionalTypesToRetain) {
        entityFilter = lineageOnlyFilter ? new HiveDDLEntityFilter(additionalTypesToRetain) : new PassthroughFilter();
    }

    public static List<HookNotification> apply(List<HookNotification> incoming) {
        return entityFilter.apply(incoming);
    }

    private static List<String> getConfiguredTypesToRetainForDDLEntityFilter(Configuration configuration) {
        try {
            if (configuration.containsKey("atlas.hook.hive.hs2.filter.entity.additional.types.to.retain")) {
                String[] configuredTypes = configuration.getStringArray("atlas.hook.hive.hs2.filter.entity.additional.types.to.retain");
                return Arrays.asList(configuredTypes);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load application properties", (Throwable)e);
        }
        return null;
    }
}

