/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.atlas.hive.hook.utils.EntityFilter;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDDLEntityFilter
implements EntityFilter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveDDLEntityFilter.class);
    private static final Set<String> defaultPathTypesToRetain = new HashSet<String>(){
        {
            this.add("hdfs_path");
            this.add("adls_gen2_account");
            this.add("adls_gen2_container");
            this.add("adls_gen2_directory");
            this.add("gcp_storage_bucket");
            this.add("gcp_storage_virtual_directory");
            this.add("aws_s3_bucket");
            this.add("aws_s3_v2_bucket");
            this.add("aws_s3_v2_directory");
            this.add("aws_s3_pseudo_dir");
            this.add("ozone_key");
            this.add("ozone_bucket");
            this.add("ozone_volume");
        }
    };
    private static final Set<String> typesToRetain = new HashSet<String>(){
        {
            this.add("hive_process");
            this.add("hive_process_execution");
            this.add("hive_column_lineage");
            this.add("hive_db_ddl");
            this.add("hive_table_ddl");
            this.addAll(defaultPathTypesToRetain);
        }
    };

    public HiveDDLEntityFilter(List<String> additionalTypesToRetain) {
        if (CollectionUtils.isEmpty(additionalTypesToRetain)) {
            return;
        }
        typesToRetain.addAll(additionalTypesToRetain);
        LOG.info("Types retained: {}", typesToRetain.toArray());
    }

    @Override
    public List<HookNotification> apply(List<HookNotification> incoming) {
        if (CollectionUtils.isEmpty(incoming)) {
            return incoming;
        }
        ArrayList<HookNotification> ret = new ArrayList<HookNotification>();
        for (HookNotification notification : incoming) {
            HookNotification filteredNotification = this.apply(notification);
            if (filteredNotification == null) continue;
            ret.add(filteredNotification);
        }
        return ret;
    }

    @VisibleForTesting
    AtlasEntity.AtlasEntityWithExtInfo apply(AtlasEntity.AtlasEntityWithExtInfo incoming) {
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo();
        AtlasEntity entity = HiveDDLEntityFilter.filter(incoming.getEntity());
        if (entity == null) {
            return null;
        }
        ret.setEntity(entity);
        Map<String, AtlasEntity> refEntities = HiveDDLEntityFilter.filter(incoming.getReferredEntities());
        if (!MapUtils.isEmpty(refEntities)) {
            ret.setReferredEntities(refEntities);
        }
        return ret;
    }

    @VisibleForTesting
    public AtlasEntity.AtlasEntitiesWithExtInfo apply(AtlasEntity.AtlasEntitiesWithExtInfo incoming) {
        if (incoming == null) {
            return incoming;
        }
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        HiveDDLEntityFilter.filterEntities(incoming, ret);
        HiveDDLEntityFilter.filterReferences(incoming, ret);
        return ret;
    }

    @VisibleForTesting
    List<AtlasObjectId> applyForObjectIds(List<AtlasObjectId> incoming) {
        if (incoming == null || CollectionUtils.isEmpty(incoming)) {
            return null;
        }
        ArrayList<AtlasObjectId> ret = new ArrayList<AtlasObjectId>();
        for (AtlasObjectId o : incoming) {
            if (this.filterObjectId(o) == null) continue;
            ret.add(o);
        }
        return ret;
    }

    private AtlasObjectId filterObjectId(AtlasObjectId o) {
        if (o != null && typesToRetain.contains(o.getTypeName())) {
            return o;
        }
        return null;
    }

    private static void filterEntities(AtlasEntity.AtlasEntitiesWithExtInfo incoming, AtlasEntity.AtlasEntitiesWithExtInfo ret) {
        ret.setEntities(HiveDDLEntityFilter.filter(incoming.getEntities()));
    }

    private static void filterReferences(AtlasEntity.AtlasEntitiesWithExtInfo incoming, AtlasEntity.AtlasEntitiesWithExtInfo ret) {
        ret.setReferredEntities(HiveDDLEntityFilter.filter(incoming.getReferredEntities()));
    }

    private static Map<String, AtlasEntity> filter(Map<String, AtlasEntity> incoming) {
        if (incoming == null || MapUtils.isEmpty(incoming)) {
            return null;
        }
        return incoming.values().stream().filter(x -> typesToRetain.contains(x.getTypeName())).collect(Collectors.toMap(AtlasEntity::getGuid, Function.identity()));
    }

    private static List<AtlasEntity> filter(List<AtlasEntity> incoming) {
        if (incoming == null) {
            return null;
        }
        List<AtlasEntity> ret = incoming.stream().filter(x -> typesToRetain.contains(x.getTypeName())).collect(Collectors.toList());
        for (AtlasEntity e : ret) {
            for (Object o : e.getRelationshipAttributes().values()) {
                if (o instanceof List) {
                    List list = (List)o;
                    for (Object ox : list) {
                        HiveDDLEntityFilter.inferObjectTypeResetGuid(ox);
                    }
                    continue;
                }
                HiveDDLEntityFilter.inferObjectTypeResetGuid(o);
            }
        }
        return ret;
    }

    private static void inferObjectTypeResetGuid(Object o) {
        if (o instanceof AtlasObjectId) {
            AtlasObjectId oid = (AtlasObjectId)o;
            String typeName = oid.getTypeName();
            if (oid.getUniqueAttributes() != null && !typesToRetain.contains(typeName)) {
                oid.setGuid(null);
            }
        } else {
            String typeName;
            LinkedHashMap hm = (LinkedHashMap)o;
            if (!hm.containsKey("guid")) {
                return;
            }
            String string = typeName = hm.containsKey("typeName") ? (String)hm.get("typeName") : null;
            if (hm.containsKey("uniqueAttributes") && !typesToRetain.contains(typeName)) {
                hm.remove("guid");
            }
        }
    }

    private static AtlasEntity filter(AtlasEntity incoming) {
        if (incoming == null) {
            return null;
        }
        return typesToRetain.contains(incoming.getTypeName()) ? incoming : null;
    }

    private HookNotification apply(HookNotification notification) {
        if (notification instanceof HookNotification.EntityCreateRequestV2) {
            return this.apply((HookNotification.EntityCreateRequestV2)notification);
        }
        if (notification instanceof HookNotification.EntityUpdateRequestV2) {
            return this.apply((HookNotification.EntityUpdateRequestV2)notification);
        }
        if (notification instanceof HookNotification.EntityPartialUpdateRequestV2) {
            return this.apply((HookNotification.EntityPartialUpdateRequestV2)notification);
        }
        if (notification instanceof HookNotification.EntityDeleteRequestV2) {
            return this.apply((HookNotification.EntityDeleteRequestV2)notification);
        }
        return null;
    }

    private HookNotification.EntityCreateRequestV2 apply(HookNotification.EntityCreateRequestV2 notification) {
        AtlasEntity.AtlasEntitiesWithExtInfo entities = this.apply(notification.getEntities());
        if (entities == null || CollectionUtils.isEmpty((Collection)entities.getEntities())) {
            return null;
        }
        return new HookNotification.EntityCreateRequestV2(notification.getUser(), entities);
    }

    private HookNotification.EntityUpdateRequestV2 apply(HookNotification.EntityUpdateRequestV2 notification) {
        AtlasEntity.AtlasEntitiesWithExtInfo entities = this.apply(notification.getEntities());
        if (entities == null || CollectionUtils.isEmpty((Collection)entities.getEntities())) {
            return null;
        }
        return new HookNotification.EntityUpdateRequestV2(notification.getUser(), entities);
    }

    private HookNotification.EntityPartialUpdateRequestV2 apply(HookNotification.EntityPartialUpdateRequestV2 notification) {
        AtlasObjectId objectId = this.filterObjectId(notification.getEntityId());
        if (objectId == null) {
            return null;
        }
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.apply(notification.getEntity());
        if (entityWithExtInfo == null) {
            return null;
        }
        return new HookNotification.EntityPartialUpdateRequestV2(notification.getUser(), objectId, entityWithExtInfo);
    }

    private HookNotification.EntityDeleteRequestV2 apply(HookNotification.EntityDeleteRequestV2 notification) {
        List<AtlasObjectId> objectIds = this.applyForObjectIds(notification.getEntities());
        if (CollectionUtils.isEmpty(objectIds)) {
            return null;
        }
        return new HookNotification.EntityDeleteRequestV2(notification.getUser(), objectIds);
    }
}

