/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.atlas.impala.hook.ImpalaLineageHook;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaLineageTool {
    private static final Logger LOG = LoggerFactory.getLogger(ImpalaLineageTool.class);
    private static final String WAL_FILE_EXTENSION = ".wal";
    private static final String WAL_FILE_PREFIX = "WAL";
    private String directoryName;
    private String prefix;

    public ImpalaLineageTool(String[] args) {
        try {
            Options options = new Options();
            options.addOption("d", "directory", true, "the lineage files' folder");
            options.addOption("p", "prefix", true, "the prefix of the lineage files");
            CommandLine cmd = new DefaultParser().parse(options, args);
            this.directoryName = cmd.getOptionValue("d");
            this.prefix = cmd.getOptionValue("p");
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse command arguments. Error: ", (Object)e.getMessage());
            ImpalaLineageTool.printUsage();
            throw new RuntimeException(e);
        }
    }

    public void run() {
        ImpalaLineageHook impalaLineageHook = new ImpalaLineageHook();
        File[] currentFiles = this.getCurrentFiles();
        int fileNum = currentFiles.length;
        for (int i = 0; i < fileNum; ++i) {
            String filename = currentFiles[i].getAbsolutePath();
            String walFilename = this.directoryName + WAL_FILE_PREFIX + currentFiles[i].getName() + WAL_FILE_EXTENSION;
            LOG.info("Importing: {}", (Object)filename);
            this.importHImpalaEntities(impalaLineageHook, filename, walFilename);
            if (i == fileNum - 1) continue;
            ImpalaLineageTool.deleteLineageAndWal(currentFiles[i], walFilename);
        }
        LOG.info("Impala bridge processing: Done! ");
    }

    public static void main(String[] args) {
        if (args != null && args.length != 4) {
            System.out.println("Impala bridge: wrong number of arguments. Please try again");
            ImpalaLineageTool.printUsage();
            return;
        }
        ImpalaLineageTool instance = new ImpalaLineageTool(args);
        instance.run();
    }

    public static void deleteLineageAndWal(File currentFile, String wal) {
        if (currentFile.exists() && currentFile.delete()) {
            LOG.info("Lineage file {} is deleted successfully", (Object)currentFile.getPath());
        } else {
            LOG.info("Failed to delete the lineage file {}", (Object)currentFile.getPath());
        }
        File file = new File(wal);
        if (file.exists() && file.delete()) {
            LOG.info("Wal file {} deleted successfully", (Object)wal);
        } else {
            LOG.info("Failed to delete the wal file {}", (Object)wal);
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println();
        System.out.println("Usage: import-impala.sh [-d <directory>] [-p <prefix>]");
        System.out.println("    Imports specified lineage files by given directory and file prefix.");
        System.out.println();
    }

    public File[] getCurrentFiles() {
        try {
            LOG.info("Scanning: " + this.directoryName);
            File folder = new File(this.directoryName);
            File[] listOfFiles = folder.listFiles((FileFilter)new PrefixFileFilter(this.prefix, IOCase.SENSITIVE));
            if (listOfFiles == null || listOfFiles.length == 0) {
                LOG.info("Found no lineage files.");
                return new File[0];
            }
            if (listOfFiles.length > 1) {
                Arrays.sort(listOfFiles, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
            }
            LOG.info("Found {} lineage files" + listOfFiles.length);
            return listOfFiles;
        }
        catch (Exception e) {
            LOG.error("Import lineage file failed.", (Throwable)e);
            return new File[0];
        }
    }

    private boolean processImpalaLineageHook(ImpalaLineageHook impalaLineageHook, List<String> lineageList) {
        boolean allSucceed = true;
        for (String lineageRecord : lineageList) {
            try {
                impalaLineageHook.process(lineageRecord);
            }
            catch (Exception ex) {
                String errorMessage = String.format("Exception at query {} \n", lineageRecord);
                LOG.error(errorMessage, (Throwable)ex);
                allSucceed = false;
            }
        }
        return allSucceed;
    }

    public void importHImpalaEntities(ImpalaLineageHook impalaLineageHook, String name, String walfile) {
        ArrayList<String> lineageList = new ArrayList<String>();
        try {
            File lineageFile = new File(name);
            File walFile = new File(walfile);
            if (!walFile.exists()) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(walfile));
                writer.write("0, " + name);
                writer.close();
            }
            LOG.debug("Reading: " + name);
            String lineageRecord = FileUtils.readFileToString((File)lineageFile, (String)"UTF-8");
            lineageList.add(lineageRecord);
            if (this.processImpalaLineageHook(impalaLineageHook, lineageList)) {
                FileWriter newWalFile = new FileWriter(walfile, true);
                BufferedWriter newWalFileBuf = new BufferedWriter(newWalFile);
                newWalFileBuf.newLine();
                newWalFileBuf.write(String.valueOf(lineageFile.length()) + "," + name);
                newWalFileBuf.close();
                newWalFile.close();
            } else {
                LOG.error("Error sending some of impala lineage records to ImpalaHook");
            }
        }
        catch (Exception e) {
            LOG.error("Error in processing lineage records. Exception: " + e.getMessage());
        }
    }
}

