/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala.hook;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.impala.hook.ImpalaIdentifierParser;
import org.apache.atlas.impala.hook.ImpalaLineageHook;
import org.apache.atlas.impala.model.ImpalaOperationType;
import org.apache.atlas.impala.model.ImpalaQuery;
import org.apache.atlas.impala.model.LineageVertex;
import org.apache.atlas.impala.model.LineageVertexMetadata;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.StringUtils;

public class AtlasImpalaHookContext {
    public static final char QNAME_SEP_METADATA_NAMESPACE = '@';
    public static final char QNAME_SEP_ENTITY_NAME = '.';
    public static final char QNAME_SEP_PROCESS = ':';
    private final ImpalaLineageHook hook;
    private final ImpalaOperationType impalaOperation;
    private final ImpalaQuery lineageQuery;
    private final Map<String, AtlasEntity> qNameEntityMap = new HashMap<String, AtlasEntity>();

    public AtlasImpalaHookContext(ImpalaLineageHook hook, ImpalaOperationType operationType, ImpalaQuery lineageQuery) throws Exception {
        this.hook = hook;
        this.impalaOperation = operationType;
        this.lineageQuery = lineageQuery;
    }

    public ImpalaQuery getLineageQuery() {
        return this.lineageQuery;
    }

    public String getQueryStr() {
        return this.lineageQuery.getQueryText();
    }

    public ImpalaOperationType getImpalaOperationType() {
        return this.impalaOperation;
    }

    public void putEntity(String qualifiedName, AtlasEntity entity) {
        this.qNameEntityMap.put(qualifiedName, entity);
    }

    public AtlasEntity getEntity(String qualifiedName) {
        return this.qNameEntityMap.get(qualifiedName);
    }

    public Collection<AtlasEntity> getEntities() {
        return this.qNameEntityMap.values();
    }

    public String getMetadataNamespace() {
        return this.hook.getMetadataNamespace();
    }

    public String getHostName() {
        return this.hook.getHostName();
    }

    public boolean isConvertHdfsPathToLowerCase() {
        return this.hook.isConvertHdfsPathToLowerCase();
    }

    public String getQualifiedNameForDb(String dbName) {
        return (dbName + '@').toLowerCase() + this.getMetadataNamespace();
    }

    public String getQualifiedNameForTable(String fullTableName) throws IllegalArgumentException {
        if (fullTableName == null) {
            throw new IllegalArgumentException("fullTableName is null");
        }
        int sepPos = fullTableName.lastIndexOf(46);
        if (!this.isSeparatorIndexValid(sepPos)) {
            throw new IllegalArgumentException(fullTableName + " does not contain database name");
        }
        return this.getQualifiedNameForTable(fullTableName.substring(0, sepPos), fullTableName.substring(sepPos + 1));
    }

    public String getQualifiedNameForTable(String dbName, String tableName) {
        return (dbName + '.' + tableName + '@').toLowerCase() + this.getMetadataNamespace();
    }

    public String getQualifiedNameForColumn(LineageVertex vertex) {
        LineageVertexMetadata metadata = vertex.getMetadata();
        if (metadata == null) {
            return this.getQualifiedNameForColumn(vertex.getVertexId());
        }
        String fullTableName = metadata.getTableName();
        if (StringUtils.isEmpty((String)fullTableName)) {
            throw new IllegalArgumentException("fullTableName in column metadata is null");
        }
        int sepPos = fullTableName.lastIndexOf(46);
        if (!this.isSeparatorIndexValid(sepPos)) {
            throw new IllegalArgumentException(fullTableName + "in column metadata does not contain database name");
        }
        String columnName = vertex.getVertexId();
        if (StringUtils.isEmpty((String)columnName)) {
            throw new IllegalArgumentException("column name in vertexId is null");
        }
        int sepPosLast = columnName.lastIndexOf(46);
        if (this.isSeparatorIndexValid(sepPosLast)) {
            columnName = columnName.substring(sepPosLast + 1);
        }
        return this.getQualifiedNameForColumn(fullTableName.substring(0, sepPos), fullTableName.substring(sepPos + 1), columnName);
    }

    public String getQualifiedNameForColumn(String fullColumnName) throws IllegalArgumentException {
        if (fullColumnName == null) {
            throw new IllegalArgumentException("fullColumnName is null");
        }
        int sepPosFirst = fullColumnName.indexOf(46);
        int sepPosLast = fullColumnName.lastIndexOf(46);
        if (!this.isSeparatorIndexValid(sepPosFirst) || !this.isSeparatorIndexValid(sepPosLast) || sepPosFirst == sepPosLast) {
            throw new IllegalArgumentException(String.format("fullColumnName {} does not contain database name or table name", fullColumnName));
        }
        return this.getQualifiedNameForColumn(fullColumnName.substring(0, sepPosFirst), fullColumnName.substring(sepPosFirst + 1, sepPosLast), fullColumnName.substring(sepPosLast + 1));
    }

    public String getColumnNameOnly(String fullColumnName) throws IllegalArgumentException {
        if (fullColumnName == null) {
            throw new IllegalArgumentException("fullColumnName is null");
        }
        int sepPosLast = fullColumnName.lastIndexOf(46);
        if (!this.isSeparatorIndexValid(sepPosLast)) {
            return fullColumnName;
        }
        return fullColumnName.substring(sepPosLast + 1);
    }

    public String getQualifiedNameForColumn(String dbName, String tableName, String columnName) {
        return (dbName + '.' + tableName + '.' + columnName + '@').toLowerCase() + this.getMetadataNamespace();
    }

    public String getUserName() {
        return this.lineageQuery.getUser();
    }

    public String getDatabaseNameFromTable(String fullTableName) {
        int sepPos = fullTableName.lastIndexOf(46);
        if (this.isSeparatorIndexValid(sepPos)) {
            return fullTableName.substring(0, sepPos);
        }
        return null;
    }

    public String getTableNameFromColumn(String columnName) {
        int sepPos = columnName.lastIndexOf(46);
        if (!this.isSeparatorIndexValid(sepPos)) {
            return null;
        }
        String tableName = columnName.substring(0, sepPos);
        if (!ImpalaIdentifierParser.isTableNameValid(tableName)) {
            return null;
        }
        return tableName;
    }

    public boolean isSeparatorIndexValid(int index) {
        return index > 0;
    }
}

