/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala.hook;

import org.apache.atlas.impala.hook.ImpalaLineageHook;
import org.apache.impala.hooks.QueryCompleteContext;
import org.apache.impala.hooks.QueryEventHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaHook
implements QueryEventHook {
    private static final Logger LOG = LoggerFactory.getLogger(ImpalaHook.class);
    private ImpalaLineageHook lineageHook;

    public void onQueryComplete(QueryCompleteContext context) {
        try {
            this.lineageHook.process(context.getLineageGraph());
        }
        catch (Exception ex) {
            String errorMessage = String.format("Error in processing impala lineage: {}", context.getLineageGraph());
            LOG.error(errorMessage, (Throwable)ex);
        }
    }

    public void onImpalaStartup() {
        this.lineageHook = new ImpalaLineageHook();
    }
}

