/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala.hook;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.impala.hook.AtlasImpalaHookContext;
import org.apache.atlas.impala.hook.ImpalaOperationParser;
import org.apache.atlas.impala.hook.events.BaseImpalaEvent;
import org.apache.atlas.impala.hook.events.CreateImpalaProcess;
import org.apache.atlas.impala.model.ImpalaOperationType;
import org.apache.atlas.impala.model.ImpalaQuery;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaLineageHook
extends AtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(ImpalaLineageHook.class);
    public static final String ATLAS_ENDPOINT = "atlas.rest.address";
    public static final String REALM_SEPARATOR = "@";
    public static final String CONF_PREFIX = "atlas.hook.impala.";
    public static final String CONF_REALM_NAME = "atlas.realm.name";
    public static final String HDFS_PATH_CONVERT_TO_LOWER_CASE = "atlas.hook.impala.hdfs_path.convert_to_lowercase";
    public static final String DEFAULT_HOST_NAME = "localhost";
    private static final String realm = atlasProperties.getString("atlas.realm.name", "primary");
    private static final boolean convertHdfsPathToLowerCase = atlasProperties.getBoolean("atlas.hook.impala.hdfs_path.convert_to_lowercase", false);
    private static String hostName;

    public String getMessageSource() {
        return "impala";
    }

    public void process(String impalaQueryString) throws Exception {
        if (StringUtils.isEmpty((String)impalaQueryString)) {
            LOG.warn("==> ImpalaLineageHook.process skips because the impalaQueryString is empty <==");
            return;
        }
        ImpalaQuery lineageQuery = (ImpalaQuery)AtlasType.fromJson((String)impalaQueryString, ImpalaQuery.class);
        this.process(lineageQuery);
    }

    public void process(ImpalaQuery lineageQuery) throws Exception {
        if (lineageQuery == null) {
            LOG.warn("==> ImpalaLineageHook.process skips because the query object is null <==");
            return;
        }
        if (StringUtils.isEmpty((String)lineageQuery.getQueryText())) {
            LOG.warn("==> ImpalaLineageHook.process skips because the query text is empty <==");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ImpalaLineageHook.process({})", (Object)lineageQuery.getQueryText());
        }
        try {
            ImpalaOperationType operationType = ImpalaOperationParser.getImpalaOperationType(lineageQuery.getQueryText());
            AtlasImpalaHookContext context = new AtlasImpalaHookContext(this, operationType, lineageQuery);
            CreateImpalaProcess event = null;
            switch (operationType) {
                case CREATEVIEW: 
                case CREATETABLE_AS_SELECT: 
                case ALTERVIEW_AS: 
                case QUERY: {
                    event = new CreateImpalaProcess(context);
                    break;
                }
                default: {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("HiveHook.run({}): operation ignored", (Object)lineageQuery.getQueryText());
                }
            }
            if (event != null) {
                LOG.debug("Processing event: " + lineageQuery.getQueryText());
                UserGroupInformation ugi = this.getUgiFromUserName(lineageQuery.getUser());
                super.notifyEntities(((BaseImpalaEvent)event).getNotificationMessages(), ugi);
            }
        }
        catch (Throwable t) {
            LOG.error("ImpalaLineageHook.process(): failed to process query {}", (Object)AtlasType.toJson((Object)lineageQuery), (Object)t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ImpalaLineageHook.process({})", (Object)lineageQuery.getQueryText());
        }
    }

    public String getHostName() {
        return hostName;
    }

    private UserGroupInformation getUgiFromUserName(String userName) throws IOException {
        String userPrincipal = userName.contains(REALM_SEPARATOR) ? userName : userName + REALM_SEPARATOR + this.getRealm();
        Subject userSubject = new Subject(false, Sets.newHashSet((Object[])new KerberosPrincipal[]{new KerberosPrincipal(userPrincipal)}), new HashSet(), new HashSet());
        return UserGroupInformation.getUGIFromSubject((Subject)userSubject);
    }

    public String getRealm() {
        return realm;
    }

    public boolean isConvertHdfsPathToLowerCase() {
        return convertHdfsPathToLowerCase;
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("No hostname found. Setting the hostname to default value {}", (Object)DEFAULT_HOST_NAME, (Object)e);
            hostName = DEFAULT_HOST_NAME;
        }
    }
}

