/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala.hook;

import java.util.regex.Pattern;
import org.apache.atlas.impala.model.ImpalaOperationType;
import org.apache.commons.lang.StringUtils;

public class ImpalaOperationParser {
    private static final Pattern COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern CREATE_VIEW_PATTERN = Pattern.compile("^[ ]*\\bcreate\\b.*\\bview\\b.*", 34);
    private static final Pattern CREATE_TABLE_AS_SELECT_PATTERN = Pattern.compile("^[ ]*\\bcreate\\b.*\\btable\\b.*\\bas\\b.*\\bselect\\b.*", 34);
    private static final Pattern ALTER_VIEW_AS_SELECT_PATTERN = Pattern.compile("^[ ]*\\balter\\b.*\\bview\\b.*\\bas.*\\bselect\\b.*", 34);
    private static final Pattern INSERT_SELECT_FROM_PATTERN = Pattern.compile("^[ ]*\\binsert\\b.*\\b(into|overwrite)\\b.*\\bselect\\b.*\\bfrom\\b.*", 34);

    public static ImpalaOperationType getImpalaOperationType(String queryText) {
        String queryTextWithNoComments = COMMENT_PATTERN.matcher(queryText).replaceAll("");
        if (ImpalaOperationParser.doesMatch(queryTextWithNoComments, CREATE_VIEW_PATTERN)) {
            return ImpalaOperationType.CREATEVIEW;
        }
        if (ImpalaOperationParser.doesMatch(queryTextWithNoComments, CREATE_TABLE_AS_SELECT_PATTERN)) {
            return ImpalaOperationType.CREATETABLE_AS_SELECT;
        }
        if (ImpalaOperationParser.doesMatch(queryTextWithNoComments, ALTER_VIEW_AS_SELECT_PATTERN)) {
            return ImpalaOperationType.ALTERVIEW_AS;
        }
        if (ImpalaOperationParser.doesMatch(queryTextWithNoComments, INSERT_SELECT_FROM_PATTERN)) {
            return ImpalaOperationType.QUERY;
        }
        return ImpalaOperationType.UNKNOWN;
    }

    public static ImpalaOperationType getImpalaOperationSubType(ImpalaOperationType operationType, String queryText) {
        if (operationType == ImpalaOperationType.QUERY) {
            if (StringUtils.containsIgnoreCase((String)queryText, (String)"insert into")) {
                return ImpalaOperationType.INSERT;
            }
            if (StringUtils.containsIgnoreCase((String)queryText, (String)"insert overwrite")) {
                return ImpalaOperationType.INSERT_OVERWRITE;
            }
        }
        return ImpalaOperationType.UNKNOWN;
    }

    private static boolean doesMatch(String queryText, Pattern pattern) {
        return pattern.matcher(queryText).matches();
    }
}

