/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala.hook.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.atlas.impala.hook.AtlasImpalaHookContext;
import org.apache.atlas.impala.hook.ImpalaOperationParser;
import org.apache.atlas.impala.model.ImpalaDataType;
import org.apache.atlas.impala.model.ImpalaNode;
import org.apache.atlas.impala.model.ImpalaOperationType;
import org.apache.atlas.impala.model.ImpalaVertexType;
import org.apache.atlas.impala.model.LineageVertex;
import org.apache.atlas.impala.model.LineageVertexMetadata;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseImpalaEvent {
    private static final Logger LOG = LoggerFactory.getLogger(BaseImpalaEvent.class);
    public static final String HIVE_TYPE_DB = "hive_db";
    public static final String HIVE_TYPE_TABLE = "hive_table";
    public static final String HIVE_TYPE_COLUMN = "hive_column";
    public static final String ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_OWNER = "owner";
    public static final String ATTRIBUTE_CLUSTER_NAME = "clusterName";
    public static final String ATTRIBUTE_CREATE_TIME = "createTime";
    public static final String ATTRIBUTE_LAST_ACCESS_TIME = "lastAccessTime";
    public static final String ATTRIBUTE_DB = "db";
    public static final String ATTRIBUTE_COLUMNS = "columns";
    public static final String ATTRIBUTE_TABLE = "table";
    public static final String ATTRIBUTE_INPUTS = "inputs";
    public static final String ATTRIBUTE_OUTPUTS = "outputs";
    public static final String ATTRIBUTE_OPERATION_TYPE = "operationType";
    public static final String ATTRIBUTE_START_TIME = "startTime";
    public static final String ATTRIBUTE_USER_NAME = "userName";
    public static final String ATTRIBUTE_QUERY_TEXT = "queryText";
    public static final String ATTRIBUTE_PROCESS = "process";
    public static final String ATTRIBUTE_PROCESS_EXECUTIONS = "processExecutions";
    public static final String ATTRIBUTE_QUERY_ID = "queryId";
    public static final String ATTRIBUTE_QUERY_PLAN = "queryPlan";
    public static final String ATTRIBUTE_END_TIME = "endTime";
    public static final String ATTRIBUTE_RECENT_QUERIES = "recentQueries";
    public static final String ATTRIBUTE_QUERY = "query";
    public static final String ATTRIBUTE_DEPENDENCY_TYPE = "dependencyType";
    public static final String ATTRIBUTE_HOSTNAME = "hostName";
    public static final String EMPTY_ATTRIBUTE_VALUE = "";
    public static final String ATTRIBUTE_EXEC_TIME = "execTime";
    public static final String ATTRIBUTE_DDL_QUERIES = "ddlQueries";
    public static final String ATTRIBUTE_SERVICE_TYPE = "serviceType";
    public static final long MILLIS_CONVERT_FACTOR = 1000L;
    protected final AtlasImpalaHookContext context;
    protected final Map<String, ImpalaNode> vertexNameMap;
    protected final Map<Long, LineageVertex> verticesMap;
    static final Comparator<AtlasEntity> entityComparator = new AtlasEntityComparator();

    public BaseImpalaEvent(AtlasImpalaHookContext context) {
        this.context = context;
        this.vertexNameMap = new HashMap<String, ImpalaNode>();
        this.verticesMap = new HashMap<Long, LineageVertex>();
    }

    public AtlasImpalaHookContext getContext() {
        return this.context;
    }

    public abstract List<HookNotification> getNotificationMessages() throws Exception;

    public String getUserName() {
        return this.context.getUserName();
    }

    public String getTableNameFromVertex(LineageVertex vertex) {
        LineageVertexMetadata metadata;
        if (vertex.getVertexType() == ImpalaVertexType.COLUMN && (metadata = vertex.getMetadata()) != null) {
            return metadata.getTableName();
        }
        return this.getTableNameFromColumn(vertex.getVertexId());
    }

    public String getTableNameFromColumn(String columnName) {
        return this.context.getTableNameFromColumn(columnName);
    }

    public String getQualifiedName(ImpalaNode node) throws IllegalArgumentException {
        return this.getQualifiedName(node.getOwnVertex());
    }

    public String getQualifiedName(LineageVertex node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        ImpalaVertexType nodeType = node.getVertexType();
        if (nodeType == null) {
            if (node.getVertexId() != null) {
                LOG.warn("null qualified name for type: null and name: {}", (Object)node.getVertexId());
            }
            return null;
        }
        if (node.getVertexId() == null) {
            LOG.warn("null qualified name for type: {} and name: null", (Object)nodeType);
            return null;
        }
        switch (nodeType) {
            case DATABASE: {
                return this.context.getQualifiedNameForDb(node.getVertexId());
            }
            case TABLE: {
                return this.context.getQualifiedNameForTable(node.getVertexId());
            }
            case COLUMN: {
                return this.context.getQualifiedNameForColumn(node);
            }
        }
        LOG.warn("null qualified name for type: {} and name: {}", (Object)nodeType, (Object)node.getVertexId());
        return null;
    }

    protected String getQualifiedName(List<AtlasEntity> inputs, List<AtlasEntity> outputs) throws Exception {
        ImpalaOperationType operation = this.context.getImpalaOperationType();
        if (operation == ImpalaOperationType.CREATEVIEW || operation == ImpalaOperationType.CREATETABLE_AS_SELECT || operation == ImpalaOperationType.ALTERVIEW_AS) {
            ArrayList<AtlasEntity> sortedEntities = new ArrayList<AtlasEntity>(outputs);
            Collections.sort(sortedEntities, entityComparator);
            for (AtlasEntity entity : sortedEntities) {
                if (!entity.getTypeName().equalsIgnoreCase(HIVE_TYPE_TABLE)) continue;
                Long createTime = (Long)entity.getAttribute(ATTRIBUTE_CREATE_TIME);
                return (String)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME) + ':' + createTime;
            }
        }
        if (operation != ImpalaOperationType.QUERY) {
            String errorMessage = String.format("Expect operation to be QUERY, but get unexpected operation type {}", operation.name());
            LOG.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        String qualifiedName = null;
        String operationName = operation.toString();
        if (operationName != null) {
            StringBuilder sb = new StringBuilder(operationName);
            this.addToProcessQualifiedName(sb, inputs, false);
            sb.append("->");
            this.addToProcessQualifiedName(sb, outputs, true);
            qualifiedName = sb.toString();
        }
        return qualifiedName;
    }

    protected void addToProcessQualifiedName(StringBuilder processQualifiedName, Collection<? extends AtlasEntity> entities, boolean isOutput) {
        if (entities == null) {
            return;
        }
        ImpalaOperationType operation = this.context.getImpalaOperationType();
        String queryText = this.context.getQueryStr();
        ArrayList<? extends AtlasEntity> sortedEntities = new ArrayList<AtlasEntity>(entities);
        Collections.sort(sortedEntities, entityComparator);
        HashSet<String> dataSetsProcessed = new HashSet<String>();
        for (AtlasEntity atlasEntity : sortedEntities) {
            Long createTimeObj;
            String qualifiedName = null;
            long createTime = 0L;
            qualifiedName = (String)atlasEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME);
            if (atlasEntity.getTypeName().equalsIgnoreCase(HIVE_TYPE_TABLE) && (createTimeObj = (Long)atlasEntity.getAttribute(ATTRIBUTE_CREATE_TIME)) != null) {
                createTime = createTimeObj;
            }
            if (qualifiedName == null || !dataSetsProcessed.add(qualifiedName)) continue;
            if (isOutput) {
                boolean addWriteType = false;
                ImpalaOperationType subType = ImpalaOperationParser.getImpalaOperationSubType(operation, queryText);
                switch (subType) {
                    case INSERT: 
                    case INSERT_OVERWRITE: {
                        addWriteType = true;
                    }
                }
                if (addWriteType) {
                    processQualifiedName.append(':').append(subType.name());
                }
            }
            processQualifiedName.append(':').append(qualifiedName.toLowerCase().replaceAll("/", EMPTY_ATTRIBUTE_VALUE));
            if (createTime == 0L) continue;
            processQualifiedName.append(':').append(createTime);
        }
    }

    protected AtlasEntity getInputOutputEntity(ImpalaNode node, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws Exception {
        AtlasEntity ret = null;
        switch (node.getNodeType()) {
            case TABLE: 
            case PARTITION: 
            case DFS_DIR: {
                ret = this.toAtlasEntity(node, entityExtInfo);
            }
        }
        return ret;
    }

    protected AtlasEntity toAtlasEntity(ImpalaNode node, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws Exception {
        AtlasEntity ret = null;
        switch (node.getNodeType()) {
            case DATABASE: {
                ret = this.toDbEntity(node);
                break;
            }
            case TABLE: 
            case PARTITION: {
                ret = this.toTableEntity(node, entityExtInfo);
                break;
            }
        }
        return ret;
    }

    protected AtlasEntity toDbEntity(ImpalaNode db) throws Exception {
        return this.toDbEntity(db.getNodeName());
    }

    protected AtlasEntity toDbEntity(String dbName) throws Exception {
        String dbQualifiedName = this.context.getQualifiedNameForDb(dbName);
        AtlasEntity ret = this.context.getEntity(dbQualifiedName);
        if (ret == null) {
            ret = new AtlasEntity(HIVE_TYPE_DB);
            ret.setGuid(null);
            ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)dbQualifiedName);
            ret.setAttribute(ATTRIBUTE_NAME, (Object)dbName.toLowerCase());
            ret.setAttribute(ATTRIBUTE_CLUSTER_NAME, (Object)this.context.getMetadataNamespace());
            this.context.putEntity(dbQualifiedName, ret);
        }
        return ret;
    }

    protected AtlasEntity.AtlasEntityWithExtInfo toTableEntity(ImpalaNode table) throws Exception {
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo();
        AtlasEntity entity = this.toTableEntity(table, (AtlasEntity.AtlasEntityExtInfo)ret);
        if (entity != null) {
            ret.setEntity(entity);
        } else {
            ret = null;
        }
        return ret;
    }

    protected AtlasEntity toTableEntity(ImpalaNode table, AtlasEntity.AtlasEntitiesWithExtInfo entities) throws Exception {
        AtlasEntity ret = this.toTableEntity(table, (AtlasEntity.AtlasEntityExtInfo)entities);
        if (ret != null) {
            entities.addEntity(ret);
        }
        return ret;
    }

    protected AtlasEntity toTableEntity(ImpalaNode table, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws Exception {
        if (table == null || table.getNodeName() == null) {
            throw new IllegalArgumentException("table is null or its name is null");
        }
        String dbName = this.context.getDatabaseNameFromTable(table.getNodeName());
        if (dbName == null) {
            throw new IllegalArgumentException(String.format("db name is null for table: {}", table.getNodeName()));
        }
        AtlasEntity dbEntity = this.toDbEntity(dbName);
        if (entityExtInfo != null && dbEntity != null) {
            entityExtInfo.addReferredEntity(dbEntity);
        }
        AtlasEntity ret = this.toTableEntity(BaseImpalaEvent.getObjectId(dbEntity), table, entityExtInfo);
        return ret;
    }

    protected AtlasEntity toTableEntity(AtlasObjectId dbId, ImpalaNode table, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws Exception {
        long createTime;
        String tblQualifiedName = this.getQualifiedName(table);
        AtlasEntity ret = this.context.getEntity(tblQualifiedName);
        if (ret != null) {
            return ret;
        }
        ret = new AtlasEntity(HIVE_TYPE_TABLE);
        ret.setGuid(null);
        long lastAccessTime = createTime = BaseImpalaEvent.getTableCreateTime(table);
        ret.setAttribute(ATTRIBUTE_DB, (Object)dbId);
        ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)tblQualifiedName);
        ret.setAttribute(ATTRIBUTE_NAME, (Object)table.getNodeName().toLowerCase());
        ret.setAttribute(ATTRIBUTE_OWNER, (Object)this.getUserName());
        ret.setAttribute(ATTRIBUTE_CREATE_TIME, (Object)createTime);
        ret.setAttribute(ATTRIBUTE_LAST_ACCESS_TIME, (Object)lastAccessTime);
        AtlasObjectId tableId = BaseImpalaEvent.getObjectId(ret);
        List<AtlasEntity> columns = this.getColumnEntities(tableId, table);
        if (entityExtInfo != null && columns != null) {
            for (AtlasEntity column : columns) {
                entityExtInfo.addReferredEntity(column);
            }
        }
        ret.setAttribute(ATTRIBUTE_COLUMNS, BaseImpalaEvent.getObjectIds(columns));
        this.context.putEntity(tblQualifiedName, ret);
        return ret;
    }

    public static AtlasObjectId getObjectId(AtlasEntity entity) {
        String qualifiedName = (String)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME);
        AtlasObjectId ret = new AtlasObjectId(entity.getGuid(), entity.getTypeName(), Collections.singletonMap(ATTRIBUTE_QUALIFIED_NAME, qualifiedName));
        return ret;
    }

    public static List<AtlasObjectId> getObjectIds(List<AtlasEntity> entities) {
        List<AtlasObjectId> ret;
        if (CollectionUtils.isNotEmpty(entities)) {
            ret = new ArrayList<AtlasObjectId>(entities.size());
            for (AtlasEntity entity : entities) {
                ret.add(BaseImpalaEvent.getObjectId(entity));
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public static long getTableCreateTime(ImpalaNode table) {
        return BaseImpalaEvent.getTableCreateTime(table.getOwnVertex());
    }

    public static long getTableCreateTime(LineageVertex tableVertex) {
        Long createTime = tableVertex.getCreateTime();
        if (createTime != null) {
            return createTime * 1000L;
        }
        return System.currentTimeMillis();
    }

    protected List<AtlasEntity> getColumnEntities(AtlasObjectId tableId, ImpalaNode table) {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        for (ImpalaNode childNode : table.getChildren().values()) {
            String colQualifiedName = this.getQualifiedName(childNode);
            AtlasEntity column = this.context.getEntity(colQualifiedName);
            if (column == null) {
                column = new AtlasEntity(HIVE_TYPE_COLUMN);
                column.setGuid(null);
                column.setAttribute(ATTRIBUTE_TABLE, (Object)tableId);
                column.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)colQualifiedName);
                column.setAttribute(ATTRIBUTE_NAME, (Object)this.context.getColumnNameOnly(childNode.getNodeName()));
                column.setAttribute(ATTRIBUTE_OWNER, (Object)this.getUserName());
                this.context.putEntity(colQualifiedName, column);
            }
            ret.add(column);
        }
        return ret;
    }

    protected AtlasEntity getImpalaProcessEntity(List<AtlasEntity> inputs, List<AtlasEntity> outputs) throws Exception {
        AtlasEntity ret = new AtlasEntity(ImpalaDataType.IMPALA_PROCESS.getName());
        String queryStr = this.context.getQueryStr();
        if (queryStr != null) {
            queryStr = queryStr.toLowerCase().trim();
        }
        Long startTime = this.getQueryStartTime();
        Long endTime = this.getQueryEndTime();
        String qualifiedName = this.getQualifiedName(inputs, outputs);
        ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)qualifiedName);
        ret.setAttribute(ATTRIBUTE_INPUTS, BaseImpalaEvent.getObjectIds(inputs));
        ret.setAttribute(ATTRIBUTE_OUTPUTS, BaseImpalaEvent.getObjectIds(outputs));
        ret.setAttribute(ATTRIBUTE_NAME, (Object)qualifiedName);
        ret.setAttribute(ATTRIBUTE_OPERATION_TYPE, (Object)this.context.getImpalaOperationType());
        ret.setAttribute(ATTRIBUTE_START_TIME, (Object)startTime);
        ret.setAttribute(ATTRIBUTE_END_TIME, (Object)endTime);
        ret.setAttribute(ATTRIBUTE_USER_NAME, (Object)EMPTY_ATTRIBUTE_VALUE);
        ret.setAttribute(ATTRIBUTE_QUERY_TEXT, (Object)EMPTY_ATTRIBUTE_VALUE);
        ret.setAttribute(ATTRIBUTE_QUERY_ID, (Object)EMPTY_ATTRIBUTE_VALUE);
        ret.setAttribute(ATTRIBUTE_QUERY_PLAN, (Object)"Not Supported");
        ret.setAttribute(ATTRIBUTE_RECENT_QUERIES, Collections.singletonList(queryStr));
        return ret;
    }

    protected AtlasEntity getImpalaProcessExecutionEntity(AtlasEntity impalaProcess) throws Exception {
        AtlasEntity ret = new AtlasEntity(ImpalaDataType.IMPALA_PROCESS_EXECUTION.getName());
        String queryStr = this.context.getQueryStr();
        if (queryStr != null) {
            queryStr = queryStr.toLowerCase().trim();
        }
        Long startTime = this.getQueryStartTime();
        Long endTime = this.getQueryEndTime();
        String qualifiedName = impalaProcess.getAttribute(ATTRIBUTE_QUALIFIED_NAME).toString() + ':' + startTime.toString() + ':' + endTime.toString();
        ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)qualifiedName);
        ret.setAttribute(ATTRIBUTE_NAME, (Object)qualifiedName);
        ret.setAttribute(ATTRIBUTE_START_TIME, (Object)startTime);
        ret.setAttribute(ATTRIBUTE_END_TIME, (Object)endTime);
        ret.setAttribute(ATTRIBUTE_USER_NAME, (Object)this.getUserName());
        ret.setAttribute(ATTRIBUTE_QUERY_TEXT, (Object)queryStr);
        ret.setAttribute(ATTRIBUTE_QUERY_ID, (Object)this.context.getLineageQuery().getQueryId());
        ret.setAttribute(ATTRIBUTE_QUERY_PLAN, (Object)"Not Supported");
        ret.setAttribute(ATTRIBUTE_HOSTNAME, (Object)this.context.getHostName());
        ret.setRelationshipAttribute(ATTRIBUTE_PROCESS, (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)impalaProcess));
        return ret;
    }

    protected Long getQueryStartTime() {
        return this.context.getLineageQuery().getTimestamp() * 1000L;
    }

    protected Long getQueryEndTime() {
        return this.context.getLineageQuery().getEndTime() * 1000L;
    }

    protected void addProcessedEntities(AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo) {
        for (AtlasEntity entity : this.context.getEntities()) {
            entitiesWithExtInfo.addReferredEntity(entity);
        }
        entitiesWithExtInfo.compact();
    }

    protected Long getCreateTimeInVertex(LineageVertex vertex) {
        LineageVertexMetadata metadata;
        if (vertex == null) {
            return System.currentTimeMillis() / 1000L;
        }
        Long createTime = vertex.getCreateTime();
        if (createTime != null) {
            return createTime;
        }
        if (vertex.getVertexType() == ImpalaVertexType.COLUMN && (metadata = vertex.getMetadata()) != null) {
            return metadata.getTableCreateTime();
        }
        return System.currentTimeMillis() / 1000L;
    }

    protected ImpalaNode createTableNode(String tableName, Long createTime) {
        LineageVertex tableVertex = new LineageVertex();
        tableVertex.setVertexType(ImpalaVertexType.TABLE);
        tableVertex.setVertexId(tableName);
        tableVertex.setCreateTime(createTime);
        return new ImpalaNode(tableVertex);
    }

    protected AtlasEntity createHiveDDLEntity(AtlasEntity dbOrTable) {
        return this.createHiveDDLEntity(dbOrTable, true);
    }

    protected AtlasEntity createHiveDDLEntity(AtlasEntity dbOrTable, boolean excludeEntityGuid) {
        AtlasObjectId objId = BaseImpalaEvent.getObjectId(dbOrTable);
        AtlasEntity hiveDDL = null;
        if (excludeEntityGuid) {
            objId.setGuid(null);
        }
        if (StringUtils.equals((String)objId.getTypeName(), (String)HIVE_TYPE_DB)) {
            hiveDDL = new AtlasEntity(ImpalaDataType.HIVE_DB_DDL.getName(), ATTRIBUTE_DB, (Object)objId);
        } else if (StringUtils.equals((String)objId.getTypeName(), (String)HIVE_TYPE_TABLE)) {
            hiveDDL = new AtlasEntity(ImpalaDataType.HIVE_TABLE_DDL.getName(), ATTRIBUTE_TABLE, (Object)objId);
        }
        if (hiveDDL != null) {
            hiveDDL.setAttribute(ATTRIBUTE_SERVICE_TYPE, (Object)"impala");
            hiveDDL.setAttribute(ATTRIBUTE_EXEC_TIME, (Object)this.getQueryStartTime());
            hiveDDL.setAttribute(ATTRIBUTE_QUERY_TEXT, (Object)this.context.getQueryStr());
            hiveDDL.setAttribute(ATTRIBUTE_USER_NAME, (Object)this.getUserName());
            hiveDDL.setAttribute(ATTRIBUTE_NAME, (Object)(this.context.getQueryStr() + ':' + this.getQueryStartTime().toString()));
            hiveDDL.setAttribute(ATTRIBUTE_QUALIFIED_NAME, hiveDDL.getAttribute(ATTRIBUTE_NAME));
        }
        return hiveDDL;
    }

    protected boolean isDdlOperation() {
        return this.context.getImpalaOperationType().equals((Object)ImpalaOperationType.CREATEVIEW) || this.context.getImpalaOperationType().equals((Object)ImpalaOperationType.ALTERVIEW_AS) || this.context.getImpalaOperationType().equals((Object)ImpalaOperationType.CREATETABLE_AS_SELECT);
    }

    static final class AtlasEntityComparator
    implements Comparator<AtlasEntity> {
        AtlasEntityComparator() {
        }

        @Override
        public int compare(AtlasEntity entity1, AtlasEntity entity2) {
            String name1 = (String)entity1.getAttribute(BaseImpalaEvent.ATTRIBUTE_QUALIFIED_NAME);
            String name2 = (String)entity2.getAttribute(BaseImpalaEvent.ATTRIBUTE_QUALIFIED_NAME);
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.toLowerCase().compareTo(name2.toLowerCase());
        }
    }
}

