/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala.hook.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.impala.hook.AtlasImpalaHookContext;
import org.apache.atlas.impala.hook.events.BaseImpalaEvent;
import org.apache.atlas.impala.model.ImpalaDataType;
import org.apache.atlas.impala.model.ImpalaDependencyType;
import org.apache.atlas.impala.model.ImpalaNode;
import org.apache.atlas.impala.model.ImpalaQuery;
import org.apache.atlas.impala.model.ImpalaVertexType;
import org.apache.atlas.impala.model.LineageEdge;
import org.apache.atlas.impala.model.LineageVertex;
import org.apache.atlas.impala.model.LineageVertexMetadata;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateImpalaProcess
extends BaseImpalaEvent {
    private static final Logger LOG = LoggerFactory.getLogger(CreateImpalaProcess.class);

    public CreateImpalaProcess(AtlasImpalaHookContext context) {
        super(context);
    }

    @Override
    public List<HookNotification> getNotificationMessages() throws Exception {
        List<HookNotification.EntityCreateRequestV2> ret = null;
        AtlasEntity.AtlasEntitiesWithExtInfo entities = this.getEntities();
        if (entities != null && CollectionUtils.isNotEmpty((Collection)entities.getEntities())) {
            ret = Collections.singletonList(new HookNotification.EntityCreateRequestV2(this.getUserName(), entities));
        }
        return ret;
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntities() throws Exception {
        AtlasEntity entity;
        String qualifiedName;
        AtlasEntity.AtlasEntitiesWithExtInfo ret = null;
        ArrayList<ImpalaNode> inputNodes = new ArrayList<ImpalaNode>();
        ArrayList<ImpalaNode> outputNodes = new ArrayList<ImpalaNode>();
        ArrayList<AtlasEntity> inputs = new ArrayList<AtlasEntity>();
        ArrayList<AtlasEntity> outputs = new ArrayList<AtlasEntity>();
        HashSet<String> processedNames = new HashSet<String>();
        this.getInputOutList(this.context.getLineageQuery(), inputNodes, outputNodes);
        if (this.skipProcess(inputNodes, outputNodes)) {
            return ret;
        }
        ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        if (!inputNodes.isEmpty()) {
            for (ImpalaNode input : inputNodes) {
                qualifiedName = this.getQualifiedName(input);
                if (qualifiedName == null || !processedNames.add(qualifiedName) || (entity = this.getInputOutputEntity(input, (AtlasEntity.AtlasEntityExtInfo)ret)) == null) continue;
                inputs.add(entity);
            }
        }
        if (outputNodes != null) {
            for (ImpalaNode output : outputNodes) {
                AtlasEntity ddlEntity;
                qualifiedName = this.getQualifiedName(output);
                if (qualifiedName == null || !processedNames.add(qualifiedName) || (entity = this.getInputOutputEntity(output, (AtlasEntity.AtlasEntityExtInfo)ret)) == null) continue;
                outputs.add(entity);
                if (!this.isDdlOperation() || (ddlEntity = this.createHiveDDLEntity(entity)) == null) continue;
                ret.addEntity(ddlEntity);
            }
        }
        if (!inputs.isEmpty() || !outputs.isEmpty()) {
            AtlasEntity process = this.getImpalaProcessEntity(inputs, outputs);
            if (process != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("get process entity with qualifiedName: {}", process.getAttribute("qualifiedName"));
                }
                ret.addEntity(process);
                AtlasEntity processExecution = this.getImpalaProcessExecutionEntity(process);
                if (processExecution != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("get process executition entity with qualifiedName: {}", processExecution.getAttribute("qualifiedName"));
                    }
                    ret.addEntity(processExecution);
                }
                this.processColumnLineage(process, ret);
                this.addProcessedEntities(ret);
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private void processColumnLineage(AtlasEntity impalaProcess, AtlasEntity.AtlasEntitiesWithExtInfo entities) {
        List<LineageEdge> edges = this.context.getLineageQuery().getEdges();
        if (CollectionUtils.isEmpty(edges)) {
            return;
        }
        ArrayList<AtlasEntity> columnLineages = new ArrayList<AtlasEntity>();
        HashSet<String> processedOutputCols = new HashSet<String>();
        for (LineageEdge edge : edges) {
            if (!edge.getEdgeType().equals((Object)ImpalaDependencyType.PROJECTION)) continue;
            ArrayList<AtlasEntity> outputColumns = new ArrayList<AtlasEntity>();
            for (Long l : edge.getTargets()) {
                LineageVertex columnVertex = (LineageVertex)this.verticesMap.get(l);
                String outputColName = this.getQualifiedName(columnVertex);
                AtlasEntity outputColumn = this.context.getEntity(outputColName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("processColumnLineage(): target id = {}, target column name = {}", (Object)l, (Object)outputColName);
                }
                if (outputColumn == null) {
                    LOG.warn("column-lineage: non-existing output-column {}", (Object)outputColName);
                    continue;
                }
                if (processedOutputCols.contains(outputColName)) {
                    LOG.warn("column-lineage: duplicate for output-column {}", (Object)outputColName);
                    continue;
                }
                processedOutputCols.add(outputColName);
                outputColumns.add(outputColumn);
            }
            ArrayList<AtlasEntity> inputColumns = new ArrayList<AtlasEntity>();
            for (Long sourceId : edge.getSources()) {
                LineageVertex columnVertex = (LineageVertex)this.verticesMap.get(sourceId);
                String inputColName = this.getQualifiedName(columnVertex);
                AtlasEntity inputColumn = this.context.getEntity(inputColName);
                if (inputColumn == null) {
                    LOG.warn("column-lineage: non-existing input-column {} with id ={}", (Object)inputColName, (Object)sourceId);
                    continue;
                }
                inputColumns.add(inputColumn);
            }
            if (inputColumns.isEmpty()) continue;
            AtlasEntity atlasEntity = new AtlasEntity(ImpalaDataType.IMPALA_COLUMN_LINEAGE.getName());
            String columnQualifiedName = (String)impalaProcess.getAttribute("qualifiedName") + ':' + ((AtlasEntity)outputColumns.get(0)).getAttribute("name");
            atlasEntity.setAttribute("name", (Object)columnQualifiedName);
            atlasEntity.setAttribute("qualifiedName", (Object)columnQualifiedName);
            atlasEntity.setAttribute("inputs", CreateImpalaProcess.getObjectIds(inputColumns));
            atlasEntity.setAttribute("outputs", CreateImpalaProcess.getObjectIds(outputColumns));
            atlasEntity.setAttribute("query", (Object)CreateImpalaProcess.getObjectId(impalaProcess));
            atlasEntity.setAttribute("dependencyType", (Object)ImpalaDependencyType.PROJECTION.getName());
            columnLineages.add(atlasEntity);
        }
        for (AtlasEntity columnLineage : columnLineages) {
            String columnQualifiedName = (String)columnLineage.getAttribute("qualifiedName");
            if (LOG.isDebugEnabled()) {
                LOG.debug("get column lineage entity with qualifiedName: {}", (Object)columnQualifiedName);
            }
            entities.addEntity(columnLineage);
        }
    }

    private void getInputOutList(ImpalaQuery lineageQuery, List<ImpalaNode> inputNodes, List<ImpalaNode> outputNodes) {
        for (LineageVertex vertex : lineageQuery.getVertices()) {
            this.updateVertexMap(vertex);
        }
        HashSet<Long> sourceIds = new HashSet<Long>();
        HashSet<Long> targetIds = new HashSet<Long>();
        for (LineageEdge edge : lineageQuery.getEdges()) {
            if (!ImpalaDependencyType.PROJECTION.equals((Object)edge.getEdgeType())) continue;
            sourceIds.addAll(edge.getSources());
            targetIds.addAll(edge.getTargets());
        }
        Map<String, ImpalaNode> inputMap = this.buildInputOutputList(sourceIds, this.verticesMap, this.vertexNameMap);
        Map<String, ImpalaNode> outputMap = this.buildInputOutputList(targetIds, this.verticesMap, this.vertexNameMap);
        inputNodes.addAll(inputMap.values());
        outputNodes.addAll(outputMap.values());
    }

    private void updateVertexMap(LineageVertex vertex) {
        this.verticesMap.put(vertex.getId(), vertex);
        this.vertexNameMap.put(vertex.getVertexId(), new ImpalaNode(vertex));
        if (vertex.getVertexType() == ImpalaVertexType.COLUMN) {
            LineageVertexMetadata metadata = vertex.getMetadata();
            if (metadata == null) {
                return;
            }
            String tableName = metadata.getTableName();
            ImpalaNode tableNode = (ImpalaNode)this.vertexNameMap.get(tableName);
            if (tableNode == null) {
                tableNode = this.createTableNode(tableName, metadata.getTableCreateTime());
                this.vertexNameMap.put(tableName, tableNode);
            }
        }
    }

    private Map<String, ImpalaNode> buildInputOutputList(Set<Long> idSet, Map<Long, LineageVertex> vertexMap, Map<String, ImpalaNode> vertexNameMap) {
        HashMap<String, ImpalaNode> returnTableMap = new HashMap<String, ImpalaNode>();
        for (Long id : idSet) {
            LineageVertex vertex = vertexMap.get(id);
            if (vertex == null) {
                LOG.warn("cannot find vertex with id: {}", (Object)id);
                continue;
            }
            if (!ImpalaVertexType.COLUMN.equals((Object)vertex.getVertexType())) continue;
            String tableName = this.getTableNameFromVertex(vertex);
            if (tableName == null) {
                LOG.warn("cannot find tableName for vertex with id: {}, column name : {}", (Object)id, (Object)(vertex.getVertexId() == null ? "null" : vertex.getVertexId()));
                continue;
            }
            ImpalaNode tableNode = (ImpalaNode)returnTableMap.get(tableName);
            if (tableNode == null) {
                tableNode = vertexNameMap.get(tableName);
                if (tableNode == null) {
                    LOG.warn("cannot find table node for vertex with id: {}, column name : {}", (Object)id, (Object)vertex.getVertexId());
                    tableNode = this.createTableNode(tableName, this.getCreateTimeInVertex(null));
                    vertexNameMap.put(tableName, tableNode);
                }
                returnTableMap.put(tableName, tableNode);
            }
            tableNode.addChild(vertex);
        }
        return returnTableMap;
    }

    private boolean skipProcess(List<ImpalaNode> inputNodes, List<ImpalaNode> ouputNodes) {
        return inputNodes.isEmpty() || ouputNodes.isEmpty();
    }
}

