/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.impala.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.impala.model.ImpalaVertexType;
import org.apache.atlas.impala.model.LineageVertex;

public class ImpalaNode {
    LineageVertex ownVertex;
    Map<Long, ImpalaNode> children;

    public ImpalaNode(LineageVertex ownVertex) {
        this.ownVertex = ownVertex;
        this.children = new HashMap<Long, ImpalaNode>();
    }

    public String getNodeName() {
        return this.ownVertex.getVertexId();
    }

    public ImpalaVertexType getNodeType() {
        return this.ownVertex.getVertexType();
    }

    public LineageVertex getOwnVertex() {
        return this.ownVertex;
    }

    public Map<Long, ImpalaNode> getChildren() {
        return this.children;
    }

    public ImpalaNode addChild(LineageVertex child) {
        ImpalaNode exitingChild = this.children.get(child.getId());
        if (exitingChild != null) {
            return exitingChild;
        }
        ImpalaNode newChild = new ImpalaNode(child);
        return this.children.put(child.getId(), newChild);
    }
}

