/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.sqoop.hook;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridge;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.hook.AtlasHookException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.sqoop.model.SqoopDataTypes;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasConfigurationUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.sqoop.SqoopJobDataPublisher;
import org.apache.sqoop.util.ImportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopHook
extends SqoopJobDataPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopHook.class);
    public static final String CLUSTER_NAME_KEY = "atlas.cluster.name";
    public static final String ATLAS_METADATA_NAMESPACE = "atlas.metadata.namespace";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    public static final String USER = "userName";
    public static final String DB_STORE_TYPE = "dbStoreType";
    public static final String DB_STORE_USAGE = "storeUse";
    public static final String SOURCE = "source";
    public static final String DESCRIPTION = "description";
    public static final String STORE_URI = "storeUri";
    public static final String OPERATION = "operation";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String CMD_LINE_OPTS = "commandlineOpts";
    public static final String INPUTS = "inputs";
    public static final String OUTPUTS = "outputs";
    public static final String ATTRIBUTE_DB = "db";
    public static final String RELATIONSHIP_HIVE_TABLE_DB = "hive_table_db";
    public static final String RELATIONSHIP_DATASET_PROCESS_INPUTS = "dataset_process_inputs";
    public static final String RELATIONSHIP_PROCESS_DATASET_OUTPUTS = "process_dataset_outputs";
    private static final AtlasHookImpl atlasHook;

    public void publish(SqoopJobDataPublisher.Data data) throws AtlasHookException {
        try {
            Configuration atlasProperties = ApplicationProperties.get();
            String metadataNamespace = AtlasConfigurationUtil.getRecentString((Configuration)atlasProperties, (String)ATLAS_METADATA_NAMESPACE, (String)this.getClusterName(atlasProperties));
            AtlasEntity entDbStore = this.toSqoopDBStoreEntity(data);
            AtlasEntity entHiveDb = this.toHiveDatabaseEntity(metadataNamespace, data.getHiveDB());
            AtlasEntity entHiveTable = data.getHiveTable() != null ? this.toHiveTableEntity(entHiveDb, data.getHiveTable()) : null;
            AtlasEntity entProcess = this.toSqoopProcessEntity(entDbStore, entHiveDb, entHiveTable, data, metadataNamespace);
            AtlasEntity.AtlasEntitiesWithExtInfo entities = new AtlasEntity.AtlasEntitiesWithExtInfo(entProcess);
            entities.addReferredEntity(entDbStore);
            entities.addReferredEntity(entHiveDb);
            if (entHiveTable != null) {
                entities.addReferredEntity(entHiveTable);
            }
            HookNotification.EntityCreateRequestV2 message = new HookNotification.EntityCreateRequestV2(AtlasHook.getUser(), entities);
            atlasHook.sendNotification((HookNotification)message);
        }
        catch (Exception e) {
            LOG.error("SqoopHook.publish() failed", (Throwable)e);
            throw new AtlasHookException("SqoopHook.publish() failed.", (Throwable)e);
        }
    }

    private String getClusterName(Configuration config) {
        return config.getString(CLUSTER_NAME_KEY, DEFAULT_CLUSTER_NAME);
    }

    private AtlasEntity toHiveDatabaseEntity(String metadataNamespace, String dbName) {
        AtlasEntity entHiveDb = new AtlasEntity(HiveDataTypes.HIVE_DB.getName());
        String qualifiedName = HiveMetaStoreBridge.getDBQualifiedName((String)metadataNamespace, (String)dbName);
        entHiveDb.setAttribute("clusterName", (Object)metadataNamespace);
        entHiveDb.setAttribute("name", (Object)dbName);
        entHiveDb.setAttribute("qualifiedName", (Object)qualifiedName);
        return entHiveDb;
    }

    private AtlasEntity toHiveTableEntity(AtlasEntity entHiveDb, String tableName) {
        AtlasEntity entHiveTable = new AtlasEntity(HiveDataTypes.HIVE_TABLE.getName());
        String qualifiedName = HiveMetaStoreBridge.getTableQualifiedName((String)((String)entHiveDb.getAttribute("clusterName")), (String)((String)entHiveDb.getAttribute("name")), (String)tableName);
        entHiveTable.setAttribute("name", (Object)tableName.toLowerCase());
        entHiveTable.setAttribute("qualifiedName", (Object)qualifiedName);
        entHiveTable.setRelationshipAttribute(ATTRIBUTE_DB, (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)entHiveDb, (String)RELATIONSHIP_HIVE_TABLE_DB));
        return entHiveTable;
    }

    private AtlasEntity toSqoopDBStoreEntity(SqoopJobDataPublisher.Data data) throws ImportException {
        String table = data.getStoreTable();
        String query = data.getStoreQuery();
        if (StringUtils.isBlank((CharSequence)table) && StringUtils.isBlank((CharSequence)query)) {
            throw new ImportException("Both table and query cannot be empty for DBStoreInstance");
        }
        String usage = table != null ? "TABLE" : "QUERY";
        String source = table != null ? table : query;
        String name = SqoopHook.getSqoopDBStoreName(data);
        AtlasEntity entDbStore = new AtlasEntity(SqoopDataTypes.SQOOP_DBDATASTORE.getName());
        entDbStore.setAttribute("name", (Object)name);
        entDbStore.setAttribute("qualifiedName", (Object)name);
        entDbStore.setAttribute(DB_STORE_TYPE, (Object)data.getStoreType());
        entDbStore.setAttribute(DB_STORE_USAGE, (Object)usage);
        entDbStore.setAttribute(STORE_URI, (Object)data.getUrl());
        entDbStore.setAttribute(SOURCE, (Object)source);
        entDbStore.setAttribute(DESCRIPTION, (Object)"");
        entDbStore.setAttribute("owner", (Object)data.getUser());
        return entDbStore;
    }

    private AtlasEntity toSqoopProcessEntity(AtlasEntity entDbStore, AtlasEntity entHiveDb, AtlasEntity entHiveTable, SqoopJobDataPublisher.Data data, String metadataNamespace) {
        AtlasEntity entProcess = new AtlasEntity(SqoopDataTypes.SQOOP_PROCESS.getName());
        String sqoopProcessName = SqoopHook.getSqoopProcessName(data, metadataNamespace);
        HashMap<String, String> sqoopOptionsMap = new HashMap<String, String>();
        Properties options = data.getOptions();
        for (Object k : options.keySet()) {
            sqoopOptionsMap.put((String)k, (String)options.get(k));
        }
        entProcess.setAttribute("name", (Object)sqoopProcessName);
        entProcess.setAttribute("qualifiedName", (Object)sqoopProcessName);
        entProcess.setAttribute(OPERATION, (Object)data.getOperation());
        List<AtlasObjectId> sqoopObjects = Collections.singletonList(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entDbStore));
        List<AtlasObjectId> hiveObjects = Collections.singletonList(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)(entHiveTable != null ? entHiveTable : entHiveDb)));
        if (this.isImportOperation(data)) {
            entProcess.setRelationshipAttribute(INPUTS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIdList(sqoopObjects, (String)RELATIONSHIP_DATASET_PROCESS_INPUTS));
            entProcess.setRelationshipAttribute(OUTPUTS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIdList(hiveObjects, (String)RELATIONSHIP_PROCESS_DATASET_OUTPUTS));
        } else {
            entProcess.setRelationshipAttribute(INPUTS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIdList(hiveObjects, (String)RELATIONSHIP_DATASET_PROCESS_INPUTS));
            entProcess.setRelationshipAttribute(OUTPUTS, (Object)AtlasTypeUtil.getAtlasRelatedObjectIdList(sqoopObjects, (String)RELATIONSHIP_PROCESS_DATASET_OUTPUTS));
        }
        entProcess.setAttribute(USER, (Object)data.getUser());
        entProcess.setAttribute(START_TIME, (Object)new Date(data.getStartTime()));
        entProcess.setAttribute(END_TIME, (Object)new Date(data.getEndTime()));
        entProcess.setAttribute(CMD_LINE_OPTS, sqoopOptionsMap);
        return entProcess;
    }

    private boolean isImportOperation(SqoopJobDataPublisher.Data data) {
        return data.getOperation().toLowerCase().equals("import");
    }

    static String getSqoopProcessName(SqoopJobDataPublisher.Data data, String metadataNamespace) {
        StringBuilder name = new StringBuilder(String.format("sqoop %s --connect %s", data.getOperation(), data.getUrl()));
        if (StringUtils.isNotEmpty((CharSequence)data.getHiveTable())) {
            name.append(" --table ").append(data.getStoreTable());
        } else {
            name.append(" --database ").append(data.getHiveDB());
        }
        if (StringUtils.isNotEmpty((CharSequence)data.getStoreQuery())) {
            name.append(" --query ").append(data.getStoreQuery());
        }
        if (data.getHiveTable() != null) {
            name.append(String.format(" --hive-%s --hive-database %s --hive-table %s --hive-cluster %s", data.getOperation(), data.getHiveDB().toLowerCase(), data.getHiveTable().toLowerCase(), metadataNamespace));
        } else {
            name.append(String.format("--hive-%s --hive-database %s --hive-cluster %s", data.getOperation(), data.getHiveDB(), metadataNamespace));
        }
        return name.toString();
    }

    static String getSqoopDBStoreName(SqoopJobDataPublisher.Data data) {
        StringBuilder name = new StringBuilder(String.format("%s --url %s", data.getStoreType(), data.getUrl()));
        if (StringUtils.isNotEmpty((CharSequence)data.getHiveTable())) {
            name.append(" --table ").append(data.getStoreTable());
        } else {
            name.append(" --database ").append(data.getHiveDB());
        }
        if (StringUtils.isNotEmpty((CharSequence)data.getStoreQuery())) {
            name.append(" --query ").append(data.getStoreQuery());
        }
        return name.toString();
    }

    static {
        org.apache.hadoop.conf.Configuration.addDefaultResource((String)"sqoop-site.xml");
        atlasHook = new AtlasHookImpl();
    }

    private static class AtlasHookImpl
    extends AtlasHook {
        private AtlasHookImpl() {
        }

        public String getMessageSource() {
            return "sqoop";
        }

        public void sendNotification(HookNotification notification) {
            super.notifyEntities(Collections.singletonList(notification), null);
        }
    }
}

