/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.storm.hook;

import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.StormTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StormTopologyUtil {
    public static final Logger LOG = LoggerFactory.getLogger(StormTopologyUtil.class);
    private static final Set<Class> WRAPPER_TYPES = new HashSet<Class>(){
        {
            this.add(Boolean.class);
            this.add(Character.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Void.class);
            this.add(String.class);
        }
    };

    private StormTopologyUtil() {
    }

    public static Set<String> getTerminalUserBoltNames(StormTopology topology) {
        HashSet<String> terminalBolts = new HashSet<String>();
        HashSet<String> inputs = new HashSet<String>();
        for (Map.Entry entry : topology.get_bolts().entrySet()) {
            String name = (String)entry.getKey();
            Set inputsForBolt = ((Bolt)entry.getValue()).get_common().get_inputs().keySet();
            if (StormTopologyUtil.isSystemComponent(name)) continue;
            for (GlobalStreamId streamId : inputsForBolt) {
                inputs.add(streamId.get_componentId());
            }
        }
        for (String boltName : topology.get_bolts().keySet()) {
            if (StormTopologyUtil.isSystemComponent(boltName) || inputs.contains(boltName)) continue;
            terminalBolts.add(boltName);
        }
        return terminalBolts;
    }

    public static boolean isSystemComponent(String componentName) {
        return componentName.startsWith("__");
    }

    public static Map<String, Set<String>> getAdjacencyMap(StormTopology topology, boolean removeSystemComponent) {
        HashMap<String, Set<String>> adjacencyMap = new HashMap<String, Set<String>>();
        for (Map.Entry entry : topology.get_bolts().entrySet()) {
            String boltName = (String)entry.getKey();
            Map inputs = ((Bolt)entry.getValue()).get_common().get_inputs();
            for (Map.Entry input : inputs.entrySet()) {
                String inputComponentId = ((GlobalStreamId)input.getKey()).get_componentId();
                Set<String> components = adjacencyMap.containsKey(inputComponentId) ? (Set)adjacencyMap.get(inputComponentId) : new HashSet();
                components.add(boltName);
                Set<String> set = components = removeSystemComponent ? StormTopologyUtil.removeSystemComponents(components) : components;
                if (removeSystemComponent && StormTopologyUtil.isSystemComponent(inputComponentId)) continue;
                adjacencyMap.put(inputComponentId, components);
            }
        }
        return adjacencyMap;
    }

    public static Set<String> removeSystemComponents(Set<String> components) {
        HashSet<String> userComponents = new HashSet<String>();
        for (String component : components) {
            if (StormTopologyUtil.isSystemComponent(component)) continue;
            userComponents.add(component);
        }
        return userComponents;
    }

    public static boolean isWrapperType(Class clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    public static boolean isCollectionType(Class clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isMapType(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public static Map<String, String> getFieldValues(Object instance, boolean prependClassName, Set<Object> objectsToSkip) {
        HashMap<String, String> output;
        block16: {
            if (objectsToSkip == null) {
                objectsToSkip = new HashSet<Object>();
            }
            output = new HashMap<String, String>();
            try {
                Class<?> clazz;
                if (!objectsToSkip.add(instance)) break block16;
                for (Class<?> c = clazz = instance.getClass(); c != null; c = c.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = c.getDeclaredFields()) {
                        Object fieldVal;
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        String key = prependClassName ? String.format("%s.%s", clazz.getSimpleName(), field.getName()) : field.getName();
                        boolean accessible = field.isAccessible();
                        if (!accessible) {
                            field.setAccessible(true);
                        }
                        if ((fieldVal = field.get(instance)) == null) continue;
                        if (fieldVal.getClass().isPrimitive() || StormTopologyUtil.isWrapperType(fieldVal.getClass())) {
                            if (StormTopologyUtil.toString(fieldVal, false).isEmpty()) continue;
                            output.put(key, StormTopologyUtil.toString(fieldVal, false));
                        } else if (StormTopologyUtil.isMapType(fieldVal.getClass())) {
                            Map map = (Map)fieldVal;
                            for (Map.Entry entry : map.entrySet()) {
                                Object mapKey = entry.getKey();
                                Object mapVal = entry.getValue();
                                String keyStr = StormTopologyUtil.getString(mapKey, false, objectsToSkip);
                                String valStr = StormTopologyUtil.getString(mapVal, false, objectsToSkip);
                                if (!StringUtils.isNotEmpty((String)valStr)) continue;
                                output.put(String.format("%s.%s", key, keyStr), valStr);
                            }
                        } else if (StormTopologyUtil.isCollectionType(fieldVal.getClass())) {
                            Collection collection = (Collection)fieldVal;
                            if (collection.size() == 0) continue;
                            String outStr = "";
                            for (Object o : collection) {
                                outStr = outStr + StormTopologyUtil.getString(o, false, objectsToSkip) + ",";
                            }
                            if (outStr.length() > 0) {
                                outStr = outStr.substring(0, outStr.length() - 1);
                            }
                            output.put(key, String.format("%s", outStr));
                        } else {
                            Map<String, String> nestedFieldValues = StormTopologyUtil.getFieldValues(fieldVal, false, objectsToSkip);
                            for (Map.Entry<Object, Object> entry : nestedFieldValues.entrySet()) {
                                output.put(String.format("%s.%s", key, entry.getKey()), (String)entry.getValue());
                            }
                        }
                        if (accessible) continue;
                        field.setAccessible(false);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while constructing topology", (Throwable)e);
            }
        }
        return output;
    }

    private static String getString(Object instance, boolean wrapWithQuote, Set<Object> objectsToSkip) {
        if (instance == null) {
            return null;
        }
        if (instance.getClass().isPrimitive() || StormTopologyUtil.isWrapperType(instance.getClass())) {
            return StormTopologyUtil.toString(instance, wrapWithQuote);
        }
        return StormTopologyUtil.getString(StormTopologyUtil.getFieldValues(instance, false, objectsToSkip), wrapWithQuote);
    }

    private static String getString(Map<String, String> flattenFields, boolean wrapWithQuote) {
        String outStr = "";
        if (flattenFields != null && !flattenFields.isEmpty()) {
            outStr = wrapWithQuote ? outStr + "\"" + Joiner.on((String)",").join(flattenFields.entrySet()) + "\"," : outStr + Joiner.on((String)",").join(flattenFields.entrySet()) + ",";
        }
        if (outStr.length() > 0) {
            outStr = outStr.substring(0, outStr.length() - 1);
        }
        return outStr;
    }

    private static String toString(Object instance, boolean wrapWithQuote) {
        if (instance instanceof String) {
            if (wrapWithQuote) {
                return "\"" + instance + "\"";
            }
            return instance.toString();
        }
        return instance.toString();
    }
}

