/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.io.IOException;
import java.time.LocalDate;
import org.apache.avro.codegentest.AbstractSpecificRecordTest;
import org.apache.avro.codegentest.testdata.LogicalTypesWithDefaults;
import org.junit.Assert;
import org.junit.Test;

public class TestLogicalTypesWithDefaults
extends AbstractSpecificRecordTest {
    private static final LocalDate DEFAULT_VALUE = LocalDate.parse("1973-05-19");

    @Test
    public void testDefaultValueOfNullableField() throws IOException {
        LogicalTypesWithDefaults instanceOfGeneratedClass = LogicalTypesWithDefaults.newBuilder().setNonNullDate(LocalDate.now()).build();
        this.verifySerDeAndStandardMethods(instanceOfGeneratedClass);
    }

    @Test
    public void testDefaultValueOfNonNullField() throws IOException {
        LogicalTypesWithDefaults instanceOfGeneratedClass = LogicalTypesWithDefaults.newBuilder().setNullableDate(LocalDate.now()).build();
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)instanceOfGeneratedClass.getNonNullDate());
        this.verifySerDeAndStandardMethods(instanceOfGeneratedClass);
    }

    @Test
    public void testWithValues() throws IOException {
        LogicalTypesWithDefaults instanceOfGeneratedClass = LogicalTypesWithDefaults.newBuilder().setNullableDate(LocalDate.now()).setNonNullDate(LocalDate.now()).build();
        this.verifySerDeAndStandardMethods(instanceOfGeneratedClass);
    }
}

