/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.time.LocalDate;
import java.util.Collections;
import org.apache.avro.codegentest.AbstractSpecificRecordTest;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesArray;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesMap;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesRecord;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesUnion;
import org.apache.avro.codegentest.testdata.NestedRecord;
import org.apache.avro.codegentest.testdata.NullableLogicalTypesArray;
import org.apache.avro.codegentest.testdata.RecordInArray;
import org.apache.avro.codegentest.testdata.RecordInMap;
import org.apache.avro.codegentest.testdata.RecordInUnion;
import org.junit.Test;

public class TestNestedLogicalTypes
extends AbstractSpecificRecordTest {
    @Test
    public void testNullableLogicalTypeInNestedRecord() {
        NestedLogicalTypesRecord nestedLogicalTypesRecord = NestedLogicalTypesRecord.newBuilder().setNestedRecord(NestedRecord.newBuilder().setNullableDateField(LocalDate.now()).build()).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesRecord);
    }

    @Test
    public void testNullableLogicalTypeInArray() {
        NullableLogicalTypesArray logicalTypesArray = NullableLogicalTypesArray.newBuilder().setArrayOfLogicalType(Collections.singletonList(LocalDate.now())).build();
        this.verifySerDeAndStandardMethods(logicalTypesArray);
    }

    @Test
    public void testNullableLogicalTypeInRecordInArray() {
        NestedLogicalTypesArray nestedLogicalTypesArray = NestedLogicalTypesArray.newBuilder().setArrayOfRecords(Collections.singletonList(RecordInArray.newBuilder().setNullableDateField(LocalDate.now()).build())).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesArray);
    }

    @Test
    public void testNullableLogicalTypeInRecordInUnion() {
        NestedLogicalTypesUnion nestedLogicalTypesUnion = NestedLogicalTypesUnion.newBuilder().setUnionOfRecords(RecordInUnion.newBuilder().setNullableDateField(LocalDate.now()).build()).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesUnion);
    }

    @Test
    public void testNullableLogicalTypeInRecordInMap() {
        NestedLogicalTypesMap nestedLogicalTypesMap = NestedLogicalTypesMap.newBuilder().setMapOfRecords(Collections.singletonMap("key", RecordInMap.newBuilder().setNullableDateField(LocalDate.now()).build())).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesMap);
    }
}

