/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCycle {
    private static final Logger LOG = LoggerFactory.getLogger(TestCycle.class);

    @Test
    public void testCycleGeneration() throws ParseException, IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Idl idl = new Idl(cl.getResourceAsStream("input/cycle.avdl"), "UTF-8");
        Protocol protocol = idl.CompilationUnit();
        String json = protocol.toString();
        LOG.info(json);
        SpecificCompiler compiler = new SpecificCompiler(protocol);
        compiler.setStringType(GenericData.StringType.String);
        File output = new File("./target");
        compiler.compileToDestination(null, output);
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        for (Schema schema : protocol.getTypes()) {
            String name = schema.getName();
            schemas.put(name, schema);
        }
        GenericRecordBuilder rb2 = new GenericRecordBuilder((Schema)schemas.get("SampleNode"));
        rb2.set("count", (Object)10);
        rb2.set("subNodes", (Object)Collections.EMPTY_LIST);
        GenericData.Record node = rb2.build();
        GenericRecordBuilder mb = new GenericRecordBuilder((Schema)schemas.get("Method"));
        mb.set("declaringClass", (Object)"Test");
        mb.set("methodName", (Object)"test");
        GenericData.Record method = mb.build();
        GenericRecordBuilder spb = new GenericRecordBuilder((Schema)schemas.get("SamplePair"));
        spb.set("method", (Object)method);
        spb.set("node", (Object)node);
        GenericData.Record sp = spb.build();
        GenericRecordBuilder rb = new GenericRecordBuilder((Schema)schemas.get("SampleNode"));
        rb.set("count", (Object)10);
        rb.set("subNodes", Collections.singletonList(sp));
        GenericData.Record record = rb.build();
        TestCycle.serDeserRecord(record);
    }

    private static void serDeserRecord(GenericData.Record data) throws IOException {
        ByteArrayOutputStream bab = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(data.getSchema());
        BinaryEncoder directBinaryEncoder = EncoderFactory.get().directBinaryEncoder((OutputStream)bab, null);
        writer.write((Object)data, (Encoder)directBinaryEncoder);
        directBinaryEncoder.flush();
        ByteArrayInputStream bis = new ByteArrayInputStream(bab.toByteArray(), 0, bab.size());
        GenericDatumReader reader = new GenericDatumReader(data.getSchema());
        BinaryDecoder directBinaryDecoder = DecoderFactory.get().directBinaryDecoder((InputStream)bis, null);
        GenericData.Record read = (GenericData.Record)reader.read(null, (Decoder)directBinaryDecoder);
        Assert.assertEquals((Object)data.toString(), (Object)read.toString());
    }
}

