/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.test.FullRecordV1;
import org.apache.avro.specific.test.FullRecordV2;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGeneratedCode {
    private static final SpecificData MODEL = new SpecificData();
    private static final Schema V1S = FullRecordV1.getClassSchema();
    private static final Schema V2S = FullRecordV2.getClassSchema();

    @Before
    public void setUp() {
        MODEL.setCustomCoders(true);
    }

    @Test
    public void withoutSchemaMigration() throws IOException {
        FullRecordV1 src = new FullRecordV1(true, 87231, 731L, Float.valueOf(54.2832f), 38.321, "Hi there", null);
        Assert.assertTrue((String)"Test schema must allow for custom coders.", (boolean)src.hasCustomCoders());
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        BinaryEncoder e = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        DatumWriter w = MODEL.createDatumWriter(V1S);
        w.write((Object)src, (Encoder)e);
        e.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BinaryDecoder d = DecoderFactory.get().directBinaryDecoder((InputStream)in, null);
        DatumReader r = MODEL.createDatumReader(V1S);
        FullRecordV1 dst = (FullRecordV1)((Object)r.read(null, (Decoder)d));
        Assert.assertEquals((Object)((Object)src), (Object)((Object)dst));
    }

    @Test
    public void withSchemaMigration() throws IOException {
        FullRecordV2 src = new FullRecordV2(true, 731, 87231, 38L, Float.valueOf(54.2832f), "Hi there", ByteBuffer.wrap(Utf8.getBytesFor((String)"Hello, world!")));
        Assert.assertTrue((String)"Test schema must allow for custom coders.", (boolean)src.hasCustomCoders());
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        BinaryEncoder e = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        DatumWriter w = MODEL.createDatumWriter(V2S);
        w.write((Object)src, (Encoder)e);
        e.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BinaryDecoder d = DecoderFactory.get().directBinaryDecoder((InputStream)in, null);
        DatumReader r = MODEL.createDatumReader(V2S, V1S);
        FullRecordV1 dst = (FullRecordV1)((Object)r.read(null, (Decoder)d));
        FullRecordV1 expected = new FullRecordV1(true, 87231, 731L, Float.valueOf(54.2832f), 38.0, null, "Hello, world!");
        Assert.assertEquals((Object)((Object)expected), (Object)((Object)dst));
    }
}

