/* Generated By:JavaCC: Do not edit this line. Idl.java */
package org.apache.avro.compiler.idl;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.avro.Schema;
import org.apache.avro.Schema.*;
import org.apache.avro.Protocol;
import org.apache.avro.Protocol.*;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.*;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * Grammar to parse a higher-level language into an Avro Schema.
 *
 * Note: each instance is not thread-safe, but multiple separate
 * instances are safely independent.
 */
public class Idl implements IdlConstants {
  static JsonNodeFactory FACTORY = JsonNodeFactory.instance;

  File inputDir = new File(".");
  String namespace;
  Map<String,Schema> names = new LinkedHashMap<String,Schema>();

  private static final ThreadLocal<String> DOC = new ThreadLocal<String>();
  static void setDoc(String doc) { DOC.set(doc.trim()); }
  static String getDoc() {
    String doc = DOC.get();
    DOC.set(null);
    return doc;
  }

  public Idl(File inputFile) throws IOException {
    this(new FileInputStream(inputFile), "UTF-8");
    this.inputDir = inputFile.getParentFile();
  }

  private ParseException error(String message, Token token) {
    return new ParseException
      (message+", at line "+token.beginLine+", column "+token.beginColumn);
  }

  private String getTextProp(String key, Map<String,JsonNode> props,
                             Token token) throws ParseException {
    JsonNode value = props.get(key);
    if (value.isTextual())
      return value.getTextValue();
    throw error(key+" property must be textual: "+value, token);
  }

  private List<String> getTextProps(String key, Map<String,JsonNode> props,
                             Token token) throws ParseException {
    JsonNode value = props.get(key);
    if (!value.isArray())
      throw error(key+" property must be array: "+value, token);
    List<String> values = new ArrayList<String>();
    for (JsonNode n : value)
      if (n.isTextual())
        values.add(n.getTextValue());
      else
        throw error(key+" values must be textual: "+n, token);
    return values;
  }

/********************************************
 * THE AVRO IDL LANGUAGE GRAMMAR STARTS HERE *
 ********************************************/

/**
 * The input to Idl is a CompilationUnit, which is currently
 * just a single Protocol.
 */
  final public Protocol CompilationUnit() throws ParseException {
  Protocol p;
    p = ProtocolDeclaration();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 65:
      jj_consume_token(65);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STUFF_TO_IGNORE:
      jj_consume_token(STUFF_TO_IGNORE);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    jj_consume_token(0);
    {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

/*
 * Declaration syntax follows.
 */
  final public Schema NamedSchemaDeclaration() throws ParseException {
  Schema s;
  Map<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
  String savedSpace = this.namespace;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      SchemaProperty(props);
    }
    if (props.containsKey("namespace"))
      this.namespace = getTextProp("namespace", props, token);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIXED:
      s = FixedDeclaration();
      break;
    case ENUM:
      s = EnumDeclaration();
      break;
    case ERROR:
    case RECORD:
      s = RecordDeclaration();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
   this.namespace = savedSpace;

   for (String key : props.keySet())
     if ("namespace".equals(key)) {               // already handled: ignore
     } else if ("aliases".equals(key)) {          // aliases
       for (String alias : getTextProps("aliases", props, token))
         s.addAlias(alias);
     } else if (props.get(key).isTextual()) {     // ignore other non-textual
       s.addProp(key, getTextProp(key, props, token));
     }

   {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Schema UnionDefinition() throws ParseException {
  Schema s;
  List<Schema> schemata = new ArrayList<Schema>();
    jj_consume_token(UNION);
    jj_consume_token(LBRACE);
    s = Type();
    schemata.add(s);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      jj_consume_token(COMMA);
      s = Type();
      schemata.add(s);
    }
    jj_consume_token(RBRACE);
    {if (true) return Schema.createUnion(schemata);}
    throw new Error("Missing return statement in function");
  }

  final public Protocol ProtocolDeclaration() throws ParseException {
  String name;
  Protocol p;
  Map<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      SchemaProperty(props);
    }
    if (props.containsKey("namespace"))
      namespace = getTextProp("namespace", props, token);
    jj_consume_token(PROTOCOL);
    name = Identifier();
   p = new Protocol(name, getDoc(), namespace);
    ProtocolBody(p);
   {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public Schema EnumDeclaration() throws ParseException {
  String name;
  List<String> symbols;
    jj_consume_token(ENUM);
    name = Identifier();
    symbols = EnumBody();
    Schema s = Schema.createEnum(name, getDoc(), this.namespace, symbols);
    names.put(s.getFullName(), s);
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public List<String> EnumBody() throws ParseException {
  List<String> symbols = new ArrayList<String>();
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case TICK:
      EnumConstant(symbols);
      label_4:
      while (true) {
        if (jj_2_1(2)) {
          ;
        } else {
          break label_4;
        }
        jj_consume_token(COMMA);
        EnumConstant(symbols);
      }
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    {if (true) return symbols;}
    throw new Error("Missing return statement in function");
  }

  final public void EnumConstant(List<String> symbols) throws ParseException {
  String sym;
    sym = Identifier();
                       symbols.add(sym);
  }

  final public void ProtocolBody(Protocol p) throws ParseException {
  Schema schema;
  Message message;
  Protocol importProtocol;
    jj_consume_token(LBRACE);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case BOOLEAN:
      case DOUBLE:
      case ENUM:
      case ERROR:
      case FIXED:
      case FLOAT:
      case IMPORT:
      case INT:
      case LONG:
      case MAP:
      case BYTES:
      case STRING:
      case NULL:
      case RECORD:
      case UNION:
      case VOID:
      case IDENTIFIER:
      case AT:
      case TICK:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENUM:
      case ERROR:
      case FIXED:
      case RECORD:
      case AT:
        schema = NamedSchemaDeclaration();
        break;
      case IMPORT:
        jj_consume_token(IMPORT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDL:
        case PROTOCOL:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IDL:
            importProtocol = ImportIdl();
            break;
          case PROTOCOL:
            importProtocol = ImportProtocol();
            break;
          default:
            jj_la1[8] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
       for (Schema s : importProtocol.getTypes())
         names.put(s.getFullName(), s);
       p.getMessages().putAll(importProtocol.getMessages());
          break;
        case SCHEMA:
          schema = ImportSchema();
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case ARRAY:
      case BOOLEAN:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case MAP:
      case BYTES:
      case STRING:
      case NULL:
      case UNION:
      case VOID:
      case IDENTIFIER:
      case TICK:
        message = MessageDeclaration(p);
     p.getMessages().put(message.getName(), message);
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    p.setTypes(names.values());
  }

  final public Protocol ImportIdl() throws ParseException {
  String importFile;
    jj_consume_token(IDL);
    importFile = JsonString();
    jj_consume_token(SEMICOLON);
      try {
        {if (true) return new Idl(new File(inputDir, importFile)).CompilationUnit();}
      } catch (IOException e) {
        {if (true) throw error("Error importing "+importFile+": "+e, token);}
      }
    throw new Error("Missing return statement in function");
  }

  final public Protocol ImportProtocol() throws ParseException {
  String importFile;
    jj_consume_token(PROTOCOL);
    importFile = JsonString();
    jj_consume_token(SEMICOLON);
      try {
        {if (true) return Protocol.parse(new File(inputDir, importFile));}
      } catch (IOException e) {
        {if (true) throw error("Error importing "+importFile+": "+e, token);}
      }
    throw new Error("Missing return statement in function");
  }

  final public Schema ImportSchema() throws ParseException {
  String importFile;
    jj_consume_token(SCHEMA);
    importFile = JsonString();
    jj_consume_token(SEMICOLON);
      try {
        Parser parser = new Schema.Parser();
        parser.addTypes(names);                   // inherit names
        Schema value = parser.parse(new File(inputDir, importFile));
        names = parser.getTypes();                // update names
        {if (true) return value;}
      } catch (IOException e) {
        {if (true) throw error("Error importing "+importFile+": "+e, token);}
      }
    throw new Error("Missing return statement in function");
  }

  final public Schema FixedDeclaration() throws ParseException {
  String name;
  Token sizeTok;
    jj_consume_token(FIXED);
    name = Identifier();
    jj_consume_token(LPAREN);
    sizeTok = jj_consume_token(INTEGER_LITERAL);
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
    Schema s = Schema.createFixed(name, getDoc(), this.namespace,
                                  Integer.parseInt(sizeTok.image));
    names.put(s.getFullName(), s);
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Schema RecordDeclaration() throws ParseException {
  String name;
  List<Field> fields = new ArrayList<Field>();
  boolean isError;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RECORD:
      jj_consume_token(RECORD);
               isError = false;
      break;
    case ERROR:
      jj_consume_token(ERROR);
                isError = true;
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = Identifier();
    Schema result = Schema.createRecord(
      name, getDoc(), this.namespace, isError);
    names.put(result.getFullName(), result);
    jj_consume_token(LBRACE);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case BOOLEAN:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case MAP:
      case BYTES:
      case STRING:
      case NULL:
      case UNION:
      case IDENTIFIER:
      case AT:
      case TICK:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      FieldDeclaration(fields);
    }
    jj_consume_token(RBRACE);
    result.setFields(fields);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void SchemaProperty(Map<String, JsonNode> properties) throws ParseException {
  String key;
  JsonNode val;
    jj_consume_token(AT);
    key = Identifier();
    jj_consume_token(LPAREN);
    val = Json();
    jj_consume_token(RPAREN);
    if (properties.containsKey(key))
      {if (true) throw error("Property '" + key + "' already specified", token);}
    properties.put(key, val);
  }

  final public void FieldDeclaration(List<Field> fields) throws ParseException {
  Schema type;
  Map<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_7;
      }
      SchemaProperty(props);
    }
    type = Type();
    VariableDeclarator(type, fields);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      VariableDeclarator(type, fields);
    }
    jj_consume_token(SEMICOLON);
    for (String key : props.keySet())
      type.addProp(key, getTextProp(key, props, token));
  }

  final public void VariableDeclarator(Schema type, List<Field> fields) throws ParseException {
  String name;
  JsonNode defaultValue = null;
  Map<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_9;
      }
      SchemaProperty(props);
    }
    name = Identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
      jj_consume_token(EQUALS);
      defaultValue = Json();
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    Field.Order order = Field.Order.ASCENDING;
    for (String key : props.keySet())
      if ("order".equals(key))
        order = Field.Order.valueOf(getTextProp(key,props,token).toUpperCase());
    Field field = new Field(name, type, getDoc(), defaultValue, order);
    for (String key : props.keySet())
      if ("order".equals(key)) {                  // already handled: ignore
      } else if ("aliases".equals(key)) {         // aliases
        for (String alias : getTextProps("aliases", props, token))
          field.addAlias(alias);
      } else if (props.get(key).isTextual()) {    // ignore other non-textual
        field.addProp(key, getTextProp(key, props, token));
      }
    fields.add(field);
  }

  final public String MessageDocumentation() throws ParseException {
       {if (true) return getDoc();}
    throw new Error("Missing return statement in function");
  }

  final public Message MessageDeclaration(Protocol p) throws ParseException {
  String msgDoc;
  String name;
  Schema request;
  Schema response;
  boolean oneWay = false;
  List<Schema> errorSchemata = new ArrayList<Schema>();
  errorSchemata.add(Protocol.SYSTEM_ERROR);
    msgDoc = MessageDocumentation();
    response = ResultType();
    name = Identifier();
    request = FormalParameters();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ONEWAY:
    case THROWS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ONEWAY:
        jj_consume_token(ONEWAY);
              oneWay = true;
        break;
      case THROWS:
        jj_consume_token(THROWS);
        ErrorList(errorSchemata);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    Schema errors = Schema.createUnion(errorSchemata);
    if (oneWay && response.getType() != Type.NULL)
      {if (true) throw error("One-way message'"+name+"' must return void", token);}
    {if (true) return oneWay
    ? p.createMessage(name, msgDoc, request)
    : p.createMessage(name, msgDoc, request, response, errors);}
    throw new Error("Missing return statement in function");
  }

  final public void ErrorList(List<Schema> errors) throws ParseException {
  Schema s;
    s = ReferenceType();
                        errors.add(s);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      s = ReferenceType();
                              errors.add(s);
    }
  }

  final public Schema FormalParameters() throws ParseException {
  List<Field> fields = new ArrayList<Field>();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case MAP:
    case BYTES:
    case STRING:
    case NULL:
    case UNION:
    case IDENTIFIER:
    case TICK:
      FormalParameter(fields);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        FormalParameter(fields);
      }
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    {if (true) return Schema.createRecord(fields);}
    throw new Error("Missing return statement in function");
  }

  final public void FormalParameter(List<Field> fields) throws ParseException {
  Schema type;
    type = Type();
    VariableDeclarator(type, fields);
  }

  final public Schema Type() throws ParseException {
  Schema s;
    if (jj_2_2(2)) {
      s = ReferenceType();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case BYTES:
      case STRING:
      case NULL:
        s = PrimitiveType();
        break;
      case UNION:
        s = UnionDefinition();
        break;
      case ARRAY:
        s = ArrayType();
        break;
      case MAP:
        s = MapType();
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Schema ArrayType() throws ParseException {
  Schema elemSchema;
    jj_consume_token(ARRAY);
    jj_consume_token(LT);
    elemSchema = Type();
    jj_consume_token(GT);
    {if (true) return Schema.createArray(elemSchema);}
    throw new Error("Missing return statement in function");
  }

  final public Schema MapType() throws ParseException {
  Schema elemSchema;
    jj_consume_token(MAP);
    jj_consume_token(LT);
    elemSchema = Type();
    jj_consume_token(GT);
    {if (true) return Schema.createMap(elemSchema);}
    throw new Error("Missing return statement in function");
  }

/**
 * A reference to some other existing type
 */
  final public Schema ReferenceType() throws ParseException {
  String part;
  Token tok;
  StringBuilder sb = new StringBuilder();
    part = Identifier();
                          sb.append(part);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[23] = jj_gen;
        break label_12;
      }
      jj_consume_token(DOT);
      tok = AnyIdentifier();
                                 sb.append(".").append(tok.image);
    }
    String name = sb.toString();
    if ((name.indexOf('.') == -1) && namespace != null)
      name = namespace + "." + name;
    Schema type = names.get(name);
    if (type == null)
      {if (true) throw error("Undefined name '" + name + "'", token);}
    {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public Schema PrimitiveType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
              {if (true) return Schema.create(Type.BOOLEAN);}
      break;
    case BYTES:
      jj_consume_token(BYTES);
            {if (true) return Schema.create(Type.BYTES);}
      break;
    case INT:
      jj_consume_token(INT);
          {if (true) return Schema.create(Type.INT);}
      break;
    case STRING:
      jj_consume_token(STRING);
             {if (true) return Schema.create(Type.STRING);}
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
            {if (true) return Schema.create(Type.FLOAT);}
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
             {if (true) return Schema.create(Type.DOUBLE);}
      break;
    case LONG:
      jj_consume_token(LONG);
           {if (true) return Schema.create(Type.LONG);}
      break;
    case NULL:
      jj_consume_token(NULL);
           {if (true) return Schema.create(Type.NULL);}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Result types are like other types, except we provide "void" as
 * an alias of "null"
 */
  final public Schema ResultType() throws ParseException {
  Schema schema;
    if (jj_2_3(2)) {
      jj_consume_token(VOID);
                      {if (true) return Schema.create(Type.NULL);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case BOOLEAN:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case MAP:
      case BYTES:
      case STRING:
      case NULL:
      case UNION:
      case IDENTIFIER:
      case TICK:
        schema = Type();
                      {if (true) return schema;}
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public String Identifier() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
                       {if (true) return t.image;}
      break;
    case TICK:
      jj_consume_token(TICK);
      t = AnyIdentifier();
      jj_consume_token(TICK);
    {if (true) return t.image;}
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Token AnyIdentifier() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
      t = jj_consume_token(ARRAY);
      break;
    case BOOLEAN:
      t = jj_consume_token(BOOLEAN);
      break;
    case DOUBLE:
      t = jj_consume_token(DOUBLE);
      break;
    case ENUM:
      t = jj_consume_token(ENUM);
      break;
    case ERROR:
      t = jj_consume_token(ERROR);
      break;
    case FALSE:
      t = jj_consume_token(FALSE);
      break;
    case FIXED:
      t = jj_consume_token(FIXED);
      break;
    case FLOAT:
      t = jj_consume_token(FLOAT);
      break;
    case INT:
      t = jj_consume_token(INT);
      break;
    case LONG:
      t = jj_consume_token(LONG);
      break;
    case MAP:
      t = jj_consume_token(MAP);
      break;
    case BYTES:
      t = jj_consume_token(BYTES);
      break;
    case STRING:
      t = jj_consume_token(STRING);
      break;
    case PROTOCOL:
      t = jj_consume_token(PROTOCOL);
      break;
    case RECORD:
      t = jj_consume_token(RECORD);
      break;
    case THROWS:
      t = jj_consume_token(THROWS);
      break;
    case TRUE:
      t = jj_consume_token(TRUE);
      break;
    case UNION:
      t = jj_consume_token(UNION);
      break;
    case VOID:
      t = jj_consume_token(VOID);
      break;
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public JsonNode Json() throws ParseException {
  String s; Token t; JsonNode n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      s = JsonString();
                     n = new TextNode(s);
      break;
    case INTEGER_LITERAL:
      t = jj_consume_token(INTEGER_LITERAL);
                         n = new LongNode(Long.parseLong(t.image));
      break;
    case FLOATING_POINT_LITERAL:
      t = jj_consume_token(FLOATING_POINT_LITERAL);
                               n=new DoubleNode(Double.parseDouble(t.image));
      break;
    case LBRACE:
      n = JsonObject();
      break;
    case LBRACK:
      n = JsonArray();
      break;
    case TRUE:
      jj_consume_token(TRUE);
             n = BooleanNode.TRUE;
      break;
    case FALSE:
      jj_consume_token(FALSE);
              n = BooleanNode.FALSE;
      break;
    case NULL:
      jj_consume_token(NULL);
             n = NullNode.instance;
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final public String JsonString() throws ParseException {
  Token t;
    t = jj_consume_token(STRING_LITERAL);
    String betweenQuotes = t.image.substring(1, t.image.length() - 1);
    {if (true) return StringEscapeUtils.unescapeJavaScript(betweenQuotes);}
    throw new Error("Missing return statement in function");
  }

  final public JsonNode JsonObject() throws ParseException {
  ObjectNode o = FACTORY.objectNode();
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      JsonFields(o);
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    {if (true) return o;}
    throw new Error("Missing return statement in function");
  }

  final public void JsonFields(ObjectNode o) throws ParseException {
    JsonPair(o);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      JsonFields(o);
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
  }

  final public void JsonPair(ObjectNode o) throws ParseException {
  String name;
  JsonNode value;
    name = JsonString();
    jj_consume_token(COLON);
    value = Json();
      o.put(name, value);
  }

  final public JsonNode JsonArray() throws ParseException {
  ArrayNode a = FACTORY.arrayNode();
    jj_consume_token(LBRACK);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case LBRACE:
    case LBRACK:
      JsonElements(a);
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    jj_consume_token(RBRACK);
      {if (true) return a;}
    throw new Error("Missing return statement in function");
  }

  final public void JsonElements(ArrayNode a) throws ParseException {
  JsonNode element;
    element = Json();
                   a.add(element);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      JsonElements(a);
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_3R_14() {
    if (jj_3R_15()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_16()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(VOID)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(TICK)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) return true;
    }
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public IdlTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[33];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x80058000,0x0,0x0,0x0,0xb5edf000,0x40100000,0x48100000,0xb5edf000,0x80010000,0x35c87000,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x35c87000,0x35c87000,0x0,0x34c86000,0x35c87000,0x0,0xd5cff000,0x20020000,0x0,0x0,0x20020000,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x8000000,0x0,0x4000000,0x8000000,0x8000,0x800800c,0x0,0x0,0x800800c,0x0,0x8008004,0x8000000,0x4000000,0x8000000,0x10000000,0x1,0x1,0x4000000,0x4000000,0x8004,0x4,0x20000000,0x0,0x8004,0x8000,0x800f,0x504112,0x4000,0x4000000,0x504112,0x4000000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x2,0x4,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[3];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public Idl(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Idl(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new IdlTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Idl(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new IdlTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Idl(IdlTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(IdlTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 33; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[67];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 33; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 67; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 3; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
