/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.IdlConstants;
import org.apache.avro.compiler.idl.IdlTokenManager;
import org.apache.avro.compiler.idl.JavaCharStream;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.idl.Token;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.LongNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

public class Idl
implements IdlConstants {
    static JsonNodeFactory FACTORY = JsonNodeFactory.instance;
    File inputDir = new File(".");
    String namespace;
    Map<String, Schema> names = new LinkedHashMap<String, Schema>();
    private static final ThreadLocal<String> DOC = new ThreadLocal();
    public IdlTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[33];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static void setDoc(String doc) {
        DOC.set(doc.trim());
    }

    static String getDoc() {
        String doc = DOC.get();
        DOC.set(null);
        return doc;
    }

    public Idl(File inputFile) throws IOException {
        this(new FileInputStream(inputFile), "UTF-8");
        this.inputDir = inputFile.getParentFile();
    }

    private ParseException error(String message, Token token) {
        return new ParseException(message + ", at line " + token.beginLine + ", column " + token.beginColumn);
    }

    private String getTextProp(String key, Map<String, JsonNode> props, Token token) throws ParseException {
        JsonNode value = props.get(key);
        if (value.isTextual()) {
            return value.getTextValue();
        }
        throw this.error(key + " property must be textual: " + value, token);
    }

    private List<String> getTextProps(String key, Map<String, JsonNode> props, Token token) throws ParseException {
        JsonNode value = props.get(key);
        if (!value.isArray()) {
            throw this.error(key + " property must be array: " + value, token);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (JsonNode n : value) {
            if (n.isTextual()) {
                values.add(n.getTextValue());
                continue;
            }
            throw this.error(key + " values must be textual: " + n, token);
        }
        return values;
    }

    public final Protocol CompilationUnit() throws ParseException {
        Protocol p = this.ProtocolDeclaration();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        return p;
    }

    public final Schema NamedSchemaDeclaration() throws ParseException {
        Schema s;
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        String savedSpace = this.namespace;
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block8;
                }
            }
            this.SchemaProperty(props);
        }
        if (props.containsKey("namespace")) {
            this.namespace = this.getTextProp("namespace", props, this.token);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                s = this.FixedDeclaration();
                break;
            }
            case 15: {
                s = this.EnumDeclaration();
                break;
            }
            case 16: 
            case 31: {
                s = this.RecordDeclaration();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.namespace = savedSpace;
        for (String key : props.keySet()) {
            if ("namespace".equals(key)) continue;
            if ("aliases".equals(key)) {
                for (String alias : this.getTextProps("aliases", props, this.token)) {
                    s.addAlias(alias);
                }
                continue;
            }
            if (!((JsonNode)props.get(key)).isTextual()) continue;
            s.addProp(key, this.getTextProp(key, props, this.token));
        }
        return s;
    }

    public final Schema UnionDefinition() throws ParseException {
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        this.jj_consume_token(34);
        this.jj_consume_token(52);
        Schema s = this.Type();
        schemata.add(s);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(58);
            s = this.Type();
            schemata.add(s);
        }
        this.jj_consume_token(53);
        return Schema.createUnion(schemata);
    }

    public final Protocol ProtocolDeclaration() throws ParseException {
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.SchemaProperty(props);
        }
        if (props.containsKey("namespace")) {
            this.namespace = this.getTextProp("namespace", props, this.token);
        }
        this.jj_consume_token(30);
        String name = this.Identifier();
        Protocol p = new Protocol(name, Idl.getDoc(), this.namespace);
        this.ProtocolBody(p);
        return p;
    }

    public final Schema EnumDeclaration() throws ParseException {
        this.jj_consume_token(15);
        String name = this.Identifier();
        List<String> symbols = this.EnumBody();
        Schema s = Schema.createEnum((String)name, (String)Idl.getDoc(), (String)this.namespace, symbols);
        this.names.put(s.getFullName(), s);
        return s;
    }

    public final List<String> EnumBody() throws ParseException {
        ArrayList<String> symbols = new ArrayList<String>();
        this.jj_consume_token(52);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: 
            case 64: {
                this.EnumConstant(symbols);
                while (this.jj_2_1(2)) {
                    this.jj_consume_token(58);
                    this.EnumConstant(symbols);
                }
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(53);
        return symbols;
    }

    public final void EnumConstant(List<String> symbols) throws ParseException {
        String sym = this.Identifier();
        symbols.add(sym);
    }

    public final void ProtocolBody(Protocol p) throws ParseException {
        block18: {
            this.jj_consume_token(52);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 34: 
                    case 35: 
                    case 47: 
                    case 59: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block18;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 16: 
                    case 18: 
                    case 31: 
                    case 59: {
                        Schema schema = this.NamedSchemaDeclaration();
                        continue block16;
                    }
                    case 21: {
                        Schema schema;
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: 
                            case 30: {
                                Protocol importProtocol;
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 20: {
                                        importProtocol = this.ImportIdl();
                                        break;
                                    }
                                    case 30: {
                                        importProtocol = this.ImportProtocol();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[8] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                for (Schema s : importProtocol.getTypes()) {
                                    this.names.put(s.getFullName(), s);
                                }
                                p.getMessages().putAll(importProtocol.getMessages());
                                continue block16;
                            }
                            case 27: {
                                schema = this.ImportSchema();
                                continue block16;
                            }
                        }
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 19: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 34: 
                    case 35: 
                    case 47: 
                    case 64: {
                        Protocol.Message message = this.MessageDeclaration(p);
                        p.getMessages().put(message.getName(), message);
                        continue block16;
                    }
                }
                break;
            }
            this.jj_la1[10] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(53);
        p.setTypes(this.names.values());
    }

    public final Protocol ImportIdl() throws ParseException {
        this.jj_consume_token(20);
        String importFile = this.JsonString();
        this.jj_consume_token(57);
        try {
            return new Idl(new File(this.inputDir, importFile)).CompilationUnit();
        }
        catch (IOException e) {
            throw this.error("Error importing " + importFile + ": " + e, this.token);
        }
    }

    public final Protocol ImportProtocol() throws ParseException {
        this.jj_consume_token(30);
        String importFile = this.JsonString();
        this.jj_consume_token(57);
        try {
            return Protocol.parse((File)new File(this.inputDir, importFile));
        }
        catch (IOException e) {
            throw this.error("Error importing " + importFile + ": " + e, this.token);
        }
    }

    public final Schema ImportSchema() throws ParseException {
        this.jj_consume_token(27);
        String importFile = this.JsonString();
        this.jj_consume_token(57);
        try {
            Schema.Parser parser = new Schema.Parser();
            parser.addTypes(this.names);
            Schema value = parser.parse(new File(this.inputDir, importFile));
            this.names = parser.getTypes();
            return value;
        }
        catch (IOException e) {
            throw this.error("Error importing " + importFile + ": " + e, this.token);
        }
    }

    public final Schema FixedDeclaration() throws ParseException {
        this.jj_consume_token(18);
        String name = this.Identifier();
        this.jj_consume_token(50);
        Token sizeTok = this.jj_consume_token(36);
        this.jj_consume_token(51);
        this.jj_consume_token(57);
        Schema s = Schema.createFixed((String)name, (String)Idl.getDoc(), (String)this.namespace, (int)Integer.parseInt(sizeTok.image));
        this.names.put(s.getFullName(), s);
        return s;
    }

    public final Schema RecordDeclaration() throws ParseException {
        boolean isError;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                isError = false;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                isError = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.Identifier();
        Schema result = Schema.createRecord((String)name, (String)Idl.getDoc(), (String)this.namespace, (boolean)isError);
        this.names.put(result.getFullName(), result);
        this.jj_consume_token(52);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 13: 
                case 14: 
                case 19: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 28: 
                case 29: 
                case 34: 
                case 47: 
                case 59: 
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block7;
                }
            }
            this.FieldDeclaration(fields);
        }
        this.jj_consume_token(53);
        result.setFields(fields);
        return result;
    }

    public final void SchemaProperty(Map<String, JsonNode> properties) throws ParseException {
        this.jj_consume_token(59);
        String key = this.Identifier();
        this.jj_consume_token(50);
        JsonNode val = this.Json();
        this.jj_consume_token(51);
        if (properties.containsKey(key)) {
            throw this.error("Property '" + key + "' already specified", this.token);
        }
        properties.put(key, val);
    }

    public final void FieldDeclaration(List<Schema.Field> fields) throws ParseException {
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block6;
                }
            }
            this.SchemaProperty(props);
        }
        Schema type = this.Type();
        this.VariableDeclarator(type, fields);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(58);
            this.VariableDeclarator(type, fields);
        }
        this.jj_consume_token(57);
        for (String key : props.keySet()) {
            type.addProp(key, this.getTextProp(key, props, this.token));
        }
    }

    public final void VariableDeclarator(Schema type, List<Schema.Field> fields) throws ParseException {
        JsonNode defaultValue = null;
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block6;
                }
            }
            this.SchemaProperty(props);
        }
        String name = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                defaultValue = this.Json();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        Schema.Field.Order order = Schema.Field.Order.ASCENDING;
        for (String key : props.keySet()) {
            if (!"order".equals(key)) continue;
            order = Schema.Field.Order.valueOf((String)this.getTextProp(key, props, this.token).toUpperCase());
        }
        Schema.Field field = new Schema.Field(name, type, Idl.getDoc(), defaultValue, order);
        for (String key : props.keySet()) {
            if ("order".equals(key)) continue;
            if ("aliases".equals(key)) {
                for (String alias : this.getTextProps("aliases", props, this.token)) {
                    field.addAlias(alias);
                }
                continue;
            }
            if (!((JsonNode)props.get(key)).isTextual()) continue;
            field.addProp(key, this.getTextProp(key, props, this.token));
        }
        fields.add(field);
    }

    public final String MessageDocumentation() throws ParseException {
        return Idl.getDoc();
    }

    public final Protocol.Message MessageDeclaration(Protocol p) throws ParseException {
        boolean oneWay = false;
        ArrayList<Schema> errorSchemata = new ArrayList<Schema>();
        errorSchemata.add(Protocol.SYSTEM_ERROR);
        String msgDoc = this.MessageDocumentation();
        Schema response = this.ResultType();
        String name = this.Identifier();
        Schema request = this.FormalParameters();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: 
            case 32: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        oneWay = true;
                        break block0;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        this.ErrorList(errorSchemata);
                        break block0;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(57);
        Schema errors = Schema.createUnion(errorSchemata);
        if (oneWay && response.getType() != Schema.Type.NULL) {
            throw this.error("One-way message'" + name + "' must return void", this.token);
        }
        return oneWay ? p.createMessage(name, msgDoc, request) : p.createMessage(name, msgDoc, request, response, errors);
    }

    public final void ErrorList(List<Schema> errors) throws ParseException {
        Schema s = this.ReferenceType();
        errors.add(s);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(58);
            s = this.ReferenceType();
            errors.add(s);
        }
    }

    public final Schema FormalParameters() throws ParseException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        this.jj_consume_token(50);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 47: 
            case 64: {
                this.FormalParameter(fields);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(58);
                    this.FormalParameter(fields);
                }
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.jj_consume_token(51);
        return Schema.createRecord(fields);
    }

    public final void FormalParameter(List<Schema.Field> fields) throws ParseException {
        Schema type = this.Type();
        this.VariableDeclarator(type, fields);
    }

    public final Schema Type() throws ParseException {
        Schema s;
        if (this.jj_2_2(2)) {
            s = this.ReferenceType();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 19: 
                case 22: 
                case 23: 
                case 26: 
                case 28: 
                case 29: {
                    s = this.PrimitiveType();
                    break;
                }
                case 34: {
                    s = this.UnionDefinition();
                    break;
                }
                case 12: {
                    s = this.ArrayType();
                    break;
                }
                case 24: {
                    s = this.MapType();
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return s;
    }

    public final Schema ArrayType() throws ParseException {
        this.jj_consume_token(12);
        this.jj_consume_token(62);
        Schema elemSchema = this.Type();
        this.jj_consume_token(63);
        return Schema.createArray((Schema)elemSchema);
    }

    public final Schema MapType() throws ParseException {
        this.jj_consume_token(24);
        this.jj_consume_token(62);
        Schema elemSchema = this.Type();
        this.jj_consume_token(63);
        return Schema.createMap((Schema)elemSchema);
    }

    public final Schema ReferenceType() throws ParseException {
        Schema type;
        StringBuilder sb = new StringBuilder();
        String part = this.Identifier();
        sb.append(part);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 61: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(61);
            Token tok = this.AnyIdentifier();
            sb.append(".").append(tok.image);
        }
        String name = sb.toString();
        if (name.indexOf(46) == -1 && this.namespace != null) {
            name = this.namespace + "." + name;
        }
        if ((type = this.names.get(name)) == null) {
            throw this.error("Undefined name '" + name + "'", this.token);
        }
        return type;
    }

    public final Schema PrimitiveType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case 26: {
                this.jj_consume_token(26);
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case 22: {
                this.jj_consume_token(22);
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case 28: {
                this.jj_consume_token(28);
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case 19: {
                this.jj_consume_token(19);
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case 14: {
                this.jj_consume_token(14);
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case 23: {
                this.jj_consume_token(23);
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case 29: {
                this.jj_consume_token(29);
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Schema ResultType() throws ParseException {
        if (this.jj_2_3(2)) {
            this.jj_consume_token(35);
            return Schema.create((Schema.Type)Schema.Type.NULL);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 47: 
            case 64: {
                Schema schema = this.Type();
                return schema;
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                Token t = this.jj_consume_token(47);
                return t.image;
            }
            case 64: {
                this.jj_consume_token(64);
                Token t = this.AnyIdentifier();
                this.jj_consume_token(64);
                return t.image;
            }
        }
        this.jj_la1[26] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token AnyIdentifier() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            case 14: {
                t = this.jj_consume_token(14);
                break;
            }
            case 15: {
                t = this.jj_consume_token(15);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 19: {
                t = this.jj_consume_token(19);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 24: {
                t = this.jj_consume_token(24);
                break;
            }
            case 26: {
                t = this.jj_consume_token(26);
                break;
            }
            case 28: {
                t = this.jj_consume_token(28);
                break;
            }
            case 30: {
                t = this.jj_consume_token(30);
                break;
            }
            case 31: {
                t = this.jj_consume_token(31);
                break;
            }
            case 32: {
                t = this.jj_consume_token(32);
                break;
            }
            case 33: {
                t = this.jj_consume_token(33);
                break;
            }
            case 34: {
                t = this.jj_consume_token(34);
                break;
            }
            case 35: {
                t = this.jj_consume_token(35);
                break;
            }
            case 47: {
                t = this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final JsonNode Json() throws ParseException {
        JsonNode n;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                String s = this.JsonString();
                n = new TextNode(s);
                break;
            }
            case 36: {
                Token t = this.jj_consume_token(36);
                n = new LongNode(Long.parseLong(t.image));
                break;
            }
            case 40: {
                Token t = this.jj_consume_token(40);
                n = new DoubleNode(Double.parseDouble(t.image));
                break;
            }
            case 52: {
                n = this.JsonObject();
                break;
            }
            case 54: {
                n = this.JsonArray();
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                n = BooleanNode.TRUE;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                n = BooleanNode.FALSE;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                n = NullNode.instance;
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final String JsonString() throws ParseException {
        Token t = this.jj_consume_token(46);
        String betweenQuotes = t.image.substring(1, t.image.length() - 1);
        return StringEscapeUtils.unescapeJavaScript((String)betweenQuotes);
    }

    public final JsonNode JsonObject() throws ParseException {
        ObjectNode o = FACTORY.objectNode();
        this.jj_consume_token(52);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.JsonFields(o);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        this.jj_consume_token(53);
        return o;
    }

    public final void JsonFields(ObjectNode o) throws ParseException {
        this.JsonPair(o);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                this.JsonFields(o);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
    }

    public final void JsonPair(ObjectNode o) throws ParseException {
        String name = this.JsonString();
        this.jj_consume_token(56);
        JsonNode value = this.Json();
        o.put(name, value);
    }

    public final JsonNode JsonArray() throws ParseException {
        ArrayNode a = FACTORY.arrayNode();
        this.jj_consume_token(54);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 29: 
            case 33: 
            case 36: 
            case 40: 
            case 46: 
            case 52: 
            case 54: {
                this.JsonElements(a);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        this.jj_consume_token(55);
        return a;
    }

    public final void JsonElements(ArrayNode a) throws ParseException {
        JsonNode element = this.Json();
        a.add(element);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                this.JsonElements(a);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private boolean jj_3R_14() {
        Token xsp;
        if (this.jj_3R_15()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_16());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_13() {
        return this.jj_3R_15();
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(14)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(15)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(16)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(17)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(18)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(19)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(22)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(23)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(24)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(26)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(28)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(30)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(31)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(32)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(33)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(34)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(35)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(47)) {
                                                                                        return true;
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_14();
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3R_16() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_18() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_17() {
        return this.jj_scan_token(47);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, -2147123200, 0, 0, 0, -1242697728, 0x40100000, 1209008128, -1242697728, -2147418112, 902328320, 0, 0, 0, 0, 0x2000000, 0x2000000, 0, 0, 902328320, 902328320, 0, 885547008, 902328320, 0, -707792896, 0x20020000, 0, 0, 0x20020000, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0x8000000, 0, 0x4000000, 0x8000000, 32768, 0x800800C, 0, 0, 0x800800C, 0, 0x8008004, 0x8000000, 0x4000000, 0x8000000, 0x10000000, 1, 1, 0x4000000, 0x4000000, 32772, 4, 0x20000000, 0, 32772, 32768, 32783, 5259538, 16384, 0x4000000, 5259538, 0x4000000};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{2, 4, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0};
    }

    public Idl(InputStream stream) {
        this(stream, null);
    }

    public Idl(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new IdlTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 33; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 33; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Idl(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new IdlTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 33; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 33; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Idl(IdlTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 33; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(IdlTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 33; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[67];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 33; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 67; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Idl.jj_la1_init_0();
        Idl.jj_la1_init_1();
        Idl.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

