/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificCompiler {
    private final Set<Schema> queue = new HashSet<Schema>();
    private Protocol protocol;
    private VelocityEngine velocityEngine;
    private String templateDir;
    private static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
    private static final Set<String> ACCESSOR_MUTATOR_RESERVED_WORDS = new HashSet<String>(Arrays.asList("class", "schema"));
    private static final Set<String> ERROR_RESERVED_WORDS;
    private static final String FILE_HEADER = "/**\n * Autogenerated by Avro\n * \n * DO NOT EDIT DIRECTLY\n */\n";
    private static String logChuteName;
    private GenericData.StringType stringType = GenericData.StringType.CharSequence;
    private static final Schema NULL_SCHEMA;

    public SpecificCompiler(Protocol protocol) {
        this();
        for (Schema s : protocol.getTypes()) {
            this.enqueue(s);
        }
        this.protocol = protocol;
    }

    public SpecificCompiler(Schema schema) {
        this();
        this.enqueue(schema);
        this.protocol = null;
    }

    SpecificCompiler() {
        this.templateDir = System.getProperty("org.apache.avro.specific.templates", "/org/apache/avro/compiler/specific/templates/java/classic/");
        this.initializeVelocity();
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    private void initializeVelocity() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.addProperty("resource.loader", (Object)"class, file");
        this.velocityEngine.addProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.addProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        this.velocityEngine.addProperty("file.resource.loader.path", (Object)"/, .");
        this.velocityEngine.setProperty("runtime.references.strict", (Object)true);
        if (null == logChuteName) {
            try {
                new Slf4jLogChute();
                logChuteName = Slf4jLogChute.class.getName();
            }
            catch (Exception e) {
                logChuteName = "org.apache.velocity.runtime.log.NullLogChute";
            }
        }
        this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)logChuteName);
    }

    public static void compileProtocol(File src, File dest) throws IOException {
        SpecificCompiler.compileProtocol(new File[]{src}, dest);
    }

    public static void compileProtocol(File[] srcFiles, File dest) throws IOException {
        for (File src : srcFiles) {
            Protocol protocol = Protocol.parse((File)src);
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.compileToDestination(src, dest);
        }
    }

    public static void compileSchema(File src, File dest) throws IOException {
        SpecificCompiler.compileSchema(new File[]{src}, dest);
    }

    public static void compileSchema(File[] srcFiles, File dest) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        for (File src : srcFiles) {
            Schema schema = parser.parse(src);
            SpecificCompiler compiler = new SpecificCompiler(schema);
            compiler.compileToDestination(src, dest);
        }
    }

    private void enqueue(Schema schema) {
        if (this.queue.contains(schema)) {
            return;
        }
        switch (schema.getType()) {
            case RECORD: {
                this.queue.add(schema);
                for (Schema.Field field : schema.getFields()) {
                    this.enqueue(field.schema());
                }
                break;
            }
            case MAP: {
                this.enqueue(schema.getValueType());
                break;
            }
            case ARRAY: {
                this.enqueue(schema.getElementType());
                break;
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    this.enqueue(s);
                }
                break;
            }
            case ENUM: 
            case FIXED: {
                this.queue.add(schema);
                break;
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
    }

    Collection<OutputFile> compile() {
        ArrayList<OutputFile> out = new ArrayList<OutputFile>();
        for (Schema schema : this.queue) {
            out.add(this.compile(schema));
        }
        if (this.protocol != null) {
            out.add(this.compileInterface(this.protocol));
        }
        return out;
    }

    public void compileToDestination(File src, File dst) throws IOException {
        for (Schema schema : this.queue) {
            OutputFile o = this.compile(schema);
            o.writeToDestination(src, dst);
        }
        if (this.protocol != null) {
            this.compileInterface(this.protocol).writeToDestination(src, dst);
        }
    }

    private String renderTemplate(String templateName, VelocityContext context) {
        Template template;
        try {
            template = this.velocityEngine.getTemplate(templateName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    OutputFile compileInterface(Protocol protocol) {
        protocol = this.addStringType(protocol);
        VelocityContext context = new VelocityContext();
        context.put("protocol", (Object)protocol);
        context.put("this", (Object)this);
        String out = this.renderTemplate(this.templateDir + "protocol.vm", context);
        OutputFile outputFile = new OutputFile();
        String mangledName = SpecificCompiler.mangle(protocol.getName());
        outputFile.path = SpecificCompiler.makePath(mangledName, protocol.getNamespace());
        outputFile.contents = out;
        return outputFile;
    }

    static String makePath(String name, String space) {
        if (space == null || space.isEmpty()) {
            return name + ".java";
        }
        return space.replace('.', File.separatorChar) + File.separatorChar + name + ".java";
    }

    OutputFile compile(Schema schema) {
        schema = this.addStringType(schema);
        String output = "";
        VelocityContext context = new VelocityContext();
        context.put("this", (Object)this);
        context.put("schema", (Object)schema);
        switch (schema.getType()) {
            case RECORD: {
                output = this.renderTemplate(this.templateDir + "record.vm", context);
                break;
            }
            case ENUM: {
                output = this.renderTemplate(this.templateDir + "enum.vm", context);
                break;
            }
            case FIXED: {
                output = this.renderTemplate(this.templateDir + "fixed.vm", context);
                break;
            }
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
        OutputFile outputFile = new OutputFile();
        String name = SpecificCompiler.mangle(schema.getName());
        outputFile.path = SpecificCompiler.makePath(name, schema.getNamespace());
        outputFile.contents = output;
        return outputFile;
    }

    public void setStringType(GenericData.StringType t) {
        this.stringType = t;
    }

    private Protocol addStringType(Protocol p) {
        if (this.stringType != GenericData.StringType.String) {
            return p;
        }
        Protocol newP = new Protocol(p.getName(), p.getDoc(), p.getNamespace());
        LinkedHashMap<Schema, Schema> types = new LinkedHashMap<Schema, Schema>();
        for (Map.Entry prop : p.getProps().entrySet()) {
            newP.addProp((String)prop.getKey(), (String)prop.getValue());
        }
        LinkedHashSet<Schema> namedTypes = new LinkedHashSet<Schema>();
        for (Schema s : p.getTypes()) {
            namedTypes.add(this.addStringType(s, types));
        }
        newP.setTypes(namedTypes);
        Map newM = newP.getMessages();
        for (Protocol.Message m : p.getMessages().values()) {
            newM.put(m.getName(), m.isOneWay() ? newP.createMessage(m.getName(), m.getDoc(), m.getProps(), this.addStringType(m.getRequest(), types)) : newP.createMessage(m.getName(), m.getDoc(), m.getProps(), this.addStringType(m.getRequest(), types), this.addStringType(m.getResponse(), types), this.addStringType(m.getErrors(), types)));
        }
        return newP;
    }

    private Schema addStringType(Schema s) {
        if (this.stringType != GenericData.StringType.String) {
            return s;
        }
        return this.addStringType(s, new LinkedHashMap<Schema, Schema>());
    }

    private Schema addStringType(Schema s, Map<Schema, Schema> seen) {
        if (seen.containsKey(s)) {
            return seen.get(s);
        }
        Schema result = s;
        switch (s.getType()) {
            case STRING: {
                result = Schema.create((Schema.Type)Schema.Type.STRING);
                GenericData.setStringType((Schema)result, (GenericData.StringType)this.stringType);
                break;
            }
            case RECORD: {
                result = Schema.createRecord((String)s.getFullName(), (String)s.getDoc(), null, (boolean)s.isError());
                seen.put(s, result);
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
                for (Schema.Field f : s.getFields()) {
                    Schema fSchema = this.addStringType(f.schema(), seen);
                    Schema.Field newF = new Schema.Field(f.name(), fSchema, f.doc(), f.defaultValue(), f.order());
                    for (Map.Entry p : f.props().entrySet()) {
                        newF.addProp((String)p.getKey(), (String)p.getValue());
                    }
                    newFields.add(newF);
                }
                result.setFields(newFields);
                break;
            }
            case ARRAY: {
                Schema e = this.addStringType(s.getElementType(), seen);
                result = Schema.createArray((Schema)e);
                break;
            }
            case MAP: {
                Schema v = this.addStringType(s.getValueType(), seen);
                result = Schema.createMap((Schema)v);
                GenericData.setStringType((Schema)result, (GenericData.StringType)this.stringType);
                break;
            }
            case UNION: {
                ArrayList<Schema> types = new ArrayList<Schema>();
                for (Schema branch : s.getTypes()) {
                    types.add(this.addStringType(branch, seen));
                }
                result = Schema.createUnion(types);
            }
        }
        for (Map.Entry p : s.getProps().entrySet()) {
            result.addProp((String)p.getKey(), (String)p.getValue());
        }
        seen.put(s, result);
        return result;
    }

    private String getStringType() {
        switch (this.stringType) {
            case String: {
                return "java.lang.String";
            }
            case Utf8: {
                return "org.apache.avro.util.Utf8";
            }
            case CharSequence: {
                return "java.lang.CharSequence";
            }
        }
        throw new RuntimeException("Unknown string type: " + this.stringType);
    }

    public String javaType(Schema schema) {
        switch (schema.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return SpecificCompiler.mangle(schema.getFullName());
            }
            case ARRAY: {
                return "java.util.List<" + this.javaType(schema.getElementType()) + ">";
            }
            case MAP: {
                return "java.util.Map<" + this.getStringType() + "," + this.javaType(schema.getValueType()) + ">";
            }
            case UNION: {
                List types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return this.javaType((Schema)types.get(((Schema)types.get(0)).equals((Object)NULL_SCHEMA) ? 1 : 0));
                }
                return "java.lang.Object";
            }
            case STRING: {
                return this.getStringType();
            }
            case BYTES: {
                return "java.nio.ByteBuffer";
            }
            case INT: {
                return "java.lang.Integer";
            }
            case LONG: {
                return "java.lang.Long";
            }
            case FLOAT: {
                return "java.lang.Float";
            }
            case DOUBLE: {
                return "java.lang.Double";
            }
            case BOOLEAN: {
                return "java.lang.Boolean";
            }
            case NULL: {
                return "java.lang.Void";
            }
        }
        throw new RuntimeException("Unknown type: " + schema);
    }

    public String javaUnbox(Schema schema) {
        switch (schema.getType()) {
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case BOOLEAN: {
                return "boolean";
            }
        }
        return this.javaType(schema);
    }

    public static String javaEscape(Object o) {
        return o.toString().replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String escapeForJavadoc(String s) {
        return s.replace("*/", "*&#47;");
    }

    public static String nullToEmpty(String x) {
        return x == null ? "" : x;
    }

    public static String mangle(String word) {
        return SpecificCompiler.mangle(word, false);
    }

    public static String mangle(String word, boolean isError) {
        return SpecificCompiler.mangle(word, isError ? ERROR_RESERVED_WORDS : RESERVED_WORDS);
    }

    public static String mangle(String word, Set<String> reservedWords) {
        return SpecificCompiler.mangle(word, reservedWords, false);
    }

    public static String mangle(String word, Set<String> reservedWords, boolean isMethod) {
        if (reservedWords.contains(word) || isMethod && reservedWords.contains(Character.toLowerCase(word.charAt(0)) + (word.length() > 1 ? word.substring(1) : ""))) {
            return word + "$";
        }
        return word;
    }

    public static String generateGetMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "get");
    }

    public static String generateSetMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "set");
    }

    public static String generateHasMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "has");
    }

    public static String generateClearMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "clear");
    }

    private static String generateMethodName(Schema schema, Schema.Field field, String prefix) {
        char firstChar = field.name().charAt(0);
        String conflictingFieldName = (Character.isLowerCase(firstChar) ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + (field.name().length() > 1 ? field.name().substring(1) : "");
        boolean fieldNameConflict = schema.getField(conflictingFieldName) != null;
        StringBuilder methodBuilder = new StringBuilder(prefix);
        String fieldName = SpecificCompiler.mangle(field.name(), schema.isError() ? ERROR_RESERVED_WORDS : ACCESSOR_MUTATOR_RESERVED_WORDS, true);
        boolean nextCharToUpper = true;
        for (int ii = 0; ii < fieldName.length(); ++ii) {
            if (fieldName.charAt(ii) == '_') {
                nextCharToUpper = true;
                continue;
            }
            if (nextCharToUpper) {
                methodBuilder.append(Character.toUpperCase(fieldName.charAt(ii)));
                nextCharToUpper = false;
                continue;
            }
            methodBuilder.append(fieldName.charAt(ii));
        }
        if (fieldNameConflict) {
            if (methodBuilder.charAt(methodBuilder.length() - 1) != '$') {
                methodBuilder.append('$');
            }
            methodBuilder.append(Character.isLowerCase(firstChar) ? (char)'0' : '1');
        }
        return methodBuilder.toString();
    }

    public static boolean isUnboxedJavaTypeNullable(Schema schema) {
        switch (schema.getType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        SpecificCompiler.compileProtocol(new File(args[0]), new File(args[1]));
    }

    static {
        ACCESSOR_MUTATOR_RESERVED_WORDS.addAll(RESERVED_WORDS);
        ERROR_RESERVED_WORDS = new HashSet<String>(Arrays.asList("message", "cause"));
        ERROR_RESERVED_WORDS.addAll(ACCESSOR_MUTATOR_RESERVED_WORDS);
        logChuteName = null;
        NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    }

    public static final class Slf4jLogChute
    implements LogChute {
        private Logger logger = LoggerFactory.getLogger((String)"AvroVelocityLogChute");

        public void init(RuntimeServices rs) throws Exception {
        }

        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    this.logger.debug(message);
                    break;
                }
                case -1: {
                    this.logger.trace(message);
                    break;
                }
                case 2: {
                    this.logger.warn(message);
                    break;
                }
                case 3: {
                    this.logger.error(message);
                    break;
                }
                default: {
                    this.logger.info(message);
                }
            }
        }

        public void log(int level, String message, Throwable t) {
            switch (level) {
                case 0: {
                    this.logger.debug(message, t);
                    break;
                }
                case -1: {
                    this.logger.trace(message, t);
                    break;
                }
                case 2: {
                    this.logger.warn(message, t);
                    break;
                }
                case 3: {
                    this.logger.error(message, t);
                    break;
                }
                default: {
                    this.logger.info(message, t);
                }
            }
        }

        public boolean isLevelEnabled(int level) {
            switch (level) {
                case 0: {
                    return this.logger.isDebugEnabled();
                }
                case -1: {
                    return this.logger.isTraceEnabled();
                }
                case 2: {
                    return this.logger.isWarnEnabled();
                }
                case 3: {
                    return this.logger.isErrorEnabled();
                }
            }
            return this.logger.isInfoEnabled();
        }
    }

    static class OutputFile {
        String path;
        String contents;

        OutputFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        File writeToDestination(File src, File destDir) throws IOException {
            File f = new File(destDir, this.path);
            if (src != null && f.exists() && f.lastModified() >= src.lastModified()) {
                return f;
            }
            f.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(f);
            try {
                fw.write(SpecificCompiler.FILE_HEADER);
                fw.write(this.contents);
            }
            finally {
                fw.close();
            }
            return f;
        }
    }
}

