/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import io.grpc.Drainable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.apache.avro.Protocol;
import org.apache.avro.grpc.AvroRequestMarshaller;
import org.apache.avro.grpc.AvroResponseMarshaller;
import org.apache.avro.grpc.test.Kind;
import org.apache.avro.grpc.test.MD5;
import org.apache.avro.grpc.test.TestRecord;
import org.apache.avro.grpc.test.TestService;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroMarshaller {
    private final TestRecord record = TestRecord.newBuilder().setName("foo").setKind(Kind.FOO).setArrayOfLongs(Arrays.asList(42L, 424L, 4242L)).setHash(new MD5(new byte[]{4, 2, 4, 2})).setNullableHash(null).build();
    private final Protocol.Message message = (Protocol.Message)TestService.PROTOCOL.getMessages().get("echo");
    private Random random = new Random();

    private void readPratialAndDrain(int partialToRead, InputStream inputStream, OutputStream target) throws IOException {
        int readByte;
        for (int i = 0; i < partialToRead && (readByte = inputStream.read()) >= 0; ++i) {
            target.write(readByte);
        }
        Drainable drainableRequest = (Drainable)inputStream;
        drainableRequest.drainTo(target);
    }

    @Test
    public void testAvroRequestReadPartialAndDrain() throws IOException {
        AvroRequestMarshaller requestMarshaller = new AvroRequestMarshaller(this.message);
        InputStream requestInputStream = requestMarshaller.stream(new Object[]{this.record});
        ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
        this.readPratialAndDrain(this.random.nextInt(7) + 1, requestInputStream, requestOutputStream);
        ByteArrayInputStream serialized = new ByteArrayInputStream(requestOutputStream.toByteArray());
        Object[] parsedArgs = requestMarshaller.parse((InputStream)serialized);
        Assert.assertEquals((long)1L, (long)parsedArgs.length);
        Assert.assertEquals((Object)((Object)this.record), (Object)parsedArgs[0]);
    }

    @Test
    public void testAvroResponseReadPartialAndDrain() throws IOException {
        AvroResponseMarshaller responseMarshaller = new AvroResponseMarshaller(this.message);
        InputStream responseInputStream = responseMarshaller.stream((Object)this.record);
        ByteArrayOutputStream responseOutputStream = new ByteArrayOutputStream();
        this.readPratialAndDrain(this.random.nextInt(7) + 1, responseInputStream, responseOutputStream);
        ByteArrayInputStream serialized = new ByteArrayInputStream(responseOutputStream.toByteArray());
        Object parsedResponse = responseMarshaller.parse((InputStream)serialized);
        Assert.assertEquals((Object)((Object)this.record), (Object)parsedResponse);
    }
}

